#!/bin/bash

. `dirname $0`/../../scripts/CONFIG.sh

print_header "Completion"
parse_opts "$@"

cd ..

if [ $clean -eq 1 ]; then
   rm -f *.new
   rm -f */*.new
   rm -f */*.ali
   rm -f */*.o
   echo ""
   exit 0
fi

run_and_exit "make -f Makefile.completion"

cd tests

export PATH=`pwd`/../obj:$PATH

rm -f test.out

error_output=""

output_test() {
   name=$1
   new_file=$2
   expected=$3
   errors="`$diff $expected $new_file`"

   if [ $silent -eq 0 ]; then
      echo $j

      if [ "$errors" != "" ]; then
         echo "$errors"
      fi
   fi

   if [ "$errors" != "" ]; then
      error_output="$name
$errors
$error_output"
   fi

}

for j in *.parse; do
   completion-test $j parse | tr -d '\r' > $j.out.new
   output_test $j $j.out.new $j.out
done

for j in *.construct; do
   completion-test $j construct | tr -d '\r' > $j.out.new
   output_test $j $j.out.new $j.out
done

for j in *.analyze; do
   completion-test $j analyze | tr -d '\r' > $j.out.new
   output_test $j $j.out.new $j.out
done

for j in *.entity; do
   cd $j

   if [ -f NO_RUN ]; then
      if [ $silent -eq 0 ]; then
         echo "$j: NO_RUN"
      fi
   else
      rm -f *.ali *.o *.exe
      sh test.cmd | tr -d '\r' > test.out.new
      output_test $j test.out.new test.out
   fi
   cd ..
done

for j in *.full; do
   cd $j
   
   if [ -f NO_RUN ]; then
      if [ $silent -eq 0 ]; then
         echo "$j: NO_RUN"
      fi
   else
      rm -f *.ali *.o
      sh test.cmd | tr -d '\r' > test.out.new
      output_test $j test.out.new test.out
   fi

   cd ..
done

if [ "$error_output" = "" ]; then
   echo_with_status 1 ""
else
   echo_with_status 0 ""
fi

if [ "$error_output" != "" -a $silent -eq 1 ]; then
   echo "$error_output"
fi
