-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/tools/util.ads,v $
--  Description     : This is a utility package for all gnade tools          --
--  Author          : Michael Erdmann                                        --
--  Created         : 5.4.2003                                               --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2003/05/10 16:24:04 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2000 - 2003 Michael Erdmann                                --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  Export the contents of a table into a simple file format. This file      --
--  format i intended for importing or processing by other gnade tools       --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;               use Ada.Text_IO;
with ODBC;                      use ODBC;
package Util is 
 
   Quiet : Boolean := False;

   ------------
   -- Report --
   ------------
   procedure Report( 
      T : in String );
      
   -----------
   -- Error --
   -----------
   procedure Error(
      T : in String );

   ---------------------
   -- Report_DB_Error --
   ---------------------
   procedure Report_DB_Error(
      DB : in out ODBC.Object);

   -----------------
   -- Bucket_Type --
   -----------------
   generic
      type Bucket_Type is private;

   package Bucket is

      procedure Add( 
         Item : in Bucket_Type );

      function Get( 
         First : in Boolean := False ) return Bucket_Type;

      function End_Of_Bucket return Boolean ;

      procedure Destroy;
         
   end Bucket;

end Util;
 
