/**
 * GMyth Library
 *
 * @file gmyth/gmyth_file.h
 * 
 * @brief <p> GMythFile is the parent GMObject that deals with the file streaming 
 * media remote/local transfering to the MythTV frontend.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Rosfran Lins Borges <rosfran.borges@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_FILE_H__
#define __GMYTH_FILE_H__

#include <glib-object.h>
#include <glib.h>

#include "gmyth_uri.h"
#include "gmyth_backendinfo.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

G_BEGIN_DECLS
#define GMYTH_FILE_TYPE               (gmyth_file_get_type ())
#define GMYTH_FILE(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_FILE_TYPE, GMythFile))
#define GMYTH_FILE_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_FILE_TYPE, GMythFileClass))
#define IS_GMYTH_FILE(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_FILE_TYPE))
#define IS_GMYTH_FILE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_FILE_TYPE))
#define GMYTH_FILE_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_FILE_TYPE, GMythFileClass))

typedef enum {
    GMYTH_FILE_READ_OK = 0,
    GMYTH_FILE_READ_NEXT_PROG_CHAIN = 1,
    GMYTH_FILE_READ_ERROR = 2,
    GMYTH_FILE_READ_EOF = 3
} GMythFileReadResult;

typedef struct _GMythFile GMythFile;
typedef struct _GMythFileClass GMythFileClass;
typedef struct _GMythFilePrivate GMythFilePrivate;

struct _GMythFile {
    GObject         parent;
    GMythFilePrivate *priv;
};

struct _GMythFileClass {
    GObjectClass    parent_class;
};

GType           gmyth_file_get_type                 (void);
GMythFile      *gmyth_file_new                      (GMythBackendInfo   *backend_info);
gchar          *gmyth_file_get_file_name            (GMythFile          *file);
void            gmyth_file_set_file_name            (GMythFile          *file,
                                                     const gchar        *filename);
gboolean        gmyth_file_setup                    (GMythFile          *file, 
                                                     const gchar        *filename);
void            gmyth_file_close                    (GMythFile          *file);
gboolean        gmyth_file_is_open                  (GMythFile          *file);
guint64         gmyth_file_get_filesize             (GMythFile          *file);
void            gmyth_file_set_filesize             (GMythFile          *file,
                                                     guint64            filesize);
gint64          gmyth_file_get_offset               (GMythFile          *file);
void            gmyth_file_set_offset               (GMythFile          *file, 
                                                     gint64             offset);
gchar          *gmyth_file_get_uri                  (GMythFile          *file);

G_END_DECLS
#endif                          /* __GMYTH_FILE_H__ */
