/**
 * GMyth Library
 *
 * @file gmyth/gmyth_backend_info.h
 * 
 * @brief <p> This component represents all the MythTV backend server
 * 						configuration information.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Hallyson Melo <hallyson.melo@indt.org.br>
 * @author Rosfran Borges <rosfran.borges@indt.org.br>
 *
* 
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
	* but WITHOUT ANY WARRANTY; without even the implied warranty of
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	* GNU General Public License for more details.
	*
	* You should have received a copy of the GNU Lesser General Public License
	* along with this program; if not, write to the Free Software
	* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	*/

#ifndef __GMYTH_BACKEND_INFO_H__
#define __GMYTH_BACKEND_INFO_H__

#include <glib-object.h>

#include "gmyth_uri.h"
#include "gmyth_socket.h"

G_BEGIN_DECLS
#define GMYTH_BACKEND_INFO_TYPE \
    (gmyth_backend_info_get_type ())
#define GMYTH_BACKEND_INFO(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_BACKEND_INFO_TYPE, GMythBackendInfo))
#define GMYTH_BACKEND_INFO_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_BACKEND_INFO_TYPE, GMythBackendInfoClass))
#define IS_GMYTH_BACKEND_INFO(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_BACKEND_INFO_TYPE))
#define IS_GMYTH_BACKEND_INFO_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_BACKEND_INFO_TYPE))
#define GMYTH_BACKEND_INFO_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_BACKEND_INFO_TYPE, GMythBackendInfoClass))

typedef struct _GMythBackendInfo GMythBackendInfo;
typedef struct _GMythBackendInfoClass GMythBackendInfoClass;

struct _GMythBackendInfoClass {
    GObjectClass    parent_class;

    /*
     * callbacks 
     */
    /*
     * no one for now 
     */
};

struct _GMythBackendInfo {
    GObject parent;
    /** The backend hostname or ip address. */
    gchar  *hostname;
    /** The backend port. */
    gint  port;
    /** The username to connect to the mysql server. */
    gchar *username;
    /** The password to connect to the mysql server. */
    gchar *password;
    /** The mythtv's mysql database name. */
    gchar *db_name;
    /** The mysql database port */
    gint  db_port;
    /** The backend status port for http connection */
    gint  status_port;

    /* Private */
    GMythSocket *sock;
};


GType               gmyth_backend_info_get_type         (void) G_GNUC_CONST;
GMythBackendInfo*   gmyth_backend_info_new              (void);
GMythBackendInfo*   gmyth_backend_info_new_full         (const gchar        *hostname,
                                                         const gchar        *username,
                                                         const gchar        *password,
                                                         const gchar        *db_name,
                                                         gint               port);
GMythBackendInfo*   gmyth_backend_info_new_with_uri     (const gchar        *uri_str);
void                gmyth_backend_info_set_hostname     (GMythBackendInfo   *backend_info,
                                                         const gchar        *hostname);
void                gmyth_backend_info_set_username     (GMythBackendInfo   *backend_info,
                                                         const gchar        *username);
void                gmyth_backend_info_set_password     (GMythBackendInfo   *backend_info,
                                                         const gchar        *password);
void                gmyth_backend_info_set_db_name      (GMythBackendInfo   *backend_info,
                                                         const gchar        *db_name);
void                gmyth_backend_info_set_db_port      (GMythBackendInfo   *backend_info,
                                                         gint               db_port);
void                gmyth_backend_info_set_port         (GMythBackendInfo   *backend_info,
                                                         gint               port);
void                gmyth_backend_info_set_status_port  (GMythBackendInfo   *backend_info,
                                                         gint               port);
const gchar*        gmyth_backend_info_get_hostname     (GMythBackendInfo   *backend_info);
const gchar*        gmyth_backend_info_get_username     (GMythBackendInfo   *backend_info);
const gchar*        gmyth_backend_info_get_password     (GMythBackendInfo   *backend_info);
const gchar*        gmyth_backend_info_get_db_name      (GMythBackendInfo   *backend_info);
gint                gmyth_backend_info_get_db_port         (GMythBackendInfo   *backend_info);
gint                gmyth_backend_info_get_port         (GMythBackendInfo   *backend_info);
GMythURI*           gmyth_backend_info_get_uri          (GMythBackendInfo   *backend_info);
gboolean            gmyth_backend_info_is_local_file    (GMythBackendInfo   *backend_info);
GMythSocket*        gmyth_backend_info_get_connected_socket
                                                        (GMythBackendInfo   *backend_info);

G_END_DECLS
#endif                          /* __GMYTH_BACKEND_INFO_H__ */
