// Gmsh - Copyright (C) 1997-2008 C. Geuzaine, J.-F. Remacle
//
// See the LICENSE.txt file for license information. Please report all
// bugs and problems to <gmsh@geuz.org>.
#include "MElement.h"
#include "GaussLegendreSimplex.h"

IntPt GQT1[1] = { {{.333333333333333,.333333333333333,0},1.0} };
IntPt GQT2[3] = {
  { {0.16666666666666,0.1666666666666,0},.333333333333333 },
  { {0.66666666666666,0.1666666666666,0},.333333333333333 },
  { {0.16666666666666,0.6666666666666,0},.333333333333333 }
};

IntPt GQT3[4] = {
  { {0.333333333333333,0.3333333333333333,0},-0.5625},
  { {0.6,0.2,0},.520833333333333 },
  { {0.2,0.6,0},.520833333333333 },
  { {0.2,0.2,0},.520833333333333 }
};

IntPt GQT4[6] = {
  { {0.816847572980459,0.091576213509771,0},0.109951743655322},
  { {0.091576213509771,0.816847572980459,0},0.109951743655322},
  { {0.091576213509771,0.091576213509771,0},0.109951743655322},
  { {0.108103018168070,0.445948490915965,0},0.223381589678011},
  { {0.445948490915965,0.108103018168070,0},0.223381589678011},
  { {0.445948490915965,0.445948490915965,0},0.223381589678011}
};

IntPt GQT5[7] = {
  { {0.333333333333333,0.333333333333333,0},0.225000000000000},
  { {0.797426985353087,0.101286507323456,0},0.125939180544827},
  { {0.101286507323456,0.797426985353087,0},0.125939180544827},
  { {0.101286507323456,0.101286507323456,0},0.125939180544827},
  { {0.470142064105115,0.059715871789770,0},0.132394152788506},
  { {0.059715871789770,0.470142064105115,0},0.132394152788506},
  { {0.470142064105115,0.470142064105115,0},0.132394152788506}
};

IntPt GQT6[12] = {
  { {0.873821971016996,0.063089014491502,0},0.050844906370207},
  { {0.063089014491502,0.873821971016996,0},0.050844906370207},
  { {0.063089014491502,0.063089014491502,0},0.050844906370207},
  { {0.501426509658179,0.249286745170910,0},0.116786275726379},
  { {0.249286745170910,0.501426509658179,0},0.116786275726379},
  { {0.249286745170910,0.249286745170910,0},0.116786275726379},
  { {0.636502499121399,0.310352451033785,0},0.082851075618374},
  { {0.310352451033785,0.636502499121399,0},0.082851075618374},
  { {0.636502499121399,0.053145049844816,0},0.082851075618374},
  { {0.310352451033785,0.053145049844816,0},0.082851075618374},
  { {0.053145049844816,0.310352451033785,0},0.082851075618374},
  { {0.053145049844816,0.636502499121399,0},0.082851075618374}
};

IntPt GQT7[13] = {
  { {0.333333333333333,0.333333333333333,0},-0.149570044467682},
  { {0.479308067841920,0.260345966079040,0},0.175615257433208},
  { {0.260345966079040,0.479308067841920,0},0.175615257433208},
  { {0.260345966079040,0.260345966079040,0},0.175615257433208},
  { {0.869739794195568,0.065130102902216,0},0.053347235608838},
  { {0.065130102902216,0.869739794195568,0},0.053347235608838},
  { {0.065130102902216,0.065130102902216,0},0.053347235608838},
  { {0.048690315425316,0.312865496004874,0},0.077113760890257},
  { {0.312865496004874,0.048690315425316,0},0.077113760890257},
  { {0.638444188569810,0.048690315425316,0},0.077113760890257},
  { {0.048690315425316,0.638444188569810,0},0.077113760890257},
  { {0.312865496004874,0.638444188569810,0},0.077113760890257},
  { {0.638444188569810,0.312865496004874,0},0.077113760890257}

};

IntPt GQT8[16] = {
  { {0.333333333333333,0.333333333333333,0},0.144315607677787},
  { {0.081414823414554,0.459292588292723,0},0.095091634267285},
  { {0.459292588292723,0.081414823414554,0},0.095091634267285},
  { {0.459292588292723,0.459292588292723,0},0.095091634267285},
  { {0.658861384496480,0.170569307751760,0},0.103217370534718},
  { {0.170569307751760,0.658861384496480,0},0.103217370534718},
  { {0.170569307751760,0.170569307751760,0},0.103217370534718},
  { {0.898905543365938,0.050547228317031,0},0.032458497623198},
  { {0.050547228317031,0.898905543365938,0},0.032458497623198},
  { {0.050547228317031,0.050547228317031,0},0.032458497623198},  
  { {0.008394777409958,0.728492392955404,0},0.027230314174435},
  { {0.728492392955404,0.008394777409958,0},0.027230314174435},
  { {0.263112829634638,0.008394777409958,0},0.027230314174435},
  { {0.008394777409958,0.263112829634638,0},0.027230314174435},
  { {0.263112829634638,0.728492392955404,0},0.027230314174435},
  { {0.728492392955404,0.263112829634638,0},0.027230314174435}
};



IntPt * GQT[9] = {GQT1,GQT1,GQT2,GQT3,GQT4,GQT5,GQT6,GQT7,GQT8};
IntPt * GQTdegen[17] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int GQTnPt[9] = {1,1,3,4,6,7,12,13,16};




// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 1 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP1Solin[1] = {
  {{0.333333333333 , 0.333333333333,0 }, 1}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 2 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP2Solin[3] = {
  {{0.166666666667 , 0.166666666667,0 }, 0.333333333333},
  {{0.166666666667 , 0.666666666667,0 }, 0.333333333333},
  {{0.666666666667 , 0.166666666667,0 }, 0.333333333333}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 3 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP3Solin[4] = {
  {{0.333333333333 , 0.333333333333,0 }, -0.5625},
  {{0.2 , 0.2 ,0}, 0.520833333333},
  {{0.2 , 0.6 ,0}, 0.520833333333},
  {{0.6 , 0.2 ,0}, 0.520833333333}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 4 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP4Solin[6] = {
  {{0.445948490916 , 0.445948490916 ,0}, 0.223381589678},
  {{0.445948490916 , 0.108103018168 ,0}, 0.223381589678},
  {{0.108103018168 , 0.445948490916 ,0}, 0.223381589678},
  {{0.0915762135098 , 0.0915762135098 ,0}, 0.109951743655},
  {{0.0915762135098 , 0.81684757298 ,0}, 0.109951743655},
  {{0.81684757298 , 0.0915762135098 ,0}, 0.109951743655}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 5 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP5Solin[7] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.225},
  {{0.470142064105 , 0.470142064105 ,0}, 0.132394152789},
  {{0.470142064105 , 0.0597158717898 ,0}, 0.132394152789},
  {{0.0597158717898 , 0.470142064105 ,0}, 0.132394152789},
  {{0.101286507323 , 0.101286507323 ,0}, 0.125939180545},
  {{0.101286507323 , 0.797426985353 ,0}, 0.125939180545},
  {{0.797426985353 , 0.101286507323 ,0}, 0.125939180545}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 6 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP6Solin[12] = {
  {{0.249286745171 , 0.249286745171 ,0}, 0.116786275726},
  {{0.249286745171 , 0.501426509658 ,0}, 0.116786275726},
  {{0.501426509658 , 0.249286745171 ,0}, 0.116786275726},
  {{0.0630890144915 , 0.0630890144915 ,0}, 0.0508449063702},
  {{0.0630890144915 , 0.873821971017 ,0}, 0.0508449063702},
  {{0.873821971017 , 0.0630890144915 ,0}, 0.0508449063702},
  {{0.310352451034 , 0.636502499121 ,0}, 0.0828510756184},
  {{0.636502499121 , 0.0531450498448 ,0}, 0.0828510756184},
  {{0.0531450498448 , 0.310352451034 ,0}, 0.0828510756184},
  {{0.310352451034 , 0.0531450498448 ,0}, 0.0828510756184},
  {{0.636502499121 , 0.310352451034 ,0}, 0.0828510756184},
  {{0.0531450498448 , 0.636502499121,0 }, 0.0828510756184}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 7 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP7Solin[13] = {
  {{0.333333333333 , 0.333333333333 ,0}, -0.149570044468},
  {{0.260345966079 , 0.260345966079 ,0}, 0.175615257433},
  {{0.260345966079 , 0.479308067842 ,0}, 0.175615257433},
  {{0.479308067842 , 0.260345966079 ,0}, 0.175615257433},
  {{0.0651301029022 , 0.0651301029022 ,0}, 0.0533472356088},
  {{0.0651301029022 , 0.869739794196 ,0}, 0.0533472356088},
  {{0.869739794196 , 0.0651301029022 ,0}, 0.0533472356088},
  {{0.312865496005 , 0.63844418857 ,0}, 0.0771137608903},
  {{0.63844418857 , 0.0486903154253 ,0}, 0.0771137608903},
  {{0.0486903154253 , 0.312865496005 ,0}, 0.0771137608903},
  {{0.312865496005 , 0.0486903154253 ,0}, 0.0771137608903},
  {{0.63844418857 , 0.312865496005 ,0}, 0.0771137608903},
  {{0.0486903154253 , 0.63844418857 ,0}, 0.0771137608903}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 8 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP8Solin[16] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.144315607678},
  {{0.459292588293 , 0.459292588293 ,0}, 0.0950916342673},
  {{0.459292588293 , 0.0814148234146 ,0}, 0.0950916342673},
  {{0.0814148234146 , 0.459292588293 ,0}, 0.0950916342673},
  {{0.170569307752 , 0.170569307752 ,0}, 0.103217370535},
  {{0.170569307752 , 0.658861384496 ,0}, 0.103217370535},
  {{0.658861384496 , 0.170569307752 ,0}, 0.103217370535},
  {{0.050547228317 , 0.050547228317 ,0}, 0.0324584976232},
  {{0.050547228317 , 0.898905543366 ,0}, 0.0324584976232},
  {{0.898905543366 , 0.050547228317 ,0}, 0.0324584976232},
  {{0.263112829635 , 0.728492392955 ,0}, 0.0272303141744},
  {{0.728492392955 , 0.00839477740996 ,0}, 0.0272303141744},
  {{0.00839477740996 , 0.263112829635 ,0}, 0.0272303141744},
  {{0.263112829635 , 0.00839477740996 ,0}, 0.0272303141744},
  {{0.728492392955 , 0.263112829635,0 }, 0.0272303141744},
  {{0.00839477740996 , 0.728492392955,0 }, 0.0272303141744}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 9 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP9Solin[19] = {
  {{0.333333333333 , 0.333333333333,0 }, 0.0971357962828},
  {{0.489682519199 , 0.489682519199 ,0}, 0.0313347002271},
  {{0.489682519199 , 0.0206349616025,0 }, 0.0313347002271},
  {{0.0206349616025 , 0.489682519199 ,0}, 0.0313347002271},
  {{0.437089591493 , 0.437089591493 ,0}, 0.0778275410048},
  {{0.437089591493 , 0.125820817014 ,0}, 0.0778275410048},
  {{0.125820817014 , 0.437089591493 ,0}, 0.0778275410048},
  {{0.188203535619 , 0.188203535619 ,0}, 0.0796477389272},
  {{0.188203535619 , 0.623592928762 ,0}, 0.0796477389272},
  {{0.623592928762 , 0.188203535619 ,0}, 0.0796477389272},
  {{0.0447295133945 , 0.0447295133945,0 }, 0.0255776756587},
  {{0.0447295133945 , 0.910540973211 ,0}, 0.0255776756587},
  {{0.910540973211 , 0.0447295133945 ,0}, 0.0255776756587},
  {{0.221962989161 , 0.741198598784 ,0}, 0.0432835393773},
  {{0.741198598784 , 0.0368384120547,0 }, 0.0432835393773},
  {{0.0368384120547 , 0.221962989161 ,0}, 0.0432835393773},
  {{0.221962989161 , 0.0368384120547 ,0}, 0.0432835393773},
  {{0.741198598784 , 0.221962989161 ,0}, 0.0432835393773},
  {{0.0368384120547 , 0.741198598784,0 }, 0.0432835393773}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 10 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP10Solin[25] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.0908179903828},
  {{0.485577633384 , 0.485577633384 ,0}, 0.0367259577565},
  {{0.485577633384 , 0.0288447332327,0 }, 0.0367259577565},
  {{0.0288447332327 , 0.485577633384 ,0}, 0.0367259577565},
  {{0.109481575485 , 0.109481575485 ,0}, 0.0453210594355},
  {{0.109481575485 , 0.78103684903 ,0}, 0.0453210594355},
  {{0.78103684903 , 0.109481575485 ,0}, 0.0453210594355},
  {{0.307939838764 , 0.550352941821 ,0}, 0.0727579168454},
  {{0.550352941821 , 0.141707219415 ,0}, 0.0727579168454},
  {{0.141707219415 , 0.307939838764 ,0}, 0.0727579168454},
  {{0.307939838764 , 0.141707219415 ,0}, 0.0727579168454},
  {{0.550352941821 , 0.307939838764 ,0}, 0.0727579168454},
  {{0.141707219415 , 0.550352941821 ,0}, 0.0727579168454},
  {{0.24667256064 , 0.728323904597 ,0}, 0.0283272425311},
  {{0.728323904597 , 0.0250035347627 ,0}, 0.0283272425311},
  {{0.0250035347627 , 0.24667256064 ,0}, 0.0283272425311},
  {{0.24667256064 , 0.0250035347627 ,0}, 0.0283272425311},
  {{0.728323904597 , 0.24667256064 ,0}, 0.0283272425311},
  {{0.0250035347627 , 0.728323904597 ,0}, 0.0283272425311},
  {{0.0668032510122 , 0.923655933587 ,0}, 0.00942166696373},
  {{0.923655933587 , 0.0095408154003 ,0}, 0.00942166696373},
  {{0.0095408154003 , 0.0668032510122 ,0}, 0.00942166696373},
  {{0.0668032510122 , 0.0095408154003 ,0}, 0.00942166696373},
  {{0.923655933587 , 0.0668032510122 ,0}, 0.00942166696373},
  {{0.0095408154003 , 0.923655933587 ,0}, 0.00942166696373}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 11 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP11Solin[27] = {
  {{0.534611048271 , 0.534611048271 ,0}, 0.000927006328961},
  {{0.534611048271 , -0.0692220965415 ,0}, 0.000927006328961},
  {{-0.0692220965415 , 0.534611048271 ,0}, 0.000927006328961},
  {{0.398969302966 , 0.398969302966 ,0}, 0.0771495349148},
  {{0.398969302966 , 0.202061394068 ,0}, 0.0771495349148},
  {{0.202061394068 , 0.398969302966 ,0}, 0.0771495349148},
  {{0.203309900431 , 0.203309900431 ,0}, 0.0593229773808},
  {{0.203309900431 , 0.593380199137 ,0}, 0.0593229773808},
  {{0.593380199137 , 0.203309900431 ,0}, 0.0593229773808},
  {{0.119350912283 , 0.119350912283 ,0}, 0.0361845405034},
  {{0.119350912283 , 0.761298175435 ,0}, 0.0361845405034},
  {{0.761298175435 , 0.119350912283 ,0}, 0.0361845405034},
  {{0.0323649481113 , 0.0323649481113 ,0}, 0.0136597310027},
  {{0.0323649481113 , 0.935270103777 ,0}, 0.0136597310027},
  {{0.935270103777 , 0.0323649481113 ,0}, 0.0136597310027},
  {{0.356620648261 , 0.593201213428 ,0}, 0.0523371119622},
  {{0.593201213428 , 0.0501781383105 ,0}, 0.0523371119622},
  {{0.0501781383105 , 0.356620648261 ,0}, 0.0523371119622},
  {{0.356620648261 , 0.0501781383105 ,0}, 0.0523371119622},
  {{0.593201213428 , 0.356620648261 ,0}, 0.0523371119622},
  {{0.0501781383105 , 0.593201213428 ,0}, 0.0523371119622},
  {{0.171488980304 , 0.80748900316 ,0}, 0.0207076596391},
  {{0.80748900316 , 0.0210220165362 ,0}, 0.0207076596391},
  {{0.0210220165362 , 0.171488980304 ,0}, 0.0207076596391},
  {{0.171488980304 , 0.0210220165362 ,0}, 0.0207076596391},
  {{0.80748900316 , 0.171488980304 ,0}, 0.0207076596391},
  {{0.0210220165362 , 0.80748900316 ,0}, 0.0207076596391}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 12 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP12Solin[33] = {
  {{0.488217389774 , 0.488217389774 ,0}, 0.0257310664405},
  {{0.488217389774 , 0.0235652204524 ,0}, 0.0257310664405},
  {{0.0235652204524 , 0.488217389774 ,0}, 0.0257310664405},
  {{0.439724392294 , 0.439724392294 ,0}, 0.043692544538},
  {{0.439724392294 , 0.120551215411 ,0}, 0.043692544538},
  {{0.120551215411 , 0.439724392294 ,0}, 0.043692544538},
  {{0.271210385012 , 0.271210385012 ,0}, 0.0628582242179},
  {{0.271210385012 , 0.457579229976 ,0}, 0.0628582242179},
  {{0.457579229976 , 0.271210385012 ,0}, 0.0628582242179},
  {{0.127576145542 , 0.127576145542 ,0}, 0.0347961129307},
  {{0.127576145542 , 0.744847708917 ,0}, 0.0347961129307},
  {{0.744847708917 , 0.127576145542 ,0}, 0.0347961129307},
  {{0.0213173504532 , 0.0213173504532 ,0}, 0.00616626105156},
  {{0.0213173504532 , 0.957365299094 ,0}, 0.00616626105156},
  {{0.957365299094 , 0.0213173504532 ,0}, 0.00616626105156},
  {{0.275713269686 , 0.60894323578 ,0}, 0.0403715577664},
  {{0.60894323578 , 0.115343494535 ,0}, 0.0403715577664},
  {{0.115343494535 , 0.275713269686 ,0}, 0.0403715577664},
  {{0.275713269686 , 0.115343494535 ,0}, 0.0403715577664},
  {{0.60894323578 , 0.275713269686 ,0}, 0.0403715577664},
  {{0.115343494535 , 0.60894323578 ,0}, 0.0403715577664},
  {{0.28132558099 , 0.695836086788 ,0}, 0.0223567732023},
  {{0.695836086788 , 0.0228383322223 ,0}, 0.0223567732023},
  {{0.0228383322223 , 0.28132558099 ,0}, 0.0223567732023},
  {{0.28132558099 , 0.0228383322223 ,0}, 0.0223567732023},
  {{0.695836086788 , 0.28132558099 ,0}, 0.0223567732023},
  {{0.0228383322223 , 0.695836086788 ,0}, 0.0223567732023},
  {{0.116251915908 , 0.858014033544 ,0}, 0.0173162311087},
  {{0.858014033544 , 0.0257340505483 ,0}, 0.0173162311087},
  {{0.0257340505483 , 0.116251915908 ,0}, 0.0173162311087},
  {{0.116251915908 , 0.0257340505483 ,0}, 0.0173162311087},
  {{0.858014033544 , 0.116251915908 ,0}, 0.0173162311087},
  {{0.0257340505483 , 0.858014033544 ,0}, 0.0173162311087}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 13 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP13Solin[37] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.0525209234008},
  {{0.49504818494 , 0.49504818494 ,0}, 0.0112801452093},
  {{0.49504818494 , 0.00990363012059 ,0}, 0.0112801452093},
  {{0.00990363012059 , 0.49504818494 ,0}, 0.0112801452093},
  {{0.46871663511 , 0.46871663511 ,0}, 0.0314235183625},
  {{0.46871663511 , 0.0625667297809 ,0}, 0.0314235183625},
  {{0.0625667297809 , 0.46871663511 ,0}, 0.0314235183625},
  {{0.414521336801 , 0.414521336801 ,0}, 0.0470725025042},
  {{0.414521336801 , 0.170957326397 ,0}, 0.0470725025042},
  {{0.170957326397 , 0.414521336801 ,0}, 0.0470725025042},
  {{0.229399572043 , 0.229399572043 ,0}, 0.0473635865364},
  {{0.229399572043 , 0.541200855914 ,0}, 0.0473635865364},
  {{0.541200855914 , 0.229399572043 ,0}, 0.0473635865364},
  {{0.114424495196 , 0.114424495196 ,0}, 0.0311675290458},
  {{0.114424495196 , 0.771151009607 ,0}, 0.0311675290458},
  {{0.771151009607 , 0.114424495196 ,0}, 0.0311675290458},
  {{0.0248113913635 , 0.0248113913635 ,0}, 0.00797577146507},
  {{0.0248113913635 , 0.950377217273 ,0}, 0.00797577146507},
  {{0.950377217273 , 0.0248113913635 ,0}, 0.00797577146507},
  {{0.268794997059 , 0.636351174562 ,0}, 0.0368484027287},
  {{0.636351174562 , 0.0948538283796 ,0}, 0.0368484027287},
  {{0.0948538283796 , 0.268794997059 ,0}, 0.0368484027287},
  {{0.268794997059 , 0.0948538283796 ,0}, 0.0368484027287},
  {{0.636351174562 , 0.268794997059 ,0}, 0.0368484027287},
  {{0.0948538283796 , 0.636351174562 ,0}, 0.0368484027287},
  {{0.291730066734 , 0.690169159987 ,0}, 0.0174014633038},
  {{0.690169159987 , 0.0181007732788 ,0}, 0.0174014633038},
  {{0.0181007732788 , 0.291730066734 ,0}, 0.0174014633038},
  {{0.291730066734 , 0.0181007732788 ,0}, 0.0174014633038},
  {{0.690169159987 , 0.291730066734 ,0}, 0.0174014633038},
  {{0.0181007732788 , 0.690169159987 ,0}, 0.0174014633038},
  {{0.126357385492 , 0.851409537834 ,0}, 0.015521786839},
  {{0.851409537834 , 0.0222330766741 ,0}, 0.015521786839},
  {{0.0222330766741 , 0.126357385492 ,0}, 0.015521786839},
  {{0.126357385492 , 0.0222330766741 ,0}, 0.015521786839},
  {{0.851409537834 , 0.126357385492 ,0}, 0.015521786839},
  {{0.0222330766741 , 0.851409537834 ,0}, 0.015521786839}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 14 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP14Solin[42] = {
  {{0.488963910362 , 0.488963910362 ,0}, 0.0218835813694},
  {{0.488963910362 , 0.0220721792756 ,0}, 0.0218835813694},
  {{0.0220721792756 , 0.488963910362 ,0}, 0.0218835813694},
  {{0.41764471934 , 0.41764471934 ,0}, 0.0327883535441},
  {{0.41764471934 , 0.164710561319 ,0}, 0.0327883535441},
  {{0.164710561319 , 0.41764471934 ,0}, 0.0327883535441},
  {{0.273477528309 , 0.273477528309 ,0}, 0.0517741045073},
  {{0.273477528309 , 0.453044943382 ,0}, 0.0517741045073},
  {{0.453044943382 , 0.273477528309 ,0}, 0.0517741045073},
  {{0.177205532413 , 0.177205532413 ,0}, 0.042162588737},
  {{0.177205532413 , 0.645588935175 ,0}, 0.042162588737},
  {{0.645588935175 , 0.177205532413 ,0}, 0.042162588737},
  {{0.0617998830909 , 0.0617998830909 ,0}, 0.0144336996698},
  {{0.0617998830909 , 0.876400233818 ,0}, 0.0144336996698},
  {{0.876400233818 , 0.0617998830909 ,0}, 0.0144336996698},
  {{0.0193909612487 , 0.0193909612487 ,0}, 0.0049234036024},
  {{0.0193909612487 , 0.961218077503 ,0}, 0.0049234036024},
  {{0.961218077503 , 0.0193909612487 ,0}, 0.0049234036024},
  {{0.172266687821 , 0.770608554775 ,0}, 0.0246657532126},
  {{0.770608554775 , 0.0571247574036 ,0}, 0.0246657532126},
  {{0.0571247574036 , 0.172266687821 ,0}, 0.0246657532126},
  {{0.172266687821 , 0.0571247574036 ,0}, 0.0246657532126},
  {{0.770608554775 , 0.172266687821 ,0}, 0.0246657532126},
  {{0.0571247574036 , 0.770608554775 ,0}, 0.0246657532126},
  {{0.336861459796 , 0.570222290847 ,0}, 0.0385715107871},
  {{0.570222290847 , 0.092916249357 ,0}, 0.0385715107871},
  {{0.092916249357 , 0.336861459796 ,0}, 0.0385715107871},
  {{0.336861459796 , 0.092916249357 ,0}, 0.0385715107871},
  {{0.570222290847 , 0.336861459796 ,0}, 0.0385715107871},
  {{0.092916249357 , 0.570222290847 ,0}, 0.0385715107871},
  {{0.298372882136 , 0.686980167808 ,0}, 0.0144363081135},
  {{0.686980167808 , 0.0146469500557 ,0}, 0.0144363081135},
  {{0.0146469500557 , 0.298372882136 ,0}, 0.0144363081135},
  {{0.298372882136 , 0.0146469500557 ,0}, 0.0144363081135},
  {{0.686980167808 , 0.298372882136 ,0}, 0.0144363081135},
  {{0.0146469500557 , 0.686980167808 ,0}, 0.0144363081135},
  {{0.118974497697 , 0.87975717137 ,0}, 0.0050102288385},
  {{0.87975717137 , 0.00126833093287 ,0}, 0.0050102288385},
  {{0.00126833093287 , 0.118974497697 ,0}, 0.0050102288385},
  {{0.118974497697 , 0.00126833093287 ,0}, 0.0050102288385},
  {{0.87975717137 , 0.118974497697 ,0}, 0.0050102288385},
  {{0.00126833093287 , 0.87975717137 ,0}, 0.0050102288385}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 15 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP15Solin[48] = {
  {{0.506972916858 , 0.506972916858 ,0}, 0.00191687564285},
  {{0.506972916858 , -0.0139458337165 ,0}, 0.00191687564285},
  {{-0.0139458337165 , 0.506972916858 ,0}, 0.00191687564285},
  {{0.431406354283 , 0.431406354283 ,0}, 0.0442490272711},
  {{0.431406354283 , 0.137187291434 ,0}, 0.0442490272711},
  {{0.137187291434 , 0.431406354283 ,0}, 0.0442490272711},
  {{0.277693644847 , 0.277693644847 ,0}, 0.0511865487189},
  {{0.277693644847 , 0.444612710306 ,0}, 0.0511865487189},
  {{0.444612710306 , 0.277693644847 ,0}, 0.0511865487189},
  {{0.126464891041 , 0.126464891041 ,0}, 0.0236877358707},
  {{0.126464891041 , 0.747070217917 ,0}, 0.0236877358707},
  {{0.747070217917 , 0.126464891041 ,0}, 0.0236877358707},
  {{0.0708083859747 , 0.0708083859747 ,0}, 0.01328977569},
  {{0.0708083859747 , 0.858383228051 ,0}, 0.01328977569},
  {{0.858383228051 , 0.0708083859747 ,0}, 0.01328977569},
  {{0.0189651702411 , 0.0189651702411 ,0}, 0.00474891660819},
  {{0.0189651702411 , 0.962069659518 ,0}, 0.00474891660819},
  {{0.962069659518 , 0.0189651702411 ,0}, 0.00474891660819},
  {{0.26131137114 , 0.604954466893 ,0}, 0.0385500725996},
  {{0.604954466893 , 0.133734161967 ,0}, 0.0385500725996},
  {{0.133734161967 , 0.26131137114 ,0}, 0.0385500725996},
  {{0.26131137114 , 0.133734161967 ,0}, 0.0385500725996},
  {{0.604954466893 , 0.26131137114 ,0}, 0.0385500725996},
  {{0.133734161967 , 0.604954466893 ,0}, 0.0385500725996},
  {{0.38804676709 , 0.575586555513 ,0}, 0.0272158143206},
  {{0.575586555513 , 0.0363666773969 ,0}, 0.0272158143206},
  {{0.0363666773969 , 0.38804676709 ,0}, 0.0272158143206},
  {{0.38804676709 , 0.0363666773969 ,0}, 0.0272158143206},
  {{0.575586555513 , 0.38804676709 ,0}, 0.0272158143206},
  {{0.0363666773969 , 0.575586555513 ,0}, 0.0272158143206},
  {{0.28571222005 , 0.724462663077 ,0}, 0.0021820773668},
  {{0.724462663077 , -0.0101748831266 ,0}, 0.0021820773668},
  {{-0.0101748831266 , 0.28571222005 ,0}, 0.0021820773668},
  {{0.28571222005 , -0.0101748831266 ,0}, 0.0021820773668},
  {{0.724462663077 , 0.28571222005 ,0}, 0.0021820773668},
  {{-0.0101748831266 , 0.724462663077 ,0}, 0.0021820773668},
  {{0.215599664072 , 0.747556466052 ,0}, 0.0215053198477},
  {{0.747556466052 , 0.0368438698759 ,0}, 0.0215053198477},
  {{0.0368438698759 , 0.215599664072 ,0}, 0.0215053198477},
  {{0.215599664072 , 0.0368438698759 ,0}, 0.0215053198477},
  {{0.747556466052 , 0.215599664072 ,0}, 0.0215053198477},
  {{0.0368438698759 , 0.747556466052 ,0}, 0.0215053198477},
  {{0.103575616576 , 0.883964574092 ,0}, 0.00767394263105},
  {{0.883964574092 , 0.0124598093312 ,0}, 0.00767394263105},
  {{0.0124598093312 , 0.103575616576 ,0}, 0.00767394263105},
  {{0.103575616576 , 0.0124598093312 ,0}, 0.00767394263105},
  {{0.883964574092 , 0.103575616576 ,0}, 0.00767394263105},
  {{0.0124598093312 , 0.883964574092 ,0}, 0.00767394263105}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 16 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP16Solin[52] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.0468756974276},
  {{0.497380541948 , 0.497380541948 ,0}, 0.00640587857858},
  {{0.497380541948 , 0.00523891610312 ,0}, 0.00640587857858},
  {{0.00523891610312 , 0.497380541948 ,0}, 0.00640587857858},
  {{0.413469438549 , 0.413469438549 ,0}, 0.0417102967394},
  {{0.413469438549 , 0.173061122901 ,0}, 0.0417102967394},
  {{0.173061122901 , 0.413469438549 ,0}, 0.0417102967394},
  {{0.470458599067 , 0.470458599067 ,0}, 0.0268914842501},
  {{0.470458599067 , 0.059082801866 ,0}, 0.0268914842501},
  {{0.059082801866 , 0.470458599067 ,0}, 0.0268914842501},
  {{0.24055374997 , 0.24055374997 ,0}, 0.0421325227616},
  {{0.24055374997 , 0.518892500061 ,0}, 0.0421325227616},
  {{0.518892500061 , 0.24055374997 ,0}, 0.0421325227616},
  {{0.147965794223 , 0.147965794223 ,0}, 0.0300002668428},
  {{0.147965794223 , 0.704068411555 ,0}, 0.0300002668428},
  {{0.704068411555 , 0.147965794223 ,0}, 0.0300002668428},
  {{0.0754651876575 , 0.0754651876575 ,0}, 0.014200098925},
  {{0.0754651876575 , 0.849069624685 ,0}, 0.014200098925},
  {{0.849069624685 , 0.0754651876575 ,0}, 0.014200098925},
  {{0.016596402623 , 0.016596402623 ,0}, 0.00358246235127},
  {{0.016596402623 , 0.966807194754 ,0}, 0.00358246235127},
  {{0.966807194754 , 0.016596402623 ,0}, 0.00358246235127},
  {{0.29655559658 , 0.599868711175 ,0}, 0.0327731474606},
  {{0.599868711175 , 0.103575692245 ,0}, 0.0327731474606},
  {{0.103575692245 , 0.29655559658 ,0}, 0.0327731474606},
  {{0.29655559658 , 0.103575692245 ,0}, 0.0327731474606},
  {{0.599868711175 , 0.29655559658 ,0}, 0.0327731474606},
  {{0.103575692245 , 0.599868711175 ,0}, 0.0327731474606},
  {{0.337723063403 , 0.642193524942 ,0}, 0.0152983062484},
  {{0.642193524942 , 0.0200834116554 ,0}, 0.0152983062484},
  {{0.0200834116554 , 0.337723063403 ,0}, 0.0152983062484},
  {{0.337723063403 , 0.0200834116554 ,0}, 0.0152983062484},
  {{0.642193524942 , 0.337723063403 ,0}, 0.0152983062484},
  {{0.0200834116554 , 0.642193524942 ,0}, 0.0152983062484},
  {{0.204748281643 , 0.799592720971 ,0}, 0.00238624419284},
  {{0.799592720971 , -0.00434100261414 ,0}, 0.00238624419284},
  {{-0.00434100261414 , 0.204748281643 ,0}, 0.00238624419284},
  {{0.204748281643 , -0.00434100261414 ,0}, 0.00238624419284},
  {{0.799592720971 , 0.204748281643 ,0}, 0.00238624419284},
  {{-0.00434100261414 , 0.799592720971 ,0}, 0.00238624419284},
  {{0.189358492131 , 0.768699721401 ,0}, 0.0190847927559},
  {{0.768699721401 , 0.041941786468 ,0}, 0.0190847927559},
  {{0.041941786468 , 0.189358492131 ,0}, 0.0190847927559},
  {{0.189358492131 , 0.041941786468 ,0}, 0.0190847927559},
  {{0.768699721401 , 0.189358492131 ,0}, 0.0190847927559},
  {{0.041941786468 , 0.768699721401 ,0}, 0.0190847927559},
  {{0.0852836156827 , 0.900399064087 ,0}, 0.00685005454654},
  {{0.900399064087 , 0.0143173202307 ,0}, 0.00685005454654},
  {{0.0143173202307 , 0.0852836156827 ,0}, 0.00685005454654},
  {{0.0852836156827 , 0.0143173202307 ,0}, 0.00685005454654},
  {{0.900399064087 , 0.0852836156827 ,0}, 0.00685005454654},
  {{0.0143173202307 , 0.900399064087 ,0}, 0.00685005454654}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 17 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP17Solin[61] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.0334371992908},
  {{0.497170540557 , 0.497170540557 ,0}, 0.00509341544051},
  {{0.497170540557 , 0.00565891888645 ,0}, 0.00509341544051},
  {{0.00565891888645 , 0.497170540557 ,0}, 0.00509341544051},
  {{0.482176322625 , 0.482176322625 ,0}, 0.0146708645276},
  {{0.482176322625 , 0.0356473547508 ,0}, 0.0146708645276},
  {{0.0356473547508 , 0.482176322625 ,0}, 0.0146708645276},
  {{0.450239969021 , 0.450239969021 ,0}, 0.0243508783537},
  {{0.450239969021 , 0.0995200619584 ,0}, 0.0243508783537},
  {{0.0995200619584 , 0.450239969021 ,0}, 0.0243508783537},
  {{0.400266239377 , 0.400266239377 ,0}, 0.031107550869},
  {{0.400266239377 , 0.199467521245 ,0}, 0.031107550869},
  {{0.199467521245 , 0.400266239377 ,0}, 0.031107550869},
  {{0.252141267971 , 0.252141267971 ,0}, 0.0312571112186},
  {{0.252141267971 , 0.495717464058 ,0}, 0.0312571112186},
  {{0.495717464058 , 0.252141267971 ,0}, 0.0312571112186},
  {{0.162047004658 , 0.162047004658 ,0}, 0.0248156543397},
  {{0.162047004658 , 0.675905990683 ,0}, 0.0248156543397},
  {{0.675905990683 , 0.162047004658 ,0}, 0.0248156543397},
  {{0.0758758822607 , 0.0758758822607 ,0}, 0.0140560730706},
  {{0.0758758822607 , 0.848248235479 ,0}, 0.0140560730706},
  {{0.848248235479 , 0.0758758822607 ,0}, 0.0140560730706},
  {{0.0156547269678 , 0.0156547269678 ,0}, 0.00319467617378},
  {{0.0156547269678 , 0.968690546064 ,0}, 0.00319467617378},
  {{0.968690546064 , 0.0156547269678 ,0}, 0.00319467617378},
  {{0.334319867364 , 0.655493203809 ,0}, 0.00811965531899},
  {{0.655493203809 , 0.0101869288269 ,0}, 0.00811965531899},
  {{0.0101869288269 , 0.334319867364 ,0}, 0.00811965531899},
  {{0.334319867364 , 0.0101869288269 ,0}, 0.00811965531899},
  {{0.655493203809 , 0.334319867364 ,0}, 0.00811965531899},
  {{0.0101869288269 , 0.655493203809 ,0}, 0.00811965531899},
  {{0.292221537797 , 0.572337590532 ,0}, 0.0268057422832},
  {{0.572337590532 , 0.135440871671 ,0}, 0.0268057422832},
  {{0.135440871671 , 0.292221537797 ,0}, 0.0268057422832},
  {{0.292221537797 , 0.135440871671 ,0}, 0.0268057422832},
  {{0.572337590532 , 0.292221537797 ,0}, 0.0268057422832},
  {{0.135440871671 , 0.572337590532 ,0}, 0.0268057422832},
  {{0.319574885423 , 0.626001190286 ,0}, 0.0184599932108},
  {{0.626001190286 , 0.0544239242906 ,0}, 0.0184599932108},
  {{0.0544239242906 , 0.319574885423 ,0}, 0.0184599932108},
  {{0.319574885423 , 0.0544239242906 ,0}, 0.0184599932108},
  {{0.626001190286 , 0.319574885423 ,0}, 0.0184599932108},
  {{0.0544239242906 , 0.626001190286 ,0}, 0.0184599932108},
  {{0.190704224192 , 0.796427214974 ,0}, 0.00847686853433},
  {{0.796427214974 , 0.0128685608336 ,0}, 0.00847686853433},
  {{0.0128685608336 , 0.190704224192 ,0}, 0.00847686853433},
  {{0.190704224192 , 0.0128685608336 ,0}, 0.00847686853433},
  {{0.796427214974 , 0.190704224192 ,0}, 0.00847686853433},
  {{0.0128685608336 , 0.796427214974 ,0}, 0.00847686853433},
  {{0.180483211649 , 0.752351005938 ,0}, 0.01829279677},
  {{0.752351005938 , 0.0671657824135 ,0}, 0.01829279677},
  {{0.0671657824135 , 0.180483211649 ,0}, 0.01829279677},
  {{0.180483211649 , 0.0671657824135 ,0}, 0.01829279677},
  {{0.752351005938 , 0.180483211649 ,0}, 0.01829279677},
  {{0.0671657824135 , 0.752351005938 ,0}, 0.01829279677},
  {{0.0807113136796 , 0.904625504096 ,0}, 0.00666563200417},
  {{0.904625504096 , 0.0146631822248 ,0}, 0.00666563200417},
  {{0.0146631822248 , 0.0807113136796 ,0}, 0.00666563200417},
  {{0.0807113136796 , 0.0146631822248 ,0}, 0.00666563200417},
  {{0.904625504096 , 0.0807113136796 ,0}, 0.00666563200417},
  {{0.0146631822248 , 0.904625504096 ,0}, 0.00666563200417}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 18 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP18Solin[70] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.0308099399376},
  {{0.493344808631 , 0.493344808631 ,0}, 0.0090724366794},
  {{0.493344808631 , 0.0133103827382 ,0}, 0.0090724366794},
  {{0.0133103827382 , 0.493344808631 ,0}, 0.0090724366794},
  {{0.469210594242 , 0.469210594242 ,0}, 0.0187613169396},
  {{0.469210594242 , 0.0615788115161 ,0}, 0.0187613169396},
  {{0.0615788115161 , 0.469210594242 ,0}, 0.0187613169396},
  {{0.436281395887 , 0.436281395887 ,0}, 0.0194410979855},
  {{0.436281395887 , 0.127437208226 ,0}, 0.0194410979855},
  {{0.127437208226 , 0.436281395887 ,0}, 0.0194410979855},
  {{0.394846170673 , 0.394846170673 ,0}, 0.0277539486108},
  {{0.394846170673 , 0.210307658653 ,0}, 0.0277539486108},
  {{0.210307658653 , 0.394846170673 ,0}, 0.0277539486108},
  {{0.249794568803 , 0.249794568803 ,0}, 0.0322562253515},
  {{0.249794568803 , 0.500410862394 ,0}, 0.0322562253515},
  {{0.500410862394 , 0.249794568803 ,0}, 0.0322562253515},
  {{0.161432193744 , 0.161432193744 ,0}, 0.0250740326169},
  {{0.161432193744 , 0.677135612512 ,0}, 0.0250740326169},
  {{0.677135612512 , 0.161432193744 ,0}, 0.0250740326169},
  {{0.0765982274854 , 0.0765982274854 ,0}, 0.0152719279718},
  {{0.0765982274854 , 0.846803545029 ,0}, 0.0152719279718},
  {{0.846803545029 , 0.0765982274854 ,0}, 0.0152719279718},
  {{0.0242524393535 , 0.0242524393535 ,0}, 0.00679392202296},
  {{0.0242524393535 , 0.951495121293 ,0}, 0.00679392202296},
  {{0.951495121293 , 0.0242524393535 ,0}, 0.00679392202296},
  {{0.043146367217 , 0.043146367217 ,0}, -0.00222309872992},
  {{0.043146367217 , 0.913707265566 ,0}, -0.00222309872992},
  {{0.913707265566 , 0.043146367217 ,0}, -0.00222309872992},
  {{0.358911494941 , 0.632657968857 ,0}, 0.00633191407641},
  {{0.632657968857 , 0.00843053620242 ,0}, 0.00633191407641},
  {{0.00843053620242 , 0.358911494941 ,0}, 0.00633191407641},
  {{0.358911494941 , 0.00843053620242 ,0}, 0.00633191407641},
  {{0.632657968857 , 0.358911494941 ,0}, 0.00633191407641},
  {{0.00843053620242 , 0.632657968857 ,0}, 0.00633191407641},
  {{0.294402476752 , 0.574410971511 ,0}, 0.0272575380491},
  {{0.574410971511 , 0.131186551737 ,0}, 0.0272575380491},
  {{0.131186551737 , 0.294402476752 ,0}, 0.0272575380491},
  {{0.294402476752 , 0.131186551737 ,0}, 0.0272575380491},
  {{0.574410971511 , 0.294402476752 ,0}, 0.0272575380491},
  {{0.131186551737 , 0.574410971511 ,0}, 0.0272575380491},
  {{0.325017801642 , 0.624779046793 ,0}, 0.0176767856495},
  {{0.624779046793 , 0.0502031515657 ,0}, 0.0176767856495},
  {{0.0502031515657 , 0.325017801642 ,0}, 0.0176767856495},
  {{0.325017801642 , 0.0502031515657 ,0}, 0.0176767856495},
  {{0.624779046793 , 0.325017801642 ,0}, 0.0176767856495},
  {{0.0502031515657 , 0.624779046793 ,0}, 0.0176767856495},
  {{0.184737559666 , 0.748933176523 ,0}, 0.0183794846381},
  {{0.748933176523 , 0.0663292638109 ,0}, 0.0183794846381},
  {{0.0663292638109 , 0.184737559666 ,0}, 0.0183794846381},
  {{0.184737559666 , 0.0663292638109 ,0}, 0.0183794846381},
  {{0.748933176523 , 0.184737559666 ,0}, 0.0183794846381},
  {{0.0663292638109 , 0.748933176523 ,0}, 0.0183794846381},
  {{0.218796800013 , 0.76920700542 ,0}, 0.00810473280819},
  {{0.76920700542 , 0.0119961945662 ,0}, 0.00810473280819},
  {{0.0119961945662 , 0.218796800013 ,0}, 0.00810473280819},
  {{0.218796800013 , 0.0119961945662 ,0}, 0.00810473280819},
  {{0.76920700542 , 0.218796800013 ,0}, 0.00810473280819},
  {{0.0119961945662 , 0.76920700542 ,0}, 0.00810473280819},
  {{0.101179597136 , 0.883962302273 ,0}, 0.00763412907073},
  {{0.883962302273 , 0.0148581005901 ,0}, 0.00763412907073},
  {{0.0148581005901 , 0.101179597136 ,0}, 0.00763412907073},
  {{0.101179597136 , 0.0148581005901 ,0}, 0.00763412907073},
  {{0.883962302273 , 0.101179597136 ,0}, 0.00763412907073},
  {{0.0148581005901 , 0.883962302273 ,0}, 0.00763412907073},
  {{0.0208747552826 , 1.01434726001 ,0}, 4.6187660794e-05},
  {{1.01434726001 , -0.0352220152879 ,0}, 4.6187660794e-05},
  {{-0.0352220152879 , 0.0208747552826 ,0}, 4.6187660794e-05},
  {{0.0208747552826 , -0.0352220152879 ,0}, 4.6187660794e-05},
  {{1.01434726001 , 0.0208747552826 ,0}, 4.6187660794e-05},
  {{-0.0352220152879 , 1.01434726001 ,0}, 4.6187660794e-05}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 19 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP19Solin[73] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.0329063313889},
  {{0.489609987073 , 0.489609987073 ,0}, 0.0103307318913},
  {{0.489609987073 , 0.020780025854 ,0}, 0.0103307318913},
  {{0.020780025854 , 0.489609987073 ,0}, 0.0103307318913},
  {{0.454536892698 , 0.454536892698 ,0}, 0.022387247263},
  {{0.454536892698 , 0.0909262146042 ,0}, 0.022387247263},
  {{0.0909262146042 , 0.454536892698 ,0}, 0.022387247263},
  {{0.401416680649 , 0.401416680649 ,0}, 0.0302661258695},
  {{0.401416680649 , 0.197166638701 ,0}, 0.0302661258695},
  {{0.197166638701 , 0.401416680649 ,0}, 0.0302661258695},
  {{0.255551654403 , 0.255551654403 ,0}, 0.0304909678022},
  {{0.255551654403 , 0.488896691194 ,0}, 0.0304909678022},
  {{0.488896691194 , 0.255551654403 ,0}, 0.0304909678022},
  {{0.177077942152 , 0.177077942152 ,0}, 0.0241592127416},
  {{0.177077942152 , 0.645844115696 ,0}, 0.0241592127416},
  {{0.645844115696 , 0.177077942152 ,0}, 0.0241592127416},
  {{0.110061053228 , 0.110061053228 ,0}, 0.0160508035868},
  {{0.110061053228 , 0.779877893544 ,0}, 0.0160508035868},
  {{0.779877893544 , 0.110061053228 ,0}, 0.0160508035868},
  {{0.0555286242518 , 0.0555286242518 ,0}, 0.00808458026178},
  {{0.0555286242518 , 0.888942751496 ,0}, 0.00808458026178},
  {{0.888942751496 , 0.0555286242518 ,0}, 0.00808458026178},
  {{0.0126218637772 , 0.0126218637772 ,0}, 0.00207936202748},
  {{0.0126218637772 , 0.974756272446 ,0}, 0.00207936202748},
  {{0.974756272446 , 0.0126218637772 ,0}, 0.00207936202748},
  {{0.395754787357 , 0.600633794795 ,0}, 0.00388487690498},
  {{0.600633794795 , 0.00361141784841 ,0}, 0.00388487690498},
  {{0.00361141784841 , 0.395754787357 ,0}, 0.00388487690498},
  {{0.395754787357 , 0.00361141784841 ,0}, 0.00388487690498},
  {{0.600633794795 , 0.395754787357 ,0}, 0.00388487690498},
  {{0.00361141784841 , 0.600633794795 ,0}, 0.00388487690498},
  {{0.30792998388 , 0.557603261589 ,0}, 0.025574160612},
  {{0.557603261589 , 0.134466754531 ,0}, 0.025574160612},
  {{0.134466754531 , 0.30792998388 ,0}, 0.025574160612},
  {{0.30792998388 , 0.134466754531 ,0}, 0.025574160612},
  {{0.557603261589 , 0.30792998388 ,0}, 0.025574160612},
  {{0.134466754531 , 0.557603261589 ,0}, 0.025574160612},
  {{0.264566948407 , 0.720987025817 ,0}, 0.00888090357334},
  {{0.720987025817 , 0.0144460257761 ,0}, 0.00888090357334},
  {{0.0144460257761 , 0.264566948407 ,0}, 0.00888090357334},
  {{0.264566948407 , 0.0144460257761 ,0}, 0.00888090357334},
  {{0.720987025817 , 0.264566948407 ,0}, 0.00888090357334},
  {{0.0144460257761 , 0.720987025817 ,0}, 0.00888090357334},
  {{0.358539352206 , 0.594527068956 ,0}, 0.0161245467617},
  {{0.594527068956 , 0.0469335788382 ,0}, 0.0161245467617},
  {{0.0469335788382 , 0.358539352206 ,0}, 0.0161245467617},
  {{0.358539352206 , 0.0469335788382 ,0}, 0.0161245467617},
  {{0.594527068956 , 0.358539352206 ,0}, 0.0161245467617},
  {{0.0469335788382 , 0.594527068956 ,0}, 0.0161245467617},
  {{0.157807405969 , 0.839331473681 ,0}, 0.00249194181749},
  {{0.839331473681 , 0.00286112035057 ,0}, 0.00249194181749},
  {{0.00286112035057 , 0.157807405969 ,0}, 0.00249194181749},
  {{0.157807405969 , 0.00286112035057 ,0}, 0.00249194181749},
  {{0.839331473681 , 0.157807405969 ,0}, 0.00249194181749},
  {{0.00286112035057 , 0.839331473681 ,0}, 0.00249194181749},
  {{0.0750505969759 , 0.701087978926 ,0}, 0.018242840119},
  {{0.701087978926 , 0.223861424098 ,0}, 0.018242840119},
  {{0.223861424098 , 0.0750505969759 ,0}, 0.018242840119},
  {{0.0750505969759 , 0.223861424098 ,0}, 0.018242840119},
  {{0.701087978926 , 0.0750505969759 ,0}, 0.018242840119},
  {{0.223861424098 , 0.701087978926 ,0}, 0.018242840119},
  {{0.142421601113 , 0.82293132407 ,0}, 0.0102585637362},
  {{0.82293132407 , 0.0346470748168 ,0}, 0.0102585637362},
  {{0.0346470748168 , 0.142421601113 ,0}, 0.0102585637362},
  {{0.142421601113 , 0.0346470748168 ,0}, 0.0102585637362},
  {{0.82293132407 , 0.142421601113 ,0}, 0.0102585637362},
  {{0.0346470748168 , 0.82293132407 ,0}, 0.0102585637362},
  {{0.0654946280829 , 0.924344252621 ,0}, 0.0037999288553},
  {{0.924344252621 , 0.0101611192963 ,0}, 0.0037999288553},
  {{0.0101611192963 , 0.0654946280829 ,0}, 0.0037999288553},
  {{0.0654946280829 , 0.0101611192963 ,0}, 0.0037999288553},
  {{0.924344252621 , 0.0654946280829 ,0}, 0.0037999288553},
  {{0.0101611192963 , 0.924344252621 ,0}, 0.0037999288553}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1


// -----------------------------------------------------------------------------
/*! Quadrature rule for an interpolation of order 20 on the triangle */
/* 'Higher-order Finite Elements', P.Solin, K.Segeth and I. Dolezel */

IntPt triP20Solin[79] = {
  {{0.333333333333 , 0.333333333333 ,0}, 0.0330570555416},
  {{0.500950464352 , 0.500950464352 ,0}, 0.000867019185663},
  {{0.500950464352 , -0.0019009287044 ,0}, 0.000867019185663},
  {{-0.0019009287044 , 0.500950464352 ,0}, 0.000867019185663},
  {{0.488212957935 , 0.488212957935 ,0}, 0.0116600527164},
  {{0.488212957935 , 0.0235740841305 ,0}, 0.0116600527164},
  {{0.0235740841305 , 0.488212957935 ,0}, 0.0116600527164},
  {{0.45513668695 , 0.45513668695 ,0}, 0.0228769363564},
  {{0.45513668695 , 0.0897266360994 ,0}, 0.0228769363564},
  {{0.0897266360994 , 0.45513668695 ,0}, 0.0228769363564},
  {{0.401996259318 , 0.401996259318 ,0}, 0.0304489826739},
  {{0.401996259318 , 0.196007481363 ,0}, 0.0304489826739},
  {{0.196007481363 , 0.401996259318 ,0}, 0.0304489826739},
  {{0.255892909759 , 0.255892909759 ,0}, 0.0306248917254},
  {{0.255892909759 , 0.488214180481 ,0}, 0.0306248917254},
  {{0.488214180481 , 0.255892909759 ,0}, 0.0306248917254},
  {{0.176488255995 , 0.176488255995 ,0}, 0.0243680576768},
  {{0.176488255995 , 0.64702348801 ,0}, 0.0243680576768},
  {{0.64702348801 , 0.176488255995 ,0}, 0.0243680576768},
  {{0.104170855337 , 0.104170855337 ,0}, 0.015997432032},
  {{0.104170855337 , 0.791658289326 ,0}, 0.015997432032},
  {{0.791658289326 , 0.104170855337 ,0}, 0.015997432032},
  {{0.0530689638409 , 0.0530689638409 ,0}, 0.0076983018156},
  {{0.0530689638409 , 0.893862072318 ,0}, 0.0076983018156},
  {{0.893862072318 , 0.0530689638409 ,0}, 0.0076983018156},
  {{0.041618715196 , 0.041618715196 ,0}, -0.000632060497488},
  {{0.041618715196 , 0.916762569608 ,0}, -0.000632060497488},
  {{0.916762569608 , 0.041618715196 ,0}, -0.000632060497488},
  {{0.0115819214068 , 0.0115819214068 ,0}, 0.00175113430119},
  {{0.0115819214068 , 0.976836157186 ,0}, 0.00175113430119},
  {{0.976836157186 , 0.0115819214068 ,0}, 0.00175113430119},
  {{0.344855770229 , 0.606402646106 ,0}, 0.0164658391896},
  {{0.606402646106 , 0.0487415836648 ,0}, 0.0164658391896},
  {{0.0487415836648 , 0.344855770229 ,0}, 0.0164658391896},
  {{0.344855770229 , 0.0487415836648 ,0}, 0.0164658391896},
  {{0.606402646106 , 0.344855770229 ,0}, 0.0164658391896},
  {{0.0487415836648 , 0.606402646106 ,0}, 0.0164658391896},
  {{0.377843269595 , 0.615842614457 ,0}, 0.00483903354049},
  {{0.615842614457 , 0.0063141159486 ,0}, 0.00483903354049},
  {{0.0063141159486 , 0.377843269595 ,0}, 0.00483903354049},
  {{0.377843269595 , 0.0063141159486 ,0}, 0.00483903354049},
  {{0.615842614457 , 0.377843269595 ,0}, 0.00483903354049},
  {{0.0063141159486 , 0.615842614457 ,0}, 0.00483903354049},
  {{0.306635479062 , 0.55904800039 ,0}, 0.0258049065347},
  {{0.55904800039 , 0.134316520547 ,0}, 0.0258049065347},
  {{0.134316520547 , 0.306635479062 ,0}, 0.0258049065347},
  {{0.306635479062 , 0.134316520547 ,0}, 0.0258049065347},
  {{0.55904800039 , 0.306635479062 ,0}, 0.0258049065347},
  {{0.134316520547 , 0.55904800039 ,0}, 0.0258049065347},
  {{0.249419362775 , 0.736606743263 ,0}, 0.00847109105444},
  {{0.736606743263 , 0.0139738939624 ,0}, 0.00847109105444},
  {{0.0139738939624 , 0.249419362775 ,0}, 0.00847109105444},
  {{0.249419362775 , 0.0139738939624 ,0}, 0.00847109105444},
  {{0.736606743263 , 0.249419362775 ,0}, 0.00847109105444},
  {{0.0139738939624 , 0.736606743263 ,0}, 0.00847109105444},
  {{0.212775724803 , 0.711675142287 ,0}, 0.0183549141063},
  {{0.711675142287 , 0.0755491329098 ,0}, 0.0183549141063},
  {{0.0755491329098 , 0.212775724803 ,0}, 0.0183549141063},
  {{0.212775724803 , 0.0755491329098 ,0}, 0.0183549141063},
  {{0.711675142287 , 0.212775724803 ,0}, 0.0183549141063},
  {{0.0755491329098 , 0.711675142287 ,0}, 0.0183549141063},
  {{0.146965436053 , 0.861402717155 ,0}, 0.000704404677908},
  {{0.861402717155 , -0.00836815320823 ,0}, 0.000704404677908},
  {{-0.00836815320823 , 0.146965436053 ,0}, 0.000704404677908},
  {{0.146965436053 , -0.00836815320823 ,0}, 0.000704404677908},
  {{0.861402717155 , 0.146965436053 ,0}, 0.000704404677908},
  {{-0.00836815320823 , 0.861402717155 ,0}, 0.000704404677908},
  {{0.137726978829 , 0.835586957912 ,0}, 0.0101126849275},
  {{0.835586957912 , 0.0266860632587 ,0}, 0.0101126849275},
  {{0.0266860632587 , 0.137726978829 ,0}, 0.0101126849275},
  {{0.137726978829 , 0.0266860632587 ,0}, 0.0101126849275},
  {{0.835586957912 , 0.137726978829 ,0}, 0.0101126849275},
  {{0.0266860632587 , 0.835586957912 ,0}, 0.0101126849275},
  {{0.059696109149 , 0.929756171557 ,0}, 0.00357390938595},
  {{0.929756171557 , 0.0105477192941 ,0}, 0.00357390938595},
  {{0.0105477192941 , 0.059696109149 ,0}, 0.00357390938595},
  {{0.059696109149 , 0.0105477192941 ,0}, 0.00357390938595},
  {{0.929756171557 , 0.059696109149 ,0}, 0.00357390938595},
  {{0.0105477192941 , 0.929756171557 ,0}, 0.00357390938595}
};

// 0 negative weights, 0 points outside of the triangle,  total sum of the weights is 1

IntPt * GQTSolin[21] = {
  triP1Solin,
  triP1Solin,
  triP2Solin,
  triP3Solin,
  triP4Solin,
  triP5Solin,
  triP6Solin,
  triP7Solin,
  triP8Solin,
  triP9Solin,
  triP10Solin,
  triP11Solin,
  triP12Solin,
  triP13Solin,
  triP14Solin,
  triP15Solin,
  triP16Solin,
  triP17Solin,
  triP18Solin,
  triP19Solin,
  triP20Solin
};
  
int GQTnPtSolin[21] = {
  1,
  1,
  3,
  4,
  6,
  7,
  12,
  13,
  16,
  19,
  25,
  27,
  33,
  37,
  42,
  48,
  52,
  61,
  70,
  73,
  79};

IntPt *getGQTPts(int order);
int getNGQTPts(int order);

IntPt *getGQTPts(int order)
{ 
  if (order < 21) return GQTSolin[order];
  int n = (order+3)/2;
  int index = n-4;
  if(!GQTdegen[index]){
    int npts = n*n;
    GQTdegen[index] = new IntPt[npts];
    GaussLegendreTri(n,n,GQTdegen[index]);
  }
  return GQTdegen[index]; 

}

int getNGQTPts(int order)
{ 
  if (order < 21) return GQTnPtSolin[order];  
  return ((order+3)/2)*((order+3)/2);
}

