/***********************************************************************************
 * QGLE - A Graphical Interface to GLE                                             *
 * Copyright (C) 2006  A. S. Budden & J. Struyf                                    *
 *                                                                                 *
 * This program is free software; you can redistribute it and/or                   *
 * modify it under the terms of the GNU General Public License                     *
 * as published by the Free Software Foundation; either version 2                  *
 * of the License, or (at your option) any later version.                          *
 *                                                                                 *
 * This program is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of                  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                   *
 * GNU General Public License for more details.                                    *
 *                                                                                 *
 * You should have received a copy of the GNU General Public License               *
 * along with this program; if not, write to the Free Software                     *
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. *
 *                                                                                 *
 * Also add information on how to contact you by electronic and paper mail.        *
 ***********************************************************************************/

/***************************************************************
 * about.cpp: The class implementation for the about box.      *
 ***************************************************************/

#include <QtGui>
#include "about.h"
#include "qgle_statics.h"
#include "qgle_definitions.h"

AboutBox::AboutBox(QWidget* par) : QDialog(par) {
	// Set the window title and size
	setWindowTitle(tr("About %1 %2: %3", "Title for about box")
			.arg(APP_NAME)
			.arg(QGLE_VERSION)
			.arg(QGLE::prettyDate(RELEASE_DATE)));

	QHBoxLayout *top = new QHBoxLayout();
	QVBoxLayout *left = new QVBoxLayout();
	QLabel* icon = new QLabel(this);
	icon->setPixmap(QPixmap(":/images/gle.png").scaled(QSize(64, 64)));
	left->addWidget(icon);
	left->addStretch(1);
	top->addLayout(left);

	// Create a label to display readme.txt
	QTextEdit* readmeLabel = new QTextEdit();
	readmeLabel->setReadOnly(true);

	// Create a new file object linked to the application
	// resource that is compiled in from readme.txt
	QFile readme(":/readme.txt");

	// Open the file as a read only text file
	if (!readme.open(QIODevice::ReadOnly | QIODevice::Text))
		return;
	// Get the text and put it in the label
	QString readmeText = readme.readAll().constData();

	QFont readmeFont;
	// Set the font to be fixed pitch
	readmeFont.setStyleHint(QFont::Courier);
	readmeFont.setFixedPitch(true);
	readmeFont.setFamily("Courier");
	readmeFont.setStretch(QFont::Condensed);
	readmeLabel->setFont(readmeFont);
	readmeLabel->setTextColor(Qt::black);
	readmeLabel->setPlainText(readmeText);
	top->addWidget(readmeLabel);

	QPushButton *okButton = new QPushButton(tr("Close"));
	connect(okButton, SIGNAL(clicked()), this, SLOT(close()));
	QHBoxLayout *buttonLayout = new QHBoxLayout();
	buttonLayout->addStretch(1);
	buttonLayout->addWidget(okButton);

	QVBoxLayout *layout = new QVBoxLayout();
	layout->addLayout(top);
	layout->addLayout(buttonLayout);
	setLayout(layout);

	QDesktopWidget* desk = QApplication::desktop();
	QRect size = desk->screenGeometry(this);
	resize(size.width()/2, size.height()/2);
}

