/*
  Glaurung, a UCI chess playing engine.
  Copyright (C) 2004-2007 Tord Romstad

  Glaurung is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  Glaurung is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#if !defined(PSQTAB_H_INCLUDED)
#define PSQTAB_H_INCLUDED

////
//// Includes
////

#include "position.h"


////
//// Variables
////

int Position::MgPieceSquareTable[16][64] = {
  { },
  { // Pawn
    0, 0, 0, 0, 0, 0, 0, 0,
    166, 192, 204, 216, 216, 204, 192, 166,
    166, 192, 210, 242, 242, 210, 192, 166, 
    166, 192, 220, 268, 268, 220, 192, 166, 
    166, 192, 220, 242, 242, 220, 192, 166, 
    166, 192, 210, 216, 216, 210, 192, 166, 
    166, 192, 204, 216, 216, 204, 192, 166, 
    0, 0, 0, 0, 0, 0, 0, 0
  }, 
  { // Knight
    704, 730, 756, 768, 768, 756, 730, 704, 
    743, 768, 794, 807, 807, 794, 768, 743, 
    781, 807, 832, 844, 844, 832, 807, 781, 
    807, 832, 857, 870, 870, 857, 832, 807, 
    820, 844, 870, 883, 883, 870, 844, 820, 
    820, 844, 870, 883, 883, 870, 844, 820, 
    781, 807, 832, 844, 844, 832, 807, 781, 
    650, 768, 794, 807, 807, 794, 768, 650
  }, 
  { // Bishop
    786, 786, 792, 797, 797, 792, 786, 786, 
    812, 832, 827, 832, 832, 827, 832, 812, 
    817, 827, 842, 837, 837, 842, 827, 817, 
    822, 832, 837, 852, 852, 837, 832, 822, 
    822, 832, 837, 852, 852, 837, 832, 822, 
    817, 827, 842, 837, 837, 842, 827, 817, 
    812, 832, 827, 832, 832, 827, 832, 812, 
    812, 812, 817, 822, 822, 817, 812, 812
  }, 
  { // Rook
    1267, 1275, 1282, 1289, 1289, 1282, 1275, 1267, 
    1267, 1275, 1282, 1289, 1289, 1282, 1275, 1267, 
    1267, 1275, 1282, 1289, 1289, 1282, 1275, 1267, 
    1267, 1275, 1282, 1289, 1289, 1282, 1275, 1267, 
    1267, 1275, 1282, 1289, 1289, 1282, 1275, 1267, 
    1267, 1275, 1282, 1289, 1289, 1282, 1275, 1267, 
    1267, 1275, 1282, 1289, 1289, 1282, 1275, 1267, 
    1267, 1275, 1282, 1289, 1289, 1282, 1275, 1267
  }, 
  { // Queen
    2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 
    2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 
    2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 
    2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 
    2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 
    2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 
    2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560, 
    2560, 2560, 2560, 2560, 2560, 2560, 2560, 2560
  }, 
  { // King
    302, 328, 276, 225, 225, 276, 328, 302, 
    276, 302, 251, 200, 200, 251, 302, 276, 
    225, 251, 200, 149, 149, 200, 251, 225, 
    200, 225, 175, 124, 124, 175, 225, 200, 
    175, 200, 149, 98, 98, 149, 200, 175, 
    149, 175, 124, 72, 72, 124, 175, 149, 
    124, 149, 98, 47, 47, 98, 149, 124, 
    98, 124, 72, 21, 21, 72, 124, 98, 
  }
};


int Position::EgPieceSquareTable[16][64] = {
  { },
  { // Pawn
    0, 0, 0, 0, 0, 0, 0, 0, 
    256, 256, 256, 256, 256, 256, 256, 256, 
    256, 256, 256, 256, 256, 256, 256, 256, 
    256, 256, 256, 256, 256, 256, 256, 256, 
    256, 256, 256, 256, 256, 256, 256, 256, 
    256, 256, 256, 256, 256, 256, 256, 256, 
    256, 256, 256, 256, 256, 256, 256, 256, 
    0, 0, 0, 0, 0, 0, 0, 0
  },
  { // Knight
    730, 756, 781, 794, 794, 781, 756, 730, 
    756, 781, 807, 820, 820, 807, 781, 756, 
    781, 807, 832, 844, 844, 832, 807, 781, 
    794, 820, 844, 857, 857, 844, 820, 794, 
    794, 820, 844, 857, 857, 844, 820, 794, 
    781, 807, 832, 844, 844, 832, 807, 781, 
    756, 781, 807, 820, 820, 807, 781, 756, 
    730, 756, 781, 794, 794, 781, 756, 730
  },
  { // Bishop
    786, 802, 809, 817, 817, 809, 802, 786, 
    802, 817, 825, 832, 832, 825, 817, 802, 
    809, 825, 832, 839, 839, 832, 825, 809, 
    817, 832, 839, 847, 847, 839, 832, 817, 
    817, 832, 839, 847, 847, 839, 832, 817, 
    809, 825, 832, 839, 839, 832, 825, 809, 
    802, 817, 825, 832, 832, 825, 817, 802, 
    786, 802, 809, 817, 817, 809, 802, 786
  },
  { // Rook
    1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
    1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
    1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
    1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
    1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
    1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
    1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
    1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282
  },
  { // Queen
    2499, 2520, 2530, 2540, 2540, 2530, 2520, 2499, 
    2520, 2540, 2550, 2560, 2560, 2550, 2540, 2520, 
    2530, 2550, 2560, 2570, 2570, 2560, 2550, 2530, 
    2540, 2560, 2570, 2580, 2580, 2570, 2560, 2540, 
    2540, 2560, 2570, 2580, 2580, 2570, 2560, 2540, 
    2530, 2550, 2560, 2570, 2570, 2560, 2550, 2530, 
    2520, 2540, 2550, 2560, 2560, 2550, 2540, 2520, 
    2499, 2520, 2530, 2540, 2540, 2530, 2520, 2499
  },
  { // King
    16, 78, 108, 139, 139, 108, 78, 16, 
    78, 139, 170, 200, 200, 170, 139, 78, 
    108, 170, 200, 230, 230, 200, 170, 108, 
    139, 200, 230, 261, 261, 230, 200, 139, 
    139, 200, 230, 261, 261, 230, 200, 139, 
    108, 170, 200, 230, 230, 200, 170, 108, 
    78, 139, 170, 200, 200, 170, 139, 78, 
    16, 78, 108, 139, 139, 108, 78, 16
  }
};


#endif // !defined(PSQTAB_H_INCLUDED)
