#!/usr/bin/ruby -w
# -*- ruby -*-

# -------------------------------------------------------
# Env
# -------------------------------------------------------

# Returns the home directory, for both Unix and Windows.

module Env

  def Env.home_directory
    if hm = ENV["HOME"]
      hm
    else
      hd = ENV["HOMEDRIVE"]
      hp = ENV["HOMEPATH"]
      if hd || hp
        (hd || "") + (hp || "\\")
      else
        nil
      end
    end
  end

  # matches single and double quoted strings:
  REGEXP = Regexp.new('              # either:
                       ([\"\'])      #   start with a quote, and save it ($1)
                       (             #   save this ($2)
                          (?:        #     either (and do not save this):
                           \\.       #       any escaped character
                         |           #     or
                           [^\1\\\\] #       anything that is not a quote ($1), and is not a backslash
                         )*          #     as many as we can get
                       )             #     end of $2
                       \1            #   end with the same quote we started with
                       |             # or
                       (\S+)         #   plain old nonwhitespace ($3)
                      ', 
                      Regexp::EXTENDED)
  
  # amazing that ruby-mode (Emacs) handled all that.
  
  # reads the environment variable, splitting it according to its quoting.
  def Env.split(varname)
    if v = ENV[varname]
      v.scan(REGEXP).collect { |x| x[1] || x[2] }
    else
      []
    end
  end

end
