/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-ui-elementtree.h"

#include <gtk/gtklabel.h>

#include "glrr-gobject.h"


void
g_inspector_panel_attach_element_tree (GInspectorPanel       *panel,
				       GInspectorElementTree *element_tree)
{
  g_return_if_fail (panel != NULL);
  g_return_if_fail (element_tree != NULL);
  g_return_if_fail (G_IS_INSPECTOR_PANEL (panel));
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_TREE (element_tree));


  g_signal_connect_swapped (panel,
			    "update",
			    G_CALLBACK (g_inspector_element_tree_update),
			    element_tree);
}



void
g_inspector_element_tree_node_widget_set_element (GtkWidget             *node_widget,
						  GInspectorElementType  element_type,
						  gpointer               element)
{
  GInspectorElementHolder *element_holder;


  element_holder = g_inspector_element_holder_new ();
  
  g_inspector_element_holder_set (element_holder,
                                  element_type,
                                  element);

  g_inspector_element_tree_node_widget_set_element_holder (node_widget,
							   element_holder);

  g_object_unref (G_OBJECT (element_holder));
}

void
g_inspector_element_tree_node_widget_set_element_gobject (GtkWidget *node_widget,
							  GObject   *object)
{
  g_inspector_element_tree_node_widget_set_element (node_widget,
						    G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
						    object);

  g_object_weak_xref (object,                 (GWeakNotify)gtk_widget_destroy,
		      G_OBJECT (node_widget), NULL);
}




static gint
label_expose (GtkWidget	     *widget,
	      GdkEventExpose *event,
	      gpointer	      user_data)
{
  if (GTK_WIDGET_DRAWABLE (widget))
    {
      switch (GTK_WIDGET_STATE (widget))
	{
	case GTK_STATE_PRELIGHT:
	  {
	    gint x;
	    gint y;
	    gint width;
	    gint height;
	    GtkStateType state;

	    x = widget->allocation.x;
	    y = widget->allocation.y;
	    width  = (widget->allocation.width	- 1);
	    height = (widget->allocation.height - 1);

	    state = GTK_WIDGET_STATE (widget);

	    gdk_gc_set_clip_rectangle (widget->style->fg_gc[state], &event->area);
	    gdk_gc_set_clip_rectangle (widget->style->bg_gc[state], &event->area);

	    gdk_draw_rectangle (widget->window,
				widget->style->bg_gc[state], TRUE,
				x, y, width, height);

	    gdk_draw_rectangle (widget->window,
				widget->style->fg_gc[state], FALSE,
				x, y, width, height);

	    gdk_gc_set_clip_rectangle (widget->style->fg_gc[state], NULL);
	    gdk_gc_set_clip_rectangle (widget->style->bg_gc[state], NULL);
	  }
	  break;

	default:
	  {
	  }
	  break;
	}
    }

  return FALSE;
}

GtkWidget *
g_inspector_element_tree_create_node_label (const gchar *label_text)
{
  GtkWidget *label;

  label = gtk_label_new (label_text);
  gtk_misc_set_padding (GTK_MISC (label), 2, 1);

  g_signal_connect (label,
		    "expose_event",
		    G_CALLBACK (label_expose),
		    NULL);

  return label;
}





GtkWidget *
g_inspector_element_tree_create_node_widget (const gchar           *label_text,
					     GInspectorElementType  element_type,
					     gpointer               element)
{
  GInspectorElementHolder *element_holder;
  GtkWidget *label;


  element_holder = g_inspector_element_holder_new ();
  
  g_inspector_element_holder_set (element_holder,
                                  element_type,
                                  element);


  label = g_inspector_element_tree_create_node_label (label_text);

  g_inspector_element_tree_node_widget_set_element_holder (label,
							   element_holder);

  g_object_unref (G_OBJECT (element_holder));



  return label;
}
