/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"

#include "glrr-glib.h"
#include "glrr-gtk.h"

#include <unistd.h>



static void builtin_module_init (void);

static gpointer create_panel_process_generic_info (gpointer data,
						   gpointer func_data,
						   gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_process (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-process";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-process-generic-info",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_PROCESS,
				  G_TYPE_NONE,
				  create_panel_process_generic_info,
				  NULL);
}



static gpointer
create_panel_process_generic_info (gpointer data,
				   gpointer func_data,
				   gpointer invoke_data)
{
  GtkWidget *top;

#if 1
# define NO_FRAME
#endif
#ifndef NO_FRAME
  GtkWidget *frame;

  {
    frame = gtk_frame_new (NULL);
    top = frame;
  }
#endif

  {
    GtkWidget *table;

    GList *label_list;
    GtkWidget *label;
    gint n;
    gint i;

    label_list
      = g_list_new (gtk_label_new        ("Prog Name:"),
		    gtk_label_new        (g_get_prgname()),
		    
		    gtk_label_new        ("Prog PID:"),
		    gtk_label_new_printf ("%d", (int)getpid ()),
		    
		    NULL);

    n = g_list_length (label_list);


    table = gtk_table_new (2, n/2, FALSE);
#ifndef NO_FRAME
    gtk_container_add (GTK_CONTAINER (frame), table);
#else
    top = table;
#endif
    gtk_container_set_border_width (GTK_CONTAINER (table), 4);


    for (i = 0; i < n; ++i)
      {
	label = g_list_nth_data (label_list, i);

	{
	  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	}

	{
	  gint left_attach;
	  gint top_attach;

	  left_attach = (i % 2);
	  top_attach  = (i / 2);

	  gtk_table_attach (GTK_TABLE (table),
			    label,
			    (left_attach + 0),
			    (left_attach + 1),
			    (top_attach + 0),
			    (top_attach + 1),
			    GTK_FILL, GTK_FILL,
			    2, 0);
	}
      }
  }

  return top;
}
