/*
 *  
 *  $Id: sincronizacion.h 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/icontroladoreventos.h>

namespace AtencionPrimaria {
	namespace Eventos {
		class EventoSincronizacion: public GNC::GCS::Eventos::IEvento
		{
		public:
			typedef enum {
				Play,
				Stop,
				Scroll,
				Dessincronizar
			} TipoSincronizacion;

			EventoSincronizacion(GNC::GCS::IVista* pVista, TipoSincronizacion  tipo = Play, int posicion = 0, bool relativa = true) : GNC::GCS::Eventos::IEvento(ginkgoEVT_GNKVisualizator_EventoSincronizacion, ginkgoAmbitoAtencionPrimaria, 100, pVista)
			{
				m_posicion = posicion;
				m_relativa = relativa;
				m_tipo = tipo;
				m_Nombre = "Sincronizacion";
			}

			~EventoSincronizacion(){}

			int GetPosicion(){return m_posicion;}

			bool EsRelativa(){return m_relativa;}

			TipoSincronizacion GetTipoEvento()
			{
				return m_tipo;
			}

			virtual void pushInfo(std::ostream& out) const {
				out << "Tipo = ";
				switch (m_tipo) {
					case Play:
						out << "Play";
						break;
					case Stop:
						out << "Stop";
						break;
					case Scroll:
						out << "Scroll";
						break;
					case Dessincronizar:
						out << "Dessincronizar";
						break;
				}
				out << ", Posicion = " << m_posicion << ", Relativa = " << m_relativa;
			}

		protected:
			TipoSincronizacion m_tipo;
			int m_posicion;
			bool m_relativa;
		};
	}
}
