/*
 *  $Id: lightvisualizatorextension.cpp 4555 2012-01-17 10:03:03Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#include "lightvisualizatorextension.h"
#include "lightvisualizator/controllers/lightvisualizatorcontroller.h"
#include <api/ientorno.h>

#include <iostream>
#include <wx/config.h>
#include <wx/msgdlg.h>
#include "lightvisualizator/license.h"
#include <lightvisualizator/resources/logo_lightvisualizator.h>

#if defined(_WIN32) && defined(_GINKGO_DEBUG)
//#include <vld.h>
#endif

//it's required to call this macro
IMPLEMENT_PrivateExtension(LightVisualizatorExtension)

//parameters are related with provider, version... sid is the extension id, it's used to know if a file has been imported by this extension
//this information will be used in viewer open preference
LightVisualizatorExtension::LightVisualizatorExtension(): PrivateExtension(EXT_SID, EXT_PROVIDER, EXT_DESCRIPTION, EXT_VERSION, EXT_SUBVERSION, EXT_RELEASE, EXT_BUILD, EXT_CODENAME, EXT_UPDATEURL, logo_lightvisualizator, sizeof(logo_lightvisualizator))
{
}

LightVisualizatorExtension::~LightVisualizatorExtension()
{
}

//returns extension controller module
PrivateExtension::TListControllers LightVisualizatorExtension::InitializeLibrary(GNC::GCS::IEntorno* pEntorno)
{
	TListControllers list;
	list.push_back(new LightVisualizator::LightVisualizatorController(pEntorno));
	return list;
}

//here you can implement your own security policy
bool LightVisualizatorExtension::IsActivated()
{
	return true;
}

//this extension is free to use
void LightVisualizatorExtension::ShowActivationDialog(wxWindow* pParent)
{	
	wxMessageBox(_("Lite Visualizator is Open Source"), _("Info"));
}

