/*
 *  
 *  $Id: icontroladorhl7.h 3963 2011-07-11 14:03:51Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <list>
#include <map>
#include <api/ientorno.h>

namespace GIL {
	class IModeloIntegracion;
}

namespace GIL {
	namespace HL7 {
		
		class ParserException : public std::exception {
		public:
			ParserException(const std::string& msg, const std::string& componente="GIL/HL7", bool fatal = true) throw()
			{
				this->cause = msg;
				this->component = componente;
				this->fatal = fatal;
			}
			~ParserException() throw()
			{
			}

			const std::string& GetComponent() const
			{
				return component;
			}

			const std::string& GetCause() const {
				return cause;
			}

			std::string GetFullCause() const {
				return *this;
			}

			bool IsFatal()  const {
				return fatal;
			}

			operator std::string () const {
				return std::string("Excepcion en componente ") + GetComponent() + std::string(": ")  + GetCause();
			}

			friend std::ostream& operator<<(std::ostream& out, const ParserException& ex)
			{
				out << (const std::string&) ex;
				return out;
			}

			friend std::ostream& operator<<(std::ostream& out, const ParserException* ex)
			{
				if (ex != NULL) {
					out << *ex;
				}
				else {
					out << "(NULL)";
				}
				return out;
			}

		protected:
			std::string cause;
			std::string component;
			bool fatal;
		};

		class IXMLIntegrationParser {
		public:
			virtual std::list<std::string> GetKeys() = 0;
			virtual void ParseIntegrationXML(GNC::GCS::IEntorno::ListaModelosIntegracion& modelos, wxXmlNode* pRoot) = 0;			
		};


		class IControladorHL7
		{
		public:

			typedef enum TipoInterpretacion {
				TI_SACYL
			} TipoInterpretacion;

			typedef enum TipoProtocolo {
				TP_MLLP
			} TipoProtocolo;

		protected:

			IControladorHL7(TipoInterpretacion interpretacion = TI_SACYL, TipoProtocolo protocolo = TP_MLLP)
			{
				m_Interpretacion = interpretacion;
				m_Protocolo      = protocolo;
			}

			~IControladorHL7()
			{

			}

		public:

			/* Interpretacion de mensajeria HL7. Por defecto: Sacyl. */
			void SetInterpretacion(TipoInterpretacion tipo)
			{
				m_Interpretacion = tipo;
			}

			/* Protocolo de mensajeria HL7. Por defecto: MLLP. */
			void SetProtocolo(TipoProtocolo tipo)
			{
				m_Protocolo = tipo;
			}

			void RegisterParser(const std::string& xmlKey, GnkPtr<IXMLIntegrationParser>& pParser) 
			{
				if (m_mapParsers.find(xmlKey) != m_mapParsers.end()) {
					throw ParserException(_Std("Fatal error! you can't register two parsers with same  key").c_str());
				}
				m_mapParsers[xmlKey] = pParser;
			}

			void UnRegisterParser(const std::string& xmlKey) 
			{
				if (m_mapParsers.find(xmlKey) != m_mapParsers.end()) {
					m_mapParsers.erase(m_mapParsers.find(xmlKey));
				}
			}

		protected:
			TipoInterpretacion m_Interpretacion;
			TipoProtocolo      m_Protocolo;
			typedef std::map<std::string,GnkPtr<IXMLIntegrationParser> > TMapIntegrationXMLParsers;
			TMapIntegrationXMLParsers m_mapParsers;
		};

	}
}
