/*
*  
*  $Id: lightvisualizatorview.cpp 3905 2011-06-30 08:47:47Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#include "lightvisualizatorview.h"
#include <eventos/eventosginkgo.h>
#include <lightvisualizator/wxvtk/glightvisualizatorview.h>

namespace LightVisualizator{

	/* Constructor */
	LightVisualizatorView::LightVisualizatorView(const GnkPtr<LightVisualizator::LightVisualizatorStudy>& estudio) : GNC::GCS::IVista( (GnkPtr<GNC::GCS::IContextoEstudio>)estudio)
	{
		LightStudy = estudio;
		m_Cargada = false;


		LightStudy->Ventana = GView = new LightVisualizator::GUI::GLightVisualizatorView(this);
	}


	LightVisualizatorView::~LightVisualizatorView()
	{
	}

	//----------------------------------------------------------------------------------------------------
	//region Interfaz de Carga


	// Comienzo de carga. Metodo sincrono con la interfaz.
	void LightVisualizatorView::OnCargaIniciada()
	{
	}

	// Paso 1: Cargar los ficheros en memoria. Metodo NO sincrono con la interfaz.
	void LightVisualizatorView::CargarEstudio(GNC::GCS::IComando* pCmdInvocador)
	{
	}

	// Finalizacion de la carga. Metodo sincrono con la interfaz.
	void LightVisualizatorView::OnCargaFinalizada()
	{
	}

	// Paso 2: Inicializacion del pipeline. Metodo sincrono con la interfaz.
	void LightVisualizatorView::IniciarPipeline()
	{
		LightStudy->SetIndiceActivo(0);
		//load video
		GView->LoadImageCanvas();

		m_Cargada = true;

		//lanzo el evento de imagen cargada
		LightStudy->Entorno->GetControladorEventos()->ProcesarEvento(new GNC::GCS::Eventos::EventoModificacionImagen(this,GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada));

		BuildTitle();
		LightStudy->Entorno->GetControladorHerramientas()->RefrescarHerramientas();
	}

	// Parada del pipeline. Metodo sincrono con la interfaz Se invoca en el caso de que ocurra un error de carga.
	void LightVisualizatorView::DetenerPipeline()
	{
		/////////////////////////////////	GVista->DetenerPipeline();
	}

	//endregion



	bool LightVisualizatorView::SoportaGuardar()
	{
		return false;
	}

	bool LightVisualizatorView::SoportaExportar()
	{
		return false;
	}

	void LightVisualizatorView::OnFocus()
	{
		if (!m_Activada) {
			LightStudy->Entorno->GetControladorVistas()->SolicitarActivarVista(this);
		}
	}

	void LightVisualizatorView::Activar()
	{
		GNC::GCS::IVista::Activar();
		GView->SetFocus();
	}

	wxWindow* LightVisualizatorView::GetWindow()
	{
		return GView;
	}

	void LightVisualizatorView::BuildTitle()
	{
		std::ostringstream ostr;
		std::string valor;

		LightStudy->GetTagImagenActiva("0010|0010",valor);
		for (std::string::iterator it = valor.begin(); it != valor.end(); it++) {
			if ( *it == '^') {
				*it = ' ';
			}
		}
		ostr << valor.c_str() << ", ";
		LightStudy->GetTagImagenActiva("0008|1030",valor);
		ostr << valor.c_str();
		if (!valor.empty()) {
			ostr << "/";
		}
		LightStudy->GetTagImagenActiva("0008|103e",valor);
		ostr << valor.c_str();
		m_Titulo = ostr.str();
	}

}