#!/bin/bash

GINKGO_VERSION=2
GINKGO_SUB_VERSION=6
GINKGO_SUB_RELEASE=0
GINKGO_BUILD=0
GINKGO_CODENAME="rc"

#########################################

VER=${GINKGO_VERSION}.${GINKGO_SUB_VERSION}.${GINKGO_SUB_RELEASE}.${GINKGO_BUILD}
if [ "X`uname`" == X"Darwin" ]; then
	export COPYFILE_DISABLE=true
	export COPY_EXTENDED_ATTRIBUTES_DISABLED=true
	mkdir build >/dev/null 2>&1
	cd build || exit 1
	cmake .. -DGINKGO_VERSION=${GINKGO_VERSION} -DGINKGO_SUB_VERSION=${GINKGO_SUB_VERSION} -DGINKGO_SUB_RELEASE=${GINKGO_SUB_RELEASE} -DGINKGO_BUILD=${GINKGO_BUILD} -DGINKGO_CODENAME=${GINKGO_CODENAME} -DCMAKE_BUILD_TYPE=Release -DINTERNET_DIST:BOOL=TRUE -DBUILD_OPHTALMOLOGY_EXT:BOOL=FALSE -DBUILD_DERMATHOLOGY_EXT:BOOL=FALSE -DBUILD_VIDEO_EXT:BOOL=FALSE -DBUILD_LIGHT_VISUALIZATOR_EXT:BOOL=TRUE -DUSE_SYSTEM_SQLITE:BOOL=FALSE -DUSE_PATCHED_LIBS:BOOL=TRUE -DUSE_CUSTOM_WX:BOOL=TRUE -DUSE_CUSTOM_VTK:BOOL=TRUE -DUSE_CUSTOM_ITK:BOOL=TRUE -DUSE_CUSTOM_DCMTK=TRUE -DCUSTOM_PACKAGE:BOOL=TRUE -DCMAKE_INSTALL_PREFIX:STRING=./deploy || exit 1
	cmake .. -DGINKGO_VERSION=${GINKGO_VERSION} -DGINKGO_SUB_VERSION=${GINKGO_SUB_VERSION} -DGINKGO_SUB_RELEASE=${GINKGO_SUB_RELEASE} -DGINKGO_BUILD=${GINKGO_BUILD} -DGINKGO_CODENAME=${GINKGO_CODENAME} -DCMAKE_BUILD_TYPE=Release -DINTERNET_DIST:BOOL=TRUE -DBUILD_OPHTALMOLOGY_EXT:BOOL=FALSE -DBUILD_DERMATHOLOGY_EXT:BOOL=FALSE -DBUILD_VIDEO_EXT:BOOL=FALSE -DBUILD_LIGHT_VISUALIZATOR_EXT:BOOL=TRUE -DUSE_SYSTEM_SQLITE:BOOL=FALSE -DUSE_PATCHED_LIBS:BOOL=TRUE -DUSE_CUSTOM_WX:BOOL=TRUE -DUSE_CUSTOM_VTK:BOOL=TRUE -DUSE_CUSTOM_ITK:BOOL=TRUE -DUSE_CUSTOM_DCMTK=TRUE -DCUSTOM_PACKAGE:BOOL=TRUE -DCMAKE_INSTALL_PREFIX:STRING=./deploy || exit 1
	make BUILD_ALL install || exit 1
	DIR="Ginkgo CADx ${VER}"
	rm -rf "$DIR"
	mkdir "$DIR" >/dev/null 2>&1
	cp -a "ginkgocadx/Ginkgo CADx.app" "$DIR"
	upx -9 "$DIR/Ginkgo CADx.app/Contents/MacOS/Ginkgo CADx"
	rm -rf "$DIR/Ginkgo CADx.app/Contents/PlugIns"
	mkdir "$DIR/Ginkgo CADx.app/Contents/PlugIns"
	cp "ginkgocadx/Ginkgo CADx.app/Contents/PlugIns/"*.inf "$DIR/Ginkgo CADx.app/Contents/PlugIns"
	mv "$DIR/Ginkgo CADx.app/Contents/MacOS/libvisualizator"*dylib* "$DIR/Ginkgo CADx.app/Contents/PlugIns"
	mv "$DIR/Ginkgo CADx.app/Contents/MacOS/liblightvisualizator"*dylib* "$DIR/Ginkgo CADx.app/Contents/PlugIns"
	upx -9 "$DIR/Ginkgo CADx.app/Contents/PlugIns/"*dylib*
	rm -rf "$DIR/Ginkgo CADx.app/Contents/Resources/lang"
	for lang in `cd ../cadxcore/lang; ls`; do
		if [ -d "../visualizator/lang/$lang" ]; then
			mkdir -p "$DIR/Ginkgo CADx.app/Contents/Resources/lang/$lang"
			cp ../cadxcore/lang/$lang/*.mo "$DIR/Ginkgo CADx.app/Contents/Resources/lang/$lang"
		fi
	done
	for lang in `cd ../visualizator/lang; ls`; do
		if [ -d "../visualizator/lang/$lang" ]; then
			mkdir -p "$DIR/Ginkgo CADx.app/Contents/Resources/lang/$lang"
			cp ../visualizator/lang/$lang/*.mo "$DIR/Ginkgo CADx.app/Contents/Resources/lang/$lang"
		fi
	done
	(cd "$DIR"; pwd; tar -zxvf ../../ginkgocadx/dmg_template.tgz)
	rm -f "../Ginkgo_CADx-$VER.dmg"
	rm -f "pack.temp.dmg"
	hdiutil create -srcfolder "$DIR" -volname "Ginkgo_CADx $VER" -fs HFS+ -fsargs "-c c=64,a=16,e=16" -format UDRW -size 100m pack.temp.dmg
	device=`hdiutil attach -readwrite -noverify -noautoopen "pack.temp.dmg" | egrep '^/dev/' | sed 1q | awk '{print $1}'`
	sleep 5
	echo '
	   tell application "Finder"
	     tell disk "'Ginkgo_CADx $VER'"
	           open
	           set current view of container window to icon view
	           set toolbar visible of container window to false
	           set statusbar visible of container window to false
	           set theViewOptions to the icon view options of container window
	           set arrangement of theViewOptions to not arranged
	           set icon size of theViewOptions to 72
	           set background picture of theViewOptions to file ".background:dmgbackground.png"
	           make new alias file at container window to POSIX file "/Applications" with properties {name:"Aplicaciones"}
	           update without registering applications
	           delay 5
	           eject
	     end tell
	   end tell
	' | osascript
	chmod -Rf go-w "/Volumes/Ginkgo_CADx $VER"
	sync
	sync
	hdiutil detach ${device}
	hdiutil convert "pack.temp.dmg" -format UDZO -imagekey zlib-level=9 -o "../Ginkgo_CADx-$VER.dmg"
	rm -f pack.temp.dmg
	cd ..
	cp "Ginkgo_CADx-$VER.dmg" ../../dist/0-ESTABLE/Internet/ 
	
	#set the bounds of container window to {400, 100, 885, 430}

else
	if [ "X`uname -m`" == "Xx86_64" ]; then
		ARCH=x86_64
	else
		ARCH=x86
	fi

	mkdir build >/dev/null 2>&1
	cd build || exit 1
	cmake .. -DGINKGO_VERSION:STRING=${GINKGO_VERSION} -DGINKGO_SUB_VERSION:STRING=${GINKGO_SUB_VERSION} -DGINKGO_SUB_RELEASE:STRING=${GINKGO_SUB_RELEASE} -DGINKGO_BUILD:STRING=${GINKGO_BUILD} -DGINKGO_CODENAME:STRING=${GINKGO_CODENAME} -DCMAKE_BUILD_TYPE=Release -DINTERNET_DIST:BOOL=TRUE -DBUILD_OPHTALMOLOGY_EXT:BOOL=FALSE -DBUILD_LIGHT_VISUALIZATOR_EXT:BOOL=TRUE -DBUILD_DERMATHOLOGY_EXT:BOOL=FALSE -DBUILD_VIDEO_EXT:BOOL=FALSE -DUSE_SYSTEM_SQLITE:BOOL=FALSE -DUSE_PATCHED_LIBS:BOOL=TRUE -DUSE_CUSTOM_WX:BOOL=TRUE -DUSE_CUSTOM_VTK:BOOL=TRUE -DUSE_CUSTOM_ITK:BOOL=TRUE -DUSE_CUSTOM_DCMTK=TRUE -DCUSTOM_PACKAGE:BOOL=TRUE -DCMAKE_INSTALL_PREFIX:STRING=./deploy || exit 1 
	cmake .. -DGINKGO_VERSION=${GINKGO_VERSION} -DGINKGO_SUB_VERSION=${GINKGO_SUB_VERSION} -DGINKGO_SUB_RELEASE=${GINKGO_SUB_RELEASE} -DGINKGO_BUILD=${GINKGO_BUILD} -DGINKGO_CODENAME=${GINKGO_CODENAME} -DCMAKE_BUILD_TYPE=Release -DINTERNET_DIST:BOOL=TRUE -DBUILD_OPHTALMOLOGY_EXT:BOOL=FALSE -DBUILD_LIGHT_VISUALIZATOR_EXT:BOOL=TRUE -DBUILD_DERMATHOLOGY_EXT:BOOL=FALSE -DBUILD_VIDEO_EXT:BOOL=FALSE -DUSE_SYSTEM_SQLITE:BOOL=FALSE -DUSE_PATCHED_LIBS:BOOL=TRUE -DUSE_CUSTOM_WX:BOOL=TRUE -DUSE_CUSTOM_VTK:BOOL=TRUE -DUSE_CUSTOM_ITK:BOOL=TRUE -DUSE_CUSTOM_DCMTK=TRUE -DCUSTOM_PACKAGE:BOOL=TRUE -DCMAKE_INSTALL_PREFIX:STRING=./deploy || exit 1 
	make -j4 BUILD_ALL || exit 1
	DIR=Ginkgo_CADx-${VER}_linux_${ARCH}
	rm -rf $DIR
	mkdir $DIR >/dev/null 2>&1
	cp -a dist/ginkgocadx $DIR/ginkgocadx
	cp -a dist/ginkgocadx-$ARCH $DIR/
	chmod +x dist/ginkgocadx
	cp -a dist/*.so* $DIR
	cp -a dist/*.xml $DIR
	chmod -x $DIR/*.so*
	mkdir -p $DIR/lang/es $DIR/lang/ja $DIR/lang/de $DIR/lang/tr $DIR/Plugins
	cp dist/lang/es/wxstd.mo $DIR/lang/es/wxstd.mo 
	cp dist/lang/es/ginkgocadxcore.mo $DIR/lang/es/ginkgocadxcore.mo
	cp dist/lang/es/visualizator.mo $DIR/lang/es/visualizator.mo
	cp dist/lang/es/lightvisualizator.mo $DIR/lang/es/lightvisualizator.mo
	cp dist/lang/ja/wxstd.mo $DIR/lang/ja/wxstd.mo
	cp dist/lang/ja/ginkgocadxcore.mo $DIR/lang/ja/ginkgocadxcore.mo
	cp dist/lang/ja/visualizator.mo $DIR/lang/ja/visualizator.mo
	cp dist/lang/de/ginkgocadxcore.mo $DIR/lang/de/ginkgocadxcore.mo
   cp dist/lang/de/visualizator.mo $DIR/lang/de/visualizator.mo
	cp dist/lang/tr/ginkgocadxcore.mo $DIR/lang/tr/ginkgocadxcore.mo
   cp dist/lang/tr/visualizator.mo $DIR/lang/tr/visualizator.mo
	cp -a dist/Plugins/libvisualizator.so*  $DIR/Plugins
	cp dist/Plugins/visualizator.inf  $DIR/Plugins
	cp -a dist/Plugins/liblightvisualizator.so*  $DIR/Plugins
	cp dist/Plugins/lightvisualizator.inf  $DIR/Plugins
	chmod -x dist/Plugins/*
	tar -zcvf $DIR.tgz $DIR
	if [ -d ../../../dist/0-ESTABLE/Internet ]; then
		cp $DIR.tgz ../../../dist/0-ESTABLE/Internet
	fi
fi
