/*
 *  $Id: startupview.cpp 4188 2011-09-23 08:13:40Z carlos $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
//#define _GINKGO_TRACE

#include <wx/wx.h>
#include <wx/dir.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/busyinfo.h>
#include <wx/msgdlg.h>

#include <wx/tarstrm.h>
#include <wx/zstream.h>
#include <wx/wfstream.h>

#include <api/globals.h>
#include <net/ginkgohttp.h>
#include <main/entorno.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/configurationcontroller.h>
#include <main/controllers/controladorinternacionalizacion.h>

#include "startupview.h"
#include "startupform.h"

#include <api/ientorno.h>
#include <net/ginkgohttp.h>
#include <endpoint/endpoint.h>

#undef __DEPRECATED
#include <ios>
#include <sstream>
#include <ostream>

#define LOGGER "STARTUP"
#define DEFAULT_RSS "http://twitter.com/statuses/user_timeline/247267254.rss"
#define DEFAULT_WELCOME_URL "http://ginkgo-cadx.com/[lan]/ginkgocadxwelcomescreen/"

namespace GNC {
	namespace GUI {

		StartUpView ::StartUpView (const GnkPtr<GNC::GUI::StartUpStudy>& study) : GNC::GCS::IVista((GnkPtr<GNC::GCS::IContextoEstudio>)study)
		{
			FooStudy = study;
			m_Cargada = false;

			FooStudy->Ventana = m_pWindow = new StartUpForm (this);
		}

		StartUpView ::~StartUpView ()
		{
		}

		//----------------------------------------------------------------------------------------------------
	//region Loading interface

		// Starts loading. Synchronous with interface.
		void StartUpView::OnCargaIniciada()
		{
			//nothing to do
		}

		// Step1: LoadStudy not synchronized with interface thread
		void StartUpView::CargarEstudio(GNC::GCS::IComando* /*pCmdInvocador*/)
		{
			m_twiterFile = "";
			//download file..
			wxString newTmpDir;
			do {
				newTmpDir = FROMPATH(FooStudy->Entorno->GetGinkgoTempDir()) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + wxT("_gnktmp_") + wxString::Format(wxT("%d"), rand());
			} while(wxDir::Exists(newTmpDir));

	#ifdef _WIN32
			wxFileName::Mkdir(newTmpDir);
	#else
			wxFileName::Mkdir(newTmpDir.c_str(), 0777);
	#endif

			//rss
			std::string rssURL = GetRSSUrl();
			wxString pathOfFileWx = newTmpDir + wxFileName::GetPathSeparator() + wxT("file.xml");
			if (DownloadFile(rssURL, pathOfFileWx)) {			
				m_twiterFile = TOPATH(pathOfFileWx);
			}
			//welcome
			std::string welcomeURL = GetWelcomeUrl();
			pathOfFileWx = newTmpDir + wxFileName::GetPathSeparator() + wxT("welcome.html");
			//parse url and path...
			if (DownloadFile(welcomeURL, pathOfFileWx)) {			
				m_welcomeFile = TOPATH(pathOfFileWx);
			}
		}

		//Ends loading. Synchronous with interface
		void StartUpView::OnCargaFinalizada()
		{
		      wxString wxPageFile = FROMPATH(m_twiterFile);
		      if (wxFileExists(wxPageFile)) {
					m_pWindow->LoadTwitterFile(wxPageFile);
		      } else {
					m_pWindow->ShowError();
		      }	
				wxPageFile = FROMPATH(m_welcomeFile);
				if (wxFileExists(wxPageFile)) {
					m_pWindow->LoadWelcomeFile(wxPageFile);
		      } else {
					m_pWindow->ShowError(false);
		      }	
		}

		// Step2: init pipeline synchronous with interface
		void StartUpView::IniciarPipeline()
		{
			//build view title
			BuildTitle();
		}


		// stops pipeline, it's called if there has been an error loading study
		void StartUpView::DetenerPipeline()
		{
		}

	//endregion

		bool StartUpView::SoportaGuardar()
		{
			return false;
		}

		bool StartUpView::SoportaExportar()
		{
			return false;
		}

		void StartUpView::Activar() {
			GNC::GCS::IVista::Activar();
			m_pWindow->SetFocus();
		}

		wxWindow * StartUpView::GetWindow()
		{
			return m_pWindow;
		}

		void StartUpView::OnFocus()
		{
			if (!m_Activada) {
				FooStudy->Entorno->GetControladorVistas()->SolicitarActivarVista(this);
			}
		}

		void StartUpView::BuildTitle()
		{
			m_Titulo = _Std("Start page");
		}

		bool StartUpView::DownloadFile(const std::string& fullUrl, const wxString& pathOfFileWx)
		{
			
			std::string host("");
			std::string protocolo("");
			int puerto = 0;
			std::string path("");

			if (!ParseURL(fullUrl,protocolo,host,puerto,path)) {
				LOG_ERROR(LOGGER, _Std("Rss url is not valid check configuration"));
			}
			
			

			std::stringstream	ostrUrl;
			ostrUrl << host <<':'<<puerto;
			
			std::string	url = ostrUrl.str();
			
			GIL::GnkNetwork::GnkHTTP::GinkgoHTTP request;
			request.SetHeader("Host",url);
			request.SetHeader("Accept","text/xml");
			request.SetHeader("Accept-Encoding","deflate");
			request.SetHeader("Accept-Language","es");
			std::string peticion = request.BuildGetRequest(path);
			//
			EndpointAddrlist::g_default_family = AF_INET;

			Endpoint::Initialize();

			Endpoint ep(TCP | CLIENT, url);

			if (!ep) {
				std::ostringstream ostr;
				ostr << _Std("It was impossible to connect server ") << url << std::endl;
				LOG_WARN(LOGGER, ostr.str());
				return false;
			}

			int nbytes = ep.Write(peticion.c_str());
			if (nbytes != (int)peticion.size()) {
				std::ostringstream ostr;
				ostr << _Std("Exception sending request");
				LOG_WARN(LOGGER, ostr.str());
				return false;
			}

			
			wxFile file(pathOfFileWx, wxFile::write);

			if (!file.IsOpened()) {	
				//error
				return false;
			}
			const int SIZE_OF_BUFFER = 8*1024;
			char buffer[SIZE_OF_BUFFER];
			bool firstChunk =true;
			do {
				nbytes = ep.Read(-1 * (int)sizeof(buffer), buffer);
				if (nbytes < 0) {
					std::ostringstream ostr;
					ostr << _Std("Exception reading response") ;
					LOG_WARN(LOGGER, ostr.str());
					return false;
				} else if (nbytes > 0) {
					if (firstChunk) {
						//skip header...
						int endOfHeaders = -1;
						GIL::GnkNetwork::GnkHTTP::GinkgoHTTP::MapaHeaders headers;
						GIL::GnkNetwork::GnkHTTP::GinkgoHTTP::ParseResponseBinary(buffer, nbytes, headers, endOfHeaders);
						if (endOfHeaders != -1) {
							file.Write(buffer+endOfHeaders, nbytes - endOfHeaders);
						} else {
							//ha habido un error
							LOG_WARN(LOGGER, "Error reading response " << std::string((char*) buffer,nbytes));
							file.Close();
							wxRemoveFile(pathOfFileWx);
							return false;
						}
						firstChunk = false;
					} else {
						file.Write(buffer, nbytes);
					}
				}
			} while(nbytes > 0);
			file.Close();
			return true;
		}

		std::string StartUpView::GetRSSUrl() 
		{
			std::string url;
			GNC::GCS::ConfigurationController::Instance()->readStringGeneral("GinkgoCore/News", "DefaultRSSUrl", url, DEFAULT_RSS);
			
			int language = GNC::GCS::ControladorInternacionalizacion::Instance()->GetIdiomaInterfaz();
			wxString wxDirPath = FROMPATH(GNC::Entorno::Instance()->GetGinkgoLanguageDir());
			wxDir dir;
			if (dir.Open(wxDirPath)) {
				wxString wxPathLang;
				bool cont = dir.GetFirst(&wxPathLang,wxEmptyString, wxDIR_DIRS);
				while (cont) {
					const wxLanguageInfo* pInfo = wxLocale::FindLanguageInfo(wxPathLang);
					if (pInfo != NULL) {
						if (pInfo->Language == language) {
							wxString rssKey = wxT("RSSUrl_") + pInfo->CanonicalName;
							GNC::GCS::ConfigurationController::Instance()->readStringGeneral("GinkgoCore/News", std::string(rssKey.ToUTF8()), url, url);
							break;
						}
					}
					cont = dir.GetNext(&wxPathLang);
				}
			}

			return url;
		}

		std::string StartUpView::GetWelcomeUrl() 
		{
			int language = GNC::GCS::ControladorInternacionalizacion::Instance()->GetIdiomaInterfaz();

			std::string url;
			GNC::GCS::ConfigurationController::Instance()->readStringGeneral("GinkgoCore/News", "WelcomeUrl",url,DEFAULT_WELCOME_URL);
		
			std::string strReplace;
			if (language >= wxLANGUAGE_SPANISH && language <= wxLANGUAGE_SPANISH_VENEZUELA) {
				strReplace = "es";
			} else {
				strReplace = "en";
			}
			std::string::size_type it0;
			it0 = url.find("[lan]");
			if (it0 != std::string::npos) {
				url = url.replace(it0, 5, strReplace );
			}
			return url;
		}

		bool StartUpView::ParseURL(const std::string url,std::string& protocolo, std::string& host, int& puerto, std::string& path)
		{
			if(url.size() == 0) {
				//lanzar excepcion url no configurada
			}

			//primero buscamos los :
			int posicion = url.find_first_of("://");
			if(posicion == (int)std::string::npos) {
				return false;
			}

			protocolo = url.substr(0,posicion);
			//TODO SUPPORT HTTPS
			if(protocolo != "http"){
				return false;
			}

			std::string hostPuerto;
			posicion=posicion+3;//nos saltamos el ://

			//pillamos el path
			int posicionPath = url.find('/',posicion);
			if(posicionPath == (int)std::string::npos) {
				path = "";
				hostPuerto = url.substr(posicion);
			} else {
				path = url.substr(posicionPath);
				hostPuerto = url.substr(posicion,posicionPath-posicion);
			}

			//por ultimo pillamos el host y el puerto
			int posicionPuntos = hostPuerto.find_first_of(':');
			if(posicionPuntos == (int)std::string::npos) {
				host = hostPuerto;
				//puerto igual al puerto por defecto
				if(protocolo == "https")
				{
					puerto = 443;
				} else {
					puerto = 80;
				}
			} else {
				host = hostPuerto.substr(0,posicionPuntos);
				puerto = atoi(hostPuerto.substr(posicionPuntos+1).c_str());
				if(puerto == 0){
					return false;
				}
			}
			return true;
		}
	}
}
