/*
 *  
 *  $Id: panelconfiguracionextensiones.h 4072 2011-08-10 13:45:52Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iconfiguracion.h>
#include "panelesconfiguracionginkgobase.h"
#include <string>
#include <vector>

namespace GNC {
	namespace GUI {

		class PanelConfiguracionExtensiones: public PanelConfiguracionExtensionesBase, public IPasoConfiguracion
		{
			public:
				PanelConfiguracionExtensiones(wxWindow* pParent,IDialogoConfiguracion* pDialogo);
				~PanelConfiguracionExtensiones();

				void Recargar();

				//region "Metodos de IPasoConfiguracion"
				wxWindow* GetPanel();

				std::string GetTitle();

				std::string GetCabecera();

				bool Validar();

				bool Guardar();

				void Exportar(wxXmlNode* pNodo);

				void Importar(wxXmlNode* pNodo);
				//endregion

				virtual void OnPropiedadCambiada();

				virtual void OnObtainExtensions(wxCommandEvent& event);

			protected:
								
				void OnSize(wxSizeEvent &);

				bool m_hasBeenChanged;
		};
	}
}
