/*
 *  
 *  $Id: icontroladorcomandos.h 3342 2011-02-18 10:28:11Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

#include <string>
#include <iostream>
#include <exception>
#include "icomando.h"

namespace GNC {
	namespace GCS {

		class ControladorComandosException : public std::exception {
		public:
			ControladorComandosException(const std::string& msg, const std::string& componente="Modelo", bool fatal = true) throw()
			{
				this->cause = msg;
				this->component = componente;
				this->fatal = fatal;
			}
			~ControladorComandosException() throw()
			{
			}

			const std::string& GetComponent() const
			{
				return component;
			}

			const std::string& GetCause() const {
				return cause;
			}

			std::string GetFullCause() const {
				return *this;
			}

			bool IsFatal()  const {
				return fatal;
			}

			operator std::string () const {
				return std::string("Excepcion en componente ") + GetComponent() + std::string(": ")  + GetCause();
			}

			friend std::ostream& operator<<(std::ostream& out, const ControladorComandosException& ex)
			{
				out << (const std::string&) ex;
				return out;
			}

			friend std::ostream& operator<<(std::ostream& out, const ControladorComandosException* ex)
			{
				if (ex != NULL) {
					out << *ex;
				}
				else {
					out << "(NULL)";
				}
				return out;
			}

		protected:
			std::string cause;
			std::string component;
			bool fatal;
		};


		class IControladorComandos {
		public:

			~IControladorComandos()
			{
			}

			virtual void Process(IComando*) = 0;
			virtual void ProcessAsync(std::string descr, IComando*, void* owner) = 0;
			virtual void AbortarComando(long threadId, bool sincrono = true) = 0;
			virtual void AbortarComandosDeOwner(void* owner) = 0;
			virtual void AbortarComandosDeOwnerAsincrono(void* owner) = 0;
			virtual void AbortarComando(IComando* pComando, bool sincrono = true) = 0;

		protected:

			IControladorComandos()
			{
			}

		};
	}
}
