with PSL.Errors; use PSL.Errors;
with Name_Table;
with Types; use Types;
with Ada.Text_IO;

package body Sa_Bools is
   function Sem (N : Node) return Node is
   begin
      case Get_Kind (N) is
         when N_Or_Bool
           | N_And_Bool =>
            Set_Left (N, Sem (Get_Left (N)));
            Set_Right (N, Sem (Get_Right (N)));
            return N;
         when N_Not_Bool =>
            Set_Boolean (N, Sem (Get_Boolean (N)));
            return N;
         when N_Name =>
            declare
               use Name_Table;
               Id : constant Name_Id := Get_Identifier (N);
               Name : Node;
            begin
               Name := Node (Get_Info (Id));
               if Name /= Null_Node then
                  return Name;
               end if;
               Name := Create_Node (N_HDL_Expr);
               Set_HDL_Node (Name, Int32 (Id));
               Set_Info (Id, Int32 (Name));
               return Name;
            end;
         when others =>
            Error_Kind ("sem", N);
      end case;
   end Sem;

   procedure Print_HDL_Expr (N : Node) is
   begin
      Ada.Text_IO.Put (Image (Name_Id (Get_HDL_Node (N))));
   end Print_HDL_Expr;
end Sa_Bools;
