/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  treesortablesignals.cc - Gtk::TreeSortable virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "treesortable.hh"
#include "treesortablesignals.hh"
#include "private/treesortableiface.hh"
#include <gfc/glib/object.hh>
#include <gfc/glib/objectsignals.hh>

using namespace GFC;

/*  Gtk::TreeSortableSignals
 */

Gtk::TreeSortableSignals::TreeSortableSignals(TreeSortable *sortable)
{
	Gtk::TreeSortableIface::init(GTK_TREE_SORTABLE_GET_IFACE(sortable->gtk_tree_sortable()));
}

Gtk::TreeSortableSignals::~TreeSortableSignals()
{
}
	
void
Gtk::TreeSortableSignals::on_sort_column_changed()
{
	GtkTreeSortableIface *g_iface = TreeSortableIface::get_parent_iface(instance_);
	if (g_iface->sort_column_changed)
		g_iface->sort_column_changed((GtkTreeSortable*)instance_);
}

/*  Gtk::TreeSortableIface
 */

void
Gtk::TreeSortableIface::init(GtkTreeSortableIface *g_iface)
{
	g_iface->sort_column_changed = &sort_column_changed_proxy;
}

GtkTreeSortableIface*
Gtk::TreeSortableIface::get_parent_iface(void *instance)
{
	void *ptr = g_type_interface_peek_parent(GTK_TREE_SORTABLE_GET_IFACE(instance));
	return static_cast<GtkTreeSortableIface*>(ptr);
}

void
Gtk::TreeSortableIface::sort_column_changed_proxy(GtkTreeSortable *sortable)
{
	void *ptr = g_object_get_qdata((GObject*)sortable, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TreeSortableSignals*>(object)->on_sort_column_changed();
	}
	else
	{
		GtkTreeSortableIface *g_iface = TreeSortableIface::get_parent_iface(sortable);
		if (g_iface->sort_column_changed)
			g_iface->sort_column_changed(sortable);
	}
}

