/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  radioactionsignals.cc - Gtk::RadioAction virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "radioaction.hh"
#include "radioactionsignals.hh"
#include "private/radioactionclass.hh"

using namespace GFC;

/*  Gtk::RadioActionSignals
 */

Gtk::RadioActionSignals::RadioActionSignals(RadioAction *action)
: ToggleActionSignals(action)
{
	Gtk::RadioActionClass::init(GTK_RADIO_ACTION_GET_CLASS(action->gtk_radio_action()));
}

Gtk::RadioActionSignals::~RadioActionSignals()
{
}

void
Gtk::RadioActionSignals::on_changed(RadioAction& current)
{
	GtkRadioActionClass *g_class = RadioActionClass::get_parent_class(instance_);
	if (g_class->changed)
		g_class->changed((GtkRadioAction*)instance_, current.gtk_radio_action());
}

/*  Gtk::RadioActionClass
 */

void
Gtk::RadioActionClass::init(GtkRadioActionClass *g_class)
{
	g_class->changed = &changed_proxy;
}

GtkRadioActionClass*
Gtk::RadioActionClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_RADIO_ACTION_GET_CLASS(instance));
	return static_cast<GtkRadioActionClass*>(ptr);
}

GType
Gtk::RadioActionClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_RADIO_ACTION);
	}
	return type;
}

void*
Gtk::RadioActionClass::create(const char *name)
{
	return g_object_new(get_type(), "name", name, 0);
}

void
Gtk::RadioActionClass::changed_proxy(GtkRadioAction *action, GtkRadioAction *current)
{
	void *ptr = g_object_get_qdata((GObject*)action, G::ObjectSignals::quark());
	if (ptr)
		static_cast<RadioActionSignals*>(ptr)->on_changed(*G::Object::wrap<RadioAction>(current));
	else
	{
		GtkRadioActionClass *g_class = RadioActionClass::get_parent_class(action);
		if (g_class->changed)
			g_class->changed(action, current);
	}
}

