/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  eventbox.cc - GtkEventBox C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "eventbox.hh"
#include "private/eventboxclass.hh"

using namespace GFC;

/*  Gtk::EventBox
 */

Gtk::EventBox::EventBox(GtkEventBox *event_box, bool reference)
: Bin((GtkBin*)event_box, reference)
{
}

Gtk::EventBox::EventBox() 
: Bin((GtkBin*)EventBoxClass::create())
{
}

Gtk::EventBox::~EventBox()
{
}

/*  Gtk::EventBoxClass
 */

GType
Gtk::EventBoxClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_EVENT_BOX);
	}
	return type;
}

void*
Gtk::EventBoxClass::create()
{
	return g_object_new(get_type(), 0);
}

