#  callback.rb - 
#  Copyright (C) 2004-2006 Frédéric Logier

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

require 'geekast/views/lib/glade_base'
require 'geekast/views/lib/multimedia'


module Geekast
  module View


    class CallbackMain < GladeBase
      include GetText

      def initialize
        super("geekast.glade", "main")
        bindtextdomain(Geekast::TEXTDOMAIN, nil, nil, "UTF-8")

        @icon = GeekastTrayIcon.new(@main)

        $Gvideo = @drawingarea_video

        @multimedia = Multimedia.main

        # Geekast/Peercast configuration
        @geekastConfig = Geekast::Model::Preferences.instance


        @model_yp = TreeviewChannel.new(@treeview_yp)

 
        @Vsignal = Hash.new


        @model_relay = TreeviewChannel.new(@treeview_relay)
        @model_connections = TreeviewConnections.new(@treeview_connection)
        @model_bookmark = TreeviewBookmark.new(@treeview_bookmark)


        @Vsignal["VrefreshBAR"]  = SIGNAL.connect("VrefreshBAR") {|data1, data2, data3|
          refreshBar(data1, data2, data3)
        }


        SIGNAL.connect("VclearTreeview") {|data|
          case data
          when Config::YP
            @model_yp.clear_tree
            @label_yp.set_markup("<b>Channels :</b> ")
          when Config::RELAY
            @model_relay.clear_tree
            @label_relay.set_markup("<b>Channels :</b> ")
          when Config::CONNECTION
            @model_connections.clear_tree
          when Config::BOOKMARK
            @model_bookmark.clear_tree
          end
        }

        SIGNAL.connect("VrefreshYP") {|data1,data2,data3|
          puts "VrefreshYP" if $DEBUG
          @icon.append(data1)
          refreshTreeview(@label_yp,@model_yp,data1,data2,data3)
        }

        SIGNAL.connect("VrefreshRelay") {|data1,data2,data3|
          puts "VrefreshRelay" if $DEBUG
#          puts data1.class
          @icon.append(data1)
          refreshTreeview(@label_relay,@model_relay,data1,data2,data3)
        }

        SIGNAL.connect("VrefreshConnection") {|data|
          puts "VrefreshConnection" if $DEBUG
          refreshTreeview(nil,@model_connections,data,nil,nil)
        }

        SIGNAL.connect("VrefreshInformation") {|data1, data2, data3, data4|
          puts "VrefreshInformation" if $DEBUG
          refreshInformation(data1, data2, data3, data4)
        }

        SIGNAL.connect("VrefreshBM") {|data|
          refreshBM(data)
        }

        @Vsignal["VnotifyBAR"] = SIGNAL.connect("VnotifyBAR") {|data|
          notifyBAR(data)
        }

        SIGNAL.connect("VblockSignal") {|data|
          @toolbutton_refresh.sensitive = true
          SIGNAL.handler_block(@Vsignal[data])
        }


        SIGNAL.connect("VunblockSignal") {|data|
          SIGNAL.handler_unblock(@Vsignal[data])
        }


        SIGNAL.connect("VrefreshVIDEO") {
          puts "VrefreshVIDEO" if $DEBUG
          @notebook_main.page = Config::VIDEO 
          @radiobutton_video.active = true
        }


        SIGNAL.connect("VstatusChannelinfo") {|data|
          puts "VstatusChannelinfo" if $DEBUG
          channelInfo(data)
        }


        SIGNAL.connect("VrefreshWeb") {|data|
          puts "VrefreshWeb" if $DEBUG
          if data
            @gecko.location = data
            SIGNAL.emit("VnotifyBAR", data + _(" updated"))
          end
          @notebook_main.page = Config::WEB
          @radiobutton_web.active = true
          @toolbutton_refresh.sensitive = true
        }



        load_pref
      end


      #######
      private
      #######


      def channelInfo(data)
        @geekastmenu_relay.sensitive(data)
      end


      def refreshInformation(data1, data2, data3, data4)

        if data1
          @label_info_1.text = data1["uptime"]
          @label_info_2.text = data1["channel_cache"]
          @label_info_3.text = data1["firewalled"]
          @label_info_4.text = data1["gnethostcache"]
        end

        if data2
          @label_bandwidth_0.text = data2["totalin"]
          @label_bandwidth_1.text = data2["totalout"]
          @label_bandwidth_2.text = data2["total"]
          @label_bandwidth_3.text = data2["internetin"]
          @label_bandwidth_4.text = data2["internetout"]
          @label_bandwidth_5.text = data2["internettotal"]
          @label_bandwidth_6.text = data2["gnetin"]
          @label_bandwidth_7.text = data2["gnetout"]
          @label_bandwidth_8.text = data2["gnettotal"]
          @label_bandwidth_9.text = data2["gnetpacketsin"]
          @label_bandwidth_10.text = data2["gnetpacketsout"]
          @label_bandwidth_11.text = data2["gnetpacketstotal"]
        end

        if data3
          @label_connections_0.text = data3["direct"]
          @label_connections_1.text = data3["relay"]
          @label_connections_2.text = data3["cincout"]
          @label_connections_3.text = data3["pgnu"]
          @label_connections_4.text = data3["incoming"]

          @label_connections_5.text = "Port " + data3["port1"] + " / " + data3["port2"]
          @label_connections_6.text = data3["port1active"] + " / " + data3["port2active"]

          #          @label_connections_7.text = data3["port1active"]
          #          @label_connections_8.text = data3["port2active"]
        end

        if data4
          @label_internal_0.text = data4["version"]
          @label_internal_1.text = data4["rootmsg"]
          @label_internal_2.text = data4["serverip"]
          @label_info_0.text = data4["serverip"]
          @label_internal_3.text = data4["localip"]
          @label_internal_4.text = data4["serverport"]
          @label_internal_5.text = data4["serverport1"]
        end

        SIGNAL.emit("VnotifyBAR", Config::PEERCAST_IP + _(" updated"))
      end


      def refreshBM(data)
        puts "VrefreshBM" if $DEBUG
        count = 0
        while count < data.length
          refreshTreeview(@label_bookmark,@model_bookmark, data[count]["channel"], count+1, data.length)
          @icon.append(data[count]["channel"])
          count += 1
        end
      end

      def refreshBar(data1, data2, data3)
           progressbar = @appbar.progress
          if data1 == -1 && data3 != 0
            somme = data2.to_f/data3.to_f

            progressbar.fraction = somme

            while (Gtk.events_pending?)
              Gtk.main_iteration
            end

          else
            @appbar.set_progress_percentage(0)
            @toolbutton_refresh.sensitive = true

          end
       end


      def notifyBAR(data)
          @appbar.push(data)
      end


      def refreshTreeview(label,model,data1,data2,data3)
          model.model_line(data1)

          if label
            label.set_markup("<b>Channels :</b> " + data2.to_s + " on " + data3.to_s + " ")
          end
          if model == @model_yp && data2 != data3
            SIGNAL.emit("VnotifyBAR", _(" xml break..."))
          else
            case model
            when @model_yp
              SIGNAL.emit("VnotifyBAR", Config::YELLOWPAGES_IP + _(" updated"))
            when @model_connections
              SIGNAL.emit("VnotifyBAR", Config::PEERCAST_IP + _(" updated"))
            end
          end
      end


      def refreshRelay(data)
        @model_relay.model_line(data)
      end



 

      def on_showcolumn_activate(widget)
        puts widget.name  if $DEBUG
        #        puts "col_" + #{widget} + "_visible"



        case widget.name
        when "name"
          if widget.active?
            @geekastConfig.col_name_visible = TRUE
          else
            @geekastConfig.col_name_visible = FALSE
          end
        when "id"
          if widget.active?
            @geekastConfig.col_id_visible = TRUE
          else
            @geekastConfig.col_id_visible = FALSE
          end
        when "bitrate"
          if widget.active?
            @geekastConfig.col_bitrate_visible = TRUE
          else
            @geekastConfig.col_bitrate_visible = FALSE
          end
        when "type"
          if widget.active?
            @geekastConfig.col_type_visible = TRUE
          else
            @geekastConfig.col_type_visible = FALSE
          end
        when "genre"
          if widget.active?
            @geekastConfig.col_genre_visible = TRUE
          else
            @geekastConfig.col_genre_visible = FALSE
          end
        when "desc"
          if widget.active?
            @geekastConfig.col_desc_visible = TRUE
          else
            @geekastConfig.col_desc_visible = FALSE
          end
        when "url"
          if widget.active?
            @geekastConfig.col_url_visible = TRUE
          else
            @geekastConfig.col_url_visible = FALSE
          end
        when "uptime"
          if widget.active?
            @geekastConfig.col_uptime_visible = TRUE
          else
            @geekastConfig.col_uptime_visible = FALSE
          end
        when "comment"
          if widget.active?
            @geekastConfig.col_comment_visible = TRUE
          else
            @geekastConfig.col_comment_visible = FALSE
          end
        when "skips"
          if widget.active?
            @geekastConfig.col_skips_visible = TRUE
          else
            @geekastConfig.col_skips_visible = FALSE
          end
        when "age"
          if widget.active?
            @geekastConfig.col_age_visible = TRUE
          else
            @geekastConfig.col_age_visible = FALSE
          end
        end


        if widget.active?
          @model_relay.show_column(@treeview_relay, widget.name)
          @model_yp.show_column(@treeview_yp, widget.name)
        else
          @model_relay.hide_column(@treeview_relay, widget.name)
          @model_yp.hide_column(@treeview_yp, widget.name)
        end


      end



      def on_showtoolbar_activate(widget)
        if !widget.active?
          @bonobodockitem_toolbar.hide_all
          @geekastConfig.toolbar_visible = false
        else
          @bonobodockitem_toolbar.show_all
          @geekastConfig.toolbar_visible = true
        end
      end
      def on_showsidebar_activate(widget)
        if !widget.active?
          @handlebox_sidebar.hide_all
          @geekastConfig.sidepan_visible = false
        else
          @handlebox_sidebar.show_all
          @geekastConfig.sidepan_visible = true
        end
      end
      def on_sidebar_radiobutton_toggled(widget)
        n = 0
        
        # get button list
        buttonList = widget.group
        
        # Parcours de la liste
        while buttonList[n]
          # selected button
          if buttonList[n].active?
            #           puts "toggled : " + n.to_s
            # puts "button : " + buttonList.length.to_s
            # toto = buttonList.length - n - 1
            # puts "button : " + toto.to_s
            
            #associate toogle button with a notebook page
            @notebook_main.page =  buttonList.length - n - 1
            break
          else
            n = n + 1
          end
        end
      end 
      
      def on_fullscreen_activate
      end
      def on_connect_activate
      end
      def on_disconnect_activate
      end
      def on_mic_on_activate
      end
      def on_mic_off_activate
      end
      def on_toolbutton_connect_clicked(widget)
      end
      def on_refresh_activate
        if @notebook_main.page != Config::BOOKMARK && @notebook_main.page != Config::VIDEO
          SIGNAL.emit("VrefreshBAR", -1, 0, 0)
          @toolbutton_refresh.sensitive = false
          @icon.clean(@notebook_main.page)
          SIGNAL.emit("CrefreshNB", @notebook_main.page)
        end
      end

      def on_pref_cancelbutton_clicked(widget)
        puts "on_pref_cancelbutton_clicked() is not implemented yet."
      end
      def on_preferences_activate(widget)
        CallbackPref.new
      end
      def on_quit_activate(widget)
        Gtk.main_quit
        # $mainloop.quit
      end
      def on_about_activate(widget)
        about_glade = GladeXML.new(Config::DATA_DIR + "/glade/geekast.glade", "about")
        about_glade["about"].hide
        about_glade["about"].name = NAME
        about_glade["about"].version = VERSION
        about_glade["about"].comments = COMMENTS
        about_glade["about"].show
      end
      def on_properties_activate(widget)
        puts "on_properties_activate() is not implemented yet."
      end
      def on_tab_activate
        if @checkmenuitem_tabs.active?
          @notebook_main.show_tabs = true
          @geekastConfig.tabs_visible = true
        else
          @notebook_main.show_tabs = false
          @geekastConfig.tabs_visible = false
        end
      end

      def on_comboboxentry_genre_changed
        puts "genre changed" if $DEBUG
        @model_yp.change_filter(4, @comboboxentry_genre.active_text)
      end


      def on_entrykeyword_changed
        puts "keyword changed" if $DEBUG
      end


      def on_combobox_bitrate_changed
        puts "bitrate changed" if $DEBUG
        #        @model_yp.change_filter(2, @comboboxentry_bitrate.active_text)
      end


      def on_combobox_type_changed
        puts "type changed" if $DEBUG
        @model_yp.change_filter(3, @combobox_type.active_text)
      end

      def on_toolbutton_stop_clicked
        @multimedia.stop
      end

      def on_toolbutton_play_clicked
        case @notebook_main.page
        when Config::RELAY
          @geekastmenu_relay.on_play_activate
        when Config::YP
          @geekastmenu_yp.on_play_activate
        when Config::BOOKMARK
          @geekastmenu_bookmark.on_play_activate
        end
      end

      def on_toolbutton_record_clicked
      end

      #######
      private
      #######

      def load_pref
        tabs_pref
        columns_pref
        bars_pref


        @comboboxentry_genre.active = 0
        @combobox_bitrate.active = 0
        @combobox_type.active = 0

        @model_yp.change_filter(6, @comboboxentry_genre.active_text)

        SIGNAL.emit("CrefreshNB", Config::INFORMATION)
        SIGNAL.emit("CrefreshNB", Config::BOOKMARK)
      end




      def tabs_pref
        if @geekastConfig.tabs_visible == true
          @checkmenuitem_tabs.active = true
        else
          @checkmenuitem_tabs.active = false
        end
      end


      def bars_pref
        if @geekastConfig.sidepan_visible == true
          @checkmenuitem_sidebar.active = true
        else
          @checkmenuitem_sidebar.active = false
        end

        if @geekastConfig.toolbar_visible == true
          @checkmenuitem_toolbar.active = true
        else
          @checkmenuitem_toolbar.active = false
        end
      end


      def columns_pref
        if @geekastConfig.col_name_visible
          @name.active = TRUE
        else
          @name.active = FALSE
        end
        if @geekastConfig.col_id_visible
          @id.active = TRUE
        else
          @id.active = FALSE
        end
        if @geekastConfig.col_bitrate_visible
          @bitrate.active = TRUE
        else
          @bitrate.active = FALSE
        end
        if @geekastConfig.col_type_visible
          @type.active = TRUE
        else
          @type.active = FALSE
        end
        if @geekastConfig.col_genre_visible
          @genre.active = TRUE
        else
          @genre.active = FALSE
        end
        if @geekastConfig.col_desc_visible
          @desc.active = TRUE
        else
          @desc.active = FALSE
        end
        if @geekastConfig.col_url_visible
          @url.active = TRUE
        else
          @url.active = FALSE
        end
        if @geekastConfig.col_uptime_visible
          @uptime.active = TRUE
        else
          @uptime.active = FALSE
        end
        if @geekastConfig.col_comment_visible
          @comment.active = TRUE
        else
          @comment.active = FALSE
        end
        if @geekastConfig.col_skips_visible
          @skips.active = TRUE
        else
          @skips.active = FALSE
        end
        if @geekastConfig.col_age_visible
          @age.active = TRUE
        else
          @age.active = FALSE
        end
        
      end
      
      
    end
    




    class ChannelInfo < GladeBase
      def initialize(url)
        super("geekast.glade", "channel_info")
        @channel_info.hide

        @SchannelInfo = SIGNAL.connect("VrefreshChannelInfo") {|data|
          puts "VrefreshChannelInfo" if $DEBUG
          if data
            @label_name.text = data["name"]
            @label_cgenre.text = data["cgenre"]
            @label_desc.text = data["desc"]
            @label_url.text = data["url"]
            @label_comment.text = data["comment"]
            @label_id.text = data["id"]
            @label_type.text = data["type"]
            @label_bitrate.text = data["bitrate"]
            @label_source.text = data["source"]
            @label_uptime.text = data["uptime"]
            @label_status.text = data["status"]
            @label_position.text = data["position"]
            @label_head.text = data["head"]
            @label_artist.text = data["artist"]
            @label_title.text = data["title"]
            @label_album.text = data["album"]
            @label_tgenre.text = data["tgenre"]
            @label_contact.text = data["contact"]
            @channel_info.show
          end
        }
        SIGNAL.emit("VstatusChannelinfo", 1)
        SIGNAL.emit("CgetChannelinfo", url)


        @Tchannel = Gtk::timeout_add(2000) {
          puts "Timeout !" if $DEBUG
          SIGNAL.emit("CgetChannelinfo", url)
          true
        }

      end


      def on_channel_info_destroy
        SIGNAL.handler_block(@SchannelInfo)
        puts "Timeout channelInfo removed" if $DEBUG
        Gtk::timeout_remove(@Tchannel)
        SIGNAL.emit("VstatusChannelinfo", 0)
      end
    end




    
    class CallbackPref < GladeBase
      def initialize
        super("geekast.glade", "preferences")
        @geekastConfig = Geekast::Model::Preferences.instance


        # Peercast config
        @entry_pip.text = @geekastConfig.ip
        @spinbutton_pspin.value = @geekastConfig.port.to_i
        @entry_ppassword.text = @geekastConfig.password
        @entry_yp.text = @geekastConfig.yellowpages
        @entry_gpo.text = @geekastConfig.player_options


        # Geekast config
        @checkbutton_player.active = @geekastConfig.internal_player

        unless @geekastConfig.player.empty?
          @filechooserbutton_player.filename = @geekastConfig.player
        else
          @filechooserbutton_player.current_folder = Config::HOME_USER
        end

        @checkbutton_effect.active = @geekastConfig.effect
      end

      def on_closebutton_clicked(widget)
        @preferences.destroy
      end

      def on_entry_pip_changed(widget)
        @geekastConfig.ip = @entry_pip.text
      end

      def on_spinbutton_pspin_change_value(widget)
        @geekastConfig.port = @spinbutton_pspin.value
      end

      def on_entry_ppassword_changed(widget)
        @geekastConfig.password = @entry_ppassword.text
      end

      def on_entry_yp_changed(widget)
        @geekastConfig.yellowpages = @entry_yp.text
      end


      def on_filechooserbutton_player_selection_changed
        @geekastConfig.player = @filechooserbutton_player.filename.to_s
      end

      def on_checkbutton_player_toggled
        unless @geekastConfig.internal_player = @checkbutton_player.active?
          @filechooserbutton_player.sensitive = TRUE
        else
          @filechooserbutton_player.sensitive = FALSE
        end
      end

      def on_checkbutton_effect_toggled
        @geekastConfig.effect = @checkbutton_effect.active?
      end






      def on_entry_gpo_changed(widget)
        @geekastConfig.player_options = @entry_gpo.text
      end


    end










    
  end
end
