package GCPlugins::GCfilms::GCDicschop;

###################################################
#
#  Copyright 2005-2007 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCfilms::GCfilmsCommon;

{
    package GCPlugins::GCfilms::GCPluginDicshop;

    use base qw(GCPlugins::GCfilms::GCfilmsPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
		
        if ($self->{parsingList})
        {
            return if $self->{parsingEnded};
            if (($tagname eq 'a')
             && ($attr->{href} =~ /ds\.php\?red=ds_produkt/)
             && ($attr->{class} eq 'PRODUCTLINK'))
            {
                $self->{isMovie} = 1;
                $self->{itemIdx}++;
                $self->{itemsList}[$self->{itemIdx}]->{url} = $attr->{href};
                my $info = $attr->{title};
                if ($info =~ /.*?fr.n ([0-9]{4}) med (.*?) och (.*)\.$/)
                {
                    $self->{itemsList}[$self->{itemIdx}]->{date} = $1;
                    $self->{itemsList}[$self->{itemIdx}]->{actors} = "$2,$3";
                }
            }
            elsif (($tagname eq 'font')
                && ($attr->{style} eq 'font-size:14px;'))
            {
                $self->{insideCategoryTitle} = 1;
            }
            elsif (($tagname eq 'span')
                && ($attr->{class} eq 'GREY'))
            {
                $self->{isPotentialDate} = 1;
            }
        }
        else
        {
            if (($tagname eq 'span')
             && ($attr->{class} eq 'HEADER_PRODUCT'))
            {
                $self->{isTitle} = 1;
            }
            elsif ($tagname eq 'font')
            {
                if ($attr->{class} eq 'dsrubrik3')
                {
                    $self->{isInfo} = 1;
                }
            }
            elsif (($tagname eq 'tr')
                && ($attr->{bgcolor} eq '#EEEEEE'))
            {
                $self->{isPotentialSynopsis} = 1;
            }
            elsif ($tagname eq 'img')
            {
                if ($attr->{src} =~ m{http://www.discshop.se/shop/img/omslag/front_normal/})
                {
                    $self->{curInfo}->{image} = $attr->{src};
                }
            }
            elsif ($tagname eq 'table')
            {
                $self->{isSynopsis} = 0;
                $self->{curInfo}->{synopsis} =~ s/\n*$//;
            }
            elsif ($tagname eq 'br')
            {
                $self->{curInfo}->{synopsis} .= "\n"
                    if ($self->{isSynopsis} && $self->{curInfo}->{synopsis});
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        $origtext =~ s/^\s*//;
        $origtext =~ s/\s*$//;
        return if !$origtext;

        if ($self->{parsingList})
        {
            if ($self->{insideCategoryTitle})
            {
                $self->{parsingEnded} = 1 if $origtext eq 'Spel';
                $self->{insideCategoryTitle} = 0;
            }
            elsif (($self->{isMovie})
                && (!$self->{itemsList}[$self->{itemIdx}]->{title})
                && ($origtext))
            {
                $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                $self->{isInfo} = 1;
                $self->{isMovie} = 0;
            }
            elsif ($self->{isPotentialDate})
            {
                $self->{itemsList}[$self->{itemIdx}]->{date} = $1
                    if $origtext =~ /\(([-\d]*)\)/;
                $self->{isPotentialDate} = 0;
            }
            elsif ($self->{isInfo})
            {
                $origtext =~ /^.*?(\d{4}) +(med +([^-.]*))?/;
                if ($1)
                {
                    $self->{itemsList}[$self->{itemIdx}]->{date} = $1 if $1;
                    $self->{itemsList}[$self->{itemIdx}]->{actors} = $3;
                }
                else
                {
                    $origtext =~ /med +([^-.]*)/;
                    $self->{itemsList}[$self->{itemIdx}]->{actors} = $1
                        if $1;
                }
                $self->{itemsList}[$self->{itemIdx}]->{actors} =~ s/ och/,/g;
                $self->{isInfo} = 0;
            }
        }
        else
        {
            if ($self->{isTitle})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{isTitle} = 0;
            }
            elsif ($self->{isInfo})
            {
                $origtext =~ /(.*?) fr.n ([0-9]{4}) av (.*?) med (.*?) och (.*)\.$/;
                $self->{curInfo}->{genre} = $1;
                $self->{curInfo}->{date} = $2;
                $self->{curInfo}->{director} = $3;
                $self->{curInfo}->{actors} = "$4,$5";
                $self->{isInfo} = 0;
            }
            elsif ($self->{isSynopsis})
            {
                $self->{isPotentialSynopsis} = 0;
                $self->{curInfo}->{synopsis} .= $origtext;
            }
            elsif ($self->{isPotentialSynopsis})
            {
                if ($origtext =~ /(Filmens) handling:/i)
                {
                    $self->{isSynopsis} = 1;
                    $self->{curInfo}->{synopsis} = '';
                }
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 1,
            director => 0,
            actors => 1,
        };

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
            $self->{parsingEnded} = 0;
            $self->{insideCategoryTitle} = 0;
        }
        else
        {
            $self->{isInfo} = 0;
            $self->{isTitle} = 0;
            $self->{isPotentialDate} = 0;
            $self->{isPotentialSynopsis} = 0;
            $self->{isSynopsis} = 0;
           # $html =~ s/<A.*?ds_kategori.*?>(.*?)<\/A>/$1/g;
           # $html =~ s/<A.*?ds_person.*?>(.*?)<\/A>/$1/g;
            $html =~ s|<a CLASS="blackNUL"[^>]*>([^<]*)</a>|$1|gi;
            $html =~ s|<FONT COLOR="white">i</FONT>| |gi;
            $html =~ s/<IMG SRC="img\/design\/pix.gif" WIDTH=2 HEIGHT=5>//g;
        }

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.discshop.se/shop/search_result.php?ref=&subsite=movies&lang=se&_q=$word&__search=1&sok_typ=titel";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.discshop.se/shop/'.$url;
    }

    sub changeUrl
    {
        my ($self, $url) = @_;
        
        return $url;
    }

    sub getName
    {
        return "Dicshop.se";
    }
    
    sub getCharset
    {
        my $self = shift;
    
        return "Windows-1252";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'SV';
    }
    
}

1;
