#############################################################################
##
#W  smgideal.gd              GAP library                     Robert Arthur
##
#H  @(#)$Id: smgideal.gd,v 4.12 2003/04/14 16:21:57 gap Exp $
##
#Y  Copyright (C)  1996,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  This file contains declarations relating to semigroup ideals.
##
Revision.smgideal_gd :=
    "@(#)$Id: smgideal.gd,v 4.12 2003/04/14 16:21:57 gap Exp $";


#############################################################################
##
#O  SemigroupIdealByGenerators(<S>, <gens>)
##
##  <S> is a semigroup, <gens> is a list of elements of <S>.
##  Returns the two-sided ideal of <S> generated by <gens>.
##
DeclareSynonym("SemigroupIdealByGenerators", MagmaIdealByGenerators );


#############################################################################
##
#P  IsLeftSemigroupIdeal(<I>)
#P  IsRightSemigroupIdeal(<I>)
#P  IsSemigroupIdeal(<I>)
##  
##  Categories of semigroup ideals.
##
DeclareProperty("IsLeftSemigroupIdeal", IsLeftMagmaIdeal );
DeclareProperty("IsRightSemigroupIdeal", IsRightMagmaIdeal );
DeclareProperty("IsSemigroupIdeal", IsMagmaIdeal );


#############################################################################
##
#A  ReesCongruenceOfSemigroupIdeal( <I> )
##
##  A two sided ideal <I> of a semigroup <S>  defines a congruence on 
##  <S> given by $\Delta \cup I \times I$.
##
DeclareAttribute("ReesCongruenceOfSemigroupIdeal", IsMagmaIdeal);


DeclareGlobalFunction( "EnumeratorOfSemigroupIdeal" );
DeclareGlobalFunction( "IsBound_LeftSemigroupIdealEnumerator" );
DeclareGlobalFunction( "IsBound_RightSemigroupIdealEnumerator" );


#############################################################################
##
#E

