#ifndef NODE_DATA_T_H
#define NODE_DATA_T_H 1
#include <ganglia/hash.h>

typedef struct
   {
      uint32_t start_time;
      struct timeval timestamp;
      unsigned int tmax;
      unsigned int dmax;
      char   *hostname;
      char location[MAX_G_STRING_SIZE];  /* Node's location in the cluster "x,y,z" */
      hash_t *hashp;
      hash_t *user_hashp;
   }
node_data_t;   

#define MAX_VAL_LEN 256
#define MAX_TYPE_LEN  16
#define MAX_UNITS_LEN 16 
#define MAX_SLOPE_LEN 16
/* The size of an ethernet frame, minus some for the name/units. */
#define FRAMESIZE  1400

/* Value payload gets trimmed later. */
typedef struct
   {
      char type[MAX_TYPE_LEN];
      char units[MAX_UNITS_LEN];
      struct timeval timestamp;
      unsigned int tmax;
      unsigned int dmax;
      char slope[MAX_SLOPE_LEN];
      unsigned int valsize;
      char val[FRAMESIZE];
   }
metric_data_t;
#endif
