/*******************************************
 *
 * $GAMGI/src/mesa/gamgi_mesa_translate.c
 *
 * Copyright (C) 2001, 2004 Carlos Pereira
 *
 * Distributed under the terms of the GNU
 * General Public License: $GAMGI/LICENSE
 *
 */

#include "gamgi_engine.h"
#include "gamgi_gtk.h"
#include "gamgi_global.h"

#include "gamgi_mesa_translate_out.h"
#include "gamgi_math_vector.h"

void gamgi_mesa_translate_text (gamgi_text *text, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_text (text, translate);

dlist = text->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_orbital (gamgi_orbital *orbital, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_orbital (orbital, translate);

dlist = orbital->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_bond (gamgi_bond *bond, double *translate)
{
gamgi_dlist *dlist;

dlist = bond->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = bond->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_atom (gamgi_atom *atom, double *translate)
{
gamgi_bond *bond;
gamgi_dlist *dlist;

gamgi_mesa_translate_out_atom (atom, translate);

/************************************************
 * translate bond elements only the second time *
 ************************************************/

dlist = atom->bond_start;
while (dlist != NULL)
  { 
  bond = GAMGI_CAST_BOND dlist->data;
  dlist = dlist->next;

  if (bond->atom2 == NULL) continue;
  if (bond->first == TRUE) { bond->first = FALSE; continue; }
  else bond->first = TRUE;

  gamgi_mesa_translate_bond (bond, translate);
  }

dlist = atom->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = atom->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_direction (gamgi_direction *direction, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_direction (direction, translate);

dlist = direction->atom_start;
while (dlist != NULL)
  { gamgi_mesa_translate_atom (GAMGI_CAST_ATOM dlist->data, translate);
    dlist = dlist->next; }

dlist = direction->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = direction->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_plane (gamgi_plane *plane, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_plane (plane, translate);

dlist = plane->direction_start;
while (dlist != NULL)
  { gamgi_mesa_translate_direction (GAMGI_CAST_DIRECTION dlist->data, translate);
    dlist = dlist->next; }

dlist = plane->atom_start;
while (dlist != NULL)
  { gamgi_mesa_translate_atom (GAMGI_CAST_ATOM dlist->data, translate);
    dlist = dlist->next; }

dlist = plane->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = plane->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_group (gamgi_group *group, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_group (group, translate);

dlist = group->group_start;
while (dlist != NULL)
  { gamgi_mesa_translate_group (GAMGI_CAST_GROUP dlist->data, translate);
    dlist = dlist->next; }

dlist = group->plane_start;
while (dlist != NULL) 
  { gamgi_mesa_translate_plane (GAMGI_CAST_PLANE dlist->data, translate);
    dlist = dlist->next; }

dlist = group->direction_start;
while (dlist != NULL)
  { gamgi_mesa_translate_direction (GAMGI_CAST_DIRECTION dlist->data, translate);
    dlist = dlist->next; }

dlist = group->atom_start;
while (dlist != NULL)
  { gamgi_mesa_translate_atom (GAMGI_CAST_ATOM dlist->data, translate);
    dlist = dlist->next; }

dlist = group->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = group->text_start;
while (dlist != NULL) 
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_molecule (gamgi_molecule *molecule, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_molecule (molecule, translate);

dlist = molecule->group_start;
while (dlist != NULL)
  { gamgi_mesa_translate_group (GAMGI_CAST_GROUP dlist->data, translate);
    dlist = dlist->next; }

dlist = molecule->plane_start;
while (dlist != NULL) 
  { gamgi_mesa_translate_plane (GAMGI_CAST_PLANE dlist->data, translate);
    dlist = dlist->next; } 

dlist = molecule->direction_start;
while (dlist != NULL)
  { gamgi_mesa_translate_direction (GAMGI_CAST_DIRECTION dlist->data, translate);
    dlist = dlist->next; }

dlist = molecule->atom_start;
while (dlist != NULL)
  { gamgi_mesa_translate_atom (GAMGI_CAST_ATOM dlist->data, translate);
    dlist = dlist->next; }

dlist = molecule->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = molecule->text_start;
while (dlist != NULL) 
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; } 
}

void gamgi_mesa_translate_cluster (gamgi_cluster *cluster, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_cluster (cluster, translate);

dlist = cluster->cluster_start;
while (dlist != NULL)
  { gamgi_mesa_translate_cluster (GAMGI_CAST_CLUSTER dlist->data, translate);
    dlist = dlist->next; }

dlist = cluster->molecule_start;
while (dlist != NULL)
  { gamgi_mesa_translate_molecule (GAMGI_CAST_MOLECULE dlist->data, translate);
    dlist = dlist->next; }

dlist = cluster->group_start;
while (dlist != NULL)
  { gamgi_mesa_translate_group (GAMGI_CAST_GROUP dlist->data, translate);
    dlist = dlist->next; }

dlist = cluster->plane_start;
while (dlist != NULL) 
  { gamgi_mesa_translate_plane (GAMGI_CAST_PLANE dlist->data, translate);
    dlist = dlist->next; }

dlist = cluster->direction_start;
while (dlist != NULL)
  { gamgi_mesa_translate_direction (GAMGI_CAST_DIRECTION dlist->data, translate);
    dlist = dlist->next; }

dlist = cluster->atom_start;
while (dlist != NULL)
  { gamgi_mesa_translate_atom (GAMGI_CAST_ATOM dlist->data, translate);
    dlist = dlist->next; }

dlist = cluster->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = cluster->text_start;
while (dlist != NULL) 
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_cell (gamgi_cell *cell, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_cell (cell, translate);

dlist = cell->cluster_start;
while (dlist != NULL)
  { gamgi_mesa_translate_cluster (GAMGI_CAST_CLUSTER dlist->data, translate);
    dlist = dlist->next; }

dlist = cell->molecule_start;
while (dlist != NULL)
  { gamgi_mesa_translate_molecule (GAMGI_CAST_MOLECULE dlist->data, translate);
    dlist = dlist->next; }

dlist = cell->group_start;
while (dlist != NULL)
  { gamgi_mesa_translate_group (GAMGI_CAST_GROUP dlist->data, translate);
    dlist = dlist->next; }

dlist = cell->plane_start;
while (dlist != NULL)
  { gamgi_mesa_translate_plane (GAMGI_CAST_PLANE dlist->data, translate);
    dlist = dlist->next; }

dlist = cell->direction_start;
while (dlist != NULL)
  { gamgi_mesa_translate_direction (GAMGI_CAST_DIRECTION dlist->data, translate);
    dlist = dlist->next; }

dlist = cell->atom_start;
while (dlist != NULL)
  { gamgi_mesa_translate_atom (GAMGI_CAST_ATOM dlist->data, translate);
    dlist = dlist->next; }

dlist = cell->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = cell->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_arrow (gamgi_arrow *arrow, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_arrow (arrow, translate);

dlist = arrow->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_shape (gamgi_shape *shape, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_shape (shape, translate);

dlist = shape->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_graph (gamgi_graph *graph, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_graph (graph, translate);

dlist = graph->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_assembly (gamgi_assembly *assembly, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_assembly (assembly, translate);

dlist = assembly->assembly_start;
while (dlist != NULL)
  { gamgi_mesa_translate_assembly (GAMGI_CAST_ASSEMBLY dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->graph_start;
while (dlist != NULL)
  { gamgi_mesa_translate_graph (GAMGI_CAST_GRAPH dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->shape_start;
while (dlist != NULL)
  { gamgi_mesa_translate_shape (GAMGI_CAST_SHAPE dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->arrow_start;
while (dlist != NULL)
  { gamgi_mesa_translate_arrow (GAMGI_CAST_ARROW dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->cell_start;
while (dlist != NULL)
  { gamgi_mesa_translate_cell (GAMGI_CAST_CELL dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->cluster_start;
while (dlist != NULL)
  { gamgi_mesa_translate_cluster (GAMGI_CAST_CLUSTER dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->molecule_start;
while (dlist != NULL)
  { gamgi_mesa_translate_molecule (GAMGI_CAST_MOLECULE dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->group_start;
while (dlist != NULL)
  { gamgi_mesa_translate_group (GAMGI_CAST_GROUP dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->plane_start;
while (dlist != NULL)
  { gamgi_mesa_translate_plane (GAMGI_CAST_PLANE dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->direction_start;
while (dlist != NULL)
  { gamgi_mesa_translate_direction (GAMGI_CAST_DIRECTION dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->atom_start;
while (dlist != NULL)
  { gamgi_mesa_translate_atom (GAMGI_CAST_ATOM dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = assembly->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_light (gamgi_light *light, double *translate)
{
gamgi_mesa_translate_out_light (light, translate);
}

void gamgi_mesa_translate_layer (gamgi_layer *layer, double *translate)
{
gamgi_dlist *dlist;

gamgi_mesa_translate_out_layer (layer, translate);

dlist = layer->assembly_start;
while (dlist != NULL)
  { gamgi_mesa_translate_assembly (GAMGI_CAST_ASSEMBLY dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->graph_start;
while (dlist != NULL)
  { gamgi_mesa_translate_graph (GAMGI_CAST_GRAPH dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->shape_start;
while (dlist != NULL)
  { gamgi_mesa_translate_shape (GAMGI_CAST_SHAPE dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->arrow_start;
while (dlist != NULL)
  {  gamgi_mesa_translate_arrow (GAMGI_CAST_ARROW dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->cell_start;
while (dlist != NULL)
  { gamgi_mesa_translate_cell (GAMGI_CAST_CELL dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->cluster_start;
while (dlist != NULL)
  { gamgi_mesa_translate_cluster (GAMGI_CAST_CLUSTER dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->molecule_start;
while (dlist != NULL)
  { gamgi_mesa_translate_molecule (GAMGI_CAST_MOLECULE dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->group_start;
while (dlist != NULL)
  { gamgi_mesa_translate_group (GAMGI_CAST_GROUP dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->plane_start;
while (dlist != NULL)
  { gamgi_mesa_translate_plane (GAMGI_CAST_PLANE dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->direction_start;
while (dlist != NULL)
  { gamgi_mesa_translate_direction (GAMGI_CAST_DIRECTION dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->atom_start;
while (dlist != NULL)
  { gamgi_mesa_translate_atom (GAMGI_CAST_ATOM dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->orbital_start;
while (dlist != NULL)
  { gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL dlist->data, translate);
    dlist = dlist->next; }

dlist = layer->text_start;
while (dlist != NULL)
  { gamgi_mesa_translate_text (GAMGI_CAST_TEXT dlist->data, translate);
    dlist = dlist->next; }
}

void gamgi_mesa_translate_object (gamgi_object *object, double *translate)
{
gamgi_group *group;
gamgi_plane *plane;
gamgi_direction *direction;

switch (object->class)
  {
  case GAMGI_ENGINE_TEXT:
  gamgi_mesa_translate_text (GAMGI_CAST_TEXT object, translate);
  break;

  case GAMGI_ENGINE_ORBITAL:
  gamgi_mesa_translate_orbital (GAMGI_CAST_ORBITAL object, translate);
  break;

  case GAMGI_ENGINE_BOND:
  gamgi_mesa_translate_out_bond (GAMGI_CAST_BOND object, translate);
  gamgi_mesa_translate_bond (GAMGI_CAST_BOND object, translate);
  break;

  case GAMGI_ENGINE_ATOM:
  gamgi_mesa_translate_atom (GAMGI_CAST_ATOM object, translate);
  break;

  case GAMGI_ENGINE_DIRECTION:
  direction = GAMGI_CAST_DIRECTION object;
  if (direction->autonomy == GAMGI_GTK_NONE)
    gamgi_mesa_translate_object (object->object, translate);
  else
    gamgi_mesa_translate_direction (direction, translate);
  break;

  case GAMGI_ENGINE_PLANE:
  plane = GAMGI_CAST_PLANE object;
  if (plane->autonomy == GAMGI_GTK_NONE)
    gamgi_mesa_translate_object (object->object, translate);
  else
    gamgi_mesa_translate_plane (plane, translate);
  break;

  case GAMGI_ENGINE_GROUP:
  group = GAMGI_CAST_GROUP object;
  if (group->autonomy == GAMGI_GTK_NONE)
    gamgi_mesa_translate_object (object->object, translate);
  else
    gamgi_mesa_translate_group (group, translate);
  break;

  case GAMGI_ENGINE_MOLECULE:
  gamgi_mesa_translate_molecule (GAMGI_CAST_MOLECULE object, translate);
  break;

  case GAMGI_ENGINE_CLUSTER:
  gamgi_mesa_translate_cluster (GAMGI_CAST_CLUSTER object, translate);
  break;

  case GAMGI_ENGINE_CELL:
  gamgi_mesa_translate_cell (GAMGI_CAST_CELL object, translate);
  break;

  case GAMGI_ENGINE_ARROW:
  gamgi_mesa_translate_arrow (GAMGI_CAST_ARROW object, translate);
  break;

  case GAMGI_ENGINE_SHAPE:
  gamgi_mesa_translate_shape (GAMGI_CAST_SHAPE object, translate);
  break;

  case GAMGI_ENGINE_GRAPH:
  gamgi_mesa_translate_graph (GAMGI_CAST_GRAPH object, translate);
  break;

  case GAMGI_ENGINE_ASSEMBLY:
  gamgi_mesa_translate_assembly (GAMGI_CAST_ASSEMBLY object, translate);
  break;

  case GAMGI_ENGINE_LIGHT:
  gamgi_mesa_translate_light (GAMGI_CAST_LIGHT object, translate);
  break;

  case GAMGI_ENGINE_LAYER:
  gamgi_mesa_translate_layer (GAMGI_CAST_LAYER object, translate);
  break;

  default:
  break;
  }

}

void gamgi_mesa_translate_out (gamgi_layer *layer, double *translate)
{
double *referential;
double x[3], y[3], z[3];

referential = layer->referential;
gamgi_math_vector_absolute (x, referential[0], referential[3], referential[6]);
gamgi_math_vector_absolute (y, referential[1], referential[4], referential[7]);
gamgi_math_vector_absolute (z, referential[2], referential[5], referential[8]);

/*****************************************
 * apply translation along vectors x,y,z *
 *****************************************/

gamgi_math_vector_scale (x, x, translate[0]);
gamgi_math_vector_scale (y, y, translate[1]);
gamgi_math_vector_scale (z, z, translate[2]);

/*******************************************
 * add x,y,z to get the global translation *
 *******************************************/

translate[0] = x[0] + y[0] + z[0];
translate[1] = x[1] + y[1] + z[1];
translate[2] = x[2] + y[2] + z[2];

/**********************************
 * translate both eye and center, *
 * so the viewing direction and   *
 * distance remain the same       *
 **********************************/

gamgi_math_vector_add (layer->eye, translate, layer->eye);
gamgi_math_vector_add (layer->eye, translate, layer->eye);
gamgi_math_vector_add (layer->eye, translate, layer->eye);

gamgi_math_vector_add (layer->center, translate, layer->center);
gamgi_math_vector_add (layer->center, translate, layer->center);
gamgi_math_vector_add (layer->center, translate, layer->center);
}

void gamgi_mesa_translate_in (gamgi_layer *layer,
gamgi_object *object, double *translate)
{
double *referential;
double x[3], y[3], z[3];

referential = layer->referential;
gamgi_math_vector_absolute (x, referential[0], referential[3], referential[6]);
gamgi_math_vector_absolute (y, referential[1], referential[4], referential[7]);
gamgi_math_vector_absolute (z, referential[2], referential[5], referential[8]);

/*****************************************
 * apply translation along vectors x,y,z *
 *****************************************/

gamgi_math_vector_scale (x, x, translate[0]);
gamgi_math_vector_scale (y, y, translate[1]);
gamgi_math_vector_scale (z, z, translate[2]);

/*******************************************
 * add x,y,z to get the global translation *
 *******************************************/

translate[0] = x[0] + y[0] + z[0];
translate[1] = x[1] + y[1] + z[1];
translate[2] = x[2] + y[2] + z[2];

gamgi_mesa_translate_object (object, translate);
}

void gamgi_mesa_translate (gamgi_window *window,
gamgi_object *object, double *translate)
{
gamgi_layer *layer;
gamgi_dlist *dlist;

/***********************
 * translate view axes *
 ***********************/

if (window->axes == TRUE)
  {
  /************************
   * in all window layers *
   ************************/

  if (object == GAMGI_CAST_OBJECT window)
    {
    for (dlist = window->layer_start; dlist != NULL; dlist = dlist->next)
      {
      layer = GAMGI_CAST_LAYER dlist->data;
      gamgi_mesa_translate_out (layer, translate);
      }
    }

  /*************************
   * just in current layer *
   *************************/

  else gamgi_mesa_translate_out (window->layer, translate);
  }

/*********************
 * translate objects *
 *********************/

if (window->axes == FALSE)
  {
  /************************
   * in all window layers *
   ************************/

  if (object == GAMGI_CAST_OBJECT window)
    {
    for (dlist = window->layer_start; dlist != NULL; dlist = dlist->next)
      {
      layer = GAMGI_CAST_LAYER dlist->data;
      gamgi_mesa_translate_in (layer, GAMGI_CAST_OBJECT layer, translate);
      }
    }

  /*************************
   * just in current layer *
   *************************/

  else gamgi_mesa_translate_in (window->layer, object, translate);
  }

/***********************
 * redraw OpenGL image *
 ***********************/

gtk_widget_queue_draw (window->area);
}
