/* File: "mem.h", Time-stamp: <2007-06-08 08:24:00 feeley> */

/* Copyright (c) 1994-2007 by Marc Feeley, All Rights Reserved. */

#ifndef ___MEM_H
#define ___MEM_H


/*
 * Memory allocation parameters:
 *
 * ___MAX_NB_PARMS is the maximum number of formal parameters of procedures.
 *
 * ___MAX_NB_ARGS is the maximum number of arguments (actual parameters)
 * that are passed to procedures.  It must be >= ___MAX_NB_PARMS.
 *
 * ___MAX_NB_FRAME_SLOTS is the maximum number of slots in continuation
 * frames.  It must be >= ___MAX_NB_ARGS.
 *
 * ___MSECTION_SIZE is the size in words of sections that contain
 * movable objects (msections).
 *
 * ___MSECTION_FUDGE is the size in words of the msection fudge area.
 * There is a fudge area at the end of the space reserved for
 * allocating movable objects (heap fudge) and a fudge area at the end
 * of the space reserved for allocating continuation frames (stack
 * fudge).  Instructions in the code generated by the compiler check
 * whether the heap allocation pointer points into the heap fudge area
 * after a bounded number of constant size allocations and whether the
 * frame pointer points into the stack fudge area.  When either of
 * these cases occur, the assignment of space for the heap and stack
 * is adjusted.  If there is less than or equal to ___MSECTION_WASTE
 * words of space left, a garbage collection is triggered.
 * ___MSECTION_FUDGE must be >=
 * ___MAX_NB_FRAME_SLOTS+1+___SUBTYPED_OVERHEAD (which is the size of
 * the largest continuation frame).
 *
 * ___MSECTION_BIGGEST is the size in words beyond which an object will
 * be allocated as a still object.  It must be <= ___MSECTION_FUDGE.
 *
 * ___MIN_NB_MSECTIONS is the minimum number of msections contained
 * in the heap.
 *
 * ___PSECTION_SIZE is the size in words of sections that contain permanent
 * objects (psections).
 *
 * ___PSECTION_WASTE is the maximum number of words that are unused
 * in a psection due to fragmentation.  It must be <= ___PSECTION_SIZE.
 *
 * ___DEFAULT_LIVE_PERCENT is the default percentage of the heap that
 * is live after a GC.  At the end of a GC the heap is resized to reach
 * this percentage.
 */


#define ___MAX_NB_PARMS         1024
#define ___MAX_NB_ARGS          8192
#define ___MAX_NB_FRAME_SLOTS   8192
#define ___MSECTION_SIZE        131072
#define ___MSECTION_FUDGE       (___MAX_NB_FRAME_SLOTS+1+___SUBTYPED_OVERHEAD)
#define ___MSECTION_WASTE       (___MSECTION_FUDGE/16)
#define ___MSECTION_BIGGEST     255
#define ___MIN_NB_MSECTIONS     1
#define ___PSECTION_SIZE        4096
#define ___PSECTION_WASTE       32
#define ___DEFAULT_LIVE_PERCENT 50


extern ___SCMOBJ ___setup_mem ___PVOID;
extern void ___cleanup_mem ___PVOID;


#ifdef ___DEBUG_GARBAGE_COLLECT

#define ___garbage_collect(n) ___garbage_collect_debug (n,__LINE__,__FILE__)

extern ___BOOL ___garbage_collect_debug
   ___P((long nonmovable_words_needed,
         int line,
         char *file),
        ());

#else

extern ___BOOL ___garbage_collect
   ___P((long nonmovable_words_needed),
        ());

#endif


#ifdef ___DEBUG_STACK_LIMIT
#define ___stack_limit() ___stack_limit_debug (__LINE__,__FILE__)
extern ___BOOL ___stack_limit_debug ___P((int line, char *file),());
#else
extern ___BOOL ___stack_limit ___PVOID;
#endif


#ifdef ___DEBUG_HEAP_LIMIT
#define ___heap_limit() ___heap_limit_debug (__LINE__,__FILE__)
extern ___BOOL ___heap_limit_debug ___P((int line, char *file),());
#else
extern ___BOOL ___heap_limit ___PVOID;
#endif


extern ___SCMOBJ ___alloc_global_var ___P((___glo_struct **glo),());

extern ___F64 ___bytes_allocated ___PVOID;


#ifdef CALL_GC_FREQUENTLY
extern int ___gc_calls_to_punt;
#endif


#endif
