/**
 * @file account-list.h Account list
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_ACCOUNT_LIST_H_
#define _GALAGOD_ACCOUNT_LIST_H_

typedef struct _GalagodAccountList GalagodAccountList;

#include <libgalago/galago.h>
#include <glib.h>
#include "meta-account.h"

struct _GalagodAccountList
{
	GalagodMetaService *meta_service;
	GHashTable *meta_accounts_table;
	GList *meta_accounts;
	size_t meta_account_count;
};

GalagodAccountList *galagod_account_list_new(GalagodMetaService *meta_service);
void galagod_account_list_destroy(GalagodAccountList *list);

void galagod_account_list_add(GalagodAccountList *list,
							  GalagoAccount *account);
void galagod_account_list_remove(GalagodAccountList *list,
								 GalagoAccount *account);

void galagod_account_list_remove_with_service(GalagodAccountList *list,
											  GalagoService *service);

void galagod_account_list_add_meta_account(GalagodAccountList *list,
										   GalagodMetaAccount *meta_account);
void galagod_account_list_remove_meta_account(GalagodAccountList *list,
											  GalagodMetaAccount *meta_account);

const GList *galagod_account_list_get_meta_accounts(
	const GalagodAccountList *list);

size_t galagod_account_list_get_meta_account_count(
	const GalagodAccountList *list);

GalagodMetaAccount *galagod_account_list_get_meta_account(
	const GalagodAccountList *list, const char *id);

#endif /* _GALAGOD_ACCOUNT_LIST_H_ */
