/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "functions.h"
#include "allocate.h"
#include "load_settings.h"

extern char DHCPD_CONF_BUF[1024];
extern char LEASE_FILE_BUF[1024];



void load_settings(struct w *widgets)
{
    FILE *fp;
    long conf_size;
    char *line;
    gchar *settings_file;
    gchar *cmd;

    /* Make sure we have the settings directory */
    if( ! file_exists(SETTINGS_PATH) )
    {
	cmd = g_strdup_printf("mkdir -p %s", SETTINGS_PATH);
	if( ! run_command(cmd) )
	{
	    printf("Cant create gadmin-dhcpd's settings directory here: %s\n", SETTINGS_PATH);
	    g_free(cmd);
	    return;
	}
	g_free(cmd);    
    }

    /* Make sure we have the settings file. SETTINGS_PATH is defined at compiletime */
    settings_file = g_strdup_printf("%s/settings.conf", SETTINGS_PATH);

    if( ! file_exists(settings_file) )
    {
	cmd = g_strdup_printf("touch %s", settings_file);
	if( ! run_command(cmd) )
	{
	    printf("Cant create gadmin-dhcpd's settings file here: %s\n", settings_file);
	    g_free(settings_file);
	    g_free(cmd);
	    return;
	}
	g_free(cmd);    
    }
	    
    if((fp=fopen(settings_file, "r"))==NULL)
    {
        printf("Couldnt open the settings file:\n%s\n", settings_file);
	g_free(settings_file);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);
					    
    line = allocate(conf_size+1);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( strlen(line) > 1000 )
	  continue;

	if( strstr(line, "dhcpd_conf:") )
	  sscanf(line, "%*s %s", DHCPD_CONF_BUF);

	if( strstr(line, "lease_file:") )
	  sscanf(line, "%*s %s", LEASE_FILE_BUF);
    }
    fclose(fp);
    free(line);
    g_free(settings_file);
}
