/* 

                          Firewall Builder

                 Copyright (C) 2006 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: FindWhereUsedWidget.cpp,v 1.6 2007/05/23 03:05:50 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "utils_no_qt.h"
#include "platforms.h"
#include "definitions.h"

#include "FindWhereUsedWidget.h"
#include "ObjectManipulator.h"
#include "FWWindow.h"
#include "FWObjectDropArea.h"
#include "ObjectManipulator.h"
#include "FWBTree.h"
#include "FWBSettings.h"
#include "ObjectTreeView.h"
#include "RuleSetView.h"
#include "ObjectEditor.h"


#include "fwbuilder/FWObjectDatabase.h"
#include "fwbuilder/FWReference.h"
#include "fwbuilder/RuleSet.h"
#include "fwbuilder/NAT.h"
#include "fwbuilder/Routing.h"
#include "fwbuilder/Policy.h"
#include "fwbuilder/Rule.h"
#include "fwbuilder/RuleElement.h"
#include "fwbuilder/Firewall.h"
#include "fwbuilder/Library.h"
#include "fwbuilder/IPService.h"
#include "fwbuilder/ICMPService.h"
#include "fwbuilder/TCPService.h"
#include "fwbuilder/UDPService.h"
#include "fwbuilder/Resources.h"

#include <qwidgetstack.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qcursor.h>
#include <qregexp.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qpixmapcache.h>

#include <iostream>
#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;


FindWhereUsedWidget::FindWhereUsedWidget(QWidget*p, const char * n, WFlags f, bool f_mini) : findWhereUsedWidget_q(p,n,f) 
{
    flShowObject=true;
    if (f_mini)
    {
        buttonsBox->hide();
        dropBox->hide();
    }
    else
    {
        //connect (dropArea,SIGNAL(objectInserted()),this,SLOT(findFromDrop()));
        connect (dropArea,SIGNAL(objectDeleted()),this,SLOT(init()));
    }
}

void FindWhereUsedWidget::setShowObject(bool fl)
{
    flShowObject=fl;
}

void FindWhereUsedWidget::itemActivated(QListViewItem* item)
{
    FWObject *o;
    o=mapping[item];
    
    if (flShowObject && o!=NULL)
    {
        showObject(o);
    }
}

void FindWhereUsedWidget::find()
{
    findFromDrop();
}

void FindWhereUsedWidget::find(FWObject *obj)
{
    dropArea->insertObject(obj);
    find();
}

void FindWhereUsedWidget::_find(FWObject *obj)
{
    object=obj;
    resListView->clear();
    mapping.clear();
    resset.clear();
    
    
    mw->db()->findWhereUsed(obj,mw->db(),resset);

    set<FWObject*>::iterator i=resset.begin();
    QListViewItem *item;
    QString c1;
    QString c2;
    FWObject* o;
    Rule* r;
    RuleSet* rs;
    FWObject* fw=NULL;
    for(;i!=resset.end();++i)
    {
        o=*i;
        fw=NULL;
        r=NULL;
        rs=NULL;
            
        if (findRef(object,o)==NULL) continue;
        if (RuleElement::cast(o)!=NULL)            
        {
            fw=o->getParent();
            
            while (fw!=NULL && !Firewall::isA(fw)) 
            {
                if (Rule::cast(fw))
                {
                    r=Rule::cast(fw); 
                } else if (RuleSet::cast(fw))
                {
                    rs=RuleSet::cast(fw);
                }
                        
                fw=fw->getParent();
            }
            if (fw==NULL || r==NULL || rs==NULL) continue;
            
            c1=QString::fromUtf8(fw->getName().c_str());
            
            if (NAT::isA(rs))
            {
                c2=tr("NAT");
            } else if (Policy::isA(rs))
            {
                c2=tr("Policy");
            } else if (Routing::isA(rs))
            {
                c2=tr("Routing");
            } else
            {
                c2=tr("Unknown rule set");
            }
            c2+=tr("/Rule%1").arg(r->getPosition());
            
        } else if (
                FWBTree::isSystem(o) ||
                Rule::cast(o) || 
                RuleSet::cast(o) || 
                Firewall::cast(o) ||
                Library::cast(o))
        {
            continue;
        }
        else
        {
            c1=QString::fromUtf8(o->getName().c_str());
            c2=tr("Type: ")+QString::fromUtf8(o->getTypeName().c_str());
        }

        string icn="icon-tree";
        FWObject *pixobj=(fw==NULL)?o:fw;
        
//        QPixmap pm = QPixmap::fromMimeSource( 
//            Resources::global_res->getObjResourceStr(pixobj, icn).c_str() );
        QString icn_file =
            Resources::global_res->getObjResourceStr(pixobj, icn).c_str();
        QPixmap pm;
        if ( ! QPixmapCache::find( icn_file, pm) )
        {
            pm = QPixmap::fromMimeSource( icn_file );
            QPixmapCache::insert( icn_file, pm);
        }
        
        item=new QListViewItem(resListView,c1,c2);
        item->setPixmap(0,pm);
        mapping[item]=o;
    }
    show();
}

void FindWhereUsedWidget::init()
{
    object=NULL;
    resListView->clear();
    mapping.clear();
    resset.clear();
    
}

void FindWhereUsedWidget::findFromDrop()
{
    _find(dropArea->getObject());
}

void FindWhereUsedWidget::showObject(FWObject* o)
{
    if (fwbdebug) qDebug("FindWhereUsedWidget::showObject");
    
    if (object==NULL || o==NULL) return;
    
    FWReference* ref=NULL;
    
            
    if (RuleElement::cast(o)!=NULL)
    {
        ref=findRef(object,o);
        if (ref==NULL) return;
        
        om->clearFocus();
        mw->ensureObjectVisibleInRules( ref );
        mw->selectRules();
        if (oe->isVisible())
        {
            om->editObject( object );
        }
        return;
    }
    mw->unselectRules();

    if (Group::cast(o)!=NULL)
    {

        om->openObject( o );
        mw->unselectRules();
        
        if (oe->isVisible())
        {
            om->editObject( o );
            oe->selectObject( object);
        }
        return;
    }
    qDebug("4444");
    //oe->close();
    //om->openObject( o );
    //om->select();  // selects an item in the tree and assigns kbd focus to it
}
