/*
 * Decompiled with CFR 0.152.
 */
package com.rc.retroweaver;

import com.rc.retroweaver.RetroWeaverException;
import java.util.HashMap;

public class NameTranslator {
    private static final String BACKPORT_CONCURRENT_PREFIX = "edu/emory/mathcs/backport/";
    private static final String CONCURRENT_PREFIX = "java/util/concurrent/";
    private static HashMap<String, String> translations = new HashMap();

    private NameTranslator() {
    }

    protected static String translate(String name) {
        if (name == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        NameTranslator.translate(name, sb, 0, name.length());
        return sb.toString();
    }

    private static String translateName(String name) {
        if (name.startsWith(CONCURRENT_PREFIX)) {
            return BACKPORT_CONCURRENT_PREFIX + name;
        }
        String newName = translations.get(name);
        if (newName != null) {
            return newName;
        }
        return name;
    }

    private static void translate(String in, StringBuffer out, int start, int end) {
        if (start >= end) {
            return;
        }
        char firstChar = in.charAt(start);
        switch (firstChar) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': 
            case '[': {
                out.append(firstChar);
                NameTranslator.translate(in, out, start + 1, end);
                break;
            }
            case 'L': {
                int endName = in.indexOf(59, start + 1);
                if (endName == -1) {
                    String name = in.substring(start, end);
                    String newName = NameTranslator.translateName(name);
                    out.append(newName);
                    break;
                }
                String className = in.substring(start + 1, endName);
                String newClassName = NameTranslator.translateName(className);
                out.append('L').append(newClassName).append(';');
                NameTranslator.translate(in, out, endName + 1, end);
                break;
            }
            case '(': {
                int endArgs = in.indexOf(41, start + 1);
                if (endArgs == -1) {
                    throw new RetroWeaverException("Class name parsing error: missing ')' in " + in);
                }
                out.append('(');
                if (endArgs != start + 1) {
                    NameTranslator.translate(in, out, start + 1, endArgs);
                }
                out.append(')');
                NameTranslator.translate(in, out, endArgs + 1, end);
                break;
            }
            default: {
                String name = in.substring(start, end);
                String newName = NameTranslator.translateName(name);
                out.append(newName);
            }
        }
    }

    static {
        translations.put("java/lang/StringBuilder", "java/lang/StringBuffer");
        translations.put("java/lang/Iterable", "com/rc/retroweaver/runtime/Iterable_");
        translations.put("java/lang/Enum", "com/rc/retroweaver/runtime/Enum_");
    }
}

