#include <QtCore/QCoreApplication>

#include <QFile>
#include <QHash>
#include <QString>
#include <QStringList>
#include <QTextStream>

#include <QDebug>

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    // read ATC_ES
    QString content;
    QFile es("/Users/eric/Desktop/Programmation/freemedforms/global_resources/sql/ia/atc_utf8_es.csv");
    if (!es.open(QFile::ReadOnly | QFile::Text)) {
        qWarning() << "not open" << es.fileName() << es.errorString();
        return 123;
    }
    QMap<QString, QString> code_es;
    content = QString::fromUtf8(es.readAll());
    es.close();

    foreach(const QString &line, content.split("\n", QString::SkipEmptyParts)) {
        int begin = 0;
        int end = 0;
        begin = line.indexOf("\t");
        if (begin==-1) {
            begin = line.indexOf(" ");
            end = begin + 1;
        } else {
            end = begin + 3;
        }
        if (begin==-1) {
            qWarning() << line << "ERROR";
        }
        QString code = line.left(begin);
//        code = code.replace("'","");
        QString label = line.mid(end);
//        label = label.replace("'","");
//        label = label.replace(".,",",");
//        label = label.replace(".","");
//        label = label.trimmed();
        code_es.insert(code.toUpper(), label.toUpper());
    }

    // read ATC_UTF8
    es.setFileName("/Users/eric/Desktop/Programmation/freemedforms/global_resources/sql/ia/atc_utf8.csv");
    if (!es.open(QFile::ReadOnly | QFile::Text)) {
        qWarning() << "not open" << es.fileName() << es.errorString();
        return 123;
    }

    QFile data("/Users/eric/Desktop/Programmation/freemedforms/global_resources/sql/ia/atc_utf8_all.csv");
    if (!data.open(QFile::WriteOnly | QFile::Text)) {
        qWarning() << "not open" << data.fileName() << data.errorString();
        return 123;
    }
    QFile missings("/Users/eric/Desktop/Programmation/freemedforms/global_resources/sql/ia/atc_utf8_missing_es.csv");
    if (!missings.open(QFile::WriteOnly | QFile::Text)) {
        qWarning() << "not open" << missings.fileName() << missings.errorString();
        return 123;
    }

    QTextStream in(&es);
    QTextStream out(&data);
    content.clear();

    while (!in.atEnd()) {
        QString line = in.readLine();
        // get code
        QString code = line.left(line.indexOf("\";\""));
        code = code.remove("\"");
        QString label = code_es.value(code);
        if (label.isEmpty()) {
            content += code + "\n";
            qWarning() << code;
        }
        label.prepend(";\"");
        label.append("\"");
        line.remove("\n");
        out << line << label << "\n";
    }

    missings.write(content.toUtf8());
    missings.close();
    data.close();

    return a.exec();
}
