/***************************************************************************
 *  The FreeMedForms project is a set of free, open source medical         *
 *  applications.                                                          *
 *  (C) 2008-2011 by Eric MAEKER, MD (France) <eric.maeker@gmail.com>      *
 *  All rights reserved.                                                   *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program (COPYING.FREEMEDFORMS file).                   *
 *  If not, see <http://www.gnu.org/licenses/>.                            *
 ***************************************************************************/
/**
  \class Core::DebugDialog
  \brief This class is a QDialog that shows the content of the tkLog class of this library.
  It can send message over the web with the tkSendMessage class (part of freemedforms).
*/
#include "debugdialog.h"
#include "ui_debugdialog.h"

#include <utils/log.h>
#include <utils/global.h>
#include <extensionsystem/pluginmanager.h>

#include <coreplugin/idebugpage.h>
#include <coreplugin/icore.h>
#include <coreplugin/imainwindow.h>
#include <coreplugin/isettings.h>

#include <QStackedLayout>
#include <QHeaderView>
#include <QMainWindow>

using namespace Core;
using namespace Core::Internal;
using namespace Trans::ConstantTranslations;

DebugDialog::DebugDialog(QWidget *parent) :
    QDialog(parent), m_ui(new Core::Internal::Ui::DebugDialog)
{
    m_ui->setupUi(this);
    setWindowFlags(Qt::Window | Qt::CustomizeWindowHint | Qt::WindowSystemMenuHint | Qt::WindowCloseButtonHint);

    setWindowTitle(qApp->applicationName());
    setObjectName("DebugDialog");

    QList<IDebugPage*> pages =
        ExtensionSystem::PluginManager::instance()->getObjects<IDebugPage>();

    m_ui->widget->setPages<IDebugPage>(pages);
    m_ui->widget->setSettingKey("Dialogs/Debug");
    m_ui->widget->setupUi();
    m_ui->widget->expandAllCategories();

    // resize and center windows
    Utils::resizeAndCenter(this);
}

DebugDialog::~DebugDialog()
{
    m_ui->widget->saveState();
    delete m_ui;
}

void DebugDialog::on_fullScreenButton_clicked()
{
    static bool fullscreen = false;
    fullscreen = !fullscreen;
//    Utils::setFullScreen(this,fullscreen);
//    this->show();
}

void DebugDialog::on_butSend_clicked()
{
    if (!Utils::isDebugCompilation()) {
        if (!Utils::Log::hasError())  // this should never be in this member
            return;
    }
    Utils::Log::addMessage(this, tkTr(Trans::Constants::START_MESSAGE_SENDING) );

    QString msg = Utils::askUser( tkTr(Trans::Constants::START_MESSAGE_SENDING), tkTr(Trans::Constants::PLEASE_DESCRIBE_PROBLEM) );
    // get full log including settings and logs
    msg += "\n\n" + Utils::Log::toString( Core::ICore::instance()->settings()->toString() );

    // send informations
    connect( &m_sender, SIGNAL(sent()), this, SLOT(onSendMessage_done()));
    m_sender.setTypeOfMessage( Utils::MessageSender::InformationToDevelopper );
    m_sender.setMessage( msg );
    if (m_sender.postMessage()) {
        m_sending = true;
        // showing a messagebox
        m_infoMessageBox = new QMessageBox(this);
        m_infoMessageBox->setText( tr( "Sending debugging informations to dev team") );
        m_infoMessageBox->setInformativeText( tr("Trying to send informations to dev team.\n"
                                                 "Using Url : %1 \n"
                                                 "Please wait..." ).arg( m_sender.usedUrl() ) );
        m_infoMessageBox->setWindowTitle( qApp->applicationName() );
        m_infoMessageBox->setStandardButtons( QMessageBox::Ok );
        m_infoMessageBox->show();
    } else {
        m_sending = false;
    }
}

bool DebugDialog::on_butSave_clicked()
{
    Core::ISettings *s = Core::ICore::instance()->settings();
    QString fileName = s->path( Core::ISettings::ResourcesPath ) + "/logs.txt" ;
    Utils::Log::addMessage( this, tkTr(Trans::Constants::SAVING_FILE_1).arg(fileName));
    return Utils::saveStringToFile( Utils::Log::toString(), fileName );
}

void DebugDialog::onSendMessage_done()
{
    Utils::Log::addMessage( this, tr( "Debugging informations correctly sent." ) );
    if ( m_infoMessageBox )
    {
        m_infoMessageBox->setInformativeText( tr("Debugging informations correctly send to dev team.\n"
                                             "Using Url : %1 \n"
                                             "%2" ).arg( m_sender.usedUrl(), m_sender.resultMessage() ) );
        m_infoMessageBox->exec();
        delete m_infoMessageBox;
        m_infoMessageBox=0;
    }
    m_sending = false;
}
