/***************************************************************************
 *   FreeMedicalForms                                                      *
 *   (C) 2008-2010 by Eric MAEKER, MD                                      *
 *   eric.maeker@free.fr                                                   *
 *   All rights reserved.                                                  *
 *                                                                         *
 *   This program is a free and open source software.                      *
 *   It is released under the terms of the new BSD License.                *
 *                                                                         *
 *   Redistribution and use in source and binary forms, with or without    *
 *   modification, are permitted provided that the following conditions    *
 *   are met:                                                              *
 *   - Redistributions of source code must retain the above copyright      *
 *   notice, this list of conditions and the following disclaimer.         *
 *   - Redistributions in binary form must reproduce the above copyright   *
 *   notice, this list of conditions and the following disclaimer in the   *
 *   documentation and/or other materials provided with the distribution.  *
 *   - Neither the name of the FreeMedForms' organization nor the names of *
 *   its contributors may be used to endorse or promote products derived   *
 *   from this software without specific prior written permission.         *
 *                                                                         *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   *
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     *
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS     *
 *   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE        *
 *   COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,  *
 *   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,  *
 *   BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;      *
 *   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER      *
 *   CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT    *
 *   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN     *
 *   ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE       *
 *   POSSIBILITY OF SUCH DAMAGE.                                           *
 ***************************************************************************/
#ifndef TEXTEDITORTABLEDIALOG_H
#define TEXTEDITORTABLEDIALOG_H

#include <coreplugin/itheme.h>
#include <coreplugin/icore.h>
#include <coreplugin/constants_icons.h>

#include <QDialog>
#include <QTextEdit>
#include <QTextCursor>
#include <QTextTable>
#include <QTextTableFormat>

// include UI headers
#include "ui_tabledialog.h"

namespace Editor {
namespace Internal {

class TableDialog : public QDialog, private Ui::TableDialog
{
    Q_OBJECT
public:
    TableDialog( QWidget *parent = 0 ) :
            QDialog( parent )
    {
        setupUi( this );
        setWindowTitle(qApp->applicationName() + " - Rich Text Widget");
        setWindowIcon(Core::ICore::instance()->theme()->icon(Core::Constants::ICONTABLE));
    }

    ~TableDialog() {}

    int rows() { return rowSpin->value() ; }
    int cols() { return colSpin->value() ; }
    int cellSpacing() { return cellSpacingSpin->value(); }
    int cellPadding() { return cellPaddingSpin->value(); }
    int border() { return borderSpin->value(); }

    QTextTableFormat format()
    {
        QTextTableFormat format;
        format.setCellPadding( cellPadding() );
        format.setCellSpacing( cellSpacing() );
        format.setBorder( border() );
        format.setWidth( QTextLength( QTextLength::PercentageLength, 100 ) );
        int i = 0;
        QVector<QTextLength> lengths;
        for ( i = 0; i < cols(); i++ ) {
            lengths << QTextLength( QTextLength::PercentageLength, 100 / cols() );
        }
        format.setColumnWidthConstraints( lengths );
        if ( header->isChecked() ) format.setHeaderRowCount( 1 );
        else format.setHeaderRowCount( 0 );
        return format;
    }
};

}  // End Internal
}  // End Editor

#endif // TEXTEDITORTABLEDIALOG_H
