/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILEMANAGER_H
#define FILEMANAGER_H

#include <qobject.h>
#include <qstrlist.h>
#include <qdatetime.h>
#include <qstring.h>
#include <qdir.h>
#include <iostream>
#include <qdeepcopy.h>
#include <qstringlist.h>
/**
@author Predrag Viceic
*/
class FileManager : public QObject
{
Q_OBJECT
public:
    FileManager(QObject *parent = 0, const char *name = 0);

    ~FileManager();
    void setFilename(QString);
    const QString getFilename();
    const QString getNextFilename();
    const QString getPreviousFilename();
    const QString getOriginalFilename();
    bool hasPrevious();
    bool hasNext();
    void deleteAfterCurrent();
    void purgeTempDir();
    QString getTempDir();
    QString getFilenameExtension();
    static void purgeDir(QString dir);
    static void deleteDir(QString dir);

protected:
    QString filename;
private:
    QStrList filenames;
    QStrListIterator* iterator;
    uint tempFilenamePrefix;
    QDir* tempDir;

};

#endif
