.TH FOTOXX 1 2011-08-01 "Linux" "Fotoxx man page"

.SH NAME
 Fotoxx - digital photo editor and collection manager

.SH SYNOPSIS
 \fBFotoxx\fR [ \fB-v\fR ] [ \fB-lang\fR \fIcode\fR ] 
        [ \fIfile\fR | \fIdirectory\fR ]
        [ \fB-recent\fR ] [ \fB-prev\fR ] 
        [ \fB-slideshow\fR <filename> [ \fB-music\fR <playlist> ] ]

.SH DESCRIPTION
 Fotoxx is a graphical menu-driven program which operates in 
 its own window. Organize and administer a collection of images, 
 edit images, search images, perform image utility functions.

.SH OVERVIEW

Edit functions include:
 - View and edit most image file types and RAW file types
 - Adjust brightness/color/contrast using movable curves
 - Fix vignetting and other brightness uniformity problems
 - Expand and/or flatten the brightness distribution
 - Trim (crop), Resize, Flip, Rotate (any angle)
 - Sharpen, Blur, Reduce noise, Remove red-eyes
 - Tone Mapping (enhance local contrast and faint details)
 - Auto adjust white balance, Match colors to a standard
 - Remove a color caste even if it varies across the image
 - Warp (stretch/distort image by dragging the mouse)
 - Panorama, HDR, and Stack composites (hand-held photos OK)
 - Combine photos with differing focus depths 
 - Artful transforms (simulate drawing, embossing, painting)
 - Pixel edit with variable brush transparency and blending
 - Edit selected objects or areas within an image
 - Copy and paste selected objects or areas (cutouts)
 - Smart erase: get rid of ground litter, power lines, etc.
 - Erase dust: remove dust spots on images from scanned slides
 - Write text on the image (vary font, color, transparency, angle)
 - Use Gimp or other editor as a plug-in function

Utility functions include:
 - Thumbnail image browser and navigator
 - Add comments, tags, dates, and star-ratings to images
 - Search images by comments, tags, dates, star-ratings, file names
 - Rename images from camera using a base name and sequence number
 - Slide-show mode: automatic or keyboard control, optional music
 - Batch convert multiple RAW files to tiff-16
 - Print image using standard or custom paper size
 - Select images from the navigator and burn a CD or DVD
 - Select images and send to preferred e-mail program
 - Assign images to named collection, edit and view collection
 - Tune monitor for color and gamma

.SH OPTIONS
Command line options
 \fB-v\fR                print version and exit
 \fB-lang\fR \fIcode\fR        specify language (de, fr, zh_CN ...)
 \fIfile\fR              initial image file to view or edit
 \fIdirectory\fR         initial directory of image files
 \fB-prev\fR             open last file from the previous session
 \fB-recent\fR           show a gallery of most recent files opened
 \fB-slideshow\fR        <filename> is first image in a slide show
 \fB-music\fR            <playlist> is a music file or a playlist

.SH SEE ALSO
 The online user manual is available using the help menu.
 This manual explains Fotoxx operation in great detail.

.SH AUTHORS
 Written by Mike Cornelison <kornelix2@gmail.com>


