/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.translator;

public class NameSpace {
    private final String oldPrefix;
    private final String newPrefix;

    public NameSpace(String oldPrefix, String newPrefix) {
        if (oldPrefix == null || newPrefix == null) {
            throw new IllegalArgumentException();
        }
        this.oldPrefix = oldPrefix.replace('.', '/');
        this.newPrefix = newPrefix.replace('.', '/');
    }

    public String getOldPrefix() {
        return this.oldPrefix;
    }

    public String getNewPrefix() {
        return this.newPrefix;
    }

    public String toString() {
        return "[" + this.oldPrefix + ", " + this.newPrefix + "]";
    }

    public String getMirrorClassName(String class_) {
        if (this.oldPrefix.length() == 0) {
            return this.newPrefix + '/' + class_;
        }
        if (!class_.startsWith(this.oldPrefix)) {
            return null;
        }
        return class_.replaceFirst(this.oldPrefix, this.newPrefix);
    }
}

