/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.harmony.runtime.java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.sourceforge.retroweaver.harmony.runtime.internal.nls.Messages;
import net.sourceforge.retroweaver.harmony.runtime.java.math.Conversion;
import net.sourceforge.retroweaver.harmony.runtime.java.math.MathContext;
import net.sourceforge.retroweaver.harmony.runtime.java.math.Multiplication;
import net.sourceforge.retroweaver.harmony.runtime.java.math.RoundingMode;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import net.sourceforge.retroweaver.runtime.java.lang.Long_;
import net.sourceforge.retroweaver.runtime.java.lang.Math_;
import net.sourceforge.retroweaver.runtime.java.math.BigInteger_;

class HarmonyBigDecimal
extends Number
implements Comparable,
Serializable {
    public static final HarmonyBigDecimal ZERO;
    public static final HarmonyBigDecimal ONE;
    public static final HarmonyBigDecimal TEN;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final double LOG10_2 = 0.3010299956639812;
    private transient String toStringImage = null;
    private transient int hashCode = 0;
    private static final BigInteger[] FIVE_POW;
    private static final BigInteger[] TEN_POW;
    private static final long[] LONG_TEN_POW;
    private static final long[] LONG_FIVE_POW;
    private static final int[] LONG_FIVE_POW_BIT_LENGTH;
    private static final int[] LONG_TEN_POW_BIT_LENGTH;
    private static final int BI_SCALED_BY_ZERO_LENGTH = 11;
    private static final HarmonyBigDecimal[] BI_SCALED_BY_ZERO;
    private static final HarmonyBigDecimal[] ZERO_SCALED_BY;
    private static final char[] CH_ZEROS;
    private BigInteger intVal;
    private transient int bitLength;
    private transient long smallValue;
    private int scale;
    private transient int precision = 0;

    HarmonyBigDecimal(BigDecimal o) {
        this(o.unscaledValue(), o.scale());
    }

    BigDecimal toBigDecimal() {
        return new BigDecimal(this.getUnscaledValue(), this.scale());
    }

    private HarmonyBigDecimal(long smallValue, int scale) {
        this.smallValue = smallValue;
        this.scale = scale;
        this.bitLength = HarmonyBigDecimal.bitLength(smallValue);
    }

    private HarmonyBigDecimal(int smallValue, int scale) {
        this.smallValue = smallValue;
        this.scale = scale;
        this.bitLength = HarmonyBigDecimal.bitLength(smallValue);
    }

    public HarmonyBigDecimal(char[] in, int offset, int len) {
        int begin = offset;
        int last = offset + (len - 1);
        String scaleString = null;
        if (in == null) {
            throw new NullPointerException();
        }
        if (last >= in.length || offset < 0 || len <= 0 || last < 0) {
            throw new NumberFormatException();
        }
        StringBuffer unscaledBuffer = new StringBuffer(len);
        int bufLength = 0;
        if (offset <= last && in[offset] == '+') {
            ++offset;
            ++begin;
        }
        int counter = 0;
        boolean wasNonZero = false;
        while (offset <= last && in[offset] != '.' && in[offset] != 'e' && in[offset] != 'E') {
            if (!wasNonZero) {
                if (in[offset] == '0') {
                    ++counter;
                } else {
                    wasNonZero = true;
                }
            }
            ++offset;
        }
        unscaledBuffer.append(in, begin, offset - begin);
        bufLength += offset - begin;
        if (offset <= last && in[offset] == '.') {
            begin = ++offset;
            while (offset <= last && in[offset] != 'e' && in[offset] != 'E') {
                if (!wasNonZero) {
                    if (in[offset] == '0') {
                        ++counter;
                    } else {
                        wasNonZero = true;
                    }
                }
                ++offset;
            }
            this.scale = offset - begin;
            bufLength += this.scale;
            unscaledBuffer.append(in, begin, this.scale);
        } else {
            this.scale = 0;
        }
        if (offset <= last && (in[offset] == 'e' || in[offset] == 'E')) {
            begin = ++offset;
            if (offset <= last && in[offset] == '+' && ++offset <= last && in[offset] != '-') {
                ++begin;
            }
            scaleString = String.valueOf(in, begin, last + 1 - begin);
            long newScale = (long)this.scale - (long)Integer.parseInt(scaleString);
            this.scale = (int)newScale;
            if (newScale != (long)this.scale) {
                throw new NumberFormatException(Messages.getString("math.02"));
            }
        }
        if (bufLength < 19) {
            this.smallValue = Long.parseLong(unscaledBuffer.toString());
            this.bitLength = HarmonyBigDecimal.bitLength(this.smallValue);
        } else {
            this.setUnscaledValue(new BigInteger(unscaledBuffer.toString()));
        }
        this.precision = unscaledBuffer.length() - counter;
        if (unscaledBuffer.charAt(0) == '-') {
            --this.precision;
        }
    }

    public HarmonyBigDecimal(char[] in, int offset, int len, MathContext mc) {
        this(in, offset, len);
        this.inplaceRound(mc);
    }

    public HarmonyBigDecimal(char[] in) {
        this(in, 0, in.length);
    }

    public HarmonyBigDecimal(char[] in, MathContext mc) {
        this(in, 0, in.length);
        this.inplaceRound(mc);
    }

    public HarmonyBigDecimal(String val) {
        this(val.toCharArray(), 0, val.length());
    }

    public HarmonyBigDecimal(String val, MathContext mc) {
        this(val.toCharArray(), 0, val.length());
        this.inplaceRound(mc);
    }

    public HarmonyBigDecimal(double val) {
        long mantisa;
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException(Messages.getString("math.03"));
        }
        long bits = Double.doubleToLongBits(val);
        this.scale = 1075 - (int)(bits >> 52 & 0x7FFL);
        long l = mantisa = this.scale == 1075 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        if (mantisa == 0L) {
            this.scale = 0;
            this.precision = 1;
        }
        if (this.scale > 0) {
            int trailingZeros = Math.min(this.scale, Long_.numberOfTrailingZeros(mantisa));
            mantisa >>>= trailingZeros;
            this.scale -= trailingZeros;
        }
        if (bits >> 63 != 0L) {
            mantisa = -mantisa;
        }
        int mantisaBits = HarmonyBigDecimal.bitLength(mantisa);
        if (this.scale < 0) {
            int n = this.bitLength = mantisaBits == 0 ? 0 : mantisaBits - this.scale;
            if (this.bitLength < 64) {
                this.smallValue = mantisa << -this.scale;
            } else {
                this.intVal = BigInteger.valueOf(mantisa).shiftLeft(-this.scale);
            }
            this.scale = 0;
        } else if (this.scale > 0) {
            if (this.scale < LONG_FIVE_POW.length && mantisaBits + LONG_FIVE_POW_BIT_LENGTH[this.scale] < 64) {
                this.smallValue = mantisa * LONG_FIVE_POW[this.scale];
                this.bitLength = HarmonyBigDecimal.bitLength(this.smallValue);
            } else {
                this.setUnscaledValue(Multiplication.multiplyByFivePow(BigInteger.valueOf(mantisa), this.scale));
            }
        } else {
            this.smallValue = mantisa;
            this.bitLength = mantisaBits;
        }
    }

    public HarmonyBigDecimal(double val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public HarmonyBigDecimal(BigInteger val) {
        this(val, 0);
    }

    public HarmonyBigDecimal(BigInteger val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public HarmonyBigDecimal(BigInteger unscaledVal, int scale) {
        if (unscaledVal == null) {
            throw new NullPointerException();
        }
        this.scale = scale;
        this.setUnscaledValue(unscaledVal);
    }

    public HarmonyBigDecimal(BigInteger unscaledVal, int scale, MathContext mc) {
        this(unscaledVal, scale);
        this.inplaceRound(mc);
    }

    public HarmonyBigDecimal(int val) {
        this(val, 0);
    }

    public HarmonyBigDecimal(int val, MathContext mc) {
        this(val, 0);
        this.inplaceRound(mc);
    }

    public HarmonyBigDecimal(long val) {
        this(val, 0);
    }

    public HarmonyBigDecimal(long val, MathContext mc) {
        this(val);
        this.inplaceRound(mc);
    }

    public static HarmonyBigDecimal valueOf(long unscaledVal, int scale) {
        if (scale == 0) {
            return HarmonyBigDecimal.valueOf(unscaledVal);
        }
        if (unscaledVal == 0L && scale >= 0 && scale < ZERO_SCALED_BY.length) {
            return ZERO_SCALED_BY[scale];
        }
        return new HarmonyBigDecimal(unscaledVal, scale);
    }

    public static HarmonyBigDecimal valueOf(long unscaledVal) {
        if (unscaledVal >= 0L && unscaledVal < 11L) {
            return BI_SCALED_BY_ZERO[(int)unscaledVal];
        }
        return new HarmonyBigDecimal(unscaledVal, 0);
    }

    public static HarmonyBigDecimal valueOf(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException(Messages.getString("math.03"));
        }
        return new HarmonyBigDecimal(Double.toString(val));
    }

    public HarmonyBigDecimal add(HarmonyBigDecimal augend) {
        int diffScale = this.scale - augend.scale;
        if (this.isZero()) {
            if (diffScale <= 0) {
                return augend;
            }
            if (augend.isZero()) {
                return this;
            }
        } else if (augend.isZero() && diffScale >= 0) {
            return this;
        }
        if (diffScale == 0) {
            if (Math.max(this.bitLength, augend.bitLength) + 1 < 64) {
                return HarmonyBigDecimal.valueOf(this.smallValue + augend.smallValue, this.scale);
            }
            return new HarmonyBigDecimal(this.getUnscaledValue().add(augend.getUnscaledValue()), this.scale);
        }
        if (diffScale > 0) {
            return HarmonyBigDecimal.addAndMult10(this, augend, diffScale);
        }
        return HarmonyBigDecimal.addAndMult10(augend, this, -diffScale);
    }

    private static HarmonyBigDecimal addAndMult10(HarmonyBigDecimal thisValue, HarmonyBigDecimal augend, int diffScale) {
        if (diffScale < LONG_TEN_POW.length && Math.max(thisValue.bitLength, augend.bitLength + LONG_TEN_POW_BIT_LENGTH[diffScale]) + 1 < 64) {
            return HarmonyBigDecimal.valueOf(thisValue.smallValue + augend.smallValue * LONG_TEN_POW[diffScale], thisValue.scale);
        }
        return new HarmonyBigDecimal(thisValue.getUnscaledValue().add(Multiplication.multiplyByTenPow(augend.getUnscaledValue(), diffScale)), thisValue.scale);
    }

    public HarmonyBigDecimal add(HarmonyBigDecimal augend, MathContext mc) {
        BigInteger tempBI;
        HarmonyBigDecimal smaller;
        HarmonyBigDecimal larger;
        long diffScale = (long)this.scale - (long)augend.scale;
        if (augend.isZero() || this.isZero() || mc.getPrecision() == 0) {
            return this.add(augend).round(mc);
        }
        if ((long)this.aproxPrecision() < diffScale - 1L) {
            larger = augend;
            smaller = this;
        } else if ((long)augend.aproxPrecision() < -diffScale - 1L) {
            larger = this;
            smaller = augend;
        } else {
            return this.add(augend).round(mc);
        }
        if (mc.getPrecision() >= larger.aproxPrecision()) {
            return this.add(augend).round(mc);
        }
        int largerSignum = larger.signum();
        if (largerSignum == smaller.signum()) {
            tempBI = Multiplication.multiplyByPositiveInt(larger.getUnscaledValue(), 10).add(BigInteger.valueOf(largerSignum));
        } else {
            tempBI = larger.getUnscaledValue().subtract(BigInteger.valueOf(largerSignum));
            tempBI = Multiplication.multiplyByPositiveInt(tempBI, 10).add(BigInteger.valueOf(largerSignum * 9));
        }
        larger = new HarmonyBigDecimal(tempBI, larger.scale + 1);
        return larger.round(mc);
    }

    public HarmonyBigDecimal subtract(HarmonyBigDecimal subtrahend) {
        int diffScale = this.scale - subtrahend.scale;
        if (this.isZero()) {
            if (diffScale <= 0) {
                return subtrahend.negate();
            }
            if (subtrahend.isZero()) {
                return this;
            }
        } else if (subtrahend.isZero() && diffScale >= 0) {
            return this;
        }
        if (diffScale == 0) {
            if (Math.max(this.bitLength, subtrahend.bitLength) + 1 < 64) {
                return HarmonyBigDecimal.valueOf(this.smallValue - subtrahend.smallValue, this.scale);
            }
            return new HarmonyBigDecimal(this.getUnscaledValue().subtract(subtrahend.getUnscaledValue()), this.scale);
        }
        if (diffScale > 0) {
            if (diffScale < LONG_TEN_POW.length && Math.max(this.bitLength, subtrahend.bitLength + LONG_TEN_POW_BIT_LENGTH[diffScale]) + 1 < 64) {
                return HarmonyBigDecimal.valueOf(this.smallValue - subtrahend.smallValue * LONG_TEN_POW[diffScale], this.scale);
            }
            return new HarmonyBigDecimal(this.getUnscaledValue().subtract(Multiplication.multiplyByTenPow(subtrahend.getUnscaledValue(), diffScale)), this.scale);
        }
        if ((diffScale = -diffScale) < LONG_TEN_POW.length && Math.max(this.bitLength + LONG_TEN_POW_BIT_LENGTH[diffScale], subtrahend.bitLength) + 1 < 64) {
            return HarmonyBigDecimal.valueOf(this.smallValue * LONG_TEN_POW[diffScale] - subtrahend.smallValue, subtrahend.scale);
        }
        return new HarmonyBigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), diffScale).subtract(subtrahend.getUnscaledValue()), subtrahend.scale);
    }

    public HarmonyBigDecimal subtract(HarmonyBigDecimal subtrahend, MathContext mc) {
        long diffScale = (long)subtrahend.scale - (long)this.scale;
        if (subtrahend.isZero() || this.isZero() || mc.getPrecision() == 0) {
            return this.subtract(subtrahend).round(mc);
        }
        if ((long)subtrahend.aproxPrecision() < diffScale - 1L && mc.getPrecision() < this.aproxPrecision()) {
            BigInteger tempBI;
            int thisSignum = this.signum();
            if (thisSignum != subtrahend.signum()) {
                tempBI = Multiplication.multiplyByPositiveInt(this.getUnscaledValue(), 10).add(BigInteger.valueOf(thisSignum));
            } else {
                tempBI = this.getUnscaledValue().subtract(BigInteger.valueOf(thisSignum));
                tempBI = Multiplication.multiplyByPositiveInt(tempBI, 10).add(BigInteger.valueOf(thisSignum * 9));
            }
            HarmonyBigDecimal leftOperand = new HarmonyBigDecimal(tempBI, this.scale + 1);
            return leftOperand.round(mc);
        }
        return this.subtract(subtrahend).round(mc);
    }

    public HarmonyBigDecimal multiply(HarmonyBigDecimal multiplicand) {
        long newScale = (long)this.scale + (long)multiplicand.scale;
        if (this.isZero() || multiplicand.isZero()) {
            return HarmonyBigDecimal.zeroScaledBy(newScale);
        }
        if (this.bitLength + multiplicand.bitLength < 64) {
            return HarmonyBigDecimal.valueOf(this.smallValue * multiplicand.smallValue, HarmonyBigDecimal.toIntScale(newScale));
        }
        return new HarmonyBigDecimal(this.getUnscaledValue().multiply(multiplicand.getUnscaledValue()), HarmonyBigDecimal.toIntScale(newScale));
    }

    public HarmonyBigDecimal multiply(HarmonyBigDecimal multiplicand, MathContext mc) {
        HarmonyBigDecimal result = this.multiply(multiplicand);
        result.inplaceRound(mc);
        return result;
    }

    public HarmonyBigDecimal divide(HarmonyBigDecimal divisor, int scale, int roundingMode) {
        return this.divide(divisor, scale, RoundingMode.valueOf(roundingMode));
    }

    public HarmonyBigDecimal divide(HarmonyBigDecimal divisor, int scale, RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException();
        }
        if (divisor.isZero()) {
            throw new ArithmeticException(Messages.getString("math.04"));
        }
        long diffScale = (long)this.scale - (long)divisor.scale - (long)scale;
        if (this.bitLength < 64 && divisor.bitLength < 64) {
            if (diffScale == 0L) {
                return HarmonyBigDecimal.dividePrimitiveLongs(this.smallValue, divisor.smallValue, scale, roundingMode);
            }
            if (diffScale > 0L) {
                if (diffScale < (long)LONG_TEN_POW.length && divisor.bitLength + LONG_TEN_POW_BIT_LENGTH[(int)diffScale] < 64) {
                    return HarmonyBigDecimal.dividePrimitiveLongs(this.smallValue, divisor.smallValue * LONG_TEN_POW[(int)diffScale], scale, roundingMode);
                }
            } else if (-diffScale < (long)LONG_TEN_POW.length && this.bitLength + LONG_TEN_POW_BIT_LENGTH[(int)(-diffScale)] < 64) {
                return HarmonyBigDecimal.dividePrimitiveLongs(this.smallValue * LONG_TEN_POW[(int)(-diffScale)], divisor.smallValue, scale, roundingMode);
            }
        }
        BigInteger scaledDividend = this.getUnscaledValue();
        BigInteger scaledDivisor = divisor.getUnscaledValue();
        if (diffScale > 0L) {
            scaledDivisor = Multiplication.multiplyByTenPow(scaledDivisor, (int)diffScale);
        } else if (diffScale < 0L) {
            scaledDividend = Multiplication.multiplyByTenPow(scaledDividend, (int)(-diffScale));
        }
        return HarmonyBigDecimal.divideBigIntegers(scaledDividend, scaledDivisor, scale, roundingMode);
    }

    private static HarmonyBigDecimal divideBigIntegers(BigInteger scaledDividend, BigInteger scaledDivisor, int scale, RoundingMode roundingMode) {
        int compRem;
        BigInteger[] quotAndRem = scaledDividend.divideAndRemainder(scaledDivisor);
        BigInteger quotient = quotAndRem[0];
        BigInteger remainder = quotAndRem[1];
        if (remainder.signum() == 0) {
            return new HarmonyBigDecimal(quotient, scale);
        }
        int sign = scaledDividend.signum() * scaledDivisor.signum();
        if (scaledDivisor.bitLength() < 63) {
            long rem = remainder.longValue();
            long divisor = scaledDivisor.longValue();
            compRem = HarmonyBigDecimal.longCompareTo(Math.abs(rem) << 1, Math.abs(divisor));
            compRem = HarmonyBigDecimal.roundingBehavior(quotient.testBit(0) ? 1 : 0, sign * (5 + compRem), roundingMode);
        } else {
            compRem = remainder.abs().shiftLeft(1).compareTo(scaledDivisor.abs());
            compRem = HarmonyBigDecimal.roundingBehavior(quotient.testBit(0) ? 1 : 0, sign * (5 + compRem), roundingMode);
        }
        if (compRem != 0) {
            if (quotient.bitLength() < 63) {
                return HarmonyBigDecimal.valueOf(quotient.longValue() + (long)compRem, scale);
            }
            quotient = quotient.add(BigInteger.valueOf(compRem));
            return new HarmonyBigDecimal(quotient, scale);
        }
        return new HarmonyBigDecimal(quotient, scale);
    }

    private static HarmonyBigDecimal dividePrimitiveLongs(long scaledDividend, long scaledDivisor, int scale, RoundingMode roundingMode) {
        long quotient = scaledDividend / scaledDivisor;
        long remainder = scaledDividend % scaledDivisor;
        int sign = Long_.signum(scaledDividend) * Long_.signum(scaledDivisor);
        if (remainder != 0L) {
            int compRem = HarmonyBigDecimal.longCompareTo(Math.abs(remainder) << 1, Math.abs(scaledDivisor));
            quotient += (long)HarmonyBigDecimal.roundingBehavior((int)quotient & 1, sign * (5 + compRem), roundingMode);
        }
        return HarmonyBigDecimal.valueOf(quotient, scale);
    }

    public HarmonyBigDecimal divide(HarmonyBigDecimal divisor, int roundingMode) {
        return this.divide(divisor, this.scale, RoundingMode.valueOf(roundingMode));
    }

    public HarmonyBigDecimal divide(HarmonyBigDecimal divisor, RoundingMode roundingMode) {
        return this.divide(divisor, this.scale, roundingMode);
    }

    public HarmonyBigDecimal divide(HarmonyBigDecimal divisor) {
        BigInteger p = this.getUnscaledValue();
        BigInteger q = divisor.getUnscaledValue();
        long diffScale = (long)this.scale - (long)divisor.scale;
        int l = 0;
        int i = 1;
        int lastPow = FIVE_POW.length - 1;
        if (divisor.isZero()) {
            throw new ArithmeticException(Messages.getString("math.04"));
        }
        if (p.signum() == 0) {
            return HarmonyBigDecimal.zeroScaledBy(diffScale);
        }
        BigInteger gcd = p.gcd(q);
        p = p.divide(gcd);
        q = q.divide(gcd);
        int k = q.getLowestSetBit();
        q = q.shiftRight(k);
        while (true) {
            BigInteger[] quotAndRem;
            if ((quotAndRem = q.divideAndRemainder(FIVE_POW[i]))[1].signum() == 0) {
                l += i;
                if (i < lastPow) {
                    ++i;
                }
                q = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (!q.abs().equals(BigInteger.ONE)) {
            throw new ArithmeticException(Messages.getString("math.05"));
        }
        if (q.signum() < 0) {
            p = p.negate();
        }
        int newScale = HarmonyBigDecimal.toIntScale(diffScale + (long)Math.max(k, l));
        i = k - l;
        p = i > 0 ? Multiplication.multiplyByFivePow(p, i) : p.shiftLeft(-i);
        return new HarmonyBigDecimal(p, newScale);
    }

    public HarmonyBigDecimal divide(HarmonyBigDecimal divisor, MathContext mc) {
        long diffScale;
        long traillingZeros = (long)mc.getPrecision() + 2L + (long)divisor.aproxPrecision() - (long)this.aproxPrecision();
        long newScale = diffScale = (long)this.scale - (long)divisor.scale;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        BigInteger[] quotAndRem = new BigInteger[]{this.getUnscaledValue()};
        if (mc.getPrecision() == 0 || this.isZero() || divisor.isZero()) {
            return this.divide(divisor);
        }
        if (traillingZeros > 0L) {
            quotAndRem[0] = this.getUnscaledValue().multiply(Multiplication.powerOf10(traillingZeros));
            newScale += traillingZeros;
        }
        quotAndRem = quotAndRem[0].divideAndRemainder(divisor.getUnscaledValue());
        BigInteger integerQuot = quotAndRem[0];
        if (quotAndRem[1].signum() != 0) {
            int compRem = quotAndRem[1].shiftLeft(1).compareTo(divisor.getUnscaledValue());
            integerQuot = integerQuot.multiply(BigInteger_.TEN).add(BigInteger.valueOf(quotAndRem[0].signum() * (5 + compRem)));
            ++newScale;
        } else {
            while (!integerQuot.testBit(0)) {
                quotAndRem = integerQuot.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && newScale - (long)i >= diffScale) {
                    newScale -= (long)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integerQuot = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
        }
        return new HarmonyBigDecimal(integerQuot, HarmonyBigDecimal.toIntScale(newScale), mc);
    }

    public HarmonyBigDecimal divideToIntegralValue(HarmonyBigDecimal divisor) {
        BigInteger integralValue;
        BigInteger[] quotAndRem = new BigInteger[]{this.getUnscaledValue()};
        long newScale = (long)this.scale - (long)divisor.scale;
        long tempScale = 0L;
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        if (divisor.isZero()) {
            throw new ArithmeticException(Messages.getString("math.04"));
        }
        if ((long)divisor.aproxPrecision() + newScale > (long)this.aproxPrecision() + 1L || this.isZero()) {
            integralValue = BigInteger.ZERO;
        } else if (newScale == 0L) {
            integralValue = this.getUnscaledValue().divide(divisor.getUnscaledValue());
        } else if (newScale > 0L) {
            BigInteger powerOfTen = Multiplication.powerOf10(newScale);
            integralValue = this.getUnscaledValue().divide(divisor.getUnscaledValue().multiply(powerOfTen));
            integralValue = integralValue.multiply(powerOfTen);
        } else {
            BigInteger powerOfTen = Multiplication.powerOf10(-newScale);
            integralValue = this.getUnscaledValue().multiply(powerOfTen).divide(divisor.getUnscaledValue());
            while (!integralValue.testBit(0)) {
                quotAndRem = integralValue.divideAndRemainder(TEN_POW[i]);
                if (quotAndRem[1].signum() == 0 && tempScale - (long)i >= newScale) {
                    tempScale -= (long)i;
                    if (i < lastPow) {
                        ++i;
                    }
                    integralValue = quotAndRem[0];
                    continue;
                }
                if (i == 1) break;
                i = 1;
            }
            newScale = tempScale;
        }
        return integralValue.signum() == 0 ? HarmonyBigDecimal.zeroScaledBy(newScale) : new HarmonyBigDecimal(integralValue, HarmonyBigDecimal.toIntScale(newScale));
    }

    public HarmonyBigDecimal divideToIntegralValue(HarmonyBigDecimal divisor, MathContext mc) {
        long diffScale;
        int mcPrecision = mc.getPrecision();
        int diffPrecision = this.precision() - divisor.precision();
        int lastPow = TEN_POW.length - 1;
        long newScale = diffScale = (long)this.scale - (long)divisor.scale;
        long quotPrecision = (long)diffPrecision - diffScale + 1L;
        BigInteger[] quotAndRem = new BigInteger[2];
        if (mcPrecision == 0 || this.isZero() || divisor.isZero()) {
            return this.divideToIntegralValue(divisor);
        }
        if (quotPrecision <= 0L) {
            quotAndRem[0] = BigInteger.ZERO;
        } else if (diffScale == 0L) {
            quotAndRem[0] = this.getUnscaledValue().divide(divisor.getUnscaledValue());
        } else if (diffScale > 0L) {
            quotAndRem[0] = this.getUnscaledValue().divide(divisor.getUnscaledValue().multiply(Multiplication.powerOf10(diffScale)));
            newScale = Math.min(diffScale, Math.max((long)mcPrecision - quotPrecision + 1L, 0L));
            quotAndRem[0] = quotAndRem[0].multiply(Multiplication.powerOf10(newScale));
        } else {
            long exp = Math.min(-diffScale, Math.max((long)mcPrecision - (long)diffPrecision, 0L));
            quotAndRem = this.getUnscaledValue().multiply(Multiplication.powerOf10(exp)).divideAndRemainder(divisor.getUnscaledValue());
            newScale += exp;
            exp = -newScale;
            if (quotAndRem[1].signum() != 0 && exp > 0L) {
                long compRemDiv = (long)new HarmonyBigDecimal(quotAndRem[1]).precision() + exp - (long)divisor.precision();
                if (compRemDiv == 0L) {
                    quotAndRem[1] = quotAndRem[1].multiply(Multiplication.powerOf10(exp)).divide(divisor.getUnscaledValue());
                    compRemDiv = Math.abs(quotAndRem[1].signum());
                }
                if (compRemDiv > 0L) {
                    throw new ArithmeticException(Messages.getString("math.06"));
                }
            }
        }
        if (quotAndRem[0].signum() == 0) {
            return HarmonyBigDecimal.zeroScaledBy(diffScale);
        }
        BigInteger strippedBI = quotAndRem[0];
        HarmonyBigDecimal integralValue = new HarmonyBigDecimal(quotAndRem[0]);
        long resultPrecision = integralValue.precision();
        int i = 1;
        while (!strippedBI.testBit(0)) {
            quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0 && (resultPrecision - (long)i >= (long)mcPrecision || newScale - (long)i >= diffScale)) {
                resultPrecision -= (long)i;
                newScale -= (long)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        if (resultPrecision > (long)mcPrecision) {
            throw new ArithmeticException(Messages.getString("math.06"));
        }
        integralValue.scale = HarmonyBigDecimal.toIntScale(newScale);
        integralValue.setUnscaledValue(strippedBI);
        return integralValue;
    }

    public HarmonyBigDecimal remainder(HarmonyBigDecimal divisor) {
        return this.divideAndRemainder(divisor)[1];
    }

    public HarmonyBigDecimal remainder(HarmonyBigDecimal divisor, MathContext mc) {
        return this.divideAndRemainder(divisor, mc)[1];
    }

    public HarmonyBigDecimal[] divideAndRemainder(HarmonyBigDecimal divisor) {
        HarmonyBigDecimal[] quotAndRem;
        quotAndRem = new HarmonyBigDecimal[]{this.divideToIntegralValue(divisor), this.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    public HarmonyBigDecimal[] divideAndRemainder(HarmonyBigDecimal divisor, MathContext mc) {
        HarmonyBigDecimal[] quotAndRem;
        quotAndRem = new HarmonyBigDecimal[]{this.divideToIntegralValue(divisor, mc), this.subtract(quotAndRem[0].multiply(divisor))};
        return quotAndRem;
    }

    public HarmonyBigDecimal pow(int n) {
        if (n == 0) {
            return ONE;
        }
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException(Messages.getString("math.07"));
        }
        long newScale = (long)this.scale * (long)n;
        return this.isZero() ? HarmonyBigDecimal.zeroScaledBy(newScale) : new HarmonyBigDecimal(this.getUnscaledValue().pow(n), HarmonyBigDecimal.toIntScale(newScale));
    }

    public HarmonyBigDecimal pow(int n, MathContext mc) {
        int m = Math.abs(n);
        int mcPrecision = mc.getPrecision();
        int elength = (int)Math_.log10(m) + 1;
        MathContext newPrecision = mc;
        if (n == 0 || this.isZero() && n > 0) {
            return this.pow(n);
        }
        if (m > 999999999 || mcPrecision == 0 && n < 0 || mcPrecision > 0 && elength > mcPrecision) {
            throw new ArithmeticException(Messages.getString("math.07"));
        }
        if (mcPrecision > 0) {
            newPrecision = new MathContext(mcPrecision + elength + 1, mc.getRoundingMode());
        }
        HarmonyBigDecimal accum = this.round(newPrecision);
        for (int oneBitMask = Integer_.highestOneBit(m) >> 1; oneBitMask > 0; oneBitMask >>= 1) {
            accum = accum.multiply(accum, newPrecision);
            if ((m & oneBitMask) != oneBitMask) continue;
            accum = accum.multiply(this, newPrecision);
        }
        if (n < 0) {
            accum = ONE.divide(accum, newPrecision);
        }
        accum.inplaceRound(mc);
        return accum;
    }

    public HarmonyBigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public HarmonyBigDecimal abs(MathContext mc) {
        return this.round(mc).abs();
    }

    public HarmonyBigDecimal negate() {
        if (this.bitLength < 63 || this.bitLength == 63 && this.smallValue != Long.MIN_VALUE) {
            return HarmonyBigDecimal.valueOf(-this.smallValue, this.scale);
        }
        return new HarmonyBigDecimal(this.getUnscaledValue().negate(), this.scale);
    }

    public HarmonyBigDecimal negate(MathContext mc) {
        return this.round(mc).negate();
    }

    public HarmonyBigDecimal plus() {
        return this;
    }

    public HarmonyBigDecimal plus(MathContext mc) {
        return this.round(mc);
    }

    public int signum() {
        if (this.bitLength < 64) {
            return Long_.signum(this.smallValue);
        }
        return this.getUnscaledValue().signum();
    }

    private boolean isZero() {
        return this.bitLength == 0 && this.smallValue != -1L;
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        if (this.precision > 0) {
            return this.precision;
        }
        int bitLength = this.bitLength;
        int decimalDigits = 1;
        double doubleUnsc = 1.0;
        if (bitLength < 1024) {
            if (bitLength >= 64) {
                doubleUnsc = this.getUnscaledValue().doubleValue();
            } else if (bitLength >= 1) {
                doubleUnsc = this.smallValue;
            }
            decimalDigits = (int)((double)decimalDigits + Math_.log10(Math.abs(doubleUnsc)));
        } else {
            decimalDigits = (int)((double)decimalDigits + (double)(bitLength - 1) * 0.3010299956639812);
            if (this.getUnscaledValue().divide(Multiplication.powerOf10(decimalDigits)).signum() != 0) {
                ++decimalDigits;
            }
        }
        this.precision = decimalDigits;
        return this.precision;
    }

    public BigInteger unscaledValue() {
        return this.getUnscaledValue();
    }

    public HarmonyBigDecimal round(MathContext mc) {
        HarmonyBigDecimal thisBD = new HarmonyBigDecimal(this.getUnscaledValue(), this.scale);
        thisBD.inplaceRound(mc);
        return thisBD;
    }

    public HarmonyBigDecimal setScale(int newScale, RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException();
        }
        long diffScale = (long)newScale - (long)this.scale;
        if (diffScale == 0L) {
            return this;
        }
        if (diffScale > 0L) {
            if (diffScale < (long)LONG_TEN_POW.length && this.bitLength + LONG_TEN_POW_BIT_LENGTH[(int)diffScale] < 64) {
                return HarmonyBigDecimal.valueOf(this.smallValue * LONG_TEN_POW[(int)diffScale], newScale);
            }
            return new HarmonyBigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), (int)diffScale), newScale);
        }
        if (this.bitLength < 64 && -diffScale < (long)LONG_TEN_POW.length) {
            return HarmonyBigDecimal.dividePrimitiveLongs(this.smallValue, LONG_TEN_POW[(int)(-diffScale)], newScale, roundingMode);
        }
        return HarmonyBigDecimal.divideBigIntegers(this.getUnscaledValue(), Multiplication.powerOf10(-diffScale), newScale, roundingMode);
    }

    public HarmonyBigDecimal setScale(int newScale, int roundingMode) {
        return this.setScale(newScale, RoundingMode.valueOf(roundingMode));
    }

    public HarmonyBigDecimal setScale(int newScale) {
        return this.setScale(newScale, RoundingMode.UNNECESSARY);
    }

    public HarmonyBigDecimal movePointLeft(int n) {
        return this.movePoint((long)this.scale + (long)n);
    }

    private HarmonyBigDecimal movePoint(long newScale) {
        if (this.isZero()) {
            return HarmonyBigDecimal.zeroScaledBy(Math.max(newScale, 0L));
        }
        if (newScale >= 0L) {
            if (this.bitLength < 64) {
                return HarmonyBigDecimal.valueOf(this.smallValue, HarmonyBigDecimal.toIntScale(newScale));
            }
            return new HarmonyBigDecimal(this.getUnscaledValue(), HarmonyBigDecimal.toIntScale(newScale));
        }
        if (-newScale < (long)LONG_TEN_POW.length && this.bitLength + LONG_TEN_POW_BIT_LENGTH[(int)(-newScale)] < 64) {
            return HarmonyBigDecimal.valueOf(this.smallValue * LONG_TEN_POW[(int)(-newScale)], 0);
        }
        return new HarmonyBigDecimal(Multiplication.multiplyByTenPow(this.getUnscaledValue(), (int)(-newScale)), 0);
    }

    public HarmonyBigDecimal movePointRight(int n) {
        return this.movePoint((long)this.scale - (long)n);
    }

    public HarmonyBigDecimal scaleByPowerOfTen(int n) {
        long newScale = (long)this.scale - (long)n;
        if (this.bitLength < 64) {
            if (this.smallValue == 0L) {
                return HarmonyBigDecimal.zeroScaledBy(newScale);
            }
            return HarmonyBigDecimal.valueOf(this.smallValue, HarmonyBigDecimal.toIntScale(newScale));
        }
        return new HarmonyBigDecimal(this.getUnscaledValue(), HarmonyBigDecimal.toIntScale(newScale));
    }

    public HarmonyBigDecimal stripTrailingZeros() {
        int i = 1;
        int lastPow = TEN_POW.length - 1;
        long newScale = this.scale;
        if (this.isZero()) {
            return new HarmonyBigDecimal("0");
        }
        BigInteger strippedBI = this.getUnscaledValue();
        while (!strippedBI.testBit(0)) {
            BigInteger[] quotAndRem = strippedBI.divideAndRemainder(TEN_POW[i]);
            if (quotAndRem[1].signum() == 0) {
                newScale -= (long)i;
                if (i < lastPow) {
                    ++i;
                }
                strippedBI = quotAndRem[0];
                continue;
            }
            if (i == 1) break;
            i = 1;
        }
        return new HarmonyBigDecimal(strippedBI, HarmonyBigDecimal.toIntScale(newScale));
    }

    public int compareTo(HarmonyBigDecimal val) {
        int valueSign;
        int thisSign = this.signum();
        if (thisSign == (valueSign = val.signum())) {
            if (this.scale == val.scale && this.bitLength < 64 && val.bitLength < 64) {
                return this.smallValue < val.smallValue ? -1 : (this.smallValue > val.smallValue ? 1 : 0);
            }
            long diffScale = (long)this.scale - (long)val.scale;
            int diffPrecision = this.aproxPrecision() - val.aproxPrecision();
            if ((long)diffPrecision > diffScale + 1L) {
                return thisSign;
            }
            if ((long)diffPrecision < diffScale - 1L) {
                return -thisSign;
            }
            BigInteger thisUnscaled = this.getUnscaledValue();
            BigInteger valUnscaled = val.getUnscaledValue();
            if (diffScale < 0L) {
                thisUnscaled = thisUnscaled.multiply(Multiplication.powerOf10(-diffScale));
            } else if (diffScale > 0L) {
                valUnscaled = valUnscaled.multiply(Multiplication.powerOf10(diffScale));
            }
            return thisUnscaled.compareTo(valUnscaled);
        }
        if (thisSign < valueSign) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (x instanceof HarmonyBigDecimal) {
            HarmonyBigDecimal x1 = (HarmonyBigDecimal)x;
            return x1.scale == this.scale && (this.bitLength < 64 ? x1.smallValue == this.smallValue : this.intVal.equals(x1.intVal));
        }
        return false;
    }

    public HarmonyBigDecimal min(HarmonyBigDecimal val) {
        return this.compareTo(val) <= 0 ? this : val;
    }

    public HarmonyBigDecimal max(HarmonyBigDecimal val) {
        return this.compareTo(val) >= 0 ? this : val;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        if (this.bitLength < 64) {
            this.hashCode = (int)(this.smallValue & 0xFFFFFFFFFFFFFFFFL);
            this.hashCode = 33 * this.hashCode + (int)(this.smallValue >> 32 & 0xFFFFFFFFFFFFFFFFL);
            this.hashCode = 17 * this.hashCode + this.scale;
            return this.hashCode;
        }
        this.hashCode = 17 * this.intVal.hashCode() + this.scale;
        return this.hashCode;
    }

    public String toString() {
        if (this.toStringImage != null) {
            return this.toStringImage;
        }
        if (this.bitLength < 32) {
            this.toStringImage = Conversion.toDecimalScaledString(this.smallValue, this.scale);
            return this.toStringImage;
        }
        String intString = this.getUnscaledValue().toString();
        if (this.scale == 0) {
            return intString;
        }
        int begin = this.getUnscaledValue().signum() < 0 ? 2 : 1;
        int end = intString.length();
        long exponent = -((long)this.scale) + (long)end - (long)begin;
        StringBuffer result = new StringBuffer();
        result.append(intString);
        if (this.scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                result.insert(end - this.scale, '.');
            } else {
                result.insert(begin - 1, "0.");
                result.insert(begin + 1, CH_ZEROS, 0, -((int)exponent) - 1);
            }
        } else {
            if (end - begin >= 1) {
                result.insert(begin, '.');
                ++end;
            }
            result.insert(end, 'E');
            if (exponent > 0L) {
                result.insert(++end, '+');
            }
            result.insert(++end, Long.toString(exponent));
        }
        this.toStringImage = result.toString();
        return this.toStringImage;
    }

    public String toEngineeringString() {
        String intString = this.getUnscaledValue().toString();
        if (this.scale == 0) {
            return intString;
        }
        int begin = this.getUnscaledValue().signum() < 0 ? 2 : 1;
        int end = intString.length();
        long exponent = -((long)this.scale) + (long)end - (long)begin;
        StringBuffer result = new StringBuffer(intString);
        if (this.scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                result.insert(end - this.scale, '.');
            } else {
                result.insert(begin - 1, "0.");
                result.insert(begin + 1, CH_ZEROS, 0, -((int)exponent) - 1);
            }
        } else {
            int delta = end - begin;
            int rem = (int)(exponent % 3L);
            if (rem != 0) {
                if (this.getUnscaledValue().signum() == 0) {
                    rem = rem < 0 ? -rem : 3 - rem;
                    exponent += (long)rem;
                } else {
                    rem = rem < 0 ? rem + 3 : rem;
                    exponent -= (long)rem;
                    begin += rem;
                }
                if (delta < 3) {
                    for (int i = rem - delta; i > 0; --i) {
                        result.insert(end++, '0');
                    }
                }
            }
            if (end - begin >= 1) {
                result.insert(begin, '.');
                ++end;
            }
            if (exponent != 0L) {
                result.insert(end, 'E');
                if (exponent > 0L) {
                    result.insert(++end, '+');
                }
                result.insert(++end, Long.toString(exponent));
            }
        }
        return result.toString();
    }

    public String toPlainString() {
        String intStr = this.getUnscaledValue().toString();
        if (this.scale == 0 || this.isZero() && this.scale < 0) {
            return intStr;
        }
        int begin = this.signum() < 0 ? 1 : 0;
        int delta = this.scale;
        StringBuffer result = new StringBuffer(intStr.length() + 1 + Math.abs(this.scale));
        if (begin == 1) {
            result.append('-');
        }
        if (this.scale > 0) {
            if ((delta -= intStr.length() - begin) >= 0) {
                result.append("0.");
                while (delta > CH_ZEROS.length) {
                    result.append(CH_ZEROS);
                    delta -= CH_ZEROS.length;
                }
                result.append(CH_ZEROS, 0, delta);
                result.append(intStr.substring(begin));
            } else {
                delta = begin - delta;
                result.append(intStr.substring(begin, delta));
                result.append('.');
                result.append(intStr.substring(delta));
            }
        } else {
            result.append(intStr.substring(begin));
            while (delta < -CH_ZEROS.length) {
                result.append(CH_ZEROS);
                delta += CH_ZEROS.length;
            }
            result.append(CH_ZEROS, 0, -delta);
        }
        return result.toString();
    }

    public BigInteger toBigInteger() {
        if (this.scale == 0 || this.isZero()) {
            return this.getUnscaledValue();
        }
        if (this.scale < 0) {
            return this.getUnscaledValue().multiply(Multiplication.powerOf10(-((long)this.scale)));
        }
        return this.getUnscaledValue().divide(Multiplication.powerOf10(this.scale));
    }

    public BigInteger toBigIntegerExact() {
        if (this.scale == 0 || this.isZero()) {
            return this.getUnscaledValue();
        }
        if (this.scale < 0) {
            return this.getUnscaledValue().multiply(Multiplication.powerOf10(-((long)this.scale)));
        }
        if (this.scale > this.aproxPrecision() || this.scale > this.getUnscaledValue().getLowestSetBit()) {
            throw new ArithmeticException(Messages.getString("math.08"));
        }
        BigInteger[] integerAndFraction = this.getUnscaledValue().divideAndRemainder(Multiplication.powerOf10(this.scale));
        if (integerAndFraction[1].signum() != 0) {
            throw new ArithmeticException(Messages.getString("math.08"));
        }
        return integerAndFraction[0];
    }

    public long longValue() {
        return this.scale <= -64 || this.scale > this.aproxPrecision() ? 0L : this.toBigInteger().longValue();
    }

    public long longValueExact() {
        return this.valueExact(64);
    }

    public int intValue() {
        return this.scale <= -32 || this.scale > this.aproxPrecision() ? 0 : this.toBigInteger().intValue();
    }

    public int intValueExact() {
        return (int)this.valueExact(32);
    }

    public short shortValueExact() {
        return (short)this.valueExact(16);
    }

    public byte byteValueExact() {
        return (byte)this.valueExact(8);
    }

    public float floatValue() {
        float floatResult = this.signum();
        long powerOfTwo = (long)this.bitLength - (long)((double)this.scale / 0.3010299956639812);
        floatResult = powerOfTwo < -149L || floatResult == 0.0f ? (floatResult *= 0.0f) : (powerOfTwo > 129L ? (floatResult *= Float.POSITIVE_INFINITY) : (float)this.doubleValue());
        return floatResult;
    }

    public double doubleValue() {
        long tempBits;
        long bits;
        int sign = this.signum();
        int exponent = 1076;
        long powerOfTwo = (long)this.bitLength - (long)((double)this.scale / 0.3010299956639812);
        if (powerOfTwo < -1074L || sign == 0) {
            return (double)sign * 0.0;
        }
        if (powerOfTwo > 1025L) {
            return (double)sign * Double.POSITIVE_INFINITY;
        }
        BigInteger mantisa = this.getUnscaledValue().abs();
        if (this.scale <= 0) {
            mantisa = mantisa.multiply(Multiplication.powerOf10(-this.scale));
        } else {
            BigInteger powerOfTen = Multiplication.powerOf10(this.scale);
            int k = 100 - (int)powerOfTwo;
            if (k > 0) {
                mantisa = mantisa.shiftLeft(k);
                exponent -= k;
            }
            BigInteger[] quotAndRem = mantisa.divideAndRemainder(powerOfTen);
            int compRem = quotAndRem[1].shiftLeft(1).compareTo(powerOfTen);
            mantisa = quotAndRem[0].shiftLeft(2).add(BigInteger.valueOf(compRem * (compRem + 3) / 2 + 1));
            exponent -= 2;
        }
        int lowestSetBit = mantisa.getLowestSetBit();
        int discardedSize = mantisa.bitLength() - 54;
        if (discardedSize > 0) {
            tempBits = bits = mantisa.shiftRight(discardedSize).longValue();
            if ((bits & 1L) == 1L && lowestSetBit < discardedSize || (bits & 3L) == 3L) {
                bits += 2L;
            }
        } else {
            tempBits = bits = mantisa.longValue() << -discardedSize;
            if ((bits & 3L) == 3L) {
                bits += 2L;
            }
        }
        if ((bits & 0x40000000000000L) == 0L) {
            bits >>= 1;
            exponent += discardedSize;
        } else {
            bits >>= 2;
            exponent += discardedSize + 1;
        }
        if (exponent > 2046) {
            return (double)sign * Double.POSITIVE_INFINITY;
        }
        if (exponent <= 0) {
            if (exponent < -53) {
                return (double)sign * 0.0;
            }
            bits = tempBits >> 1;
            tempBits = bits & -1L >>> 63 + exponent;
            if (((bits >>= -exponent) & 3L) == 3L || (bits & 1L) == 1L && tempBits != 0L && lowestSetBit < discardedSize) {
                ++bits;
            }
            exponent = 0;
            bits >>= 1;
        }
        bits = (long)sign & Long.MIN_VALUE | (long)exponent << 52 | bits & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits);
    }

    public HarmonyBigDecimal ulp() {
        return HarmonyBigDecimal.valueOf(1L, this.scale);
    }

    private void inplaceRound(MathContext mc) {
        int mcPrecision = mc.getPrecision();
        if (this.aproxPrecision() - mcPrecision <= 0 || mcPrecision == 0) {
            return;
        }
        int discardedPrecision = this.precision() - mcPrecision;
        if (discardedPrecision <= 0) {
            return;
        }
        if (this.bitLength < 64) {
            this.smallRound(mc, discardedPrecision);
            return;
        }
        BigInteger sizeOfFraction = Multiplication.powerOf10(discardedPrecision);
        BigInteger[] integerAndFraction = this.getUnscaledValue().divideAndRemainder(sizeOfFraction);
        long newScale = (long)this.scale - (long)discardedPrecision;
        if (integerAndFraction[1].signum() != 0) {
            HarmonyBigDecimal tempBD;
            int compRem = integerAndFraction[1].abs().shiftLeft(1).compareTo(sizeOfFraction);
            compRem = HarmonyBigDecimal.roundingBehavior(integerAndFraction[0].testBit(0) ? 1 : 0, integerAndFraction[1].signum() * (5 + compRem), mc.getRoundingMode());
            if (compRem != 0) {
                integerAndFraction[0] = integerAndFraction[0].add(BigInteger.valueOf(compRem));
            }
            if ((tempBD = new HarmonyBigDecimal(integerAndFraction[0])).precision() > mcPrecision) {
                integerAndFraction[0] = integerAndFraction[0].divide(BigInteger_.TEN);
                --newScale;
            }
        }
        this.scale = HarmonyBigDecimal.toIntScale(newScale);
        this.precision = mcPrecision;
        this.setUnscaledValue(integerAndFraction[0]);
    }

    private static int longCompareTo(long value1, long value2) {
        return value1 > value2 ? 1 : (value1 < value2 ? -1 : 0);
    }

    private void smallRound(MathContext mc, int discardedPrecision) {
        long sizeOfFraction = LONG_TEN_POW[discardedPrecision];
        long newScale = (long)this.scale - (long)discardedPrecision;
        long unscaledVal = this.smallValue;
        long integer = unscaledVal / sizeOfFraction;
        long fraction = unscaledVal % sizeOfFraction;
        if (fraction != 0L) {
            int compRem = HarmonyBigDecimal.longCompareTo(Math.abs(fraction) << 1, sizeOfFraction);
            if (Math_.log10(Math.abs(integer += (long)HarmonyBigDecimal.roundingBehavior((int)integer & 1, Long_.signum(fraction) * (5 + compRem), mc.getRoundingMode()))) >= (double)mc.getPrecision()) {
                integer /= 10L;
                --newScale;
            }
        }
        this.scale = HarmonyBigDecimal.toIntScale(newScale);
        this.precision = mc.getPrecision();
        this.smallValue = integer;
        this.bitLength = HarmonyBigDecimal.bitLength(integer);
        this.intVal = null;
    }

    private static int roundingBehavior(int parityBit, int fraction, RoundingMode roundingMode) {
        int increment = 0;
        switch (1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[roundingMode.ordinal()]) {
            case 1: {
                if (fraction == 0) break;
                throw new ArithmeticException(Messages.getString("math.08"));
            }
            case 2: {
                increment = Integer_.signum(fraction);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                increment = Math.max(Integer_.signum(fraction), 0);
                break;
            }
            case 5: {
                increment = Math.min(Integer_.signum(fraction), 0);
                break;
            }
            case 6: {
                if (Math.abs(fraction) < 5) break;
                increment = Integer_.signum(fraction);
                break;
            }
            case 7: {
                if (Math.abs(fraction) <= 5) break;
                increment = Integer_.signum(fraction);
                break;
            }
            case 8: {
                if (Math.abs(fraction) + parityBit <= 5) break;
                increment = Integer_.signum(fraction);
            }
        }
        return increment;
    }

    private long valueExact(int bitLengthOfType) {
        BigInteger bigInteger = this.toBigIntegerExact();
        if (bigInteger.bitLength() < bitLengthOfType) {
            return bigInteger.longValue();
        }
        throw new ArithmeticException(Messages.getString("math.08"));
    }

    private int aproxPrecision() {
        return (this.precision > 0 ? this.precision : (int)((double)(this.bitLength - 1) * 0.3010299956639812)) + 1;
    }

    private static int toIntScale(long longScale) {
        if (longScale < Integer.MIN_VALUE) {
            throw new ArithmeticException(Messages.getString("math.09"));
        }
        if (longScale > Integer.MAX_VALUE) {
            throw new ArithmeticException(Messages.getString("math.0A"));
        }
        return (int)longScale;
    }

    private static HarmonyBigDecimal zeroScaledBy(long longScale) {
        if (longScale == (long)((int)longScale)) {
            return HarmonyBigDecimal.valueOf(0L, (int)longScale);
        }
        if (longScale >= 0L) {
            return new HarmonyBigDecimal(0, Integer.MAX_VALUE);
        }
        return new HarmonyBigDecimal(0, Integer.MIN_VALUE);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bitLength = this.intVal.bitLength();
        if (this.bitLength < 64) {
            this.smallValue = this.intVal.longValue();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getUnscaledValue();
        out.defaultWriteObject();
    }

    private BigInteger getUnscaledValue() {
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.smallValue);
        }
        return this.intVal;
    }

    private void setUnscaledValue(BigInteger unscaledValue) {
        this.intVal = unscaledValue;
        this.bitLength = unscaledValue.bitLength();
        if (this.bitLength < 64) {
            this.smallValue = unscaledValue.longValue();
        }
    }

    private static int bitLength(long smallValue) {
        if (smallValue < 0L) {
            smallValue ^= 0xFFFFFFFFFFFFFFFFL;
        }
        return 64 - Long_.numberOfLeadingZeros(smallValue);
    }

    private static int bitLength(int smallValue) {
        if (smallValue < 0) {
            smallValue ^= 0xFFFFFFFF;
        }
        return 32 - Integer_.numberOfLeadingZeros(smallValue);
    }

    static {
        int j;
        int i;
        ZERO = new HarmonyBigDecimal(0, 0);
        ONE = new HarmonyBigDecimal(1, 0);
        TEN = new HarmonyBigDecimal(10, 0);
        LONG_TEN_POW = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        LONG_FIVE_POW = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L, 7450580596923828125L};
        LONG_FIVE_POW_BIT_LENGTH = new int[LONG_FIVE_POW.length];
        LONG_TEN_POW_BIT_LENGTH = new int[LONG_TEN_POW.length];
        BI_SCALED_BY_ZERO = new HarmonyBigDecimal[11];
        ZERO_SCALED_BY = new HarmonyBigDecimal[11];
        CH_ZEROS = new char[100];
        for (i = 0; i < ZERO_SCALED_BY.length; ++i) {
            HarmonyBigDecimal.BI_SCALED_BY_ZERO[i] = new HarmonyBigDecimal(i, 0);
            HarmonyBigDecimal.ZERO_SCALED_BY[i] = new HarmonyBigDecimal(0, i);
            HarmonyBigDecimal.CH_ZEROS[i] = 48;
        }
        while (i < CH_ZEROS.length) {
            HarmonyBigDecimal.CH_ZEROS[i] = 48;
            ++i;
        }
        for (j = 0; j < LONG_FIVE_POW_BIT_LENGTH.length; ++j) {
            HarmonyBigDecimal.LONG_FIVE_POW_BIT_LENGTH[j] = HarmonyBigDecimal.bitLength(LONG_FIVE_POW[j]);
        }
        for (j = 0; j < LONG_TEN_POW_BIT_LENGTH.length; ++j) {
            HarmonyBigDecimal.LONG_TEN_POW_BIT_LENGTH[j] = HarmonyBigDecimal.bitLength(LONG_TEN_POW[j]);
        }
        TEN_POW = Multiplication.bigTenPows;
        FIVE_POW = Multiplication.bigFivePows;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode;

        static {
            $SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode = new int[RoundingMode.values().length];
            try {
                1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[RoundingMode.UNNECESSARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[RoundingMode.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[RoundingMode.DOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[RoundingMode.CEILING.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[RoundingMode.FLOOR.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[RoundingMode.HALF_UP.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[RoundingMode.HALF_DOWN.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$net$sourceforge$retroweaver$harmony$runtime$java$math$RoundingMode[RoundingMode.HALF_EVEN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

