/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.harmony.runtime.java.math;

class Conversion {
    static final int[] digitFitInInt = new int[]{-1, -1, 31, 19, 15, 13, 11, 11, 10, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5};
    static final int[] bigRadices = new int[]{Integer.MIN_VALUE, 1162261467, 0x40000000, 1220703125, 362797056, 1977326743, 0x40000000, 387420489, 1000000000, 214358881, 429981696, 815730721, 1475789056, 170859375, 0x10000000, 410338673, 612220032, 893871739, 1280000000, 1801088541, 113379904, 148035889, 191102976, 244140625, 308915776, 387420489, 481890304, 594823321, 729000000, 887503681, 0x40000000, 1291467969, 1544804416, 1838265625, 60466176};

    private Conversion() {
    }

    static String toDecimalScaledString(long value, int scale) {
        boolean negNumber;
        boolean bl = negNumber = value < 0L;
        if (negNumber) {
            value = -value;
        }
        if (value == 0L) {
            switch (scale) {
                case 0: {
                    return "0";
                }
                case 1: {
                    return "0.0";
                }
                case 2: {
                    return "0.00";
                }
                case 3: {
                    return "0.000";
                }
                case 4: {
                    return "0.0000";
                }
                case 5: {
                    return "0.00000";
                }
                case 6: {
                    return "0.000000";
                }
            }
            StringBuffer result1 = new StringBuffer();
            if (scale < 0) {
                result1.append("0E+");
            } else {
                result1.append("0E");
            }
            result1.append(scale == Integer.MIN_VALUE ? "2147483648" : Integer.toString(-scale));
            return result1.toString();
        }
        int resLengthInChars = 18;
        char[] result = new char[resLengthInChars + 1];
        int currentChar = resLengthInChars;
        long v = value;
        do {
            long prev = v;
            result[--currentChar] = (char)(48L + (prev - (v /= 10L) * 10L));
        } while (v != 0L);
        long exponent = (long)resLengthInChars - (long)currentChar - (long)scale - 1L;
        if (scale == 0) {
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        if (scale > 0 && exponent >= -6L) {
            if (exponent >= 0L) {
                int insertPoint = currentChar + (int)exponent;
                for (int j = resLengthInChars - 1; j >= insertPoint; --j) {
                    result[j + 1] = result[j];
                }
                result[++insertPoint] = 46;
                if (negNumber) {
                    result[--currentChar] = 45;
                }
                return new String(result, currentChar, resLengthInChars - currentChar + 1);
            }
            int j = 2;
            while ((long)j < -exponent + 1L) {
                result[--currentChar] = 48;
                ++j;
            }
            result[--currentChar] = 46;
            result[--currentChar] = 48;
            if (negNumber) {
                result[--currentChar] = 45;
            }
            return new String(result, currentChar, resLengthInChars - currentChar);
        }
        int startPoint = currentChar + 1;
        int endPoint = resLengthInChars;
        StringBuffer result1 = new StringBuffer(16 + endPoint - startPoint);
        if (negNumber) {
            result1.append('-');
        }
        if (endPoint - startPoint >= 1) {
            result1.append(result[currentChar]);
            result1.append('.');
            result1.append(result, currentChar + 1, resLengthInChars - currentChar - 1);
        } else {
            result1.append(result, currentChar, resLengthInChars - currentChar);
        }
        result1.append('E');
        if (exponent > 0L) {
            result1.append('+');
        }
        result1.append(Long.toString(exponent));
        return result1.toString();
    }

    static long divideLongByBillion(long a) {
        long rem;
        long quot;
        if (a >= 0L) {
            long bLong = 1000000000L;
            quot = a / bLong;
            rem = a % bLong;
        } else {
            long aPos = a >>> 1;
            long bPos = 500000000L;
            quot = aPos / bPos;
            rem = aPos % bPos;
            rem = (rem << 1) + (a & 1L);
        }
        return rem << 32 | quot & 0xFFFFFFFFL;
    }
}

