/* aggregation.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from aggregation.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <kf-test.h>
#include <tp-test-contactlist.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gio/gio.h>


#define TYPE_AGGREGATION_TESTS (aggregation_tests_get_type ())
#define AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATION_TESTS, AggregationTests))
#define AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATION_TESTS, AggregationTestsClass))
#define IS_AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATION_TESTS))
#define IS_AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATION_TESTS))
#define AGGREGATION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATION_TESTS, AggregationTestsClass))

typedef struct _AggregationTests AggregationTests;
typedef struct _AggregationTestsClass AggregationTestsClass;
typedef struct _AggregationTestsPrivate AggregationTestsPrivate;

#define AGGREGATION_TESTS_TYPE_INDIVIDUAL_STATE (aggregation_tests_individual_state_get_type ())
#define _kf_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (kf_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

struct _AggregationTests {
	FolksTestCase parent_instance;
	AggregationTestsPrivate * priv;
};

struct _AggregationTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AggregationTestsPrivate {
	KfTestBackend* _kf_backend;
	TpTestBackend* _tp_backend;
	GeeHashSet* _default_personas;
	gint _test_timeout;
};

typedef enum  {
	AGGREGATION_TESTS_INDIVIDUAL_STATE_ADDED,
	AGGREGATION_TESTS_INDIVIDUAL_STATE_REMOVED,
	AGGREGATION_TESTS_INDIVIDUAL_STATE_FINALISED
} AggregationTestsIndividualState;

struct _Block1Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	GeeHashSet* default_individuals;
	GeeHashSet* expected_individuals;
	FolksIndividualAggregator* aggregator;
};

struct _Block2Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	FolksIndividual* individual1;
	FolksIndividual* individual2;
	FolksIndividualAggregator* aggregator;
};

struct _Block3Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	FolksIndividual* individual1;
	FolksIndividual* individual2;
	FolksIndividualAggregator* aggregator;
};

struct _Block4Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	FolksIndividual* user_individual;
	FolksIndividualAggregator* aggregator;
};

struct _Block5Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	FolksIndividualAggregator* aggregator;
};

struct _Block6Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	GeeHashMap* individuals_map;
	FolksIndividualAggregator* aggregator;
	gboolean aggregator_is_finalising;
};


static gpointer aggregation_tests_parent_class = NULL;

GType aggregation_tests_get_type (void) G_GNUC_CONST;
#define AGGREGATION_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AGGREGATION_TESTS, AggregationTestsPrivate))
enum  {
	AGGREGATION_TESTS_DUMMY_PROPERTY
};
static GType aggregation_tests_individual_state_get_type (void) G_GNUC_UNUSED;
AggregationTests* aggregation_tests_new (void);
AggregationTests* aggregation_tests_construct (GType object_type);
void aggregation_tests_test_iid (AggregationTests* self);
static void _aggregation_tests_test_iid_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_linkable_properties_same_store (AggregationTests* self);
static void _aggregation_tests_test_linkable_properties_same_store_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_linkable_properties_different_stores (AggregationTests* self);
static void _aggregation_tests_test_linkable_properties_different_stores_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_user (AggregationTests* self);
static void _aggregation_tests_test_user_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_untrusted_store (AggregationTests* self);
static void _aggregation_tests_test_untrusted_store_folks_test_case_test_method (gpointer self);
void aggregation_tests_test_linked_individual_refcounting (AggregationTests* self);
static void _aggregation_tests_test_linked_individual_refcounting_folks_test_case_test_method (gpointer self);
static void aggregation_tests_real_set_up (FolksTestCase* base);
static void aggregation_tests_real_tear_down (FolksTestCase* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_);
static void __lambda0__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda1_ (Block1Data* _data1_);
static gboolean __lambda1__gsource_func (gpointer self);
static gboolean _lambda2_ (Block1Data* _data1_);
static void _lambda3_ (GObject* s, GAsyncResult* r, Block1Data* _data1_);
static void __lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda2__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda4_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block2Data* _data2_);
static void __lambda4__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda5_ (Block2Data* _data2_);
static gboolean __lambda5__gsource_func (gpointer self);
static gboolean _lambda6_ (Block2Data* _data2_);
static void _lambda7_ (GObject* s, GAsyncResult* r, Block2Data* _data2_);
static void __lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda6__gsource_func (gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda8_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block3Data* _data3_);
static void __lambda8__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda9_ (Block3Data* _data3_);
static gboolean __lambda9__gsource_func (gpointer self);
static gboolean _lambda10_ (Block3Data* _data3_);
static void _lambda11_ (GObject* s, GAsyncResult* r, Block3Data* _data3_);
static void __lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda10__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda12_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block4Data* _data4_);
static void __lambda12__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda13_ (Block4Data* _data4_);
static gboolean __lambda13__gsource_func (gpointer self);
static gboolean _lambda14_ (Block4Data* _data4_);
static void _lambda15_ (GObject* s, GAsyncResult* r, Block4Data* _data4_);
static void __lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda14__gsource_func (gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void _lambda16_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, AggregationTests* self);
static void __lambda16__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda17_ (Block5Data* _data5_);
static gboolean __lambda17__gsource_func (gpointer self);
static gboolean _lambda18_ (Block5Data* _data5_);
static void _lambda19_ (GObject* s, GAsyncResult* r, Block5Data* _data5_);
static void __lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda18__gsource_func (gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _lambda20_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block6Data* _data6_);
static void _lambda21_ (Block6Data* _data6_, GObject* obj);
static void __lambda21__gweak_notify (gpointer self, GObject* object);
static void __lambda20__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda22_ (Block6Data* _data6_);
static gboolean __lambda22__gsource_func (gpointer self);
static gboolean _lambda23_ (Block6Data* _data6_);
static void _lambda24_ (GObject* s, GAsyncResult* r, Block6Data* _data6_);
static void __lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda23__gsource_func (gpointer self);
static gboolean _lambda25_ (Block6Data* _data6_);
static gboolean __lambda25__gsource_func (gpointer self);
static void aggregation_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static GType aggregation_tests_individual_state_get_type (void) {
	static volatile gsize aggregation_tests_individual_state_type_id__volatile = 0;
	if (g_once_init_enter (&aggregation_tests_individual_state_type_id__volatile)) {
		static const GEnumValue values[] = {{AGGREGATION_TESTS_INDIVIDUAL_STATE_ADDED, "AGGREGATION_TESTS_INDIVIDUAL_STATE_ADDED", "added"}, {AGGREGATION_TESTS_INDIVIDUAL_STATE_REMOVED, "AGGREGATION_TESTS_INDIVIDUAL_STATE_REMOVED", "removed"}, {AGGREGATION_TESTS_INDIVIDUAL_STATE_FINALISED, "AGGREGATION_TESTS_INDIVIDUAL_STATE_FINALISED", "finalised"}, {0, NULL, NULL}};
		GType aggregation_tests_individual_state_type_id;
		aggregation_tests_individual_state_type_id = g_enum_register_static ("AggregationTestsIndividualState", values);
		g_once_init_leave (&aggregation_tests_individual_state_type_id__volatile, aggregation_tests_individual_state_type_id);
	}
	return aggregation_tests_individual_state_type_id__volatile;
}


static void _aggregation_tests_test_iid_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_iid (self);
}


static void _aggregation_tests_test_linkable_properties_same_store_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_linkable_properties_same_store (self);
}


static void _aggregation_tests_test_linkable_properties_different_stores_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_linkable_properties_different_stores (self);
}


static void _aggregation_tests_test_user_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_user (self);
}


static void _aggregation_tests_test_untrusted_store_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_untrusted_store (self);
}


static void _aggregation_tests_test_linked_individual_refcounting_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_linked_individual_refcounting (self);
}


AggregationTests* aggregation_tests_construct (GType object_type) {
	AggregationTests * self = NULL;
	KfTestBackend* _tmp0_;
	TpTestBackend* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	GeeHashSet* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeHashSet* _tmp9_;
	GeeHashSet* _tmp10_;
	GeeHashSet* _tmp11_;
	GeeHashSet* _tmp12_;
	const gchar* _tmp13_ = NULL;
	self = (AggregationTests*) folks_test_case_construct (object_type, "Aggregation");
	_tmp0_ = kf_test_backend_new ();
	_kf_test_backend_unref0 (self->priv->_kf_backend);
	self->priv->_kf_backend = _tmp0_;
	_tmp1_ = tp_test_backend_new ();
	_g_object_unref0 (self->priv->_tp_backend);
	self->priv->_tp_backend = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp2_, _tmp3_);
	_g_object_unref0 (self->priv->_default_personas);
	self->priv->_default_personas = _tmp4_;
	_tmp5_ = self->priv->_default_personas;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, "travis@example.com");
	_tmp6_ = self->priv->_default_personas;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, "olivier@example.com");
	_tmp7_ = self->priv->_default_personas;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "guillaume@example.com");
	_tmp8_ = self->priv->_default_personas;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "sjoerd@example.com");
	_tmp9_ = self->priv->_default_personas;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "christian@example.com");
	_tmp10_ = self->priv->_default_personas;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "wim@example.com");
	_tmp11_ = self->priv->_default_personas;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "helen@example.com");
	_tmp12_ = self->priv->_default_personas;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "geraldine@example.com");
	folks_test_case_add_test ((FolksTestCase*) self, "IID", _aggregation_tests_test_iid_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "linkable properties:same store", _aggregation_tests_test_linkable_properties_same_store_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "linkable properties:different stores", _aggregation_tests_test_linkable_properties_different_stores_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "user", _aggregation_tests_test_user_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "untrusted store", _aggregation_tests_test_untrusted_store_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "refcounting", _aggregation_tests_test_linked_individual_refcounting_folks_test_case_test_method, self);
	_tmp13_ = g_getenv ("FOLKS_TEST_VALGRIND");
	if (_tmp13_ != NULL) {
		self->priv->_test_timeout = 10;
	}
	return self;
}


AggregationTests* aggregation_tests_new (void) {
	return aggregation_tests_construct (TYPE_AGGREGATION_TESTS);
}


static void aggregation_tests_real_set_up (FolksTestCase* base) {
	AggregationTests * self;
	TpTestBackend* _tmp0_;
	self = (AggregationTests*) base;
	_tmp0_ = self->priv->_tp_backend;
	tp_test_backend_set_up (_tmp0_);
}


static void aggregation_tests_real_tear_down (FolksTestCase* base) {
	AggregationTests * self;
	TpTestBackend* _tmp0_;
	self = (AggregationTests*) base;
	_tmp0_ = self->priv->_tp_backend;
	tp_test_backend_tear_down (_tmp0_);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->aggregator);
		_g_object_unref0 (_data1_->expected_individuals);
		_g_object_unref0 (_data1_->default_individuals);
		_g_main_loop_unref0 (_data1_->main_loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda0_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_) {
	AggregationTests * self;
	self = _data1_->self;
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = removed;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			FolksIndividual* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp16_;
			gboolean _tmp22_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp8_ = i;
			_tmp9_ = folks_individual_get_is_user (_tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				FolksIndividual* _tmp11_;
				GeeSet* _tmp12_;
				GeeSet* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				_tmp11_ = i;
				_tmp12_ = folks_individual_get_personas (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp7_ = _tmp15_ == 2;
			} else {
				_tmp7_ = FALSE;
			}
			_tmp16_ = _tmp7_;
			if (_tmp16_) {
				GeeHashSet* _tmp17_;
				FolksIndividual* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp17_ = _data1_->default_individuals;
				_tmp18_ = i;
				_tmp19_ = folks_individual_get_id (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp17_, _tmp20_);
				_tmp6_ = _tmp21_;
			} else {
				_tmp6_ = FALSE;
			}
			_tmp22_ = _tmp6_;
			if (_tmp22_) {
				GeeHashSet* _tmp23_;
				FolksIndividual* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp23_ = _data1_->expected_individuals;
				_tmp24_ = i;
				_tmp25_ = folks_individual_get_id (_tmp24_);
				_tmp26_ = _tmp25_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp26_);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp27_;
		GeeIterator* _tmp28_ = NULL;
		GeeIterator* _i_it;
		_tmp27_ = added;
		_tmp28_ = gee_iterable_iterator ((GeeIterable*) _tmp27_);
		_i_it = _tmp28_;
		while (TRUE) {
			GeeIterator* _tmp29_;
			gboolean _tmp30_ = FALSE;
			GeeIterator* _tmp31_;
			gpointer _tmp32_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp33_;
			GeeSet* _tmp34_;
			GeeSet* _tmp35_;
			GeeSet* _tmp36_;
			GeeSet* personas;
			gboolean _tmp37_ = FALSE;
			FolksIndividual* _tmp38_;
			gboolean _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp44_;
			_tmp29_ = _i_it;
			_tmp30_ = gee_iterator_next (_tmp29_);
			if (!_tmp30_) {
				break;
			}
			_tmp31_ = _i_it;
			_tmp32_ = gee_iterator_get (_tmp31_);
			i = (FolksIndividual*) _tmp32_;
			_tmp33_ = i;
			_tmp34_ = folks_individual_get_personas (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = _g_object_ref0 (_tmp35_);
			personas = _tmp36_;
			_tmp38_ = i;
			_tmp39_ = folks_individual_get_is_user (_tmp38_);
			_tmp40_ = _tmp39_;
			if (!_tmp40_) {
				GeeSet* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				_tmp41_ = personas;
				_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp37_ = _tmp43_ == 2;
			} else {
				_tmp37_ = FALSE;
			}
			_tmp44_ = _tmp37_;
			if (_tmp44_) {
				GeeHashSet* _tmp45_;
				FolksIndividual* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				gboolean _tmp49_ = FALSE;
				gchar* iid;
				_tmp45_ = _data1_->expected_individuals;
				_tmp46_ = i;
				_tmp47_ = folks_individual_get_id (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp45_, _tmp48_);
				g_assert (_tmp49_);
				iid = NULL;
				{
					GeeSet* _tmp50_;
					GeeIterator* _tmp51_ = NULL;
					GeeIterator* _persona_it;
					_tmp50_ = personas;
					_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
					_persona_it = _tmp51_;
					while (TRUE) {
						GeeIterator* _tmp52_;
						gboolean _tmp53_ = FALSE;
						GeeIterator* _tmp54_;
						gpointer _tmp55_ = NULL;
						FolksPersona* persona;
						const gchar* _tmp56_;
						_tmp52_ = _persona_it;
						_tmp53_ = gee_iterator_next (_tmp52_);
						if (!_tmp53_) {
							break;
						}
						_tmp54_ = _persona_it;
						_tmp55_ = gee_iterator_get (_tmp54_);
						persona = (FolksPersona*) _tmp55_;
						_tmp56_ = iid;
						if (_tmp56_ != NULL) {
							FolksPersona* _tmp57_;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							const gchar* _tmp60_;
							_tmp57_ = persona;
							_tmp58_ = folks_persona_get_iid (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = iid;
							g_assert (g_strcmp0 (_tmp59_, _tmp60_) == 0);
						} else {
							FolksPersona* _tmp61_;
							const gchar* _tmp62_;
							const gchar* _tmp63_;
							gchar* _tmp64_;
							_tmp61_ = persona;
							_tmp62_ = folks_persona_get_iid (_tmp61_);
							_tmp63_ = _tmp62_;
							_tmp64_ = g_strdup (_tmp63_);
							_g_free0 (iid);
							iid = _tmp64_;
						}
						_g_object_unref0 (persona);
					}
					_g_object_unref0 (_persona_it);
				}
				_g_free0 (iid);
			}
			_g_object_unref0 (personas);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void __lambda0__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda0_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda1_ (Block1Data* _data1_) {
	AggregationTests * self;
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->main_loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static void _lambda3_ (GObject* s, GAsyncResult* r, Block1Data* _data1_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	{
		FolksIndividualAggregator* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data1_->aggregator;
		_tmp1_ = r;
		folks_individual_aggregator_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e1 = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e1;
		_tmp3_ = _tmp2_->message;
		g_critical ("aggregation.vala:189: Failed to prepare aggregator: %s", _tmp3_);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda3_ (source_object, res, self);
	block1_data_unref (self);
}


static gboolean _lambda2_ (Block1Data* _data1_) {
	AggregationTests * self;
	gboolean result = FALSE;
	FolksIndividualAggregator* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->aggregator;
	folks_individual_aggregator_prepare (_tmp0_, __lambda3__gasync_ready_callback, block1_data_ref (_data1_));
	result = FALSE;
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


void aggregation_tests_test_iid (AggregationTests* self) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	KfTestBackend* _tmp1_;
	TpTestBackend* _tmp2_;
	void* _tmp3_ = NULL;
	void* account1_handle;
	TpTestBackend* _tmp4_;
	void* _tmp5_ = NULL;
	void* account2_handle;
	GeeHashSet* _tmp6_;
	GeeHashSet* _tmp7_;
	GeeHashSet* _tmp8_;
	GeeHashSet* _tmp9_;
	GeeHashSet* _tmp10_;
	GeeHashSet* _tmp11_;
	GeeHashSet* _tmp12_;
	GeeHashSet* _tmp13_;
	GeeHashSet* _tmp14_;
	GeeHashSet* _tmp15_;
	FolksIndividualAggregator* _tmp24_;
	FolksIndividualAggregator* _tmp25_;
	gint _tmp26_;
	GMainLoop* _tmp27_;
	GeeHashSet* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	TpTestBackend* _tmp31_;
	void* _tmp32_;
	TpTestBackend* _tmp33_;
	void* _tmp34_;
	KfTestBackend* _tmp35_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data1_->main_loop = _tmp0_;
	_tmp1_ = self->priv->_kf_backend;
	kf_test_backend_set_up (_tmp1_, "");
	_tmp2_ = self->priv->_tp_backend;
	_tmp3_ = tp_test_backend_add_account (_tmp2_, "protocol", "me@example.com", "cm", "account");
	account1_handle = _tmp3_;
	_tmp4_ = self->priv->_tp_backend;
	_tmp5_ = tp_test_backend_add_account (_tmp4_, "protocol", "me2@example.com", "cm", "account2");
	account2_handle = _tmp5_;
	_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data1_->default_individuals = _tmp6_;
	_tmp7_ = _data1_->default_individuals;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "6380b17dc511b21a1defd4811f1add97b278f92c");
	_tmp8_ = _data1_->default_individuals;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "6b08188cb2ef8cbaca140b277780069b5af8add6");
	_tmp9_ = _data1_->default_individuals;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "60c91326018f6a60604f8d260fc24a60a5b8512c");
	_tmp10_ = _data1_->default_individuals;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "0e46c5e74f61908f49550d241f2a1651892a1695");
	_tmp11_ = _data1_->default_individuals;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "07b913b8977c04d2f2011e26a46ea3e3dcfe3e3d");
	_tmp12_ = _data1_->default_individuals;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "f948d4d2af79085ab860f0ef67bf0c201c4602d4");
	_tmp13_ = _data1_->default_individuals;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "f34529a442577b840a75271b464e90666c38c464");
	_tmp14_ = _data1_->default_individuals;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "467d13f955e62bf30ebf9620fa052aaee2160260");
	_tmp15_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_data1_->expected_individuals = _tmp15_;
	{
		GeeHashSet* _tmp16_;
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _id_it;
		_tmp16_ = _data1_->default_individuals;
		_tmp17_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp16_);
		_id_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* id;
			GeeHashSet* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = _id_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _id_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			id = (gchar*) _tmp21_;
			_tmp22_ = _data1_->expected_individuals;
			_tmp23_ = id;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp24_ = folks_individual_aggregator_new ();
	_data1_->aggregator = _tmp24_;
	_tmp25_ = _data1_->aggregator;
	g_signal_connect_data (_tmp25_, "individuals-changed", (GCallback) __lambda0__folks_individual_aggregator_individuals_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp26_ = self->priv->_test_timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp26_, __lambda1__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda2__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_tmp27_ = _data1_->main_loop;
	g_main_loop_run (_tmp27_);
	_tmp28_ = _data1_->expected_individuals;
	_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	g_assert (_tmp30_ == 0);
	_tmp31_ = self->priv->_tp_backend;
	_tmp32_ = account2_handle;
	tp_test_backend_remove_account (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->_tp_backend;
	_tmp34_ = account1_handle;
	tp_test_backend_remove_account (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->_kf_backend;
	kf_test_backend_tear_down (_tmp35_);
	_g_object_unref0 (_data1_->aggregator);
	_data1_->aggregator = NULL;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->aggregator);
		_g_main_loop_unref0 (_data2_->main_loop);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda4_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block2Data* _data2_) {
	AggregationTests * self;
	self = _data2_->self;
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = removed;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			gboolean _tmp6_ = FALSE;
			FolksIndividual* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp15_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp7_ = i;
			_tmp8_ = folks_individual_get_is_user (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				FolksIndividual* _tmp10_;
				GeeSet* _tmp11_;
				GeeSet* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp10_ = i;
				_tmp11_ = folks_individual_get_personas (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp6_ = _tmp14_ == 5;
			} else {
				_tmp6_ = FALSE;
			}
			_tmp15_ = _tmp6_;
			if (_tmp15_) {
				FolksIndividual* _tmp16_;
				FolksIndividual* _tmp17_;
				_tmp16_ = i;
				_tmp17_ = _data2_->individual1;
				if (_tmp16_ == _tmp17_) {
					_data2_->individual1 = NULL;
				} else {
					FolksIndividual* _tmp18_;
					FolksIndividual* _tmp19_;
					_tmp18_ = i;
					_tmp19_ = _data2_->individual2;
					if (_tmp18_ == _tmp19_) {
						_data2_->individual2 = NULL;
					} else {
						FolksIndividual* _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						_tmp20_ = i;
						_tmp21_ = folks_individual_get_id (_tmp20_);
						_tmp22_ = _tmp21_;
						g_critical ("aggregation.vala:253: Unknown 5-persona individual: %s", _tmp22_);
						g_assert_not_reached ();
					}
				}
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp23_;
		GeeIterator* _tmp24_ = NULL;
		GeeIterator* _i_it;
		_tmp23_ = added;
		_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
		_i_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_;
			gboolean _tmp26_ = FALSE;
			GeeIterator* _tmp27_;
			gpointer _tmp28_ = NULL;
			FolksIndividual* i;
			gboolean _tmp29_ = FALSE;
			FolksIndividual* _tmp30_;
			gboolean _tmp31_;
			gboolean _tmp32_;
			gboolean _tmp38_;
			_tmp25_ = _i_it;
			_tmp26_ = gee_iterator_next (_tmp25_);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = _i_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			i = (FolksIndividual*) _tmp28_;
			_tmp30_ = i;
			_tmp31_ = folks_individual_get_is_user (_tmp30_);
			_tmp32_ = _tmp31_;
			if (!_tmp32_) {
				FolksIndividual* _tmp33_;
				GeeSet* _tmp34_;
				GeeSet* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				_tmp33_ = i;
				_tmp34_ = folks_individual_get_personas (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = gee_collection_get_size ((GeeCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp29_ = _tmp37_ == 5;
			} else {
				_tmp29_ = FALSE;
			}
			_tmp38_ = _tmp29_;
			if (_tmp38_) {
				FolksIndividual* _tmp39_;
				_tmp39_ = _data2_->individual1;
				if (_tmp39_ == NULL) {
					FolksIndividual* _tmp40_;
					_tmp40_ = i;
					_data2_->individual1 = _tmp40_;
				} else {
					FolksIndividual* _tmp41_;
					_tmp41_ = _data2_->individual2;
					if (_tmp41_ == NULL) {
						FolksIndividual* _tmp42_;
						_tmp42_ = i;
						_data2_->individual2 = _tmp42_;
					} else {
						FolksIndividual* _tmp43_;
						const gchar* _tmp44_;
						const gchar* _tmp45_;
						_tmp43_ = i;
						_tmp44_ = folks_individual_get_id (_tmp43_);
						_tmp45_ = _tmp44_;
						g_critical ("aggregation.vala:273: Unknown 5-persona individual: %s", _tmp45_);
						g_assert_not_reached ();
					}
				}
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void __lambda4__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda4_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda5_ (Block2Data* _data2_) {
	AggregationTests * self;
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	self = _data2_->self;
	_tmp0_ = _data2_->main_loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean __lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda5_ (self);
	return result;
}


static void _lambda7_ (GObject* s, GAsyncResult* r, Block2Data* _data2_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (r != NULL);
	{
		FolksIndividualAggregator* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data2_->aggregator;
		_tmp1_ = r;
		folks_individual_aggregator_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e1 = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e1;
		_tmp3_ = _tmp2_->message;
		g_critical ("aggregation.vala:299: Failed to prepare aggregator: %s", _tmp3_);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda7_ (source_object, res, self);
	block2_data_unref (self);
}


static gboolean _lambda6_ (Block2Data* _data2_) {
	AggregationTests * self;
	gboolean result = FALSE;
	FolksIndividualAggregator* _tmp0_;
	self = _data2_->self;
	_tmp0_ = _data2_->aggregator;
	folks_individual_aggregator_prepare (_tmp0_, __lambda7__gasync_ready_callback, block2_data_ref (_data2_));
	result = FALSE;
	return result;
}


static gboolean __lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda6_ (self);
	return result;
}


void aggregation_tests_test_linkable_properties_same_store (AggregationTests* self) {
	Block2Data* _data2_;
	GMainLoop* _tmp0_;
	KfTestBackend* _tmp1_;
	TpTestBackend* _tmp2_;
	void* _tmp3_ = NULL;
	void* account_handle;
	FolksIndividualAggregator* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	gint _tmp6_;
	GMainLoop* _tmp7_;
	FolksIndividual* _tmp8_;
	FolksIndividual* _tmp9_;
	GeeHashSet* _tmp10_;
	GeeHashSet* individual1_expected;
	GeeHashSet* _tmp11_;
	GeeHashSet* _tmp12_;
	GeeHashSet* _tmp13_;
	GeeHashSet* _tmp14_;
	GeeHashSet* _tmp15_;
	GeeHashSet* _tmp16_;
	GeeHashSet* individual2_expected;
	GeeHashSet* _tmp17_;
	GeeHashSet* _tmp18_;
	GeeHashSet* _tmp19_;
	GeeHashSet* _tmp20_;
	GeeHashSet* _tmp21_;
	GeeHashSet* set_in_use;
	GeeHashSet* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	GeeHashSet* _tmp51_;
	GeeHashSet* _tmp52_;
	GeeHashSet* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	TpTestBackend* _tmp73_;
	void* _tmp74_;
	KfTestBackend* _tmp75_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data2_->main_loop = _tmp0_;
	_tmp1_ = self->priv->_kf_backend;
	kf_test_backend_set_up (_tmp1_, "[0]\n" "protocol=travis@example.com;olivier@example.com;" "guillaume@example.com;sjoerd@example.com\n" "[1]\n" "protocol=christian@example.com;wim@example.com;" "helen@example.com;geraldine@example.com");
	_tmp2_ = self->priv->_tp_backend;
	_tmp3_ = tp_test_backend_add_account (_tmp2_, "protocol", "me@example.com", "cm", "account");
	account_handle = _tmp3_;
	_data2_->individual1 = NULL;
	_data2_->individual2 = NULL;
	_tmp4_ = folks_individual_aggregator_new ();
	_data2_->aggregator = _tmp4_;
	_tmp5_ = _data2_->aggregator;
	g_signal_connect_data (_tmp5_, "individuals-changed", (GCallback) __lambda4__folks_individual_aggregator_individuals_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp6_ = self->priv->_test_timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp6_, __lambda5__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda6__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	_tmp7_ = _data2_->main_loop;
	g_main_loop_run (_tmp7_);
	_tmp8_ = _data2_->individual1;
	g_assert (_tmp8_ != NULL);
	_tmp9_ = _data2_->individual2;
	g_assert (_tmp9_ != NULL);
	_tmp10_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	individual1_expected = _tmp10_;
	_tmp11_ = individual1_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "0");
	_tmp12_ = individual1_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "travis@example.com");
	_tmp13_ = individual1_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "olivier@example.com");
	_tmp14_ = individual1_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "guillaume@example.com");
	_tmp15_ = individual1_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "sjoerd@example.com");
	_tmp16_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	individual2_expected = _tmp16_;
	_tmp17_ = individual2_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, "1");
	_tmp18_ = individual2_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, "christian@example.com");
	_tmp19_ = individual2_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, "wim@example.com");
	_tmp20_ = individual2_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, "helen@example.com");
	_tmp21_ = individual2_expected;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, "geraldine@example.com");
	set_in_use = NULL;
	{
		FolksIndividual* _tmp22_;
		GeeSet* _tmp23_;
		GeeSet* _tmp24_;
		GeeIterator* _tmp25_ = NULL;
		GeeIterator* _p_it;
		_tmp22_ = _data2_->individual1;
		_tmp23_ = folks_individual_get_personas (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_iterable_iterator ((GeeIterable*) _tmp24_);
		_p_it = _tmp25_;
		while (TRUE) {
			GeeIterator* _tmp26_;
			gboolean _tmp27_ = FALSE;
			GeeIterator* _tmp28_;
			gpointer _tmp29_ = NULL;
			FolksPersona* p;
			gboolean _tmp30_ = FALSE;
			GeeHashSet* _tmp31_;
			gboolean _tmp37_;
			GeeHashSet* _tmp43_;
			FolksPersona* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			gboolean _tmp47_ = FALSE;
			_tmp26_ = _p_it;
			_tmp27_ = gee_iterator_next (_tmp26_);
			if (!_tmp27_) {
				break;
			}
			_tmp28_ = _p_it;
			_tmp29_ = gee_iterator_get (_tmp28_);
			p = (FolksPersona*) _tmp29_;
			_tmp31_ = set_in_use;
			if (_tmp31_ == NULL) {
				GeeHashSet* _tmp32_;
				FolksPersona* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gboolean _tmp36_ = FALSE;
				_tmp32_ = individual1_expected;
				_tmp33_ = p;
				_tmp34_ = folks_persona_get_display_id (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp32_, _tmp35_);
				_tmp30_ = _tmp36_;
			} else {
				_tmp30_ = FALSE;
			}
			_tmp37_ = _tmp30_;
			if (_tmp37_) {
				GeeHashSet* _tmp38_;
				GeeHashSet* _tmp39_;
				_tmp38_ = individual1_expected;
				_tmp39_ = _g_object_ref0 (_tmp38_);
				_g_object_unref0 (set_in_use);
				set_in_use = _tmp39_;
			} else {
				GeeHashSet* _tmp40_;
				_tmp40_ = set_in_use;
				if (_tmp40_ == NULL) {
					GeeHashSet* _tmp41_;
					GeeHashSet* _tmp42_;
					_tmp41_ = individual2_expected;
					_tmp42_ = _g_object_ref0 (_tmp41_);
					_g_object_unref0 (set_in_use);
					set_in_use = _tmp42_;
				}
			}
			_tmp43_ = set_in_use;
			_tmp44_ = p;
			_tmp45_ = folks_persona_get_display_id (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp43_, _tmp46_);
			g_assert (_tmp47_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp48_ = set_in_use;
	_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
	_tmp50_ = _tmp49_;
	g_assert (_tmp50_ == 0);
	_tmp51_ = set_in_use;
	_tmp52_ = individual1_expected;
	if (_tmp51_ == _tmp52_) {
		GeeHashSet* _tmp53_;
		GeeHashSet* _tmp54_;
		_tmp53_ = individual2_expected;
		_tmp54_ = _g_object_ref0 (_tmp53_);
		_g_object_unref0 (set_in_use);
		set_in_use = _tmp54_;
	} else {
		GeeHashSet* _tmp55_;
		GeeHashSet* _tmp56_;
		_tmp55_ = individual1_expected;
		_tmp56_ = _g_object_ref0 (_tmp55_);
		_g_object_unref0 (set_in_use);
		set_in_use = _tmp56_;
	}
	{
		FolksIndividual* _tmp57_;
		GeeSet* _tmp58_;
		GeeSet* _tmp59_;
		GeeIterator* _tmp60_ = NULL;
		GeeIterator* _p_it;
		_tmp57_ = _data2_->individual2;
		_tmp58_ = folks_individual_get_personas (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = gee_iterable_iterator ((GeeIterable*) _tmp59_);
		_p_it = _tmp60_;
		while (TRUE) {
			GeeIterator* _tmp61_;
			gboolean _tmp62_ = FALSE;
			GeeIterator* _tmp63_;
			gpointer _tmp64_ = NULL;
			FolksPersona* p;
			GeeHashSet* _tmp65_;
			FolksPersona* _tmp66_;
			const gchar* _tmp67_;
			const gchar* _tmp68_;
			gboolean _tmp69_ = FALSE;
			_tmp61_ = _p_it;
			_tmp62_ = gee_iterator_next (_tmp61_);
			if (!_tmp62_) {
				break;
			}
			_tmp63_ = _p_it;
			_tmp64_ = gee_iterator_get (_tmp63_);
			p = (FolksPersona*) _tmp64_;
			_tmp65_ = set_in_use;
			_tmp66_ = p;
			_tmp67_ = folks_persona_get_display_id (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp65_, _tmp68_);
			g_assert (_tmp69_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp70_ = set_in_use;
	_tmp71_ = gee_collection_get_size ((GeeCollection*) _tmp70_);
	_tmp72_ = _tmp71_;
	g_assert (_tmp72_ == 0);
	_tmp73_ = self->priv->_tp_backend;
	_tmp74_ = account_handle;
	tp_test_backend_remove_account (_tmp73_, _tmp74_);
	_tmp75_ = self->priv->_kf_backend;
	kf_test_backend_tear_down (_tmp75_);
	_g_object_unref0 (_data2_->aggregator);
	_data2_->aggregator = NULL;
	_g_object_unref0 (set_in_use);
	_g_object_unref0 (individual2_expected);
	_g_object_unref0 (individual1_expected);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->aggregator);
		_g_main_loop_unref0 (_data3_->main_loop);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda8_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block3Data* _data3_) {
	AggregationTests * self;
	self = _data3_->self;
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = removed;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			gboolean _tmp6_ = FALSE;
			FolksIndividual* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp15_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp7_ = i;
			_tmp8_ = folks_individual_get_is_user (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				FolksIndividual* _tmp10_;
				GeeSet* _tmp11_;
				GeeSet* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp10_ = i;
				_tmp11_ = folks_individual_get_personas (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp6_ = _tmp14_ == 9;
			} else {
				_tmp6_ = FALSE;
			}
			_tmp15_ = _tmp6_;
			if (_tmp15_) {
				FolksIndividual* _tmp16_;
				FolksIndividual* _tmp17_;
				_tmp16_ = i;
				_tmp17_ = _data3_->individual1;
				if (_tmp16_ == _tmp17_) {
					_data3_->individual1 = NULL;
				} else {
					FolksIndividual* _tmp18_;
					FolksIndividual* _tmp19_;
					_tmp18_ = i;
					_tmp19_ = _data3_->individual2;
					if (_tmp18_ == _tmp19_) {
						_data3_->individual2 = NULL;
					} else {
						FolksIndividual* _tmp20_;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						_tmp20_ = i;
						_tmp21_ = folks_individual_get_id (_tmp20_);
						_tmp22_ = _tmp21_;
						g_critical ("aggregation.vala:419: Unknown 9-persona individual: %s", _tmp22_);
						g_assert_not_reached ();
					}
				}
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp23_;
		GeeIterator* _tmp24_ = NULL;
		GeeIterator* _i_it;
		_tmp23_ = added;
		_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
		_i_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_;
			gboolean _tmp26_ = FALSE;
			GeeIterator* _tmp27_;
			gpointer _tmp28_ = NULL;
			FolksIndividual* i;
			gboolean _tmp29_ = FALSE;
			FolksIndividual* _tmp30_;
			gboolean _tmp31_;
			gboolean _tmp32_;
			gboolean _tmp38_;
			_tmp25_ = _i_it;
			_tmp26_ = gee_iterator_next (_tmp25_);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = _i_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			i = (FolksIndividual*) _tmp28_;
			_tmp30_ = i;
			_tmp31_ = folks_individual_get_is_user (_tmp30_);
			_tmp32_ = _tmp31_;
			if (!_tmp32_) {
				FolksIndividual* _tmp33_;
				GeeSet* _tmp34_;
				GeeSet* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				_tmp33_ = i;
				_tmp34_ = folks_individual_get_personas (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = gee_collection_get_size ((GeeCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp29_ = _tmp37_ == 9;
			} else {
				_tmp29_ = FALSE;
			}
			_tmp38_ = _tmp29_;
			if (_tmp38_) {
				FolksIndividual* _tmp39_;
				_tmp39_ = _data3_->individual1;
				if (_tmp39_ == NULL) {
					FolksIndividual* _tmp40_;
					_tmp40_ = i;
					_data3_->individual1 = _tmp40_;
				} else {
					FolksIndividual* _tmp41_;
					_tmp41_ = _data3_->individual2;
					if (_tmp41_ == NULL) {
						FolksIndividual* _tmp42_;
						_tmp42_ = i;
						_data3_->individual2 = _tmp42_;
					} else {
						FolksIndividual* _tmp43_;
						const gchar* _tmp44_;
						const gchar* _tmp45_;
						_tmp43_ = i;
						_tmp44_ = folks_individual_get_id (_tmp43_);
						_tmp45_ = _tmp44_;
						g_critical ("aggregation.vala:439: Unknown 9-persona individual: %s", _tmp45_);
						g_assert_not_reached ();
					}
				}
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void __lambda8__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda8_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda9_ (Block3Data* _data3_) {
	AggregationTests * self;
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->main_loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean __lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda9_ (self);
	return result;
}


static void _lambda11_ (GObject* s, GAsyncResult* r, Block3Data* _data3_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	g_return_if_fail (r != NULL);
	{
		FolksIndividualAggregator* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data3_->aggregator;
		_tmp1_ = r;
		folks_individual_aggregator_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e1 = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e1;
		_tmp3_ = _tmp2_->message;
		g_critical ("aggregation.vala:465: Failed to prepare aggregator: %s", _tmp3_);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda11_ (source_object, res, self);
	block3_data_unref (self);
}


static gboolean _lambda10_ (Block3Data* _data3_) {
	AggregationTests * self;
	gboolean result = FALSE;
	FolksIndividualAggregator* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->aggregator;
	folks_individual_aggregator_prepare (_tmp0_, __lambda11__gasync_ready_callback, block3_data_ref (_data3_));
	result = FALSE;
	return result;
}


static gboolean __lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda10_ (self);
	return result;
}


void aggregation_tests_test_linkable_properties_different_stores (AggregationTests* self) {
	Block3Data* _data3_;
	GMainLoop* _tmp0_;
	KfTestBackend* _tmp1_;
	TpTestBackend* _tmp2_;
	void* _tmp3_ = NULL;
	void* account1_handle;
	TpTestBackend* _tmp4_;
	void* _tmp5_ = NULL;
	void* account2_handle;
	FolksIndividualAggregator* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	gint _tmp8_;
	GMainLoop* _tmp9_;
	FolksIndividual* _tmp10_;
	FolksIndividual* _tmp11_;
	GeeHashSet* _tmp12_;
	GeeHashSet* expected_personas1;
	GeeHashSet* _tmp13_;
	GeeHashSet* expected_personas2;
	GeeHashSet* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	GeeHashSet* _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	TpTestBackend* _tmp76_;
	void* _tmp77_;
	TpTestBackend* _tmp78_;
	void* _tmp79_;
	KfTestBackend* _tmp80_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data3_->main_loop = _tmp0_;
	_tmp1_ = self->priv->_kf_backend;
	kf_test_backend_set_up (_tmp1_, "[0]\n" "protocol=travis@example.com;olivier@example.com;" "guillaume@example.com;sjoerd@example.com\n" "protocol2=christian@example.com;wim@example.com;" "helen@example.com;geraldine@example.com\n" "[1]\n" "protocol=christian@example.com;wim@example.com;" "helen@example.com;geraldine@example.com\n" "protocol2=travis@example.com;olivier@example.com;" "guillaume@example.com;sjoerd@example.com");
	_tmp2_ = self->priv->_tp_backend;
	_tmp3_ = tp_test_backend_add_account (_tmp2_, "protocol", "me@example.com", "cm", "account");
	account1_handle = _tmp3_;
	_tmp4_ = self->priv->_tp_backend;
	_tmp5_ = tp_test_backend_add_account (_tmp4_, "protocol2", "me@example.com", "cm", "account2");
	account2_handle = _tmp5_;
	_data3_->individual1 = NULL;
	_data3_->individual2 = NULL;
	_tmp6_ = folks_individual_aggregator_new ();
	_data3_->aggregator = _tmp6_;
	_tmp7_ = _data3_->aggregator;
	g_signal_connect_data (_tmp7_, "individuals-changed", (GCallback) __lambda8__folks_individual_aggregator_individuals_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp8_ = self->priv->_test_timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp8_, __lambda9__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda10__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	_tmp9_ = _data3_->main_loop;
	g_main_loop_run (_tmp9_);
	_tmp10_ = _data3_->individual1;
	g_assert (_tmp10_ != NULL);
	_tmp11_ = _data3_->individual2;
	g_assert (_tmp11_ != NULL);
	_tmp12_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	expected_personas1 = _tmp12_;
	_tmp13_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	expected_personas2 = _tmp13_;
	{
		GeeHashSet* _tmp14_;
		GeeIterator* _tmp15_ = NULL;
		GeeIterator* _id_it;
		_tmp14_ = self->priv->_default_personas;
		_tmp15_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp14_);
		_id_it = _tmp15_;
		while (TRUE) {
			GeeIterator* _tmp16_;
			gboolean _tmp17_ = FALSE;
			GeeIterator* _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* id;
			GeeHashSet* _tmp20_;
			const gchar* _tmp21_;
			GeeHashSet* _tmp22_;
			const gchar* _tmp23_;
			_tmp16_ = _id_it;
			_tmp17_ = gee_iterator_next (_tmp16_);
			if (!_tmp17_) {
				break;
			}
			_tmp18_ = _id_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			id = (gchar*) _tmp19_;
			_tmp20_ = expected_personas1;
			_tmp21_ = id;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
			_tmp22_ = expected_personas2;
			_tmp23_ = id;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
			_g_free0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	{
		FolksIndividual* _tmp24_;
		GeeSet* _tmp25_;
		GeeSet* _tmp26_;
		GeeIterator* _tmp27_ = NULL;
		GeeIterator* _p_it;
		_tmp24_ = _data3_->individual1;
		_tmp25_ = folks_individual_get_personas (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = gee_iterable_iterator ((GeeIterable*) _tmp26_);
		_p_it = _tmp27_;
		while (TRUE) {
			GeeIterator* _tmp28_;
			gboolean _tmp29_ = FALSE;
			GeeIterator* _tmp30_;
			gpointer _tmp31_ = NULL;
			FolksPersona* p;
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
			GeeHashSet* _tmp34_;
			FolksPersona* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gboolean _tmp38_ = FALSE;
			gboolean _tmp42_;
			gboolean _tmp46_;
			_tmp28_ = _p_it;
			_tmp29_ = gee_iterator_next (_tmp28_);
			if (!_tmp29_) {
				break;
			}
			_tmp30_ = _p_it;
			_tmp31_ = gee_iterator_get (_tmp30_);
			p = (FolksPersona*) _tmp31_;
			_tmp34_ = expected_personas1;
			_tmp35_ = p;
			_tmp36_ = folks_persona_get_display_id (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp34_, _tmp37_);
			if (_tmp38_) {
				_tmp33_ = TRUE;
			} else {
				FolksPersona* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				_tmp39_ = p;
				_tmp40_ = folks_persona_get_display_id (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp33_ = g_strcmp0 (_tmp41_, "0") == 0;
			}
			_tmp42_ = _tmp33_;
			if (_tmp42_) {
				_tmp32_ = TRUE;
			} else {
				FolksPersona* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				_tmp43_ = p;
				_tmp44_ = folks_persona_get_display_id (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp32_ = g_strcmp0 (_tmp45_, "1") == 0;
			}
			_tmp46_ = _tmp32_;
			g_assert (_tmp46_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp47_ = expected_personas1;
	_tmp48_ = gee_collection_get_size ((GeeCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	g_assert (_tmp49_ == 0);
	{
		FolksIndividual* _tmp50_;
		GeeSet* _tmp51_;
		GeeSet* _tmp52_;
		GeeIterator* _tmp53_ = NULL;
		GeeIterator* _p_it;
		_tmp50_ = _data3_->individual2;
		_tmp51_ = folks_individual_get_personas (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = gee_iterable_iterator ((GeeIterable*) _tmp52_);
		_p_it = _tmp53_;
		while (TRUE) {
			GeeIterator* _tmp54_;
			gboolean _tmp55_ = FALSE;
			GeeIterator* _tmp56_;
			gpointer _tmp57_ = NULL;
			FolksPersona* p;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			GeeHashSet* _tmp60_;
			FolksPersona* _tmp61_;
			const gchar* _tmp62_;
			const gchar* _tmp63_;
			gboolean _tmp64_ = FALSE;
			gboolean _tmp68_;
			gboolean _tmp72_;
			_tmp54_ = _p_it;
			_tmp55_ = gee_iterator_next (_tmp54_);
			if (!_tmp55_) {
				break;
			}
			_tmp56_ = _p_it;
			_tmp57_ = gee_iterator_get (_tmp56_);
			p = (FolksPersona*) _tmp57_;
			_tmp60_ = expected_personas2;
			_tmp61_ = p;
			_tmp62_ = folks_persona_get_display_id (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp60_, _tmp63_);
			if (_tmp64_) {
				_tmp59_ = TRUE;
			} else {
				FolksPersona* _tmp65_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				_tmp65_ = p;
				_tmp66_ = folks_persona_get_display_id (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp59_ = g_strcmp0 (_tmp67_, "0") == 0;
			}
			_tmp68_ = _tmp59_;
			if (_tmp68_) {
				_tmp58_ = TRUE;
			} else {
				FolksPersona* _tmp69_;
				const gchar* _tmp70_;
				const gchar* _tmp71_;
				_tmp69_ = p;
				_tmp70_ = folks_persona_get_display_id (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = g_strcmp0 (_tmp71_, "1") == 0;
			}
			_tmp72_ = _tmp58_;
			g_assert (_tmp72_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp73_ = expected_personas2;
	_tmp74_ = gee_collection_get_size ((GeeCollection*) _tmp73_);
	_tmp75_ = _tmp74_;
	g_assert (_tmp75_ == 0);
	_tmp76_ = self->priv->_tp_backend;
	_tmp77_ = account2_handle;
	tp_test_backend_remove_account (_tmp76_, _tmp77_);
	_tmp78_ = self->priv->_tp_backend;
	_tmp79_ = account1_handle;
	tp_test_backend_remove_account (_tmp78_, _tmp79_);
	_tmp80_ = self->priv->_kf_backend;
	kf_test_backend_tear_down (_tmp80_);
	_g_object_unref0 (_data3_->aggregator);
	_data3_->aggregator = NULL;
	_g_object_unref0 (expected_personas2);
	_g_object_unref0 (expected_personas1);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_object_unref0 (_data4_->aggregator);
		_g_object_unref0 (_data4_->user_individual);
		_g_main_loop_unref0 (_data4_->main_loop);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda12_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block4Data* _data4_) {
	AggregationTests * self;
	self = _data4_->self;
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = removed;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp6_ = i;
			_tmp7_ = folks_individual_get_is_user (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				FolksIndividual* _tmp9_;
				FolksIndividual* _tmp10_;
				_tmp9_ = _data4_->user_individual;
				_tmp10_ = i;
				g_assert (_tmp9_ == _tmp10_);
				_g_object_unref0 (_data4_->user_individual);
				_data4_->user_individual = NULL;
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp11_;
		GeeIterator* _tmp12_ = NULL;
		GeeIterator* _i_it;
		_tmp11_ = added;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_i_it = _tmp12_;
		while (TRUE) {
			GeeIterator* _tmp13_;
			gboolean _tmp14_ = FALSE;
			GeeIterator* _tmp15_;
			gpointer _tmp16_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp13_ = _i_it;
			_tmp14_ = gee_iterator_next (_tmp13_);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = _i_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			i = (FolksIndividual*) _tmp16_;
			_tmp17_ = i;
			_tmp18_ = folks_individual_get_is_user (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_) {
				FolksIndividual* _tmp20_;
				FolksIndividual* _tmp21_;
				FolksIndividual* _tmp22_;
				_tmp20_ = _data4_->user_individual;
				g_assert (_tmp20_ == NULL);
				_tmp21_ = i;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_g_object_unref0 (_data4_->user_individual);
				_data4_->user_individual = _tmp22_;
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void __lambda12__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda12_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda13_ (Block4Data* _data4_) {
	AggregationTests * self;
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->main_loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean __lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda13_ (self);
	return result;
}


static void _lambda15_ (GObject* s, GAsyncResult* r, Block4Data* _data4_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	g_return_if_fail (r != NULL);
	{
		FolksIndividualAggregator* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data4_->aggregator;
		_tmp1_ = r;
		folks_individual_aggregator_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e1 = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e1;
		_tmp3_ = _tmp2_->message;
		g_critical ("aggregation.vala:573: Failed to prepare aggregator: %s", _tmp3_);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda15_ (source_object, res, self);
	block4_data_unref (self);
}


static gboolean _lambda14_ (Block4Data* _data4_) {
	AggregationTests * self;
	gboolean result = FALSE;
	FolksIndividualAggregator* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->aggregator;
	folks_individual_aggregator_prepare (_tmp0_, __lambda15__gasync_ready_callback, block4_data_ref (_data4_));
	result = FALSE;
	return result;
}


static gboolean __lambda14__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda14_ (self);
	return result;
}


void aggregation_tests_test_user (AggregationTests* self) {
	Block4Data* _data4_;
	GMainLoop* _tmp0_;
	KfTestBackend* _tmp1_;
	TpTestBackend* _tmp2_;
	void* _tmp3_ = NULL;
	void* account1_handle;
	TpTestBackend* _tmp4_;
	void* _tmp5_ = NULL;
	void* account2_handle;
	FolksIndividualAggregator* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	gint _tmp8_;
	GMainLoop* _tmp9_;
	FolksIndividualAggregator* _tmp10_;
	FolksIndividual* _tmp11_;
	FolksIndividual* _tmp12_;
	FolksIndividual* _tmp13_;
	FolksIndividual* _tmp14_;
	GeeSet* _tmp15_;
	GeeSet* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GeeHashSet* _tmp19_;
	GeeHashSet* display_ids;
	gboolean _tmp32_ = FALSE;
	GeeHashSet* _tmp33_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp37_;
	TpTestBackend* _tmp38_;
	void* _tmp39_;
	TpTestBackend* _tmp40_;
	void* _tmp41_;
	KfTestBackend* _tmp42_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data4_->main_loop = _tmp0_;
	_tmp1_ = self->priv->_kf_backend;
	kf_test_backend_set_up (_tmp1_, "");
	_tmp2_ = self->priv->_tp_backend;
	_tmp3_ = tp_test_backend_add_account (_tmp2_, "protocol", "me@example.com", "cm", "account");
	account1_handle = _tmp3_;
	_tmp4_ = self->priv->_tp_backend;
	_tmp5_ = tp_test_backend_add_account (_tmp4_, "protocol", "me2@example.com", "cm", "account2");
	account2_handle = _tmp5_;
	_data4_->user_individual = NULL;
	_tmp6_ = folks_individual_aggregator_new ();
	_data4_->aggregator = _tmp6_;
	_tmp7_ = _data4_->aggregator;
	g_signal_connect_data (_tmp7_, "individuals-changed", (GCallback) __lambda12__folks_individual_aggregator_individuals_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp8_ = self->priv->_test_timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp8_, __lambda13__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda14__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	_tmp9_ = _data4_->main_loop;
	g_main_loop_run (_tmp9_);
	_tmp10_ = _data4_->aggregator;
	_tmp11_ = folks_individual_aggregator_get_user (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _data4_->user_individual;
	g_assert (_tmp12_ == _tmp13_);
	_tmp14_ = _data4_->user_individual;
	_tmp15_ = folks_individual_get_personas (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	g_assert (_tmp18_ == 2);
	_tmp19_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	display_ids = _tmp19_;
	{
		FolksIndividual* _tmp20_;
		GeeSet* _tmp21_;
		GeeSet* _tmp22_;
		GeeIterator* _tmp23_ = NULL;
		GeeIterator* _persona_it;
		_tmp20_ = _data4_->user_individual;
		_tmp21_ = folks_individual_get_personas (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
		_persona_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			gboolean _tmp25_ = FALSE;
			GeeIterator* _tmp26_;
			gpointer _tmp27_ = NULL;
			FolksPersona* persona;
			GeeHashSet* _tmp28_;
			FolksPersona* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp24_ = _persona_it;
			_tmp25_ = gee_iterator_next (_tmp24_);
			if (!_tmp25_) {
				break;
			}
			_tmp26_ = _persona_it;
			_tmp27_ = gee_iterator_get (_tmp26_);
			persona = (FolksPersona*) _tmp27_;
			_tmp28_ = display_ids;
			_tmp29_ = persona;
			_tmp30_ = folks_persona_get_display_id (_tmp29_);
			_tmp31_ = _tmp30_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp31_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp33_ = display_ids;
	_tmp34_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp33_, "me@example.com");
	if (_tmp34_) {
		GeeHashSet* _tmp35_;
		gboolean _tmp36_ = FALSE;
		_tmp35_ = display_ids;
		_tmp36_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp35_, "me2@example.com");
		_tmp32_ = _tmp36_;
	} else {
		_tmp32_ = FALSE;
	}
	_tmp37_ = _tmp32_;
	g_assert (_tmp37_);
	_tmp38_ = self->priv->_tp_backend;
	_tmp39_ = account2_handle;
	tp_test_backend_remove_account (_tmp38_, _tmp39_);
	_tmp40_ = self->priv->_tp_backend;
	_tmp41_ = account1_handle;
	tp_test_backend_remove_account (_tmp40_, _tmp41_);
	_tmp42_ = self->priv->_kf_backend;
	kf_test_backend_tear_down (_tmp42_);
	_g_object_unref0 (_data4_->aggregator);
	_data4_->aggregator = NULL;
	_g_object_unref0 (display_ids);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->aggregator);
		_g_main_loop_unref0 (_data5_->main_loop);
		g_slice_free (Block5Data, _data5_);
	}
}


static void _lambda16_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, AggregationTests* self) {
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = removed;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			gboolean _tmp6_ = FALSE;
			FolksIndividual* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp15_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp7_ = i;
			_tmp8_ = folks_individual_get_is_user (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				_tmp6_ = TRUE;
			} else {
				FolksIndividual* _tmp10_;
				GeeSet* _tmp11_;
				GeeSet* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				_tmp10_ = i;
				_tmp11_ = folks_individual_get_personas (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp6_ = _tmp14_ == 1;
			}
			_tmp15_ = _tmp6_;
			g_assert (_tmp15_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp16_;
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _i_it;
		_tmp16_ = added;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_i_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			FolksIndividual* i;
			gboolean _tmp22_ = FALSE;
			FolksIndividual* _tmp23_;
			gboolean _tmp24_;
			gboolean _tmp25_;
			gboolean _tmp31_;
			_tmp18_ = _i_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _i_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			i = (FolksIndividual*) _tmp21_;
			_tmp23_ = i;
			_tmp24_ = folks_individual_get_is_user (_tmp23_);
			_tmp25_ = _tmp24_;
			if (_tmp25_) {
				_tmp22_ = TRUE;
			} else {
				FolksIndividual* _tmp26_;
				GeeSet* _tmp27_;
				GeeSet* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				_tmp26_ = i;
				_tmp27_ = folks_individual_get_personas (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp22_ = _tmp30_ == 1;
			}
			_tmp31_ = _tmp22_;
			g_assert (_tmp31_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void __lambda16__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda16_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda17_ (Block5Data* _data5_) {
	AggregationTests * self;
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->main_loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean __lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda17_ (self);
	return result;
}


static void _lambda19_ (GObject* s, GAsyncResult* r, Block5Data* _data5_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	g_return_if_fail (r != NULL);
	{
		FolksIndividualAggregator* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data5_->aggregator;
		_tmp1_ = r;
		folks_individual_aggregator_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e1 = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e1;
		_tmp3_ = _tmp2_->message;
		g_critical ("aggregation.vala:657: Failed to prepare aggregator: %s", _tmp3_);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda19_ (source_object, res, self);
	block5_data_unref (self);
}


static gboolean _lambda18_ (Block5Data* _data5_) {
	AggregationTests * self;
	gboolean result = FALSE;
	FolksIndividualAggregator* _tmp0_;
	self = _data5_->self;
	_tmp0_ = _data5_->aggregator;
	folks_individual_aggregator_prepare (_tmp0_, __lambda19__gasync_ready_callback, block5_data_ref (_data5_));
	result = FALSE;
	return result;
}


static gboolean __lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda18_ (self);
	return result;
}


void aggregation_tests_test_untrusted_store (AggregationTests* self) {
	Block5Data* _data5_;
	GMainLoop* _tmp0_;
	KfTestBackend* _tmp1_;
	TpTestBackend* _tmp2_;
	void* _tmp3_ = NULL;
	void* account1_handle;
	TpTestBackend* _tmp4_;
	void* _tmp5_ = NULL;
	void* account2_handle;
	FolksIndividualAggregator* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	gint _tmp8_;
	GMainLoop* _tmp9_;
	TpTestBackend* _tmp10_;
	void* _tmp11_;
	TpTestBackend* _tmp12_;
	void* _tmp13_;
	KfTestBackend* _tmp14_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data5_->main_loop = _tmp0_;
	_tmp1_ = self->priv->_kf_backend;
	kf_test_backend_set_up (_tmp1_, "");
	_tmp2_ = self->priv->_tp_backend;
	_tmp3_ = tp_test_backend_add_account (_tmp2_, "irc", "me@example.com", "cm", "account");
	account1_handle = _tmp3_;
	_tmp4_ = self->priv->_tp_backend;
	_tmp5_ = tp_test_backend_add_account (_tmp4_, "irc", "me2@example.com", "cm", "account2");
	account2_handle = _tmp5_;
	_tmp6_ = folks_individual_aggregator_new ();
	_data5_->aggregator = _tmp6_;
	_tmp7_ = _data5_->aggregator;
	g_signal_connect_object (_tmp7_, "individuals-changed", (GCallback) __lambda16__folks_individual_aggregator_individuals_changed, self, 0);
	_tmp8_ = self->priv->_test_timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp8_, __lambda17__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda18__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	_tmp9_ = _data5_->main_loop;
	g_main_loop_run (_tmp9_);
	_tmp10_ = self->priv->_tp_backend;
	_tmp11_ = account2_handle;
	tp_test_backend_remove_account (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->_tp_backend;
	_tmp13_ = account1_handle;
	tp_test_backend_remove_account (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->_kf_backend;
	kf_test_backend_tear_down (_tmp14_);
	_g_object_unref0 (_data5_->aggregator);
	_data5_->aggregator = NULL;
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->aggregator);
		_g_object_unref0 (_data6_->individuals_map);
		_g_main_loop_unref0 (_data6_->main_loop);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _lambda21_ (Block6Data* _data6_, GObject* obj) {
	AggregationTests * self;
	GObject* _tmp0_;
	FolksIndividual* ind;
	GeeHashMap* _tmp1_;
	FolksIndividual* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp4_;
	FolksIndividual* _tmp5_;
	gpointer _tmp6_ = NULL;
	AggregationTestsIndividualState state;
	gboolean _tmp7_ = FALSE;
	AggregationTestsIndividualState _tmp8_;
	gboolean _tmp13_;
	GeeHashMap* _tmp14_;
	FolksIndividual* _tmp15_;
	self = _data6_->self;
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	ind = FOLKS_INDIVIDUAL (_tmp0_);
	_tmp1_ = _data6_->individuals_map;
	_tmp2_ = ind;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
	g_assert (_tmp3_ == TRUE);
	_tmp4_ = _data6_->individuals_map;
	_tmp5_ = ind;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
	state = GPOINTER_TO_INT (_tmp6_);
	_tmp8_ = state;
	if (_tmp8_ == AGGREGATION_TESTS_INDIVIDUAL_STATE_REMOVED) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		gboolean _tmp12_;
		_tmp10_ = _data6_->aggregator_is_finalising;
		if (_tmp10_ == TRUE) {
			AggregationTestsIndividualState _tmp11_;
			_tmp11_ = state;
			_tmp9_ = _tmp11_ == AGGREGATION_TESTS_INDIVIDUAL_STATE_ADDED;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp12_ = _tmp9_;
		_tmp7_ = _tmp12_;
	}
	_tmp13_ = _tmp7_;
	g_assert (_tmp13_);
	_tmp14_ = _data6_->individuals_map;
	_tmp15_ = ind;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp15_, GINT_TO_POINTER (AGGREGATION_TESTS_INDIVIDUAL_STATE_FINALISED));
}


static void __lambda21__gweak_notify (gpointer self, GObject* object) {
	_lambda21_ (self, object);
}


static void _lambda20_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block6Data* _data6_) {
	AggregationTests * self;
	self = _data6_->self;
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = removed;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			GeeHashMap* _tmp6_;
			FolksIndividual* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeHashMap* _tmp9_;
			FolksIndividual* _tmp10_;
			gpointer _tmp11_ = NULL;
			GeeHashMap* _tmp12_;
			FolksIndividual* _tmp13_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp6_ = _data6_->individuals_map;
			_tmp7_ = i;
			_tmp8_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _tmp7_);
			g_assert (_tmp8_ == TRUE);
			_tmp9_ = _data6_->individuals_map;
			_tmp10_ = i;
			_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
			g_assert (GPOINTER_TO_INT (_tmp11_) == AGGREGATION_TESTS_INDIVIDUAL_STATE_ADDED);
			_tmp12_ = _data6_->individuals_map;
			_tmp13_ = i;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp13_, GINT_TO_POINTER (AGGREGATION_TESTS_INDIVIDUAL_STATE_REMOVED));
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	{
		GeeSet* _tmp14_;
		GeeIterator* _tmp15_ = NULL;
		GeeIterator* _i_it;
		_tmp14_ = added;
		_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
		_i_it = _tmp15_;
		while (TRUE) {
			GeeIterator* _tmp16_;
			gboolean _tmp17_ = FALSE;
			GeeIterator* _tmp18_;
			gpointer _tmp19_ = NULL;
			FolksIndividual* i;
			GeeHashMap* _tmp20_;
			FolksIndividual* _tmp21_;
			gboolean _tmp22_ = FALSE;
			GeeHashMap* _tmp23_;
			FolksIndividual* _tmp24_;
			FolksIndividual* _tmp25_;
			_tmp16_ = _i_it;
			_tmp17_ = gee_iterator_next (_tmp16_);
			if (!_tmp17_) {
				break;
			}
			_tmp18_ = _i_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			i = (FolksIndividual*) _tmp19_;
			_tmp20_ = _data6_->individuals_map;
			_tmp21_ = i;
			_tmp22_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp20_, _tmp21_);
			g_assert (_tmp22_ == FALSE);
			_tmp23_ = _data6_->individuals_map;
			_tmp24_ = i;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, GINT_TO_POINTER (AGGREGATION_TESTS_INDIVIDUAL_STATE_ADDED));
			_tmp25_ = i;
			g_object_weak_ref ((GObject*) _tmp25_, __lambda21__gweak_notify, _data6_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
}


static void __lambda20__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda20_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda22_ (Block6Data* _data6_) {
	AggregationTests * self;
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	self = _data6_->self;
	_tmp0_ = _data6_->main_loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean __lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda22_ (self);
	return result;
}


static void _lambda24_ (GObject* s, GAsyncResult* r, Block6Data* _data6_) {
	AggregationTests * self;
	GError * _inner_error_ = NULL;
	self = _data6_->self;
	g_return_if_fail (r != NULL);
	{
		FolksIndividualAggregator* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data6_->aggregator;
		_tmp1_ = r;
		folks_individual_aggregator_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e1 = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e1;
		_tmp3_ = _tmp2_->message;
		g_critical ("aggregation.vala:772: Failed to prepare aggregator: %s", _tmp3_);
		g_assert_not_reached ();
		_g_error_free0 (e1);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda24_ (source_object, res, self);
	block6_data_unref (self);
}


static gboolean _lambda23_ (Block6Data* _data6_) {
	AggregationTests * self;
	gboolean result = FALSE;
	FolksIndividualAggregator* _tmp0_;
	self = _data6_->self;
	_tmp0_ = _data6_->aggregator;
	folks_individual_aggregator_prepare (_tmp0_, __lambda24__gasync_ready_callback, block6_data_ref (_data6_));
	result = FALSE;
	return result;
}


static gboolean __lambda23__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda23_ (self);
	return result;
}


static gboolean _lambda25_ (Block6Data* _data6_) {
	AggregationTests * self;
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	self = _data6_->self;
	_tmp0_ = _data6_->main_loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean __lambda25__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda25_ (self);
	return result;
}


void aggregation_tests_test_linked_individual_refcounting (AggregationTests* self) {
	Block6Data* _data6_;
	GMainLoop* _tmp0_;
	KfTestBackend* _tmp1_;
	TpTestBackend* _tmp2_;
	void* _tmp3_ = NULL;
	void* account_handle;
	GeeHashMap* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	FolksIndividualAggregator* _tmp6_;
	gint _tmp7_;
	GMainLoop* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeMapIterator* _tmp10_ = NULL;
	GeeMapIterator* iter;
	TpTestBackend* _tmp19_;
	void* _tmp20_;
	KfTestBackend* _tmp21_;
	gint _tmp22_;
	GMainLoop* _tmp23_;
	GeeHashMap* _tmp24_;
	GeeMapIterator* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data6_->main_loop = _tmp0_;
	_tmp1_ = self->priv->_kf_backend;
	kf_test_backend_set_up (_tmp1_, "[0]\n" "protocol=travis@example.com;olivier@example.com;" "guillaume@example.com;sjoerd@example.com\n" "[1]\n" "protocol=christian@example.com;wim@example.com;" "helen@example.com;geraldine@example.com");
	_tmp2_ = self->priv->_tp_backend;
	_tmp3_ = tp_test_backend_add_account (_tmp2_, "protocol", "me@example.com", "cm", "account");
	account_handle = _tmp3_;
	_tmp4_ = gee_hash_map_new (FOLKS_TYPE_INDIVIDUAL, NULL, NULL, AGGREGATION_TESTS_TYPE_INDIVIDUAL_STATE, NULL, NULL, NULL, NULL, NULL);
	_data6_->individuals_map = _tmp4_;
	_tmp5_ = folks_individual_aggregator_new ();
	_data6_->aggregator = _tmp5_;
	_data6_->aggregator_is_finalising = FALSE;
	_tmp6_ = _data6_->aggregator;
	g_signal_connect_data (_tmp6_, "individuals-changed", (GCallback) __lambda20__folks_individual_aggregator_individuals_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp7_ = self->priv->_test_timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp7_, __lambda22__gsource_func, block6_data_ref (_data6_), block6_data_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda23__gsource_func, block6_data_ref (_data6_), block6_data_unref);
	_tmp8_ = _data6_->main_loop;
	g_main_loop_run (_tmp8_);
	_tmp9_ = _data6_->individuals_map;
	_tmp10_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp9_);
	iter = _tmp10_;
	while (TRUE) {
		GeeMapIterator* _tmp11_;
		gboolean _tmp12_ = FALSE;
		GeeMapIterator* _tmp13_;
		gpointer _tmp14_ = NULL;
		AggregationTestsIndividualState state;
		gboolean _tmp15_ = FALSE;
		AggregationTestsIndividualState _tmp16_;
		gboolean _tmp18_;
		_tmp11_ = iter;
		_tmp12_ = gee_map_iterator_next (_tmp11_);
		if (!(_tmp12_ == TRUE)) {
			break;
		}
		_tmp13_ = iter;
		_tmp14_ = gee_map_iterator_get_value (_tmp13_);
		state = GPOINTER_TO_INT (_tmp14_);
		_tmp16_ = state;
		if (_tmp16_ == AGGREGATION_TESTS_INDIVIDUAL_STATE_ADDED) {
			_tmp15_ = TRUE;
		} else {
			AggregationTestsIndividualState _tmp17_;
			_tmp17_ = state;
			_tmp15_ = _tmp17_ == AGGREGATION_TESTS_INDIVIDUAL_STATE_FINALISED;
		}
		_tmp18_ = _tmp15_;
		g_assert (_tmp18_);
	}
	_tmp19_ = self->priv->_tp_backend;
	_tmp20_ = account_handle;
	tp_test_backend_remove_account (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->_kf_backend;
	kf_test_backend_tear_down (_tmp21_);
	_data6_->aggregator_is_finalising = TRUE;
	_g_object_unref0 (_data6_->aggregator);
	_data6_->aggregator = NULL;
	_tmp22_ = self->priv->_test_timeout;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp22_, __lambda25__gsource_func, block6_data_ref (_data6_), block6_data_unref);
	_tmp23_ = _data6_->main_loop;
	g_main_loop_run (_tmp23_);
	_tmp24_ = _data6_->individuals_map;
	_tmp25_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp24_);
	_g_object_unref0 (iter);
	iter = _tmp25_;
	while (TRUE) {
		GeeMapIterator* _tmp26_;
		gboolean _tmp27_ = FALSE;
		GeeMapIterator* _tmp28_;
		gpointer _tmp29_ = NULL;
		_tmp26_ = iter;
		_tmp27_ = gee_map_iterator_next (_tmp26_);
		if (!(_tmp27_ == TRUE)) {
			break;
		}
		_tmp28_ = iter;
		_tmp29_ = gee_map_iterator_get_value (_tmp28_);
		g_assert (GPOINTER_TO_INT (_tmp29_) == AGGREGATION_TESTS_INDIVIDUAL_STATE_FINALISED);
	}
	_g_object_unref0 (iter);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void aggregation_tests_class_init (AggregationTestsClass * klass) {
	aggregation_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AggregationTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = aggregation_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = aggregation_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = aggregation_tests_finalize;
}


static void aggregation_tests_instance_init (AggregationTests * self) {
	self->priv = AGGREGATION_TESTS_GET_PRIVATE (self);
	self->priv->_test_timeout = 3;
}


static void aggregation_tests_finalize (GObject* obj) {
	AggregationTests * self;
	self = AGGREGATION_TESTS (obj);
	_kf_test_backend_unref0 (self->priv->_kf_backend);
	_g_object_unref0 (self->priv->_tp_backend);
	_g_object_unref0 (self->priv->_default_personas);
	G_OBJECT_CLASS (aggregation_tests_parent_class)->finalize (obj);
}


GType aggregation_tests_get_type (void) {
	static volatile gsize aggregation_tests_type_id__volatile = 0;
	if (g_once_init_enter (&aggregation_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AggregationTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aggregation_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AggregationTests), 0, (GInstanceInitFunc) aggregation_tests_instance_init, NULL };
		GType aggregation_tests_type_id;
		aggregation_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AggregationTests", &g_define_type_info, 0);
		g_once_init_leave (&aggregation_tests_type_id__volatile, aggregation_tests_type_id);
	}
	return aggregation_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	GTestSuite* _tmp1_;
	AggregationTests* _tmp2_;
	AggregationTests* _tmp3_;
	GTestSuite* _tmp4_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = root;
	_tmp2_ = aggregation_tests_new ();
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_test_case_get_suite ((FolksTestCase*) _tmp3_);
	g_test_suite_add_suite (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp3_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



