/* im-details.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from im-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;
typedef struct _FolksAbstractFieldDetailsPrivate FolksAbstractFieldDetailsPrivate;

#define FOLKS_TYPE_IM_FIELD_DETAILS (folks_im_field_details_get_type ())
#define FOLKS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetails))
#define FOLKS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))
#define FOLKS_IS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IM_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))

typedef struct _FolksImFieldDetails FolksImFieldDetails;
typedef struct _FolksImFieldDetailsClass FolksImFieldDetailsClass;
typedef struct _FolksImFieldDetailsPrivate FolksImFieldDetailsPrivate;

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

/**
 * Errors related to IM addresses and IM address handling.
 */
typedef enum  {
	FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS
} FolksImDetailsError;
#define FOLKS_IM_DETAILS_ERROR folks_im_details_error_quark ()
struct _FolksAbstractFieldDetails {
	GObject parent_instance;
	FolksAbstractFieldDetailsPrivate * priv;
};

struct _FolksAbstractFieldDetailsClass {
	GObjectClass parent_class;
	gboolean (*equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	guint (*hash) (FolksAbstractFieldDetails* self);
	gconstpointer (*get_value) (FolksAbstractFieldDetails* self);
	void (*set_value) (FolksAbstractFieldDetails* self, gconstpointer value);
	GeeMultiMap* (*get_parameters) (FolksAbstractFieldDetails* self);
	void (*set_parameters) (FolksAbstractFieldDetails* self, GeeMultiMap* value);
};

struct _FolksImFieldDetails {
	FolksAbstractFieldDetails parent_instance;
	FolksImFieldDetailsPrivate * priv;
};

struct _FolksImFieldDetailsClass {
	FolksAbstractFieldDetailsClass parent_class;
};

struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};


static gpointer folks_im_field_details_parent_class = NULL;

GQuark folks_im_details_error_quark (void);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_im_field_details_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_IM_FIELD_DETAILS_DUMMY_PROPERTY
};
FolksImFieldDetails* folks_im_field_details_new (const gchar* value, GeeMultiMap* parameters);
FolksImFieldDetails* folks_im_field_details_construct (GType object_type, const gchar* value, GeeMultiMap* parameters);
FolksAbstractFieldDetails* folks_abstract_field_details_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
void folks_abstract_field_details_set_value (FolksAbstractFieldDetails* self, gconstpointer value);
void folks_abstract_field_details_set_parameters (FolksAbstractFieldDetails* self, GeeMultiMap* value);
static gboolean folks_im_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that);
gboolean folks_abstract_field_details_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
static guint folks_im_field_details_real_hash (FolksAbstractFieldDetails* base);
guint folks_abstract_field_details_hash (FolksAbstractFieldDetails* self);
GType folks_im_details_get_type (void) G_GNUC_CONST;
gchar* folks_im_details_normalise_im_address (const gchar* im_address, const gchar* protocol, GError** error);
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
void folks_im_details_set_im_addresses (FolksImDetails* self, GeeMultiMap* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark folks_im_details_error_quark (void) {
	return g_quark_from_static_string ("folks_im_details_error-quark");
}


/**
   * Create a new ImFieldDetails.
   *
   * @param value the value of the field
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A `null` value is equivalent to an
   * empty map of parameters.
   *
   * @return a new ImFieldDetails
   *
   * @since 0.6.0
   */
FolksImFieldDetails* folks_im_field_details_construct (GType object_type, const gchar* value, GeeMultiMap* parameters) {
	FolksImFieldDetails * self = NULL;
	const gchar* _tmp0_;
	GeeMultiMap* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	self = (FolksImFieldDetails*) folks_abstract_field_details_construct (object_type, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free);
	_tmp0_ = value;
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) self, _tmp0_);
	_tmp1_ = parameters;
	if (_tmp1_ != NULL) {
		GeeMultiMap* _tmp2_;
		_tmp2_ = parameters;
		folks_abstract_field_details_set_parameters ((FolksAbstractFieldDetails*) self, _tmp2_);
	}
	return self;
}


FolksImFieldDetails* folks_im_field_details_new (const gchar* value, GeeMultiMap* parameters) {
	return folks_im_field_details_construct (FOLKS_TYPE_IM_FIELD_DETAILS, value, parameters);
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean folks_im_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that) {
	FolksImFieldDetails * self;
	gboolean result = FALSE;
	FolksAbstractFieldDetails* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (FolksImFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	_tmp1_ = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_im_field_details_parent_class)->equal (FOLKS_ABSTRACT_FIELD_DETAILS (self), _tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint folks_im_field_details_real_hash (FolksAbstractFieldDetails* base) {
	FolksImFieldDetails * self;
	guint result = 0U;
	guint _tmp0_ = 0U;
	self = (FolksImFieldDetails*) base;
	_tmp0_ = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_im_field_details_parent_class)->hash (FOLKS_ABSTRACT_FIELD_DETAILS (self));
	result = _tmp0_;
	return result;
}


static void folks_im_field_details_class_init (FolksImFieldDetailsClass * klass) {
	folks_im_field_details_parent_class = g_type_class_peek_parent (klass);
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->equal = folks_im_field_details_real_equal;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->hash = folks_im_field_details_real_hash;
}


static void folks_im_field_details_instance_init (FolksImFieldDetails * self) {
}


/**
 * Object representing an IM address value that can have some parameters
 * associated with it.
 *
 * See {@link Folks.AbstractFieldDetails}.
 *
 * @since 0.6.0
 */
GType folks_im_field_details_get_type (void) {
	static volatile gsize folks_im_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_im_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_im_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksImFieldDetails), 0, (GInstanceInitFunc) folks_im_field_details_instance_init, NULL };
		GType folks_im_field_details_type_id;
		folks_im_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksImFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_im_field_details_type_id__volatile, folks_im_field_details_type_id);
	}
	return folks_im_field_details_type_id__volatile;
}


/**
   * Normalise an IM address so that it's suitable for string comparison.
   *
   * IM addresses for various protocols can be represented in different ways,
   * only one of which is canonical. In order to allow simple string comparisons
   * of IM addresses to work, the IM addresses must be normalised beforehand.
   *
   * If the provided IM address is invalid,
   * {@link Folks.ImDetailsError.INVALID_IM_ADDRESS} will be thrown. Note that
   * this isn't guaranteed to be thrown for all invalid addresses, but if it is
   * thrown, the address is guaranteed to be invalid.
   *
   * @param im_address the address to normalise
   * @param protocol the protocol of this im_address
   *
   * @since 0.2.0
   * @throws Folks.ImDetailsError if the provided IM address was invalid
   */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* folks_im_details_normalise_im_address (const gchar* im_address, const gchar* protocol, GError** error) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp1_ = protocol;
	if (g_strcmp0 (_tmp1_, "aim") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = protocol;
		_tmp0_ = g_strcmp0 (_tmp2_, "myspace") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp4_ = im_address;
		_tmp5_ = string_replace (_tmp4_, " ", "");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) (-1));
		_tmp8_ = _tmp7_;
		_tmp9_ = g_utf8_normalize (_tmp8_, (gssize) (-1), G_NORMALIZE_DEFAULT);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		result = _tmp10_;
		return result;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gboolean _tmp16_;
		gboolean _tmp18_;
		gboolean _tmp20_;
		_tmp14_ = protocol;
		if (g_strcmp0 (_tmp14_, "irc") == 0) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = protocol;
			_tmp13_ = g_strcmp0 (_tmp15_, "yahoo") == 0;
		}
		_tmp16_ = _tmp13_;
		if (_tmp16_) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp17_;
			_tmp17_ = protocol;
			_tmp12_ = g_strcmp0 (_tmp17_, "yahoojp") == 0;
		}
		_tmp18_ = _tmp12_;
		if (_tmp18_) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp19_;
			_tmp19_ = protocol;
			_tmp11_ = g_strcmp0 (_tmp19_, "groupwise") == 0;
		}
		_tmp20_ = _tmp11_;
		if (_tmp20_) {
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			_tmp21_ = im_address;
			_tmp22_ = g_utf8_strdown (_tmp21_, (gssize) (-1));
			_tmp23_ = _tmp22_;
			_tmp24_ = g_utf8_normalize (_tmp23_, (gssize) (-1), G_NORMALIZE_DEFAULT);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			result = _tmp25_;
			return result;
		} else {
			const gchar* _tmp26_;
			_tmp26_ = protocol;
			if (g_strcmp0 (_tmp26_, "jabber") == 0) {
				const gchar* _tmp27_;
				gchar** _tmp28_;
				gchar** _tmp29_ = NULL;
				gchar** parts;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp30_;
				gint _tmp30__length1;
				gchar* resource;
				gchar** _tmp34_;
				gint _tmp34__length1;
				gchar** _tmp38_;
				gint _tmp38__length1;
				const gchar* _tmp39_;
				gchar** _tmp40_;
				gchar** _tmp41_ = NULL;
				gchar** _tmp42_;
				gint _tmp42__length1;
				gchar* node = NULL;
				gchar* domain = NULL;
				gchar** _tmp46_;
				gint _tmp46__length1;
				gboolean _tmp56_ = FALSE;
				gboolean _tmp57_ = FALSE;
				gboolean _tmp58_ = FALSE;
				const gchar* _tmp59_;
				gboolean _tmp61_;
				gboolean _tmp66_;
				gboolean _tmp71_;
				const gchar* _tmp75_;
				gchar* _tmp76_ = NULL;
				const gchar* _tmp77_;
				gchar* normalised;
				gboolean _tmp80_ = FALSE;
				const gchar* _tmp81_;
				gboolean _tmp83_;
				const gchar* _tmp99_;
				gchar* _tmp100_ = NULL;
				_tmp27_ = im_address;
				_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "/", 2);
				parts = _tmp29_;
				parts_length1 = _vala_array_length (_tmp28_);
				_parts_size_ = parts_length1;
				_tmp30_ = parts;
				_tmp30__length1 = parts_length1;
				if (_tmp30__length1 < 1) {
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_;
					GError* _tmp33_;
					_tmp31_ = _ ("The IM address '%s' could not be understood.");
					_tmp32_ = im_address;
					_tmp33_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _tmp31_, _tmp32_);
					_inner_error_ = _tmp33_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				resource = NULL;
				_tmp34_ = parts;
				_tmp34__length1 = parts_length1;
				if (_tmp34__length1 == 2) {
					gchar** _tmp35_;
					gint _tmp35__length1;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp35_ = parts;
					_tmp35__length1 = parts_length1;
					_tmp36_ = _tmp35_[1];
					_tmp37_ = g_strdup (_tmp36_);
					_g_free0 (resource);
					resource = _tmp37_;
				}
				_tmp38_ = parts;
				_tmp38__length1 = parts_length1;
				_tmp39_ = _tmp38_[0];
				_tmp41_ = _tmp40_ = g_strsplit (_tmp39_, "@", 2);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				parts = _tmp41_;
				parts_length1 = _vala_array_length (_tmp40_);
				_parts_size_ = parts_length1;
				_tmp42_ = parts;
				_tmp42__length1 = parts_length1;
				if (_tmp42__length1 < 1) {
					const gchar* _tmp43_ = NULL;
					const gchar* _tmp44_;
					GError* _tmp45_;
					_tmp43_ = _ ("The IM address '%s' could not be understood.");
					_tmp44_ = im_address;
					_tmp45_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _tmp43_, _tmp44_);
					_inner_error_ = _tmp45_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp46_ = parts;
				_tmp46__length1 = parts_length1;
				if (_tmp46__length1 == 2) {
					gchar** _tmp47_;
					gint _tmp47__length1;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					gchar** _tmp50_;
					gint _tmp50__length1;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					_tmp47_ = parts;
					_tmp47__length1 = parts_length1;
					_tmp48_ = _tmp47_[0];
					_tmp49_ = g_strdup (_tmp48_);
					_g_free0 (node);
					node = _tmp49_;
					_tmp50_ = parts;
					_tmp50__length1 = parts_length1;
					_tmp51_ = _tmp50_[1];
					_tmp52_ = g_strdup (_tmp51_);
					_g_free0 (domain);
					domain = _tmp52_;
				} else {
					gchar** _tmp53_;
					gint _tmp53__length1;
					const gchar* _tmp54_;
					gchar* _tmp55_;
					_g_free0 (node);
					node = NULL;
					_tmp53_ = parts;
					_tmp53__length1 = parts_length1;
					_tmp54_ = _tmp53_[0];
					_tmp55_ = g_strdup (_tmp54_);
					_g_free0 (domain);
					domain = _tmp55_;
				}
				_tmp59_ = node;
				if (_tmp59_ != NULL) {
					const gchar* _tmp60_;
					_tmp60_ = node;
					_tmp58_ = g_strcmp0 (_tmp60_, "") == 0;
				} else {
					_tmp58_ = FALSE;
				}
				_tmp61_ = _tmp58_;
				if (_tmp61_) {
					_tmp57_ = TRUE;
				} else {
					gboolean _tmp62_ = FALSE;
					const gchar* _tmp63_;
					gboolean _tmp65_;
					_tmp63_ = domain;
					if (_tmp63_ == NULL) {
						_tmp62_ = TRUE;
					} else {
						const gchar* _tmp64_;
						_tmp64_ = domain;
						_tmp62_ = g_strcmp0 (_tmp64_, "") == 0;
					}
					_tmp65_ = _tmp62_;
					_tmp57_ = _tmp65_;
				}
				_tmp66_ = _tmp57_;
				if (_tmp66_) {
					_tmp56_ = TRUE;
				} else {
					gboolean _tmp67_ = FALSE;
					const gchar* _tmp68_;
					gboolean _tmp70_;
					_tmp68_ = resource;
					if (_tmp68_ != NULL) {
						const gchar* _tmp69_;
						_tmp69_ = resource;
						_tmp67_ = g_strcmp0 (_tmp69_, "") == 0;
					} else {
						_tmp67_ = FALSE;
					}
					_tmp70_ = _tmp67_;
					_tmp56_ = _tmp70_;
				}
				_tmp71_ = _tmp56_;
				if (_tmp71_) {
					const gchar* _tmp72_ = NULL;
					const gchar* _tmp73_;
					GError* _tmp74_;
					_tmp72_ = _ ("The IM address '%s' could not be understood.");
					_tmp73_ = im_address;
					_tmp74_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _tmp72_, _tmp73_);
					_inner_error_ = _tmp74_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (domain);
						_g_free0 (node);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						_g_free0 (domain);
						_g_free0 (node);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp75_ = domain;
				_tmp76_ = g_utf8_strdown (_tmp75_, (gssize) (-1));
				_g_free0 (domain);
				domain = _tmp76_;
				_tmp77_ = node;
				if (_tmp77_ != NULL) {
					const gchar* _tmp78_;
					gchar* _tmp79_ = NULL;
					_tmp78_ = node;
					_tmp79_ = g_utf8_strdown (_tmp78_, (gssize) (-1));
					_g_free0 (node);
					node = _tmp79_;
				}
				normalised = NULL;
				_tmp81_ = node;
				if (_tmp81_ != NULL) {
					const gchar* _tmp82_;
					_tmp82_ = resource;
					_tmp80_ = _tmp82_ != NULL;
				} else {
					_tmp80_ = FALSE;
				}
				_tmp83_ = _tmp80_;
				if (_tmp83_) {
					const gchar* _tmp84_;
					const gchar* _tmp85_;
					const gchar* _tmp86_;
					gchar* _tmp87_ = NULL;
					_tmp84_ = node;
					_tmp85_ = domain;
					_tmp86_ = resource;
					_tmp87_ = g_strdup_printf ("%s@%s/%s", _tmp84_, _tmp85_, _tmp86_);
					_g_free0 (normalised);
					normalised = _tmp87_;
				} else {
					const gchar* _tmp88_;
					_tmp88_ = node;
					if (_tmp88_ != NULL) {
						const gchar* _tmp89_;
						const gchar* _tmp90_;
						gchar* _tmp91_ = NULL;
						_tmp89_ = node;
						_tmp90_ = domain;
						_tmp91_ = g_strdup_printf ("%s@%s", _tmp89_, _tmp90_);
						_g_free0 (normalised);
						normalised = _tmp91_;
					} else {
						const gchar* _tmp92_;
						_tmp92_ = resource;
						if (_tmp92_ != NULL) {
							const gchar* _tmp93_;
							const gchar* _tmp94_;
							gchar* _tmp95_ = NULL;
							_tmp93_ = domain;
							_tmp94_ = resource;
							_tmp95_ = g_strdup_printf ("%s/%s", _tmp93_, _tmp94_);
							_g_free0 (normalised);
							normalised = _tmp95_;
						} else {
							const gchar* _tmp96_ = NULL;
							const gchar* _tmp97_;
							GError* _tmp98_;
							_tmp96_ = _ ("The IM address '%s' could not be understood.");
							_tmp97_ = im_address;
							_tmp98_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _tmp96_, _tmp97_);
							_inner_error_ = _tmp98_;
							if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (normalised);
								_g_free0 (domain);
								_g_free0 (node);
								_g_free0 (resource);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								return NULL;
							} else {
								_g_free0 (normalised);
								_g_free0 (domain);
								_g_free0 (node);
								_g_free0 (resource);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				}
				_tmp99_ = normalised;
				_tmp100_ = g_utf8_normalize (_tmp99_, (gssize) (-1), G_NORMALIZE_NFKC);
				result = _tmp100_;
				_g_free0 (normalised);
				_g_free0 (domain);
				_g_free0 (node);
				_g_free0 (resource);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				const gchar* _tmp101_;
				gchar* _tmp102_ = NULL;
				_tmp101_ = im_address;
				_tmp102_ = g_utf8_normalize (_tmp101_, (gssize) (-1), G_NORMALIZE_DEFAULT);
				result = _tmp102_;
				return result;
			}
		}
	}
}


GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self) {
	return FOLKS_IM_DETAILS_GET_INTERFACE (self)->get_im_addresses (self);
}


void folks_im_details_set_im_addresses (FolksImDetails* self, GeeMultiMap* value) {
	FOLKS_IM_DETAILS_GET_INTERFACE (self)->set_im_addresses (self, value);
}


static void folks_im_details_base_init (FolksImDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * A mapping of IM protocol to an (unordered) set of IM addresses.
		   *
		   * Each mapping is from an arbitrary protocol identifier to a set of IM
		   * addresses on that protocol for the contact, listed in no particular order.
		   *
		   * There must be no duplicate IM addresses in each set, though a given
		   * IM address may be present in the sets for different protocols.
		   *
		   * All the IM addresses must be normalised using
		   * {@link ImDetails.normalise_im_address} before being added to this property.
		   *
		   * @since 0.5.1
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("im-addresses", "im-addresses", "im-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * IM addresses exposed by an object implementing {@link PresenceDetails}.
 *
 * @since 0.1.13
 */
GType folks_im_details_get_type (void) {
	static volatile gsize folks_im_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_im_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImDetailsIface), (GBaseInitFunc) folks_im_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_im_details_type_id;
		folks_im_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksImDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_im_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_im_details_type_id__volatile, folks_im_details_type_id);
	}
	return folks_im_details_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



