
/* single-turn.c
 *
 * This file is part of fizmo.
 *
 * Copyright (c) 2009-2011 Christoph Ender.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include "../fizmo/fizmo.h"
#include "../fizmo/types.h"
#include "../c/screen_interface.h"
#include "../fizmo/i18n.h"
#include "../fizmo/wordwrap.h"
#include "../fizmo/text.h"
#include "../fizmo/streams.h"
#include "../fizmo/locales.h"
#include "../fizmo/config.h"


static char* single_turn_input;


char *single_turn_get_interface_name()
{ return "simple-c"; }

bool single_turn_return_false()
{ return false; }

bool single_turn_return_true()
{ return true; }

uint8_t single_turn_get_screen_height()
{ return 24; }

uint8_t single_turn_get_screen_width()
{ return 80; }

uint8_t single_turn_return_1()
{ return 1; }

z_colour single_turn_get_default_foreground_colour()
{ return Z_COLOUR_BLACK; }

z_colour single_turn_get_default_background_colour()
{ return Z_COLOUR_WHITE; }

uint8_t single_turn_return_0()
{ return 0; }

int single_turn_parse_config_parameter(char *key, char *value)
{ return 1;}

void single_turn_link_interface_to_story(struct z_story *story)
{ }

void single_turn_reset_interface()
{ }

int single_turn_close_interface(z_ucs *error_message)
{ return 0; }

void single_turn_set_buffer_mode(uint8_t new_buffer_mode)
{ }

void single_turn_interface_output_z_ucs(z_ucs *z_ucs_output)
{
  while (*z_ucs_output != 0)
  {
    if ((*z_ucs_output & 0xffffff80) != 0)
      putchar('?');
    else
      putchar((char)*z_ucs_output);

    z_ucs_output++;
  }
}

int16_t single_turn_interface_read_line(zscii *dest, uint16_t maximum_length,
    uint16_t tenth_seconds, uint32_t verification_routine,
    uint8_t preloaded_input, int *tenth_seconds_elapsed,
    bool disable_command_history, bool return_on_escape)
{
  int16_t input_size = 0;;
  char *input;
  int i = 0;

  if (single_turn_input == NULL)
    return 0;

  input = single_turn_input;

  while ( (*input != 0) && (i < maximum_length) )
  {
    if ( (*input == '\n') || (*input == '\r') )
      break;

    *(dest++) = *(input++);
    input_size++;
  }

  return input_size;
}

int single_turn_interface_read_char(uint16_t tenth_seconds,
    uint32_t verification_routine, int *tenth_seconds_elapsed)
{
  exit(-1);
}

void single_turn_show_status(z_ucs *room_description, int status_line_mode,
      int16_t parameter1, int16_t parameter2)
{ }

void single_turn_set_text_style(z_style text_style)
{ }

void single_turn_set_colour(z_colour foreground, z_colour background,
    int16_t window)
{ }

void single_turn_set_font(z_font font_type)
{ }

void single_turn_split_window(int16_t nof_lines)
{ }

void single_turn_set_window(int16_t window_number)
{ }

void single_turn_erase_window(int16_t window_number)
{ }

void single_turn_set_cursor(int16_t line, int16_t column, int16_t window)
{ }

uint16_t single_turn_get_cursor_row()
{ return 0; }

uint16_t single_turn_get_cursor_column()
{ return 0;}

void single_turn_erase_line_value(uint16_t start_position)
{ }

void single_turn_erase_line_pixels(uint16_t start_position)
{ }

void single_turn_output_interface_info()
{ }

struct z_screen_interface single_turn_interface =
{
  &single_turn_get_interface_name,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_return_true,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_return_false,
  &single_turn_get_screen_height,
  &single_turn_get_screen_width,
  &single_turn_get_screen_height,
  &single_turn_get_screen_width,
  &single_turn_return_1,
  &single_turn_return_1,
  &single_turn_get_default_foreground_colour,
  &single_turn_get_default_background_colour,
  &single_turn_return_0,
  &single_turn_parse_config_parameter,
  &single_turn_link_interface_to_story,
  &single_turn_reset_interface,
  &single_turn_close_interface,
  &single_turn_set_buffer_mode,
  &single_turn_interface_output_z_ucs,
  &single_turn_interface_read_line,
  &single_turn_interface_read_char,
  &single_turn_show_status,
  &single_turn_set_text_style,
  &single_turn_set_colour,
  &single_turn_set_font,
  &single_turn_split_window,
  &single_turn_set_window,
  &single_turn_erase_window,
  &single_turn_set_cursor,
  &single_turn_get_cursor_row,
  &single_turn_get_cursor_column,
  &single_turn_erase_line_value,
  &single_turn_erase_line_pixels,
  &single_turn_output_interface_info
};


void print_startup_syntax()
{
  streams_latin1_output(
      "\nSyntax: fizmo <story-file> <quetzal-file> [command]\n\n");
}


int main(int argc, char *argv[])
{
  fizmo_register_screen_interface(&single_turn_interface);

  if ( (argc < 3) || (argc > 4) )
  {
    print_startup_syntax();
    return 1;
  }
  else
  {
    set_configuration_value("save-and-quit-file-before-read", argv[2]);

    if (argc == 4)
      single_turn_input = argv[3];
    else
      single_turn_input = NULL;

    if (fopen(argv[2], "r") == NULL)
      fizmo_start(argv[1], NULL, NULL);
    else
      fizmo_start(argv[1], NULL, argv[2]);

    return 0;
  }
}

