/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.1
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.1 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.1 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <cstdlib>
#include <cstring>
#include <unistd.h>
#include <iostream>
#include "ringbuffer.h"
using namespace std;

RingBuffer::RingBuffer(int size)
{
	__buffer = (char*)malloc(size);
	__data = (char*)malloc(size);
	if((!__data) || (!__buffer))
	{
		cerr << "ERROR: cannot allocate memory for ringbuffer" << endl;
		exit(EXIT_FAILURE);
	}
	__position = 0;
	__locked = false;
	__length = size;
	__full = false;
	__inserted = 0;
	cout << "* created ringbuffer of size " << __length << endl;
}

RingBuffer::~RingBuffer()
{
	free(__buffer);
	free(__data);
}

void RingBuffer::insert(char* src, int n)
{
	if(n > __length)
	{
		cout << "ERROR: cannot insert " << dec << n << " bytes into ringbuffer of size " << dec << __length << endl;
		exit(EXIT_FAILURE);
	}
	while(__locked) usleep(89);
	__locked = true;
	int d = __length - __position;
	if(d >= n) memcpy(__buffer + __position, src, n);
	else
	{
		memcpy(__buffer + __position, src, d);
		memcpy(__buffer, src + d, n - d);
	}
	__position += n;
	while(__position >= __length) __position-= __length;
	__inserted += n;
	if(__inserted >= __length) __full = true;
	__locked = false;
}

char* RingBuffer::get()
{
	__inserted = 0;
	__full = false;
	while(__locked) usleep(97);
	__locked = true;
	int d = __length - __position;
	memcpy(__data, __buffer + __position, d);
	memcpy(__data + d, __buffer, __length - d);
	__locked = false;
	return __data;
}

int RingBuffer::size()
{
	return __length;
}

bool RingBuffer::ready()
{
	return __full;
}
