/*
 *	fhist - file history and comparison tools
 *	Copyright (C) 1991-1995, 1998, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	Derived from a work
 *	Copyright (C) 1990 David I. Bell.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/cmalloc.c
 *
 * Definitions to use releaseable memory allocation.
 */

#ifndef	CMALLOC_H
#define	CMALLOC_H

#include <ac/stddef.h>

#include <main.h>

/*
 * prevent use of libc functions
 */
#undef malloc
#define	malloc(n)	!/!/!cmalloc((unsigned long) (n))
#undef realloc
#define	realloc(p,n)	!/!/!cmrealloc((char *) (p), (unsigned long) (n))
#undef calloc
#define	calloc(n,s)	!/!/!cmcalloc((unsigned long) (n), (unsigned long) (s))
#undef free
#define	free(p)		!/!/!cmfree((char *) (p))

/*
 * these functions can be released
 * by using the cmreset function.
 */
void *cm_alloc(size_t);
void *cm_alloc_and_check(size_t);
void *cm_realloc(void *, size_t);
void *cm_realloc_and_check(void *, size_t);
void *cm_calloc(size_t, size_t);
void *cm_calloc_and_check(size_t, size_t);
void cm_free(void *);
void cm_reset(void);

/*
 * these functions access the libc functions more-or-less directly
 */
void *r_alloc(size_t);
void *r_alloc_and_check(size_t);
void *r_realloc(void *, size_t);
void *r_realloc_and_check(void *, size_t);
void *r_calloc(size_t, size_t);
void r_free(void *);

#endif /* CMALLOC_H */
