/* -*- mode: c++ -*-

  This file is part of the Feel library

  Author(s): Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
       Date: 2009-08-11

  Copyright (C) 2009 Universit Joseph Fourier (Grenoble I)

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file test_parameter.cpp
   \author Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
   \author Stephane Veys <stephane.veys@imag.fr>
   \date 2011-09-23
 */
#define BOOST_TEST_MODULE parameter testsuite
#include <boost/test/unit_test.hpp>
using boost::unit_test::test_suite;
#include <iostream>
#include <algorithm>
#include <boost/foreach.hpp>
#include <boost/lambda/lambda.hpp>

#include <feel/feelcrb/parameterspace.hpp>

#include <Eigen/Core>
#include <Eigen/LU>
#include <Eigen/Dense>

/**
   Test computation of eigenvalues with library Eigen
   Need the file "PodMatrix" (which is automatically generated if you run a transiant model with CRB)
   This file contains the POD matrix
 */

BOOST_AUTO_TEST_CASE( parameter1  )
{
    Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> Matrix;
    std::ifstream matrix_file;
    int Nrows, Ncols;

    matrix_file.open("PodMatrix",std::ios::in);
    matrix_file>>Nrows;
    matrix_file>>Ncols;

    if(Nrows*Ncols == 0)
    {
        std::cout<<"There is a problem with the matrix"<<std::endl;
        std::cout<<"Number of columns : "<<Ncols<<std::endl;
        std::cout<<"Number of rows : "<<Nrows<<std::endl;
        exit(0);
    }

    Matrix.resize(Nrows,Ncols);
    for(int i=0;i<Matrix.rows();i++)
    {
        for(int j=0;j<Matrix.cols();j++)
        {
            matrix_file>>Matrix(i,j);
        }
    }

    std::cout<<"Matrix of size "<<Matrix.rows()<<"*"<<Matrix.cols()<<" read with success"<<std::endl;
    Eigen::SelfAdjointEigenSolver<Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> > eigen_solver;
    eigen_solver.compute(Matrix);
    int number_of_eigenvalues =  eigen_solver.eigenvalues().size();
    std::cout<<"Number of eigenvalues : "<<number_of_eigenvalues<<std::endl;

}

