/* vim:set noet ts=4: */
/*
 * ibus - The Input Bus
 *
 * Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA
 */
#ifndef __FcitxKey_COMPOSE_DATA_H_
#define __FcitxKey_COMPOSE_DATA_H_

static const quint32 fcitx_compose_seqs_compact[] = {
    FcitxKey_dead_stroke, 138, 226, 235, 235, 235,
    FcitxKey_Greek_accentdieresis, 235, 239, 239, 239, 239,
    FcitxKey_dead_grave, 239, 299, 386, 598, 598,
    FcitxKey_dead_acute, 598, 664, 760, 1036, 1036,
    FcitxKey_dead_circumflex, 1036, 1176, 1176, 1376, 1376,
    FcitxKey_dead_tilde, 1376, 1458, 1521, 1661, 1661,
    FcitxKey_dead_macron, 1661, 1707, 1707, 1779, 1779,
    FcitxKey_dead_breve, 1779, 1833, 1833, 1857, 1857,
    FcitxKey_dead_abovedot, 1857, 1887, 1890, 1922, 1922,
    FcitxKey_dead_diaeresis, 1922, 2010, 2019, 2043, 2043,
    FcitxKey_dead_abovering, 2043, 2053, 2053, 2053, 2053,
    FcitxKey_dead_doubleacute, 2053, 2063, 2063, 2063, 2063,
    FcitxKey_dead_caron, 2063, 2089, 2089, 2097, 2097,
    FcitxKey_dead_cedilla, 2097, 2111, 2111, 2111, 2111,
    FcitxKey_dead_ogonek, 2111, 2121, 2121, 2121, 2121,
    FcitxKey_dead_iota, 2121, 2143, 2242, 2674, 3334,
    FcitxKey_dead_voiced_sound, 3334, 3380, 3380, 3380, 3380,
    FcitxKey_dead_semivoiced_sound, 3380, 3390, 3390, 3390, 3390,
    FcitxKey_dead_belowdot, 3390, 3400, 3400, 3416, 3416,
    FcitxKey_dead_hook, 3416, 3494, 3494, 3550, 3550,
    FcitxKey_dead_psili, 3550, 3578, 3578, 3578, 3578,
    FcitxKey_dead_dasia, 3578, 3610, 3610, 3610, 3610,
    FcitxKey_Multi_key, 3610, 3610, 9589, 13297, 15157,
    FcitxKey_space, 0x002F,
    FcitxKey_2, 0x01BB,
    FcitxKey_A, 0x023A,
    FcitxKey_B, 0x0243,
    FcitxKey_C, 0x023B,
    FcitxKey_D, 0x0110,
    FcitxKey_E, 0x0246,
    FcitxKey_G, 0x01E4,
    FcitxKey_H, 0x0126,
    FcitxKey_I, 0x0197,
    FcitxKey_J, 0x0248,
    FcitxKey_L, 0x0141,
    FcitxKey_O, 0x00D8,
    FcitxKey_P, 0x2C63,
    FcitxKey_R, 0x024C,
    FcitxKey_T, 0x0166,
    FcitxKey_U, 0x0244,
    FcitxKey_Y, 0x024E,
    FcitxKey_Z, 0x01B5,
    FcitxKey_a, 0x2C65,
    FcitxKey_b, 0x0180,
    FcitxKey_c, 0x023C,
    FcitxKey_d, 0x0111,
    FcitxKey_e, 0x0247,
    FcitxKey_g, 0x01E5,
    FcitxKey_h, 0x0127,
    FcitxKey_i, 0x0268,
    FcitxKey_j, 0x0249,
    FcitxKey_l, 0x0142,
    FcitxKey_o, 0x00F8,
    FcitxKey_p, 0x1D7D,
    FcitxKey_r, 0x024D,
    FcitxKey_t, 0x0167,
    FcitxKey_u, 0x0289,
    FcitxKey_y, 0x024F,
    FcitxKey_z, 0x01B6,
    FcitxKey_nobreakspace, 0x0338,
    FcitxKey_Oacute, 0x01FE,
    FcitxKey_oacute, 0x01FF,
    0x0237, 0x025F,
    0x0269, 0x1D7C,
    FcitxKey_dead_stroke, 0x002F,
    FcitxKey_lessthanequal, 0x2270,
    FcitxKey_greaterthanequal, 0x2271,
    FcitxKey_dead_acute, FcitxKey_O, 0x01FE,
    FcitxKey_dead_acute, FcitxKey_o, 0x01FF,
    FcitxKey_dead_abovedot, FcitxKey_j, 0x025F,
    FcitxKey_Greek_iota, 0x0390,
    FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_space, 0x0060,
    FcitxKey_V, 0x01DB,
    FcitxKey_v, 0x01DC,
    FcitxKey_Abreve, 0x1EB0,
    FcitxKey_abreve, 0x1EB1,
    FcitxKey_Emacron, 0x1E14,
    FcitxKey_emacron, 0x1E15,
    FcitxKey_Omacron, 0x1E50,
    FcitxKey_omacron, 0x1E51,
    FcitxKey_Cyrillic_ie, 0x0450,
    FcitxKey_Cyrillic_i, 0x045D,
    FcitxKey_Cyrillic_IE, 0x0400,
    FcitxKey_Cyrillic_I, 0x040D,
    FcitxKey_Greek_iotadieresis, 0x1FD2,
    FcitxKey_Greek_upsilondieresis, 0x1FE2,
    FcitxKey_Greek_ALPHA, 0x1FBA,
    FcitxKey_Greek_EPSILON, 0x1FC8,
    FcitxKey_Greek_ETA, 0x1FCA,
    FcitxKey_Greek_IOTA, 0x1FDA,
    FcitxKey_Greek_OMICRON, 0x1FF8,
    FcitxKey_Greek_UPSILON, 0x1FEA,
    FcitxKey_Greek_OMEGA, 0x1FFA,
    FcitxKey_Greek_alpha, 0x1F70,
    FcitxKey_Greek_epsilon, 0x1F72,
    FcitxKey_Greek_eta, 0x1F74,
    FcitxKey_Greek_iota, 0x1F76,
    FcitxKey_Greek_omicron, 0x1F78,
    FcitxKey_Greek_upsilon, 0x1F7A,
    FcitxKey_Greek_omega, 0x1F7C,
    FcitxKey_dead_grave, 0x0060,
    FcitxKey_dead_diaeresis, FcitxKey_Greek_iota, 0x1FD2,
    FcitxKey_dead_diaeresis, FcitxKey_Greek_upsilon, 0x1FE2,
    FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F0A,
    FcitxKey_dead_psili, FcitxKey_Greek_EPSILON, 0x1F1A,
    FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F2A,
    FcitxKey_dead_psili, FcitxKey_Greek_IOTA, 0x1F3A,
    FcitxKey_dead_psili, FcitxKey_Greek_OMICRON, 0x1F4A,
    FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1F6A,
    FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F02,
    FcitxKey_dead_psili, FcitxKey_Greek_epsilon, 0x1F12,
    FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F22,
    FcitxKey_dead_psili, FcitxKey_Greek_iota, 0x1F32,
    FcitxKey_dead_psili, FcitxKey_Greek_omicron, 0x1F42,
    FcitxKey_dead_psili, FcitxKey_Greek_upsilon, 0x1F52,
    FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1F62,
    FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F0B,
    FcitxKey_dead_dasia, FcitxKey_Greek_EPSILON, 0x1F1B,
    FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F2B,
    FcitxKey_dead_dasia, FcitxKey_Greek_IOTA, 0x1F3B,
    FcitxKey_dead_dasia, FcitxKey_Greek_OMICRON, 0x1F4B,
    FcitxKey_dead_dasia, FcitxKey_Greek_UPSILON, 0x1F5B,
    FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1F6B,
    FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F03,
    FcitxKey_dead_dasia, FcitxKey_Greek_epsilon, 0x1F13,
    FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F23,
    FcitxKey_dead_dasia, FcitxKey_Greek_iota, 0x1F33,
    FcitxKey_dead_dasia, FcitxKey_Greek_omicron, 0x1F43,
    FcitxKey_dead_dasia, FcitxKey_Greek_upsilon, 0x1F53,
    FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1F63,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_U, 0x01DB,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_u, 0x01DC,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_Greek_iota, 0x1FD2,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_Greek_upsilon, 0x1FE2,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F0B,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_EPSILON, 0x1F1B,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F2B,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_IOTA, 0x1F3B,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMICRON, 0x1F4B,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_UPSILON, 0x1F5B,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1F6B,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F03,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_epsilon, 0x1F13,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F23,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_iota, 0x1F33,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omicron, 0x1F43,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_upsilon, 0x1F53,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1F63,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F0A,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_EPSILON, 0x1F1A,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F2A,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_IOTA, 0x1F3A,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMICRON, 0x1F4A,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1F6A,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F02,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_epsilon, 0x1F12,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F22,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_iota, 0x1F32,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omicron, 0x1F42,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_upsilon, 0x1F52,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1F62,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_O, 0x1EDC,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_U, 0x1EEA,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_o, 0x1EDD,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_u, 0x1EEB,
    FcitxKey_Multi_key, FcitxKey_U, FcitxKey_A, 0x1EB0,
    FcitxKey_Multi_key, FcitxKey_U, FcitxKey_a, 0x1EB1,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_A, 0x1EA6,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_E, 0x1EC0,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_O, 0x1ED2,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_a, 0x1EA7,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_e, 0x1EC1,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_o, 0x1ED3,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_E, 0x1E14,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_O, 0x1E50,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_e, 0x1E15,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_o, 0x1E51,
    FcitxKey_Multi_key, FcitxKey_b, FcitxKey_A, 0x1EB0,
    FcitxKey_Multi_key, FcitxKey_b, FcitxKey_a, 0x1EB1,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_E, 0x1E14,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_O, 0x1E50,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_e, 0x1E15,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_o, 0x1E51,
    FcitxKey_space, 0x0027,
    FcitxKey_V, 0x01D7,
    FcitxKey_v, 0x01D8,
    FcitxKey_Abreve, 0x1EAE,
    FcitxKey_abreve, 0x1EAF,
    FcitxKey_Emacron, 0x1E16,
    FcitxKey_emacron, 0x1E17,
    FcitxKey_Utilde, 0x1E78,
    FcitxKey_omacron, 0x1E53,
    FcitxKey_utilde, 0x1E79,
    FcitxKey_Cyrillic_ghe, 0x0453,
    FcitxKey_Cyrillic_ka, 0x045C,
    FcitxKey_Cyrillic_GHE, 0x0403,
    FcitxKey_Cyrillic_KA, 0x040C,
    FcitxKey_Greek_iotadieresis, 0x0390,
    FcitxKey_Greek_upsilondieresis, 0x03B0,
    FcitxKey_Greek_ALPHA, 0x0386,
    FcitxKey_Greek_EPSILON, 0x0388,
    FcitxKey_Greek_ETA, 0x0389,
    FcitxKey_Greek_IOTA, 0x038A,
    FcitxKey_Greek_OMICRON, 0x038C,
    FcitxKey_Greek_UPSILON, 0x038E,
    FcitxKey_Greek_OMEGA, 0x038F,
    FcitxKey_Greek_alpha, 0x03AC,
    FcitxKey_Greek_epsilon, 0x03AD,
    FcitxKey_Greek_eta, 0x03AE,
    FcitxKey_Greek_iota, 0x03AF,
    FcitxKey_Greek_omicron, 0x03CC,
    FcitxKey_Greek_upsilon, 0x03CD,
    FcitxKey_Greek_omega, 0x03CE,
    FcitxKey_Sabovedot, 0x1E64,
    FcitxKey_sabovedot, 0x1E65,
    FcitxKey_dead_acute, 0x00B4,
    FcitxKey_dead_stroke, FcitxKey_O, 0x01FE,
    FcitxKey_dead_stroke, FcitxKey_o, 0x01FF,
    FcitxKey_dead_diaeresis, FcitxKey_space, 0x0385,
    FcitxKey_dead_diaeresis, FcitxKey_Greek_iota, 0x0390,
    FcitxKey_dead_diaeresis, FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F0C,
    FcitxKey_dead_psili, FcitxKey_Greek_EPSILON, 0x1F1C,
    FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F2C,
    FcitxKey_dead_psili, FcitxKey_Greek_IOTA, 0x1F3C,
    FcitxKey_dead_psili, FcitxKey_Greek_OMICRON, 0x1F4C,
    FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1F6C,
    FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F04,
    FcitxKey_dead_psili, FcitxKey_Greek_epsilon, 0x1F14,
    FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F24,
    FcitxKey_dead_psili, FcitxKey_Greek_iota, 0x1F34,
    FcitxKey_dead_psili, FcitxKey_Greek_omicron, 0x1F44,
    FcitxKey_dead_psili, FcitxKey_Greek_upsilon, 0x1F54,
    FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1F64,
    FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F0D,
    FcitxKey_dead_dasia, FcitxKey_Greek_EPSILON, 0x1F1D,
    FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F2D,
    FcitxKey_dead_dasia, FcitxKey_Greek_IOTA, 0x1F3D,
    FcitxKey_dead_dasia, FcitxKey_Greek_OMICRON, 0x1F4D,
    FcitxKey_dead_dasia, FcitxKey_Greek_UPSILON, 0x1F5D,
    FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1F6D,
    FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F05,
    FcitxKey_dead_dasia, FcitxKey_Greek_epsilon, 0x1F15,
    FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F25,
    FcitxKey_dead_dasia, FcitxKey_Greek_iota, 0x1F35,
    FcitxKey_dead_dasia, FcitxKey_Greek_omicron, 0x1F45,
    FcitxKey_dead_dasia, FcitxKey_Greek_upsilon, 0x1F55,
    FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1F65,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_I, 0x1E2E,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_U, 0x01D7,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_i, 0x1E2F,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_u, 0x01D8,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_Greek_iota, 0x0390,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F0D,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_EPSILON, 0x1F1D,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F2D,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_IOTA, 0x1F3D,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMICRON, 0x1F4D,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_UPSILON, 0x1F5D,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1F6D,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F05,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_epsilon, 0x1F15,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F25,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_iota, 0x1F35,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omicron, 0x1F45,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_upsilon, 0x1F55,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1F65,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F0C,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_EPSILON, 0x1F1C,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F2C,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_IOTA, 0x1F3C,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMICRON, 0x1F4C,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1F6C,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F04,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_epsilon, 0x1F14,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F24,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_iota, 0x1F34,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omicron, 0x1F44,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_upsilon, 0x1F54,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1F64,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_O, 0x1EDA,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_U, 0x1EE8,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_o, 0x1EDB,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_u, 0x1EE9,
    FcitxKey_Multi_key, FcitxKey_comma, FcitxKey_C, 0x1E08,
    FcitxKey_Multi_key, FcitxKey_comma, FcitxKey_c, 0x1E09,
    FcitxKey_Multi_key, FcitxKey_slash, FcitxKey_O, 0x01FE,
    FcitxKey_Multi_key, FcitxKey_slash, FcitxKey_o, 0x01FF,
    FcitxKey_Multi_key, FcitxKey_U, FcitxKey_A, 0x1EAE,
    FcitxKey_Multi_key, FcitxKey_U, FcitxKey_a, 0x1EAF,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_A, 0x1EA4,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_E, 0x1EBE,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_O, 0x1ED0,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_a, 0x1EA5,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_e, 0x1EBF,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_o, 0x1ED1,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_E, 0x1E16,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_O, 0x1E52,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_e, 0x1E17,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_o, 0x1E53,
    FcitxKey_Multi_key, FcitxKey_b, FcitxKey_A, 0x1EAE,
    FcitxKey_Multi_key, FcitxKey_b, FcitxKey_a, 0x1EAF,
    FcitxKey_Multi_key, FcitxKey_o, FcitxKey_A, 0x01FA,
    FcitxKey_Multi_key, FcitxKey_o, FcitxKey_a, 0x01FB,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_O, 0x1E4C,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_U, 0x1E78,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_o, 0x1E4D,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_u, 0x1E79,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_E, 0x1E16,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_O, 0x1E52,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_e, 0x1E17,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_o, 0x1E53,
    FcitxKey_Multi_key, FcitxKey_cedilla, FcitxKey_C, 0x1E08,
    FcitxKey_Multi_key, FcitxKey_cedilla, FcitxKey_c, 0x1E09,
    FcitxKey_Multi_key, FcitxKey_KP_Divide, FcitxKey_O, 0x01FE,
    FcitxKey_Multi_key, FcitxKey_KP_Divide, FcitxKey_o, 0x01FF,
    FcitxKey_space, 0x005E,
    FcitxKey_parenleft, 0x207D,
    FcitxKey_parenright, 0x207E,
    FcitxKey_plus, 0x207A,
    FcitxKey_minus, 0x207B,
    FcitxKey_0, 0x2070,
    FcitxKey_1, 0x00B9,
    FcitxKey_2, 0x00B2,
    FcitxKey_3, 0x00B3,
    FcitxKey_4, 0x2074,
    FcitxKey_5, 0x2075,
    FcitxKey_6, 0x2076,
    FcitxKey_7, 0x2077,
    FcitxKey_8, 0x2078,
    FcitxKey_9, 0x2079,
    FcitxKey_equal, 0x207C,
    FcitxKey_nobreakspace, 0x0302,
    FcitxKey_Agrave, 0x1EA6,
    FcitxKey_Aacute, 0x1EA4,
    FcitxKey_Atilde, 0x1EAA,
    FcitxKey_Egrave, 0x1EC0,
    FcitxKey_Eacute, 0x1EBE,
    FcitxKey_Ograve, 0x1ED2,
    FcitxKey_Oacute, 0x1ED0,
    FcitxKey_Otilde, 0x1ED6,
    FcitxKey_agrave, 0x1EA7,
    FcitxKey_aacute, 0x1EA5,
    FcitxKey_atilde, 0x1EAB,
    FcitxKey_egrave, 0x1EC1,
    FcitxKey_eacute, 0x1EBF,
    FcitxKey_ograve, 0x1ED3,
    FcitxKey_oacute, 0x1ED1,
    FcitxKey_otilde, 0x1ED7,
    FcitxKey_Ahook, 0x1EA8,
    FcitxKey_ahook, 0x1EA9,
    FcitxKey_Ehook, 0x1EC2,
    FcitxKey_ehook, 0x1EC3,
    FcitxKey_Etilde, 0x1EC4,
    FcitxKey_etilde, 0x1EC5,
    FcitxKey_Ohook, 0x1ED4,
    FcitxKey_ohook, 0x1ED5,
    0x2212, 0x207B,
    0x4E00, 0x3192,
    0x4E01, 0x319C,
    0x4E09, 0x3194,
    0x4E0A, 0x3196,
    0x4E0B, 0x3198,
    0x4E19, 0x319B,
    0x4E2D, 0x3197,
    0x4E59, 0x319A,
    0x4E8C, 0x3193,
    0x4EBA, 0x319F,
    0x56DB, 0x3195,
    0x5730, 0x319E,
    0x5929, 0x319D,
    0x7532, 0x3199,
    FcitxKey_dead_circumflex, 0x005E,
    FcitxKey_KP_Space, 0x00B2,
    FcitxKey_KP_Add, 0x207A,
    FcitxKey_KP_0, 0x2070,
    FcitxKey_KP_1, 0x00B9,
    FcitxKey_KP_2, 0x00B2,
    FcitxKey_KP_3, 0x00B3,
    FcitxKey_KP_4, 0x2074,
    FcitxKey_KP_5, 0x2075,
    FcitxKey_KP_6, 0x2076,
    FcitxKey_KP_7, 0x2077,
    FcitxKey_KP_8, 0x2078,
    FcitxKey_KP_9, 0x2079,
    FcitxKey_KP_Equal, 0x207C,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_A, 0x1EAC,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_E, 0x1EC6,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_O, 0x1ED8,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_a, 0x1EAD,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_e, 0x1EC7,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_o, 0x1ED9,
    FcitxKey_Multi_key, FcitxKey_S, FcitxKey_M, 0x2120,
    FcitxKey_Multi_key, FcitxKey_S, FcitxKey_m, 0x2120,
    FcitxKey_Multi_key, FcitxKey_T, FcitxKey_M, 0x2122,
    FcitxKey_Multi_key, FcitxKey_T, FcitxKey_m, 0x2122,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_a, 0x00AA,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_h, 0x02B0,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_i, 0x2071,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_j, 0x02B2,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_l, 0x02E1,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_n, 0x207F,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_o, 0x00BA,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_r, 0x02B3,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_s, 0x02E2,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_w, 0x02B7,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_x, 0x02E3,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_y, 0x02B8,
    FcitxKey_Multi_key, FcitxKey_underscore, 0x0263, 0x02E0,
    FcitxKey_Multi_key, FcitxKey_underscore, 0x0266, 0x02B1,
    FcitxKey_Multi_key, FcitxKey_underscore, 0x0279, 0x02B4,
    FcitxKey_Multi_key, FcitxKey_underscore, 0x027B, 0x02B5,
    FcitxKey_Multi_key, FcitxKey_underscore, 0x0281, 0x02B6,
    FcitxKey_Multi_key, FcitxKey_underscore, 0x0295, 0x02E4,
    FcitxKey_Multi_key, FcitxKey_s, FcitxKey_M, 0x2120,
    FcitxKey_Multi_key, FcitxKey_s, FcitxKey_m, 0x2120,
    FcitxKey_Multi_key, FcitxKey_t, FcitxKey_M, 0x2122,
    FcitxKey_Multi_key, FcitxKey_t, FcitxKey_m, 0x2122,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_a, 0x00AA,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_h, 0x02B0,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_i, 0x2071,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_j, 0x02B2,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_l, 0x02E1,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_n, 0x207F,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_o, 0x00BA,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_r, 0x02B3,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_s, 0x02E2,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_w, 0x02B7,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_x, 0x02E3,
    FcitxKey_Multi_key, FcitxKey_underbar, FcitxKey_y, 0x02B8,
    FcitxKey_Multi_key, FcitxKey_underbar, 0x0263, 0x02E0,
    FcitxKey_Multi_key, FcitxKey_underbar, 0x0266, 0x02B1,
    FcitxKey_Multi_key, FcitxKey_underbar, 0x0279, 0x02B4,
    FcitxKey_Multi_key, FcitxKey_underbar, 0x027B, 0x02B5,
    FcitxKey_Multi_key, FcitxKey_underbar, 0x0281, 0x02B6,
    FcitxKey_Multi_key, FcitxKey_underbar, 0x0295, 0x02E4,
    FcitxKey_space, 0x007E,
    FcitxKey_less, 0x2272,
    FcitxKey_equal, 0x2243,
    FcitxKey_greater, 0x2273,
    FcitxKey_Oacute, 0x1E4C,
    FcitxKey_Odiaeresis, 0x1E4E,
    FcitxKey_Uacute, 0x1E78,
    FcitxKey_oacute, 0x1E4D,
    FcitxKey_odiaeresis, 0x1E4F,
    FcitxKey_uacute, 0x1E79,
    FcitxKey_Abreve, 0x1EB4,
    FcitxKey_abreve, 0x1EB5,
    FcitxKey_Omacron, 0x022C,
    FcitxKey_omacron, 0x022D,
    FcitxKey_Greek_iotadieresis, 0x1FD7,
    FcitxKey_Greek_upsilondieresis, 0x1FE7,
    FcitxKey_Greek_alpha, 0x1FB6,
    FcitxKey_Greek_eta, 0x1FC6,
    FcitxKey_Greek_iota, 0x1FD6,
    FcitxKey_Greek_upsilon, 0x1FE6,
    FcitxKey_Greek_omega, 0x1FF6,
    0x1F00, 0x1F06,
    0x1F01, 0x1F07,
    0x1F08, 0x1F0E,
    0x1F09, 0x1F0F,
    0x1F20, 0x1F26,
    0x1F21, 0x1F27,
    0x1F28, 0x1F2E,
    0x1F29, 0x1F2F,
    0x1F30, 0x1F36,
    0x1F31, 0x1F37,
    0x1F38, 0x1F3E,
    0x1F39, 0x1F3F,
    0x1F50, 0x1F56,
    0x1F51, 0x1F57,
    0x1F59, 0x1F5F,
    0x1F60, 0x1F66,
    0x1F61, 0x1F67,
    0x1F68, 0x1F6E,
    0x1F69, 0x1F6F,
    FcitxKey_dead_tilde, 0x007E,
    FcitxKey_dead_diaeresis, FcitxKey_Greek_iota, 0x1FD7,
    FcitxKey_dead_diaeresis, FcitxKey_Greek_upsilon, 0x1FE7,
    FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F0E,
    FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F2E,
    FcitxKey_dead_psili, FcitxKey_Greek_IOTA, 0x1F3E,
    FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1F6E,
    FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F06,
    FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F26,
    FcitxKey_dead_psili, FcitxKey_Greek_iota, 0x1F36,
    FcitxKey_dead_psili, FcitxKey_Greek_upsilon, 0x1F56,
    FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1F66,
    FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F0F,
    FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F2F,
    FcitxKey_dead_dasia, FcitxKey_Greek_IOTA, 0x1F3F,
    FcitxKey_dead_dasia, FcitxKey_Greek_UPSILON, 0x1F5F,
    FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1F6F,
    FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F07,
    FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F27,
    FcitxKey_dead_dasia, FcitxKey_Greek_iota, 0x1F37,
    FcitxKey_dead_dasia, FcitxKey_Greek_upsilon, 0x1F57,
    FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1F67,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_Greek_iota, 0x1FD7,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_Greek_upsilon, 0x1FE7,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F0F,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F2F,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_IOTA, 0x1F3F,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_UPSILON, 0x1F5F,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1F6F,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F07,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F27,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_iota, 0x1F37,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_upsilon, 0x1F57,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1F67,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F0E,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F2E,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_IOTA, 0x1F3E,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1F6E,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F06,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F26,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_iota, 0x1F36,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_upsilon, 0x1F56,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1F66,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_O, 0x1EE0,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_U, 0x1EEE,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_o, 0x1EE1,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_u, 0x1EEF,
    FcitxKey_Multi_key, FcitxKey_U, FcitxKey_A, 0x1EB4,
    FcitxKey_Multi_key, FcitxKey_U, FcitxKey_a, 0x1EB5,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_A, 0x1EAA,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_E, 0x1EC4,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_O, 0x1ED6,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_a, 0x1EAB,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_e, 0x1EC5,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_o, 0x1ED7,
    FcitxKey_Multi_key, FcitxKey_b, FcitxKey_A, 0x1EB4,
    FcitxKey_Multi_key, FcitxKey_b, FcitxKey_a, 0x1EB5,
    FcitxKey_space, 0x00AF,
    FcitxKey_V, 0x01D5,
    FcitxKey_v, 0x01D6,
    FcitxKey_nobreakspace, 0x0304,
    FcitxKey_Egrave, 0x1E14,
    FcitxKey_Eacute, 0x1E16,
    FcitxKey_Ograve, 0x1E50,
    FcitxKey_Oacute, 0x1E52,
    FcitxKey_egrave, 0x1E15,
    FcitxKey_eacute, 0x1E17,
    FcitxKey_ograve, 0x1E51,
    FcitxKey_oacute, 0x1E53,
    FcitxKey_Cyrillic_i, 0x04E3,
    FcitxKey_Cyrillic_u, 0x04EF,
    FcitxKey_Cyrillic_I, 0x04E2,
    FcitxKey_Cyrillic_U, 0x04EE,
    FcitxKey_Greek_ALPHA, 0x1FB9,
    FcitxKey_Greek_IOTA, 0x1FD9,
    FcitxKey_Greek_UPSILON, 0x1FE9,
    FcitxKey_Greek_alpha, 0x1FB1,
    FcitxKey_Greek_iota, 0x1FD1,
    FcitxKey_Greek_upsilon, 0x1FE1,
    FcitxKey_dead_macron, 0x00AF,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_L, 0x1E38,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_R, 0x1E5C,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_l, 0x1E39,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_r, 0x1E5D,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_A, 0x01DE,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_O, 0x022A,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_U, 0x01D5,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_a, 0x01DF,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_o, 0x022B,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_u, 0x01D6,
    FcitxKey_Multi_key, FcitxKey_period, FcitxKey_A, 0x01E0,
    FcitxKey_Multi_key, FcitxKey_period, FcitxKey_O, 0x0230,
    FcitxKey_Multi_key, FcitxKey_period, FcitxKey_a, 0x01E1,
    FcitxKey_Multi_key, FcitxKey_period, FcitxKey_o, 0x0231,
    FcitxKey_Multi_key, FcitxKey_semicolon, FcitxKey_O, 0x01EC,
    FcitxKey_Multi_key, FcitxKey_semicolon, FcitxKey_o, 0x01ED,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_O, 0x022C,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_o, 0x022D,
    FcitxKey_space, 0x02D8,
    FcitxKey_nobreakspace, 0x0306,
    FcitxKey_Agrave, 0x1EB0,
    FcitxKey_Aacute, 0x1EAE,
    FcitxKey_Atilde, 0x1EB4,
    FcitxKey_agrave, 0x1EB1,
    FcitxKey_aacute, 0x1EAF,
    FcitxKey_atilde, 0x1EB5,
    FcitxKey_Cyrillic_a, 0x04D1,
    FcitxKey_Cyrillic_ie, 0x04D7,
    FcitxKey_Cyrillic_i, 0x0439,
    FcitxKey_Cyrillic_u, 0x045E,
    FcitxKey_Cyrillic_zhe, 0x04C2,
    FcitxKey_Cyrillic_A, 0x04D0,
    FcitxKey_Cyrillic_IE, 0x04D6,
    FcitxKey_Cyrillic_I, 0x0419,
    FcitxKey_Cyrillic_U, 0x040E,
    FcitxKey_Cyrillic_ZHE, 0x04C1,
    FcitxKey_Greek_ALPHA, 0x1FB8,
    FcitxKey_Greek_IOTA, 0x1FD8,
    FcitxKey_Greek_UPSILON, 0x1FE8,
    FcitxKey_Greek_alpha, 0x1FB0,
    FcitxKey_Greek_iota, 0x1FD0,
    FcitxKey_Greek_upsilon, 0x1FE0,
    FcitxKey_Ahook, 0x1EB2,
    FcitxKey_ahook, 0x1EB3,
    FcitxKey_dead_breve, 0x02D8,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_A, 0x1EB6,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_a, 0x1EB7,
    FcitxKey_Multi_key, FcitxKey_comma, FcitxKey_E, 0x1E1C,
    FcitxKey_Multi_key, FcitxKey_comma, FcitxKey_e, 0x1E1D,
    FcitxKey_Multi_key, FcitxKey_cedilla, FcitxKey_E, 0x1E1C,
    FcitxKey_Multi_key, FcitxKey_cedilla, FcitxKey_e, 0x1E1D,
    FcitxKey_space, 0x02D9,
    FcitxKey_L, 0x013F,
    FcitxKey_i, 0x0131,
    FcitxKey_j, 0x0237,
    FcitxKey_l, 0x0140,
    FcitxKey_nobreakspace, 0x0307,
    FcitxKey_Sacute, 0x1E64,
    FcitxKey_Scaron, 0x1E66,
    FcitxKey_sacute, 0x1E65,
    FcitxKey_scaron, 0x1E67,
    FcitxKey_Amacron, 0x01E0,
    FcitxKey_Omacron, 0x0230,
    FcitxKey_amacron, 0x01E1,
    FcitxKey_omacron, 0x0231,
    FcitxKey_dead_abovedot, 0x02D9,
    FcitxKey_dead_stroke, FcitxKey_j, 0x025F,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_S, 0x1E68,
    FcitxKey_Multi_key, FcitxKey_exclam, FcitxKey_s, 0x1E69,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_S, 0x1E64,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_s, 0x1E65,
    FcitxKey_Multi_key, FcitxKey_c, FcitxKey_S, 0x1E66,
    FcitxKey_Multi_key, FcitxKey_c, FcitxKey_s, 0x1E67,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_S, 0x1E64,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_s, 0x1E65,
    FcitxKey_space, 0x0022,
    FcitxKey_apostrophe, 0x0344,
    FcitxKey_nobreakspace, 0x0308,
    FcitxKey_acute, 0x0344,
    FcitxKey_Iacute, 0x1E2E,
    FcitxKey_Ugrave, 0x01DB,
    FcitxKey_Uacute, 0x01D7,
    FcitxKey_iacute, 0x1E2F,
    FcitxKey_ugrave, 0x01DC,
    FcitxKey_uacute, 0x01D8,
    0x01D3, 0x01D9,
    0x01D4, 0x01DA,
    FcitxKey_Amacron, 0x01DE,
    FcitxKey_Umacron, 0x1E7A,
    FcitxKey_amacron, 0x01DF,
    FcitxKey_omacron, 0x022B,
    FcitxKey_umacron, 0x1E7B,
    FcitxKey_Ukrainian_i, 0x0457,
    FcitxKey_Ukrainian_I, 0x0407,
    FcitxKey_Cyrillic_a, 0x04D3,
    FcitxKey_Cyrillic_ie, 0x0451,
    FcitxKey_Cyrillic_i, 0x04E5,
    FcitxKey_Cyrillic_o, 0x04E7,
    FcitxKey_Cyrillic_u, 0x04F1,
    FcitxKey_Cyrillic_zhe, 0x04DD,
    FcitxKey_Cyrillic_yeru, 0x04F9,
    FcitxKey_Cyrillic_ze, 0x04DF,
    FcitxKey_Cyrillic_e, 0x04ED,
    FcitxKey_Cyrillic_che, 0x04F5,
    FcitxKey_Cyrillic_A, 0x04D2,
    FcitxKey_Cyrillic_IE, 0x0401,
    FcitxKey_Cyrillic_I, 0x04E4,
    FcitxKey_Cyrillic_O, 0x04E6,
    FcitxKey_Cyrillic_U, 0x04F0,
    FcitxKey_Cyrillic_ZHE, 0x04DC,
    FcitxKey_Cyrillic_YERU, 0x04F8,
    FcitxKey_Cyrillic_ZE, 0x04DE,
    FcitxKey_Cyrillic_E, 0x04EC,
    FcitxKey_Cyrillic_CHE, 0x04F4,
    FcitxKey_Greek_IOTA, 0x03AA,
    FcitxKey_Greek_UPSILON, 0x03AB,
    FcitxKey_Greek_iota, 0x03CA,
    FcitxKey_Greek_upsilon, 0x03CB,
    FcitxKey_dead_diaeresis, 0x00A8,
    FcitxKey_dead_acute, FcitxKey_space, 0x0385,
    FcitxKey_dead_acute, FcitxKey_Greek_iota, 0x0390,
    FcitxKey_dead_acute, FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_U, 0x1E7A,
    FcitxKey_Multi_key, FcitxKey_underscore, FcitxKey_u, 0x1E7B,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_O, 0x1E4E,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_o, 0x1E4F,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_U, 0x1E7A,
    FcitxKey_Multi_key, FcitxKey_macron, FcitxKey_u, 0x1E7B,
    FcitxKey_space, 0x00B0,
    FcitxKey_nobreakspace, 0x030A,
    FcitxKey_Aacute, 0x01FA,
    FcitxKey_aacute, 0x01FB,
    FcitxKey_dead_abovering, 0x00B0,
    FcitxKey_space, 0x02DD,
    FcitxKey_nobreakspace, 0x030B,
    FcitxKey_Cyrillic_u, 0x04F3,
    FcitxKey_Cyrillic_U, 0x04F2,
    FcitxKey_dead_doubleacute, 0x02DD,
    FcitxKey_space, 0x02C7,
    FcitxKey_parenleft, 0x208D,
    FcitxKey_parenright, 0x208E,
    FcitxKey_plus, 0x208A,
    FcitxKey_minus, 0x208B,
    FcitxKey_equal, 0x208C,
    FcitxKey_V, 0x01D9,
    FcitxKey_v, 0x01DA,
    FcitxKey_nobreakspace, 0x030C,
    0x01F2, 0x01C5,
    FcitxKey_Sabovedot, 0x1E66,
    FcitxKey_sabovedot, 0x1E67,
    FcitxKey_dead_caron, 0x02C7,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_U, 0x01D9,
    FcitxKey_Multi_key, FcitxKey_quotedbl, FcitxKey_u, 0x01DA,
    FcitxKey_space, 0x00B8,
    FcitxKey_nobreakspace, 0x0327,
    FcitxKey_cent, 0x20B5,
    FcitxKey_Cacute, 0x1E08,
    FcitxKey_cacute, 0x1E09,
    FcitxKey_ColonSign, 0x20B5,
    FcitxKey_dead_cedilla, 0x00B8,
    FcitxKey_space, 0x02DB,
    FcitxKey_nobreakspace, 0x0328,
    FcitxKey_Omacron, 0x01EC,
    FcitxKey_omacron, 0x01ED,
    FcitxKey_dead_ogonek, 0x02DB,
    FcitxKey_space, 0x037A,
    FcitxKey_Greek_alphaaccent, 0x1FB4,
    FcitxKey_Greek_etaaccent, 0x1FC4,
    FcitxKey_Greek_omegaaccent, 0x1FF4,
    FcitxKey_Greek_ALPHA, 0x1FBC,
    FcitxKey_Greek_ETA, 0x1FCC,
    FcitxKey_Greek_OMEGA, 0x1FFC,
    FcitxKey_Greek_alpha, 0x1FB3,
    FcitxKey_Greek_eta, 0x1FC3,
    FcitxKey_Greek_omega, 0x1FF3,
    FcitxKey_dead_iota, 0x037A,
    FcitxKey_dead_grave, FcitxKey_Greek_alpha, 0x1FB2,
    FcitxKey_dead_grave, FcitxKey_Greek_eta, 0x1FC2,
    FcitxKey_dead_grave, FcitxKey_Greek_omega, 0x1FF2,
    FcitxKey_dead_acute, FcitxKey_Greek_alpha, 0x1FB4,
    FcitxKey_dead_acute, FcitxKey_Greek_eta, 0x1FC4,
    FcitxKey_dead_acute, FcitxKey_Greek_omega, 0x1FF4,
    FcitxKey_dead_tilde, FcitxKey_Greek_alpha, 0x1FB7,
    FcitxKey_dead_tilde, FcitxKey_Greek_eta, 0x1FC7,
    FcitxKey_dead_tilde, FcitxKey_Greek_omega, 0x1FF7,
    FcitxKey_dead_tilde, 0x1F00, 0x1F86,
    FcitxKey_dead_tilde, 0x1F01, 0x1F87,
    FcitxKey_dead_tilde, 0x1F08, 0x1F8E,
    FcitxKey_dead_tilde, 0x1F09, 0x1F8F,
    FcitxKey_dead_tilde, 0x1F20, 0x1F96,
    FcitxKey_dead_tilde, 0x1F21, 0x1F97,
    FcitxKey_dead_tilde, 0x1F28, 0x1F9E,
    FcitxKey_dead_tilde, 0x1F29, 0x1F9F,
    FcitxKey_dead_tilde, 0x1F60, 0x1FA6,
    FcitxKey_dead_tilde, 0x1F61, 0x1FA7,
    FcitxKey_dead_tilde, 0x1F68, 0x1FAE,
    FcitxKey_dead_tilde, 0x1F69, 0x1FAF,
    FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F88,
    FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F98,
    FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FA8,
    FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F80,
    FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F90,
    FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA0,
    FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F89,
    FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F99,
    FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FA9,
    FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F81,
    FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F91,
    FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA1,
    FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8A,
    FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9A,
    FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAA,
    FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F82,
    FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F92,
    FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA2,
    FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8B,
    FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9B,
    FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAB,
    FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F83,
    FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F93,
    FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA3,
    FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8E,
    FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9E,
    FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAE,
    FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F86,
    FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F96,
    FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA6,
    FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8F,
    FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9F,
    FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAF,
    FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F87,
    FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F97,
    FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA7,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_Greek_alpha, 0x1FB4,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_Greek_eta, 0x1FC4,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_Greek_omega, 0x1FF4,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F00, 0x1F84,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F01, 0x1F85,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F08, 0x1F8C,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F09, 0x1F8D,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F20, 0x1F94,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F21, 0x1F95,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F28, 0x1F9C,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F29, 0x1F9D,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F60, 0x1FA4,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F61, 0x1FA5,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F68, 0x1FAC,
    FcitxKey_Multi_key, FcitxKey_apostrophe, 0x1F69, 0x1FAD,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F89,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F99,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FA9,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F81,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F91,
    FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA1,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F88,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F98,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FA8,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F80,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F90,
    FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA0,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_Greek_alpha, 0x1FB2,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_Greek_eta, 0x1FC2,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_Greek_omega, 0x1FF2,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F00, 0x1F82,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F01, 0x1F83,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F08, 0x1F8A,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F09, 0x1F8B,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F20, 0x1F92,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F21, 0x1F93,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F28, 0x1F9A,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F29, 0x1F9B,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F60, 0x1FA2,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F61, 0x1FA3,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F68, 0x1FAA,
    FcitxKey_Multi_key, FcitxKey_grave, 0x1F69, 0x1FAB,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_Greek_alpha, 0x1FB7,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_Greek_eta, 0x1FC7,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_Greek_omega, 0x1FF7,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F00, 0x1F86,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F01, 0x1F87,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F08, 0x1F8E,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F09, 0x1F8F,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F20, 0x1F96,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F21, 0x1F97,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F28, 0x1F9E,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F29, 0x1F9F,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F60, 0x1FA6,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F61, 0x1FA7,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F68, 0x1FAE,
    FcitxKey_Multi_key, FcitxKey_asciitilde, 0x1F69, 0x1FAF,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_Greek_alpha, 0x1FB4,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_Greek_eta, 0x1FC4,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_Greek_omega, 0x1FF4,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F00, 0x1F84,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F01, 0x1F85,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F08, 0x1F8C,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F09, 0x1F8D,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F20, 0x1F94,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F21, 0x1F95,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F28, 0x1F9C,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F29, 0x1F9D,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F60, 0x1FA4,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F61, 0x1FA5,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F68, 0x1FAC,
    FcitxKey_Multi_key, FcitxKey_acute, 0x1F69, 0x1FAD,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8B,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9B,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAB,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F83,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F93,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA3,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8A,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9A,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAA,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F82,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F92,
    FcitxKey_dead_grave, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA2,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_dead_acute, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8F,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9F,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAF,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F87,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F97,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA7,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8E,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9E,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAE,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F86,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F96,
    FcitxKey_dead_tilde, FcitxKey_Multi_key, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA6,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Multi_key, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8B,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9B,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAB,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F83,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F93,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA3,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8A,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9A,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAA,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F82,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F92,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA2,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8A,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9A,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAA,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F82,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F92,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA2,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8B,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9B,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAB,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F83,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F93,
    FcitxKey_Multi_key, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA3,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8F,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9F,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAF,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F87,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F97,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA7,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8E,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9E,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAE,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F86,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F96,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA6,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8E,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9E,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAE,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F86,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F96,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA6,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8F,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9F,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAF,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F87,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F97,
    FcitxKey_Multi_key, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA7,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Multi_key, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_kana_WO, 0x30FA,
    FcitxKey_kana_U, 0x30F4,
    FcitxKey_kana_KA, 0x30AC,
    FcitxKey_kana_KI, 0x30AE,
    FcitxKey_kana_KU, 0x30B0,
    FcitxKey_kana_KE, 0x30B2,
    FcitxKey_kana_KO, 0x30B4,
    FcitxKey_kana_SA, 0x30B6,
    FcitxKey_kana_SHI, 0x30B8,
    FcitxKey_kana_SU, 0x30BA,
    FcitxKey_kana_SE, 0x30BC,
    FcitxKey_kana_SO, 0x30BE,
    FcitxKey_kana_TA, 0x30C0,
    FcitxKey_kana_CHI, 0x30C2,
    FcitxKey_kana_TSU, 0x30C5,
    FcitxKey_kana_TE, 0x30C7,
    FcitxKey_kana_TO, 0x30C9,
    FcitxKey_kana_HA, 0x30D0,
    FcitxKey_kana_HI, 0x30D3,
    FcitxKey_kana_FU, 0x30D6,
    FcitxKey_kana_HE, 0x30D9,
    FcitxKey_kana_HO, 0x30DC,
    FcitxKey_kana_WA, 0x30F7,
    FcitxKey_kana_HA, 0x30D1,
    FcitxKey_kana_HI, 0x30D4,
    FcitxKey_kana_FU, 0x30D7,
    FcitxKey_kana_HE, 0x30DA,
    FcitxKey_kana_HO, 0x30DD,
    FcitxKey_plus, 0x2A25,
    FcitxKey_minus, 0x2A2A,
    FcitxKey_equal, 0x2A66,
    FcitxKey_Abreve, 0x1EB6,
    FcitxKey_abreve, 0x1EB7,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_O, 0x1EE2,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_U, 0x1EF0,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_o, 0x1EE3,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_u, 0x1EF1,
    FcitxKey_space, 0x0309,
    FcitxKey_B, 0x0181,
    FcitxKey_C, 0x0187,
    FcitxKey_D, 0x018A,
    FcitxKey_F, 0x0191,
    FcitxKey_G, 0x0193,
    FcitxKey_K, 0x0198,
    FcitxKey_M, 0x2C6E,
    FcitxKey_N, 0x019D,
    FcitxKey_P, 0x01A4,
    FcitxKey_T, 0x01AC,
    FcitxKey_V, 0x01B2,
    FcitxKey_W, 0x2C72,
    FcitxKey_Z, 0x0224,
    FcitxKey_b, 0x0253,
    FcitxKey_c, 0x0188,
    FcitxKey_d, 0x0257,
    FcitxKey_f, 0x0192,
    FcitxKey_g, 0x0260,
    FcitxKey_h, 0x0266,
    FcitxKey_k, 0x0199,
    FcitxKey_m, 0x0271,
    FcitxKey_n, 0x0272,
    FcitxKey_p, 0x01A5,
    FcitxKey_q, 0x02A0,
    FcitxKey_s, 0x0282,
    FcitxKey_t, 0x01AD,
    FcitxKey_v, 0x028B,
    FcitxKey_w, 0x2C73,
    FcitxKey_z, 0x0225,
    FcitxKey_nobreakspace, 0x0309,
    FcitxKey_Abreve, 0x1EB2,
    FcitxKey_abreve, 0x1EB3,
    0x0256, 0x1D91,
    FcitxKey_schwa, 0x025A,
    0x025C, 0x025D,
    0x025F, 0x0284,
    0x0279, 0x027B,
    FcitxKey_dead_hook, 0x0309,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_O, 0x1EDE,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_U, 0x1EEC,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_o, 0x1EDF,
    FcitxKey_Multi_key, FcitxKey_plus, FcitxKey_u, 0x1EED,
    FcitxKey_Multi_key, FcitxKey_U, FcitxKey_A, 0x1EB2,
    FcitxKey_Multi_key, FcitxKey_U, FcitxKey_a, 0x1EB3,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_A, 0x1EA8,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_E, 0x1EC2,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_O, 0x1ED4,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_a, 0x1EA9,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_e, 0x1EC3,
    FcitxKey_Multi_key, FcitxKey_asciicircum, FcitxKey_o, 0x1ED5,
    FcitxKey_Multi_key, FcitxKey_b, FcitxKey_A, 0x1EB2,
    FcitxKey_Multi_key, FcitxKey_b, FcitxKey_a, 0x1EB3,
    FcitxKey_Greek_ALPHA, 0x1F08,
    FcitxKey_Greek_EPSILON, 0x1F18,
    FcitxKey_Greek_ETA, 0x1F28,
    FcitxKey_Greek_IOTA, 0x1F38,
    FcitxKey_Greek_OMICRON, 0x1F48,
    FcitxKey_Greek_OMEGA, 0x1F68,
    FcitxKey_Greek_alpha, 0x1F00,
    FcitxKey_Greek_epsilon, 0x1F10,
    FcitxKey_Greek_eta, 0x1F20,
    FcitxKey_Greek_iota, 0x1F30,
    FcitxKey_Greek_omicron, 0x1F40,
    FcitxKey_Greek_rho, 0x1FE4,
    FcitxKey_Greek_upsilon, 0x1F50,
    FcitxKey_Greek_omega, 0x1F60,
    FcitxKey_Greek_ALPHA, 0x1F09,
    FcitxKey_Greek_EPSILON, 0x1F19,
    FcitxKey_Greek_ETA, 0x1F29,
    FcitxKey_Greek_IOTA, 0x1F39,
    FcitxKey_Greek_OMICRON, 0x1F49,
    FcitxKey_Greek_RHO, 0x1FEC,
    FcitxKey_Greek_UPSILON, 0x1F59,
    FcitxKey_Greek_OMEGA, 0x1F69,
    FcitxKey_Greek_alpha, 0x1F01,
    FcitxKey_Greek_epsilon, 0x1F11,
    FcitxKey_Greek_eta, 0x1F21,
    FcitxKey_Greek_iota, 0x1F31,
    FcitxKey_Greek_omicron, 0x1F41,
    FcitxKey_Greek_rho, 0x1FE5,
    FcitxKey_Greek_upsilon, 0x1F51,
    FcitxKey_Greek_omega, 0x1F61,
    FcitxKey_space, FcitxKey_space, 0x00A0,
    FcitxKey_space, FcitxKey_apostrophe, 0x0027,
    FcitxKey_space, FcitxKey_parenleft, 0x02D8,
    FcitxKey_space, FcitxKey_comma, 0x00B8,
    FcitxKey_space, FcitxKey_minus, 0x007E,
    FcitxKey_space, FcitxKey_period, 0x2008,
    FcitxKey_space, FcitxKey_less, 0x02C7,
    FcitxKey_space, FcitxKey_greater, 0x005E,
    FcitxKey_space, FcitxKey_asciicircum, 0x005E,
    FcitxKey_space, FcitxKey_grave, 0x0060,
    FcitxKey_space, FcitxKey_asciitilde, 0x007E,
    FcitxKey_exclam, FcitxKey_exclam, 0x00A1,
    FcitxKey_exclam, FcitxKey_question, 0x203D,
    FcitxKey_exclam, FcitxKey_A, 0x1EA0,
    FcitxKey_exclam, FcitxKey_B, 0x1E04,
    FcitxKey_exclam, FcitxKey_D, 0x1E0C,
    FcitxKey_exclam, FcitxKey_E, 0x1EB8,
    FcitxKey_exclam, FcitxKey_H, 0x1E24,
    FcitxKey_exclam, FcitxKey_I, 0x1ECA,
    FcitxKey_exclam, FcitxKey_K, 0x1E32,
    FcitxKey_exclam, FcitxKey_L, 0x1E36,
    FcitxKey_exclam, FcitxKey_M, 0x1E42,
    FcitxKey_exclam, FcitxKey_N, 0x1E46,
    FcitxKey_exclam, FcitxKey_O, 0x1ECC,
    FcitxKey_exclam, FcitxKey_P, 0x00B6,
    FcitxKey_exclam, FcitxKey_R, 0x1E5A,
    FcitxKey_exclam, FcitxKey_S, 0x00A7,
    FcitxKey_exclam, FcitxKey_T, 0x1E6C,
    FcitxKey_exclam, FcitxKey_U, 0x1EE4,
    FcitxKey_exclam, FcitxKey_V, 0x1E7E,
    FcitxKey_exclam, FcitxKey_W, 0x1E88,
    FcitxKey_exclam, FcitxKey_Y, 0x1EF4,
    FcitxKey_exclam, FcitxKey_Z, 0x1E92,
    FcitxKey_exclam, FcitxKey_asciicircum, 0x00A6,
    FcitxKey_exclam, FcitxKey_a, 0x1EA1,
    FcitxKey_exclam, FcitxKey_b, 0x1E05,
    FcitxKey_exclam, FcitxKey_d, 0x1E0D,
    FcitxKey_exclam, FcitxKey_e, 0x1EB9,
    FcitxKey_exclam, FcitxKey_h, 0x1E25,
    FcitxKey_exclam, FcitxKey_i, 0x1ECB,
    FcitxKey_exclam, FcitxKey_k, 0x1E33,
    FcitxKey_exclam, FcitxKey_l, 0x1E37,
    FcitxKey_exclam, FcitxKey_m, 0x1E43,
    FcitxKey_exclam, FcitxKey_n, 0x1E47,
    FcitxKey_exclam, FcitxKey_o, 0x1ECD,
    FcitxKey_exclam, FcitxKey_p, 0x00B6,
    FcitxKey_exclam, FcitxKey_r, 0x1E5B,
    FcitxKey_exclam, FcitxKey_s, 0x00A7,
    FcitxKey_exclam, FcitxKey_t, 0x1E6D,
    FcitxKey_exclam, FcitxKey_u, 0x1EE5,
    FcitxKey_exclam, FcitxKey_v, 0x1E7F,
    FcitxKey_exclam, FcitxKey_w, 0x1E89,
    FcitxKey_exclam, FcitxKey_y, 0x1EF5,
    FcitxKey_exclam, FcitxKey_z, 0x1E93,
    FcitxKey_exclam, FcitxKey_Ohorn, 0x1EE2,
    FcitxKey_exclam, FcitxKey_ohorn, 0x1EE3,
    FcitxKey_exclam, FcitxKey_Uhorn, 0x1EF0,
    FcitxKey_exclam, FcitxKey_uhorn, 0x1EF1,
    FcitxKey_quotedbl, FcitxKey_quotedbl, 0x00A8,
    FcitxKey_quotedbl, FcitxKey_apostrophe, 0x0344,
    FcitxKey_quotedbl, FcitxKey_comma, 0x201E,
    FcitxKey_quotedbl, FcitxKey_slash, 0x301E,
    FcitxKey_quotedbl, FcitxKey_less, 0x201C,
    FcitxKey_quotedbl, FcitxKey_greater, 0x201D,
    FcitxKey_quotedbl, FcitxKey_A, 0x00C4,
    FcitxKey_quotedbl, FcitxKey_E, 0x00CB,
    FcitxKey_quotedbl, FcitxKey_H, 0x1E26,
    FcitxKey_quotedbl, FcitxKey_I, 0x00CF,
    FcitxKey_quotedbl, FcitxKey_O, 0x00D6,
    FcitxKey_quotedbl, FcitxKey_U, 0x00DC,
    FcitxKey_quotedbl, FcitxKey_W, 0x1E84,
    FcitxKey_quotedbl, FcitxKey_X, 0x1E8C,
    FcitxKey_quotedbl, FcitxKey_Y, 0x0178,
    FcitxKey_quotedbl, FcitxKey_backslash, 0x301D,
    FcitxKey_quotedbl, FcitxKey_a, 0x00E4,
    FcitxKey_quotedbl, FcitxKey_e, 0x00EB,
    FcitxKey_quotedbl, FcitxKey_h, 0x1E27,
    FcitxKey_quotedbl, FcitxKey_i, 0x00EF,
    FcitxKey_quotedbl, FcitxKey_o, 0x00F6,
    FcitxKey_quotedbl, FcitxKey_t, 0x1E97,
    FcitxKey_quotedbl, FcitxKey_u, 0x00FC,
    FcitxKey_quotedbl, FcitxKey_w, 0x1E85,
    FcitxKey_quotedbl, FcitxKey_x, 0x1E8D,
    FcitxKey_quotedbl, FcitxKey_y, 0x00FF,
    FcitxKey_quotedbl, FcitxKey_acute, 0x0344,
    FcitxKey_quotedbl, FcitxKey_Otilde, 0x1E4E,
    FcitxKey_quotedbl, FcitxKey_otilde, 0x1E4F,
    FcitxKey_quotedbl, 0x03D2, 0x03D4,
    FcitxKey_quotedbl, FcitxKey_Umacron, 0x1E7A,
    FcitxKey_quotedbl, FcitxKey_umacron, 0x1E7B,
    FcitxKey_quotedbl, 0x04D8, 0x04DA,
    FcitxKey_quotedbl, 0x04D9, 0x04DB,
    FcitxKey_quotedbl, 0x04E8, 0x04EA,
    FcitxKey_quotedbl, 0x04E9, 0x04EB,
    FcitxKey_quotedbl, FcitxKey_Ukrainian_i, 0x0457,
    FcitxKey_quotedbl, FcitxKey_Ukrainian_I, 0x0407,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_a, 0x04D3,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_ie, 0x0451,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_i, 0x04E5,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_o, 0x04E7,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_u, 0x04F1,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_zhe, 0x04DD,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_yeru, 0x04F9,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_ze, 0x04DF,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_e, 0x04ED,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_che, 0x04F5,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_A, 0x04D2,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_IE, 0x0401,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_I, 0x04E4,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_O, 0x04E6,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_U, 0x04F0,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_ZHE, 0x04DC,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_YERU, 0x04F8,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_ZE, 0x04DE,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_E, 0x04EC,
    FcitxKey_quotedbl, FcitxKey_Cyrillic_CHE, 0x04F4,
    FcitxKey_quotedbl, FcitxKey_Greek_IOTA, 0x03AA,
    FcitxKey_quotedbl, FcitxKey_Greek_UPSILON, 0x03AB,
    FcitxKey_quotedbl, FcitxKey_Greek_iota, 0x03CA,
    FcitxKey_quotedbl, FcitxKey_Greek_upsilon, 0x03CB,
    FcitxKey_quotedbl, FcitxKey_dead_acute, 0x0344,
    FcitxKey_numbersign, FcitxKey_numbersign, 0x266F,
    FcitxKey_numbersign, FcitxKey_b, 0x266D,
    FcitxKey_numbersign, FcitxKey_f, 0x266E,
    FcitxKey_percent, FcitxKey_o, 0x2030,
    FcitxKey_apostrophe, FcitxKey_space, 0x0027,
    FcitxKey_apostrophe, FcitxKey_apostrophe, 0x00B4,
    FcitxKey_apostrophe, FcitxKey_comma, 0x201A,
    FcitxKey_apostrophe, FcitxKey_less, 0x2018,
    FcitxKey_apostrophe, FcitxKey_greater, 0x2019,
    FcitxKey_apostrophe, FcitxKey_A, 0x00C1,
    FcitxKey_apostrophe, FcitxKey_C, 0x0106,
    FcitxKey_apostrophe, FcitxKey_E, 0x00C9,
    FcitxKey_apostrophe, FcitxKey_G, 0x01F4,
    FcitxKey_apostrophe, FcitxKey_I, 0x00CD,
    FcitxKey_apostrophe, FcitxKey_K, 0x1E30,
    FcitxKey_apostrophe, FcitxKey_L, 0x0139,
    FcitxKey_apostrophe, FcitxKey_M, 0x1E3E,
    FcitxKey_apostrophe, FcitxKey_N, 0x0143,
    FcitxKey_apostrophe, FcitxKey_O, 0x00D3,
    FcitxKey_apostrophe, FcitxKey_P, 0x1E54,
    FcitxKey_apostrophe, FcitxKey_R, 0x0154,
    FcitxKey_apostrophe, FcitxKey_S, 0x015A,
    FcitxKey_apostrophe, FcitxKey_U, 0x00DA,
    FcitxKey_apostrophe, FcitxKey_W, 0x1E82,
    FcitxKey_apostrophe, FcitxKey_Y, 0x00DD,
    FcitxKey_apostrophe, FcitxKey_Z, 0x0179,
    FcitxKey_apostrophe, FcitxKey_a, 0x00E1,
    FcitxKey_apostrophe, FcitxKey_c, 0x0107,
    FcitxKey_apostrophe, FcitxKey_e, 0x00E9,
    FcitxKey_apostrophe, FcitxKey_g, 0x01F5,
    FcitxKey_apostrophe, FcitxKey_i, 0x00ED,
    FcitxKey_apostrophe, FcitxKey_k, 0x1E31,
    FcitxKey_apostrophe, FcitxKey_l, 0x013A,
    FcitxKey_apostrophe, FcitxKey_m, 0x1E3F,
    FcitxKey_apostrophe, FcitxKey_n, 0x0144,
    FcitxKey_apostrophe, FcitxKey_o, 0x00F3,
    FcitxKey_apostrophe, FcitxKey_p, 0x1E55,
    FcitxKey_apostrophe, FcitxKey_r, 0x0155,
    FcitxKey_apostrophe, FcitxKey_s, 0x015B,
    FcitxKey_apostrophe, FcitxKey_u, 0x00FA,
    FcitxKey_apostrophe, FcitxKey_w, 0x1E83,
    FcitxKey_apostrophe, FcitxKey_y, 0x00FD,
    FcitxKey_apostrophe, FcitxKey_z, 0x017A,
    FcitxKey_apostrophe, FcitxKey_Acircumflex, 0x1EA4,
    FcitxKey_apostrophe, FcitxKey_Aring, 0x01FA,
    FcitxKey_apostrophe, FcitxKey_AE, 0x01FC,
    FcitxKey_apostrophe, FcitxKey_Ccedilla, 0x1E08,
    FcitxKey_apostrophe, FcitxKey_Ecircumflex, 0x1EBE,
    FcitxKey_apostrophe, FcitxKey_Idiaeresis, 0x1E2E,
    FcitxKey_apostrophe, FcitxKey_Ocircumflex, 0x1ED0,
    FcitxKey_apostrophe, FcitxKey_Otilde, 0x1E4C,
    FcitxKey_apostrophe, FcitxKey_Ooblique, 0x01FE,
    FcitxKey_apostrophe, 0x00DC, 0x01D7,
    FcitxKey_apostrophe, FcitxKey_acircumflex, 0x1EA5,
    FcitxKey_apostrophe, FcitxKey_aring, 0x01FB,
    FcitxKey_apostrophe, FcitxKey_ae, 0x01FD,
    FcitxKey_apostrophe, FcitxKey_ccedilla, 0x1E09,
    FcitxKey_apostrophe, FcitxKey_ecircumflex, 0x1EBF,
    FcitxKey_apostrophe, FcitxKey_idiaeresis, 0x1E2F,
    FcitxKey_apostrophe, FcitxKey_ocircumflex, 0x1ED1,
    FcitxKey_apostrophe, FcitxKey_otilde, 0x1E4D,
    FcitxKey_apostrophe, FcitxKey_oslash, 0x01FF,
    FcitxKey_apostrophe, FcitxKey_udiaeresis, 0x01D8,
    FcitxKey_apostrophe, FcitxKey_Ohorn, 0x1EDA,
    FcitxKey_apostrophe, FcitxKey_ohorn, 0x1EDB,
    FcitxKey_apostrophe, FcitxKey_Uhorn, 0x1EE8,
    FcitxKey_apostrophe, FcitxKey_uhorn, 0x1EE9,
    FcitxKey_apostrophe, FcitxKey_Abreve, 0x1EAE,
    FcitxKey_apostrophe, FcitxKey_abreve, 0x1EAF,
    FcitxKey_apostrophe, FcitxKey_Emacron, 0x1E16,
    FcitxKey_apostrophe, FcitxKey_emacron, 0x1E17,
    FcitxKey_apostrophe, FcitxKey_Omacron, 0x1E52,
    FcitxKey_apostrophe, FcitxKey_Utilde, 0x1E78,
    FcitxKey_apostrophe, FcitxKey_omacron, 0x1E53,
    FcitxKey_apostrophe, FcitxKey_utilde, 0x1E79,
    FcitxKey_apostrophe, FcitxKey_Cyrillic_ghe, 0x0453,
    FcitxKey_apostrophe, FcitxKey_Cyrillic_ka, 0x045C,
    FcitxKey_apostrophe, FcitxKey_Cyrillic_GHE, 0x0403,
    FcitxKey_apostrophe, FcitxKey_Cyrillic_KA, 0x040C,
    FcitxKey_apostrophe, FcitxKey_Greek_iotadieresis, 0x0390,
    FcitxKey_apostrophe, FcitxKey_Greek_upsilondieresis, 0x03B0,
    FcitxKey_apostrophe, FcitxKey_Greek_ALPHA, 0x0386,
    FcitxKey_apostrophe, FcitxKey_Greek_EPSILON, 0x0388,
    FcitxKey_apostrophe, FcitxKey_Greek_ETA, 0x0389,
    FcitxKey_apostrophe, FcitxKey_Greek_IOTA, 0x038A,
    FcitxKey_apostrophe, FcitxKey_Greek_OMICRON, 0x038C,
    FcitxKey_apostrophe, FcitxKey_Greek_UPSILON, 0x038E,
    FcitxKey_apostrophe, FcitxKey_Greek_OMEGA, 0x038F,
    FcitxKey_apostrophe, FcitxKey_Greek_alpha, 0x03AC,
    FcitxKey_apostrophe, FcitxKey_Greek_epsilon, 0x03AD,
    FcitxKey_apostrophe, FcitxKey_Greek_eta, 0x03AE,
    FcitxKey_apostrophe, FcitxKey_Greek_iota, 0x03AF,
    FcitxKey_apostrophe, FcitxKey_Greek_omicron, 0x03CC,
    FcitxKey_apostrophe, FcitxKey_Greek_upsilon, 0x03CD,
    FcitxKey_apostrophe, FcitxKey_Greek_omega, 0x03CE,
    FcitxKey_apostrophe, 0x1F00, 0x1F04,
    FcitxKey_apostrophe, 0x1F01, 0x1F05,
    FcitxKey_apostrophe, 0x1F08, 0x1F0C,
    FcitxKey_apostrophe, 0x1F09, 0x1F0D,
    FcitxKey_apostrophe, 0x1F10, 0x1F14,
    FcitxKey_apostrophe, 0x1F11, 0x1F15,
    FcitxKey_apostrophe, 0x1F18, 0x1F1C,
    FcitxKey_apostrophe, 0x1F19, 0x1F1D,
    FcitxKey_apostrophe, 0x1F20, 0x1F24,
    FcitxKey_apostrophe, 0x1F21, 0x1F25,
    FcitxKey_apostrophe, 0x1F28, 0x1F2C,
    FcitxKey_apostrophe, 0x1F29, 0x1F2D,
    FcitxKey_apostrophe, 0x1F30, 0x1F34,
    FcitxKey_apostrophe, 0x1F31, 0x1F35,
    FcitxKey_apostrophe, 0x1F38, 0x1F3C,
    FcitxKey_apostrophe, 0x1F39, 0x1F3D,
    FcitxKey_apostrophe, 0x1F40, 0x1F44,
    FcitxKey_apostrophe, 0x1F41, 0x1F45,
    FcitxKey_apostrophe, 0x1F48, 0x1F4C,
    FcitxKey_apostrophe, 0x1F49, 0x1F4D,
    FcitxKey_apostrophe, 0x1F50, 0x1F54,
    FcitxKey_apostrophe, 0x1F51, 0x1F55,
    FcitxKey_apostrophe, 0x1F59, 0x1F5D,
    FcitxKey_apostrophe, 0x1F60, 0x1F64,
    FcitxKey_apostrophe, 0x1F61, 0x1F65,
    FcitxKey_apostrophe, 0x1F68, 0x1F6C,
    FcitxKey_apostrophe, 0x1F69, 0x1F6D,
    FcitxKey_parenleft, FcitxKey_space, 0x02D8,
    FcitxKey_parenleft, FcitxKey_parenleft, 0x005B,
    FcitxKey_parenleft, FcitxKey_minus, 0x007B,
    FcitxKey_parenleft, FcitxKey_A, 0x0102,
    FcitxKey_parenleft, FcitxKey_G, 0x011E,
    FcitxKey_parenleft, FcitxKey_a, 0x0103,
    FcitxKey_parenleft, FcitxKey_c, 0x00A9,
    FcitxKey_parenleft, FcitxKey_g, 0x011F,
    FcitxKey_parenleft, FcitxKey_r, 0x00AE,
    FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F09,
    FcitxKey_parenleft, FcitxKey_Greek_EPSILON, 0x1F19,
    FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F29,
    FcitxKey_parenleft, FcitxKey_Greek_IOTA, 0x1F39,
    FcitxKey_parenleft, FcitxKey_Greek_OMICRON, 0x1F49,
    FcitxKey_parenleft, FcitxKey_Greek_RHO, 0x1FEC,
    FcitxKey_parenleft, FcitxKey_Greek_UPSILON, 0x1F59,
    FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1F69,
    FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F01,
    FcitxKey_parenleft, FcitxKey_Greek_epsilon, 0x1F11,
    FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F21,
    FcitxKey_parenleft, FcitxKey_Greek_iota, 0x1F31,
    FcitxKey_parenleft, FcitxKey_Greek_omicron, 0x1F41,
    FcitxKey_parenleft, FcitxKey_Greek_rho, 0x1FE5,
    FcitxKey_parenleft, FcitxKey_Greek_upsilon, 0x1F51,
    FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1F61,
    FcitxKey_parenright, FcitxKey_parenright, 0x005D,
    FcitxKey_parenright, FcitxKey_minus, 0x007D,
    FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F08,
    FcitxKey_parenright, FcitxKey_Greek_EPSILON, 0x1F18,
    FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F28,
    FcitxKey_parenright, FcitxKey_Greek_IOTA, 0x1F38,
    FcitxKey_parenright, FcitxKey_Greek_OMICRON, 0x1F48,
    FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1F68,
    FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F00,
    FcitxKey_parenright, FcitxKey_Greek_epsilon, 0x1F10,
    FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F20,
    FcitxKey_parenright, FcitxKey_Greek_iota, 0x1F30,
    FcitxKey_parenright, FcitxKey_Greek_omicron, 0x1F40,
    FcitxKey_parenright, FcitxKey_Greek_rho, 0x1FE4,
    FcitxKey_parenright, FcitxKey_Greek_upsilon, 0x1F50,
    FcitxKey_parenright, FcitxKey_Greek_omega, 0x1F60,
    FcitxKey_asterisk, FcitxKey_0, 0x00B0,
    FcitxKey_asterisk, FcitxKey_A, 0x00C5,
    FcitxKey_asterisk, FcitxKey_U, 0x016E,
    FcitxKey_asterisk, FcitxKey_a, 0x00E5,
    FcitxKey_asterisk, FcitxKey_u, 0x016F,
    FcitxKey_plus, FcitxKey_plus, 0x0023,
    FcitxKey_plus, FcitxKey_minus, 0x00B1,
    FcitxKey_plus, FcitxKey_O, 0x01A0,
    FcitxKey_plus, FcitxKey_U, 0x01AF,
    FcitxKey_plus, FcitxKey_o, 0x01A1,
    FcitxKey_plus, FcitxKey_u, 0x01B0,
    FcitxKey_comma, FcitxKey_space, 0x00B8,
    FcitxKey_comma, FcitxKey_quotedbl, 0x201E,
    FcitxKey_comma, FcitxKey_apostrophe, 0x201A,
    FcitxKey_comma, FcitxKey_comma, 0x00B8,
    FcitxKey_comma, FcitxKey_minus, 0x00AC,
    FcitxKey_comma, FcitxKey_A, 0x0104,
    FcitxKey_comma, FcitxKey_C, 0x00C7,
    FcitxKey_comma, FcitxKey_D, 0x1E10,
    FcitxKey_comma, FcitxKey_E, 0x0118,
    FcitxKey_comma, FcitxKey_G, 0x0122,
    FcitxKey_comma, FcitxKey_H, 0x1E28,
    FcitxKey_comma, FcitxKey_I, 0x012E,
    FcitxKey_comma, FcitxKey_K, 0x0136,
    FcitxKey_comma, FcitxKey_L, 0x013B,
    FcitxKey_comma, FcitxKey_N, 0x0145,
    FcitxKey_comma, FcitxKey_R, 0x0156,
    FcitxKey_comma, FcitxKey_S, 0x015E,
    FcitxKey_comma, FcitxKey_T, 0x0162,
    FcitxKey_comma, FcitxKey_U, 0x0172,
    FcitxKey_comma, FcitxKey_a, 0x0105,
    FcitxKey_comma, FcitxKey_c, 0x00E7,
    FcitxKey_comma, FcitxKey_d, 0x1E11,
    FcitxKey_comma, FcitxKey_e, 0x0119,
    FcitxKey_comma, FcitxKey_g, 0x0123,
    FcitxKey_comma, FcitxKey_h, 0x1E29,
    FcitxKey_comma, FcitxKey_i, 0x012F,
    FcitxKey_comma, FcitxKey_k, 0x0137,
    FcitxKey_comma, FcitxKey_l, 0x013C,
    FcitxKey_comma, FcitxKey_n, 0x0146,
    FcitxKey_comma, FcitxKey_r, 0x0157,
    FcitxKey_comma, FcitxKey_s, 0x015F,
    FcitxKey_comma, FcitxKey_t, 0x0163,
    FcitxKey_comma, FcitxKey_u, 0x0173,
    FcitxKey_minus, FcitxKey_space, 0x007E,
    FcitxKey_minus, FcitxKey_parenleft, 0x007B,
    FcitxKey_minus, FcitxKey_parenright, 0x007D,
    FcitxKey_minus, FcitxKey_plus, 0x00B1,
    FcitxKey_minus, FcitxKey_comma, 0x00AC,
    FcitxKey_minus, FcitxKey_colon, 0x00F7,
    FcitxKey_minus, FcitxKey_A, 0x00C3,
    FcitxKey_minus, FcitxKey_D, 0x0110,
    FcitxKey_minus, FcitxKey_E, 0x0112,
    FcitxKey_minus, FcitxKey_I, 0x012A,
    FcitxKey_minus, FcitxKey_L, 0x00A3,
    FcitxKey_minus, FcitxKey_N, 0x00D1,
    FcitxKey_minus, FcitxKey_O, 0x00D5,
    FcitxKey_minus, FcitxKey_U, 0x016A,
    FcitxKey_minus, FcitxKey_Y, 0x00A5,
    FcitxKey_minus, FcitxKey_asciicircum, 0x00AF,
    FcitxKey_minus, FcitxKey_a, 0x00E3,
    FcitxKey_minus, FcitxKey_d, 0x0111,
    FcitxKey_minus, FcitxKey_e, 0x0113,
    FcitxKey_minus, FcitxKey_i, 0x012B,
    FcitxKey_minus, FcitxKey_l, 0x00A3,
    FcitxKey_minus, FcitxKey_n, 0x00F1,
    FcitxKey_minus, FcitxKey_o, 0x00F5,
    FcitxKey_minus, FcitxKey_u, 0x016B,
    FcitxKey_minus, FcitxKey_y, 0x00A5,
    FcitxKey_period, FcitxKey_minus, 0x00B7,
    FcitxKey_period, FcitxKey_period, 0x02D9,
    FcitxKey_period, FcitxKey_less, 0x2039,
    FcitxKey_period, FcitxKey_equal, 0x2022,
    FcitxKey_period, FcitxKey_greater, 0x203A,
    FcitxKey_period, FcitxKey_A, 0x0226,
    FcitxKey_period, FcitxKey_B, 0x1E02,
    FcitxKey_period, FcitxKey_C, 0x010A,
    FcitxKey_period, FcitxKey_D, 0x1E0A,
    FcitxKey_period, FcitxKey_E, 0x0116,
    FcitxKey_period, FcitxKey_F, 0x1E1E,
    FcitxKey_period, FcitxKey_G, 0x0120,
    FcitxKey_period, FcitxKey_H, 0x1E22,
    FcitxKey_period, FcitxKey_I, 0x0130,
    FcitxKey_period, FcitxKey_M, 0x1E40,
    FcitxKey_period, FcitxKey_N, 0x1E44,
    FcitxKey_period, FcitxKey_O, 0x022E,
    FcitxKey_period, FcitxKey_P, 0x1E56,
    FcitxKey_period, FcitxKey_R, 0x1E58,
    FcitxKey_period, FcitxKey_S, 0x1E60,
    FcitxKey_period, FcitxKey_T, 0x1E6A,
    FcitxKey_period, FcitxKey_W, 0x1E86,
    FcitxKey_period, FcitxKey_X, 0x1E8A,
    FcitxKey_period, FcitxKey_Y, 0x1E8E,
    FcitxKey_period, FcitxKey_Z, 0x017B,
    FcitxKey_period, FcitxKey_asciicircum, 0x00B7,
    FcitxKey_period, FcitxKey_a, 0x0227,
    FcitxKey_period, FcitxKey_b, 0x1E03,
    FcitxKey_period, FcitxKey_c, 0x010B,
    FcitxKey_period, FcitxKey_d, 0x1E0B,
    FcitxKey_period, FcitxKey_e, 0x0117,
    FcitxKey_period, FcitxKey_f, 0x1E1F,
    FcitxKey_period, FcitxKey_g, 0x0121,
    FcitxKey_period, FcitxKey_h, 0x1E23,
    FcitxKey_period, FcitxKey_i, 0x0131,
    FcitxKey_period, FcitxKey_m, 0x1E41,
    FcitxKey_period, FcitxKey_n, 0x1E45,
    FcitxKey_period, FcitxKey_o, 0x022F,
    FcitxKey_period, FcitxKey_p, 0x1E57,
    FcitxKey_period, FcitxKey_r, 0x1E59,
    FcitxKey_period, FcitxKey_s, 0x1E61,
    FcitxKey_period, FcitxKey_t, 0x1E6B,
    FcitxKey_period, FcitxKey_w, 0x1E87,
    FcitxKey_period, FcitxKey_x, 0x1E8B,
    FcitxKey_period, FcitxKey_y, 0x1E8F,
    FcitxKey_period, FcitxKey_z, 0x017C,
    FcitxKey_period, 0x017F, 0x1E9B,
    FcitxKey_period, FcitxKey_Sacute, 0x1E64,
    FcitxKey_period, FcitxKey_Scaron, 0x1E66,
    FcitxKey_period, FcitxKey_sacute, 0x1E65,
    FcitxKey_period, FcitxKey_scaron, 0x1E67,
    FcitxKey_period, 0x1E62, 0x1E68,
    FcitxKey_period, 0x1E63, 0x1E69,
    FcitxKey_slash, FcitxKey_slash, 0x005C,
    FcitxKey_slash, FcitxKey_less, 0x005C,
    FcitxKey_slash, FcitxKey_C, 0x00A2,
    FcitxKey_slash, FcitxKey_D, 0x0110,
    FcitxKey_slash, FcitxKey_G, 0x01E4,
    FcitxKey_slash, FcitxKey_H, 0x0126,
    FcitxKey_slash, FcitxKey_I, 0x0197,
    FcitxKey_slash, FcitxKey_L, 0x0141,
    FcitxKey_slash, FcitxKey_O, 0x00D8,
    FcitxKey_slash, FcitxKey_T, 0x0166,
    FcitxKey_slash, FcitxKey_U, 0x00B5,
    FcitxKey_slash, FcitxKey_Z, 0x01B5,
    FcitxKey_slash, FcitxKey_asciicircum, 0x007C,
    FcitxKey_slash, FcitxKey_b, 0x0180,
    FcitxKey_slash, FcitxKey_c, 0x00A2,
    FcitxKey_slash, FcitxKey_d, 0x0111,
    FcitxKey_slash, FcitxKey_g, 0x01E5,
    FcitxKey_slash, FcitxKey_h, 0x0127,
    FcitxKey_slash, FcitxKey_i, 0x0268,
    FcitxKey_slash, FcitxKey_l, 0x0142,
    FcitxKey_slash, FcitxKey_m, 0x20A5,
    FcitxKey_slash, FcitxKey_o, 0x00F8,
    FcitxKey_slash, FcitxKey_t, 0x0167,
    FcitxKey_slash, FcitxKey_u, 0x00B5,
    FcitxKey_slash, FcitxKey_z, 0x01B6,
    FcitxKey_slash, 0x0294, 0x02A1,
    FcitxKey_slash, 0x04AE, 0x04B0,
    FcitxKey_slash, 0x04AF, 0x04B1,
    FcitxKey_slash, FcitxKey_Cyrillic_ghe, 0x0493,
    FcitxKey_slash, FcitxKey_Cyrillic_ka, 0x049F,
    FcitxKey_slash, FcitxKey_Cyrillic_GHE, 0x0492,
    FcitxKey_slash, FcitxKey_Cyrillic_KA, 0x049E,
    FcitxKey_slash, FcitxKey_leftarrow, 0x219A,
    FcitxKey_slash, FcitxKey_rightarrow, 0x219B,
    FcitxKey_slash, 0x2194, 0x21AE,
    FcitxKey_0, FcitxKey_asterisk, 0x00B0,
    FcitxKey_0, FcitxKey_C, 0x00A9,
    FcitxKey_0, FcitxKey_S, 0x00A7,
    FcitxKey_0, FcitxKey_X, 0x00A4,
    FcitxKey_0, FcitxKey_asciicircum, 0x00B0,
    FcitxKey_0, FcitxKey_c, 0x00A9,
    FcitxKey_0, FcitxKey_s, 0x00A7,
    FcitxKey_0, FcitxKey_x, 0x00A4,
    FcitxKey_1, FcitxKey_2, 0x00BD,
    FcitxKey_1, FcitxKey_3, 0x2153,
    FcitxKey_1, FcitxKey_4, 0x00BC,
    FcitxKey_1, FcitxKey_5, 0x2155,
    FcitxKey_1, FcitxKey_6, 0x2159,
    FcitxKey_1, FcitxKey_8, 0x215B,
    FcitxKey_1, FcitxKey_S, 0x00B9,
    FcitxKey_1, FcitxKey_asciicircum, 0x00B9,
    FcitxKey_1, FcitxKey_s, 0x00B9,
    FcitxKey_2, FcitxKey_3, 0x2154,
    FcitxKey_2, FcitxKey_5, 0x2156,
    FcitxKey_2, FcitxKey_S, 0x00B2,
    FcitxKey_2, FcitxKey_asciicircum, 0x00B2,
    FcitxKey_2, FcitxKey_s, 0x00B2,
    FcitxKey_3, FcitxKey_4, 0x00BE,
    FcitxKey_3, FcitxKey_5, 0x2157,
    FcitxKey_3, FcitxKey_8, 0x215C,
    FcitxKey_3, FcitxKey_S, 0x00B3,
    FcitxKey_3, FcitxKey_asciicircum, 0x00B3,
    FcitxKey_3, FcitxKey_s, 0x00B3,
    FcitxKey_4, FcitxKey_5, 0x2158,
    FcitxKey_5, FcitxKey_6, 0x215A,
    FcitxKey_5, FcitxKey_8, 0x215D,
    FcitxKey_7, FcitxKey_8, 0x215E,
    FcitxKey_colon, FcitxKey_minus, 0x00F7,
    FcitxKey_semicolon, FcitxKey_A, 0x0104,
    FcitxKey_semicolon, FcitxKey_E, 0x0118,
    FcitxKey_semicolon, FcitxKey_I, 0x012E,
    FcitxKey_semicolon, FcitxKey_O, 0x01EA,
    FcitxKey_semicolon, FcitxKey_U, 0x0172,
    FcitxKey_semicolon, FcitxKey_a, 0x0105,
    FcitxKey_semicolon, FcitxKey_e, 0x0119,
    FcitxKey_semicolon, FcitxKey_i, 0x012F,
    FcitxKey_semicolon, FcitxKey_o, 0x01EB,
    FcitxKey_semicolon, FcitxKey_u, 0x0173,
    FcitxKey_less, FcitxKey_space, 0x02C7,
    FcitxKey_less, FcitxKey_quotedbl, 0x201C,
    FcitxKey_less, FcitxKey_apostrophe, 0x2018,
    FcitxKey_less, FcitxKey_slash, 0x005C,
    FcitxKey_less, FcitxKey_less, 0x00AB,
    FcitxKey_less, FcitxKey_C, 0x010C,
    FcitxKey_less, FcitxKey_D, 0x010E,
    FcitxKey_less, FcitxKey_E, 0x011A,
    FcitxKey_less, FcitxKey_L, 0x013D,
    FcitxKey_less, FcitxKey_N, 0x0147,
    FcitxKey_less, FcitxKey_R, 0x0158,
    FcitxKey_less, FcitxKey_S, 0x0160,
    FcitxKey_less, FcitxKey_T, 0x0164,
    FcitxKey_less, FcitxKey_Z, 0x017D,
    FcitxKey_less, FcitxKey_c, 0x010D,
    FcitxKey_less, FcitxKey_d, 0x010F,
    FcitxKey_less, FcitxKey_e, 0x011B,
    FcitxKey_less, FcitxKey_l, 0x013E,
    FcitxKey_less, FcitxKey_n, 0x0148,
    FcitxKey_less, FcitxKey_r, 0x0159,
    FcitxKey_less, FcitxKey_s, 0x0161,
    FcitxKey_less, FcitxKey_t, 0x0165,
    FcitxKey_less, FcitxKey_z, 0x017E,
    FcitxKey_less, 0x0338, 0x226E,
    FcitxKey_equal, FcitxKey_C, 0x20AC,
    FcitxKey_equal, FcitxKey_E, 0x20AC,
    FcitxKey_equal, FcitxKey_L, 0x00A3,
    FcitxKey_equal, FcitxKey_N, 0x20A6,
    FcitxKey_equal, FcitxKey_O, 0x0150,
    FcitxKey_equal, FcitxKey_U, 0x0170,
    FcitxKey_equal, FcitxKey_W, 0x20A9,
    FcitxKey_equal, FcitxKey_Y, 0x00A5,
    FcitxKey_equal, FcitxKey_c, 0x20AC,
    FcitxKey_equal, FcitxKey_e, 0x20AC,
    FcitxKey_equal, FcitxKey_l, 0x00A3,
    FcitxKey_equal, FcitxKey_o, 0x0151,
    FcitxKey_equal, FcitxKey_u, 0x0171,
    FcitxKey_equal, FcitxKey_y, 0x00A5,
    FcitxKey_equal, 0x0338, 0x2260,
    FcitxKey_equal, FcitxKey_Cyrillic_u, 0x04F3,
    FcitxKey_equal, FcitxKey_Cyrillic_IE, 0x20AC,
    FcitxKey_equal, FcitxKey_Cyrillic_ES, 0x20AC,
    FcitxKey_equal, FcitxKey_Cyrillic_U, 0x04F2,
    FcitxKey_greater, FcitxKey_space, 0x005E,
    FcitxKey_greater, FcitxKey_quotedbl, 0x201D,
    FcitxKey_greater, FcitxKey_apostrophe, 0x2019,
    FcitxKey_greater, FcitxKey_greater, 0x00BB,
    FcitxKey_greater, FcitxKey_A, 0x00C2,
    FcitxKey_greater, FcitxKey_E, 0x00CA,
    FcitxKey_greater, FcitxKey_I, 0x00CE,
    FcitxKey_greater, FcitxKey_O, 0x00D4,
    FcitxKey_greater, FcitxKey_U, 0x00DB,
    FcitxKey_greater, FcitxKey_a, 0x00E2,
    FcitxKey_greater, FcitxKey_e, 0x00EA,
    FcitxKey_greater, FcitxKey_i, 0x00EE,
    FcitxKey_greater, FcitxKey_o, 0x00F4,
    FcitxKey_greater, FcitxKey_u, 0x00FB,
    FcitxKey_greater, 0x0338, 0x226F,
    FcitxKey_question, FcitxKey_exclam, 0x203D,
    FcitxKey_question, FcitxKey_question, 0x00BF,
    FcitxKey_question, FcitxKey_A, 0x1EA2,
    FcitxKey_question, FcitxKey_E, 0x1EBA,
    FcitxKey_question, FcitxKey_I, 0x1EC8,
    FcitxKey_question, FcitxKey_O, 0x1ECE,
    FcitxKey_question, FcitxKey_U, 0x1EE6,
    FcitxKey_question, FcitxKey_Y, 0x1EF6,
    FcitxKey_question, FcitxKey_a, 0x1EA3,
    FcitxKey_question, FcitxKey_e, 0x1EBB,
    FcitxKey_question, FcitxKey_i, 0x1EC9,
    FcitxKey_question, FcitxKey_o, 0x1ECF,
    FcitxKey_question, FcitxKey_u, 0x1EE7,
    FcitxKey_question, FcitxKey_y, 0x1EF7,
    FcitxKey_question, FcitxKey_Acircumflex, 0x1EA8,
    FcitxKey_question, FcitxKey_Ecircumflex, 0x1EC2,
    FcitxKey_question, FcitxKey_Ocircumflex, 0x1ED4,
    FcitxKey_question, FcitxKey_acircumflex, 0x1EA9,
    FcitxKey_question, FcitxKey_ecircumflex, 0x1EC3,
    FcitxKey_question, FcitxKey_ocircumflex, 0x1ED5,
    FcitxKey_question, FcitxKey_Ohorn, 0x1EDE,
    FcitxKey_question, FcitxKey_ohorn, 0x1EDF,
    FcitxKey_question, FcitxKey_Uhorn, 0x1EEC,
    FcitxKey_question, FcitxKey_uhorn, 0x1EED,
    FcitxKey_question, FcitxKey_Abreve, 0x1EB2,
    FcitxKey_question, FcitxKey_abreve, 0x1EB3,
    FcitxKey_A, FcitxKey_quotedbl, 0x00C4,
    FcitxKey_A, FcitxKey_apostrophe, 0x00C1,
    FcitxKey_A, FcitxKey_parenleft, 0x0102,
    FcitxKey_A, FcitxKey_asterisk, 0x00C5,
    FcitxKey_A, FcitxKey_comma, 0x0104,
    FcitxKey_A, FcitxKey_minus, 0x00C3,
    FcitxKey_A, FcitxKey_greater, 0x00C2,
    FcitxKey_A, FcitxKey_A, 0x00C5,
    FcitxKey_A, FcitxKey_E, 0x00C6,
    FcitxKey_A, FcitxKey_T, 0x0040,
    FcitxKey_A, FcitxKey_asciicircum, 0x00C2,
    FcitxKey_A, FcitxKey_underscore, 0x00AA,
    FcitxKey_A, FcitxKey_grave, 0x00C0,
    FcitxKey_A, FcitxKey_asciitilde, 0x00C3,
    FcitxKey_A, FcitxKey_diaeresis, 0x00C4,
    FcitxKey_A, FcitxKey_acute, 0x00C1,
    FcitxKey_B, FcitxKey_period, 0x1E02,
    FcitxKey_C, FcitxKey_apostrophe, 0x0106,
    FcitxKey_C, FcitxKey_comma, 0x00C7,
    FcitxKey_C, FcitxKey_period, 0x010A,
    FcitxKey_C, FcitxKey_slash, 0x00A2,
    FcitxKey_C, FcitxKey_0, 0x00A9,
    FcitxKey_C, FcitxKey_less, 0x010C,
    FcitxKey_C, FcitxKey_equal, 0x20AC,
    FcitxKey_C, FcitxKey_E, 0x20A0,
    FcitxKey_C, FcitxKey_O, 0x00A9,
    FcitxKey_C, FcitxKey_o, 0x00A9,
    FcitxKey_C, FcitxKey_r, 0x20A2,
    FcitxKey_C, FcitxKey_bar, 0x00A2,
    FcitxKey_D, FcitxKey_minus, 0x0110,
    FcitxKey_D, FcitxKey_period, 0x1E0A,
    FcitxKey_D, FcitxKey_less, 0x010E,
    FcitxKey_D, FcitxKey_H, 0x00D0,
    FcitxKey_E, FcitxKey_quotedbl, 0x00CB,
    FcitxKey_E, FcitxKey_apostrophe, 0x00C9,
    FcitxKey_E, FcitxKey_comma, 0x0118,
    FcitxKey_E, FcitxKey_minus, 0x0112,
    FcitxKey_E, FcitxKey_period, 0x0116,
    FcitxKey_E, FcitxKey_less, 0x011A,
    FcitxKey_E, FcitxKey_equal, 0x20AC,
    FcitxKey_E, FcitxKey_greater, 0x00CA,
    FcitxKey_E, FcitxKey_asciicircum, 0x00CA,
    FcitxKey_E, FcitxKey_underscore, 0x0112,
    FcitxKey_E, FcitxKey_grave, 0x00C8,
    FcitxKey_E, FcitxKey_diaeresis, 0x00CB,
    FcitxKey_E, FcitxKey_acute, 0x00C9,
    FcitxKey_F, FcitxKey_period, 0x1E1E,
    FcitxKey_F, FcitxKey_r, 0x20A3,
    FcitxKey_G, FcitxKey_parenleft, 0x011E,
    FcitxKey_G, FcitxKey_comma, 0x0122,
    FcitxKey_G, FcitxKey_period, 0x0120,
    FcitxKey_G, FcitxKey_U, 0x011E,
    FcitxKey_G, FcitxKey_breve, 0x011E,
    FcitxKey_I, FcitxKey_quotedbl, 0x00CF,
    FcitxKey_I, FcitxKey_apostrophe, 0x00CD,
    FcitxKey_I, FcitxKey_comma, 0x012E,
    FcitxKey_I, FcitxKey_minus, 0x012A,
    FcitxKey_I, FcitxKey_period, 0x0130,
    FcitxKey_I, FcitxKey_greater, 0x00CE,
    FcitxKey_I, FcitxKey_asciicircum, 0x00CE,
    FcitxKey_I, FcitxKey_underscore, 0x012A,
    FcitxKey_I, FcitxKey_grave, 0x00CC,
    FcitxKey_I, FcitxKey_asciitilde, 0x0128,
    FcitxKey_I, FcitxKey_diaeresis, 0x00CF,
    FcitxKey_I, FcitxKey_acute, 0x00CD,
    FcitxKey_K, FcitxKey_comma, 0x0136,
    FcitxKey_L, FcitxKey_apostrophe, 0x0139,
    FcitxKey_L, FcitxKey_comma, 0x013B,
    FcitxKey_L, FcitxKey_minus, 0x00A3,
    FcitxKey_L, FcitxKey_slash, 0x0141,
    FcitxKey_L, FcitxKey_less, 0x013D,
    FcitxKey_L, FcitxKey_equal, 0x00A3,
    FcitxKey_L, FcitxKey_V, 0x007C,
    FcitxKey_M, FcitxKey_period, 0x1E40,
    FcitxKey_N, FcitxKey_apostrophe, 0x0143,
    FcitxKey_N, FcitxKey_comma, 0x0145,
    FcitxKey_N, FcitxKey_minus, 0x00D1,
    FcitxKey_N, FcitxKey_less, 0x0147,
    FcitxKey_N, FcitxKey_equal, 0x20A6,
    FcitxKey_N, FcitxKey_G, 0x014A,
    FcitxKey_N, FcitxKey_O, 0x2116,
    FcitxKey_N, FcitxKey_o, 0x2116,
    FcitxKey_N, FcitxKey_asciitilde, 0x00D1,
    FcitxKey_O, FcitxKey_quotedbl, 0x00D6,
    FcitxKey_O, FcitxKey_apostrophe, 0x00D3,
    FcitxKey_O, FcitxKey_minus, 0x00D5,
    FcitxKey_O, FcitxKey_slash, 0x00D8,
    FcitxKey_O, FcitxKey_greater, 0x00D4,
    FcitxKey_O, FcitxKey_C, 0x00A9,
    FcitxKey_O, FcitxKey_E, 0x0152,
    FcitxKey_O, FcitxKey_R, 0x00AE,
    FcitxKey_O, FcitxKey_S, 0x00A7,
    FcitxKey_O, FcitxKey_X, 0x00A4,
    FcitxKey_O, FcitxKey_asciicircum, 0x00D4,
    FcitxKey_O, FcitxKey_underscore, 0x00BA,
    FcitxKey_O, FcitxKey_grave, 0x00D2,
    FcitxKey_O, FcitxKey_c, 0x00A9,
    FcitxKey_O, FcitxKey_r, 0x00AE,
    FcitxKey_O, FcitxKey_x, 0x00A4,
    FcitxKey_O, FcitxKey_asciitilde, 0x00D5,
    FcitxKey_O, FcitxKey_diaeresis, 0x00D6,
    FcitxKey_O, FcitxKey_acute, 0x00D3,
    FcitxKey_P, FcitxKey_exclam, 0x00B6,
    FcitxKey_P, FcitxKey_period, 0x1E56,
    FcitxKey_P, FcitxKey_P, 0x00B6,
    FcitxKey_P, FcitxKey_t, 0x20A7,
    FcitxKey_R, FcitxKey_apostrophe, 0x0154,
    FcitxKey_R, FcitxKey_comma, 0x0156,
    FcitxKey_R, FcitxKey_less, 0x0158,
    FcitxKey_R, FcitxKey_O, 0x00AE,
    FcitxKey_R, FcitxKey_s, 0x20A8,
    FcitxKey_S, FcitxKey_exclam, 0x00A7,
    FcitxKey_S, FcitxKey_apostrophe, 0x015A,
    FcitxKey_S, FcitxKey_comma, 0x015E,
    FcitxKey_S, FcitxKey_period, 0x1E60,
    FcitxKey_S, FcitxKey_0, 0x00A7,
    FcitxKey_S, FcitxKey_1, 0x00B9,
    FcitxKey_S, FcitxKey_2, 0x00B2,
    FcitxKey_S, FcitxKey_3, 0x00B3,
    FcitxKey_S, FcitxKey_less, 0x0160,
    FcitxKey_S, FcitxKey_M, 0x2120,
    FcitxKey_S, FcitxKey_O, 0x00A7,
    FcitxKey_S, FcitxKey_m, 0x2120,
    FcitxKey_S, FcitxKey_cedilla, 0x015E,
    FcitxKey_T, FcitxKey_minus, 0x0166,
    FcitxKey_T, FcitxKey_period, 0x1E6A,
    FcitxKey_T, FcitxKey_slash, 0x0166,
    FcitxKey_T, FcitxKey_less, 0x0164,
    FcitxKey_T, FcitxKey_H, 0x00DE,
    FcitxKey_T, FcitxKey_M, 0x2122,
    FcitxKey_T, FcitxKey_m, 0x2122,
    FcitxKey_U, FcitxKey_quotedbl, 0x00DC,
    FcitxKey_U, FcitxKey_apostrophe, 0x00DA,
    FcitxKey_U, FcitxKey_asterisk, 0x016E,
    FcitxKey_U, FcitxKey_comma, 0x0172,
    FcitxKey_U, FcitxKey_minus, 0x016A,
    FcitxKey_U, FcitxKey_slash, 0x00B5,
    FcitxKey_U, FcitxKey_greater, 0x00DB,
    FcitxKey_U, FcitxKey_A, 0x0102,
    FcitxKey_U, FcitxKey_E, 0x0114,
    FcitxKey_U, FcitxKey_G, 0x011E,
    FcitxKey_U, FcitxKey_I, 0x012C,
    FcitxKey_U, FcitxKey_O, 0x014E,
    FcitxKey_U, FcitxKey_U, 0x016C,
    FcitxKey_U, FcitxKey_asciicircum, 0x00DB,
    FcitxKey_U, FcitxKey_underscore, 0x016A,
    FcitxKey_U, FcitxKey_grave, 0x00D9,
    FcitxKey_U, FcitxKey_a, 0x0103,
    FcitxKey_U, FcitxKey_e, 0x0115,
    FcitxKey_U, FcitxKey_g, 0x011F,
    FcitxKey_U, FcitxKey_i, 0x012D,
    FcitxKey_U, FcitxKey_o, 0x014F,
    FcitxKey_U, FcitxKey_u, 0x016D,
    FcitxKey_U, FcitxKey_asciitilde, 0x0168,
    FcitxKey_U, FcitxKey_diaeresis, 0x00DC,
    FcitxKey_U, FcitxKey_acute, 0x00DA,
    FcitxKey_U, 0x0228, 0x1E1C,
    FcitxKey_U, 0x0229, 0x1E1D,
    FcitxKey_U, FcitxKey_Cyrillic_a, 0x04D1,
    FcitxKey_U, FcitxKey_Cyrillic_ie, 0x04D7,
    FcitxKey_U, FcitxKey_Cyrillic_i, 0x0439,
    FcitxKey_U, FcitxKey_Cyrillic_u, 0x045E,
    FcitxKey_U, FcitxKey_Cyrillic_zhe, 0x04C2,
    FcitxKey_U, FcitxKey_Cyrillic_A, 0x04D0,
    FcitxKey_U, FcitxKey_Cyrillic_IE, 0x04D6,
    FcitxKey_U, FcitxKey_Cyrillic_I, 0x0419,
    FcitxKey_U, FcitxKey_Cyrillic_U, 0x040E,
    FcitxKey_U, FcitxKey_Cyrillic_ZHE, 0x04C1,
    FcitxKey_U, FcitxKey_Greek_ALPHA, 0x1FB8,
    FcitxKey_U, FcitxKey_Greek_IOTA, 0x1FD8,
    FcitxKey_U, FcitxKey_Greek_UPSILON, 0x1FE8,
    FcitxKey_U, FcitxKey_Greek_alpha, 0x1FB0,
    FcitxKey_U, FcitxKey_Greek_iota, 0x1FD0,
    FcitxKey_U, FcitxKey_Greek_upsilon, 0x1FE0,
    FcitxKey_U, 0x1EA0, 0x1EB6,
    FcitxKey_U, 0x1EA1, 0x1EB7,
    FcitxKey_V, FcitxKey_L, 0x007C,
    FcitxKey_W, FcitxKey_equal, 0x20A9,
    FcitxKey_W, FcitxKey_asciicircum, 0x0174,
    FcitxKey_X, FcitxKey_0, 0x00A4,
    FcitxKey_X, FcitxKey_O, 0x00A4,
    FcitxKey_X, FcitxKey_o, 0x00A4,
    FcitxKey_Y, FcitxKey_quotedbl, 0x0178,
    FcitxKey_Y, FcitxKey_apostrophe, 0x00DD,
    FcitxKey_Y, FcitxKey_minus, 0x00A5,
    FcitxKey_Y, FcitxKey_equal, 0x00A5,
    FcitxKey_Y, FcitxKey_asciicircum, 0x0176,
    FcitxKey_Y, FcitxKey_diaeresis, 0x0178,
    FcitxKey_Y, FcitxKey_acute, 0x00DD,
    FcitxKey_Z, FcitxKey_apostrophe, 0x0179,
    FcitxKey_Z, FcitxKey_period, 0x017B,
    FcitxKey_Z, FcitxKey_less, 0x017D,
    FcitxKey_asciicircum, FcitxKey_space, 0x005E,
    FcitxKey_asciicircum, FcitxKey_parenleft, 0x207D,
    FcitxKey_asciicircum, FcitxKey_parenright, 0x207E,
    FcitxKey_asciicircum, FcitxKey_plus, 0x207A,
    FcitxKey_asciicircum, FcitxKey_minus, 0x00AF,
    FcitxKey_asciicircum, FcitxKey_period, 0x00B7,
    FcitxKey_asciicircum, FcitxKey_slash, 0x007C,
    FcitxKey_asciicircum, FcitxKey_0, 0x00B0,
    FcitxKey_asciicircum, FcitxKey_1, 0x00B9,
    FcitxKey_asciicircum, FcitxKey_2, 0x00B2,
    FcitxKey_asciicircum, FcitxKey_3, 0x00B3,
    FcitxKey_asciicircum, FcitxKey_4, 0x2074,
    FcitxKey_asciicircum, FcitxKey_5, 0x2075,
    FcitxKey_asciicircum, FcitxKey_6, 0x2076,
    FcitxKey_asciicircum, FcitxKey_7, 0x2077,
    FcitxKey_asciicircum, FcitxKey_8, 0x2078,
    FcitxKey_asciicircum, FcitxKey_9, 0x2079,
    FcitxKey_asciicircum, FcitxKey_equal, 0x207C,
    FcitxKey_asciicircum, FcitxKey_A, 0x00C2,
    FcitxKey_asciicircum, FcitxKey_C, 0x0108,
    FcitxKey_asciicircum, FcitxKey_E, 0x00CA,
    FcitxKey_asciicircum, FcitxKey_G, 0x011C,
    FcitxKey_asciicircum, FcitxKey_H, 0x0124,
    FcitxKey_asciicircum, FcitxKey_I, 0x00CE,
    FcitxKey_asciicircum, FcitxKey_J, 0x0134,
    FcitxKey_asciicircum, FcitxKey_O, 0x00D4,
    FcitxKey_asciicircum, FcitxKey_S, 0x015C,
    FcitxKey_asciicircum, FcitxKey_U, 0x00DB,
    FcitxKey_asciicircum, FcitxKey_W, 0x0174,
    FcitxKey_asciicircum, FcitxKey_Y, 0x0176,
    FcitxKey_asciicircum, FcitxKey_Z, 0x1E90,
    FcitxKey_asciicircum, FcitxKey_underscore, 0x00AF,
    FcitxKey_asciicircum, FcitxKey_a, 0x00E2,
    FcitxKey_asciicircum, FcitxKey_c, 0x0109,
    FcitxKey_asciicircum, FcitxKey_e, 0x00EA,
    FcitxKey_asciicircum, FcitxKey_g, 0x011D,
    FcitxKey_asciicircum, FcitxKey_h, 0x0125,
    FcitxKey_asciicircum, FcitxKey_i, 0x00EE,
    FcitxKey_asciicircum, FcitxKey_j, 0x0135,
    FcitxKey_asciicircum, FcitxKey_o, 0x00F4,
    FcitxKey_asciicircum, FcitxKey_s, 0x015D,
    FcitxKey_asciicircum, FcitxKey_u, 0x00FB,
    FcitxKey_asciicircum, FcitxKey_w, 0x0175,
    FcitxKey_asciicircum, FcitxKey_y, 0x0177,
    FcitxKey_asciicircum, FcitxKey_z, 0x1E91,
    FcitxKey_asciicircum, 0x1EA0, 0x1EAC,
    FcitxKey_asciicircum, 0x1EA1, 0x1EAD,
    FcitxKey_asciicircum, 0x1EB8, 0x1EC6,
    FcitxKey_asciicircum, 0x1EB9, 0x1EC7,
    FcitxKey_asciicircum, 0x1ECC, 0x1ED8,
    FcitxKey_asciicircum, 0x1ECD, 0x1ED9,
    FcitxKey_asciicircum, 0x2212, 0x207B,
    FcitxKey_asciicircum, 0x4E00, 0x3192,
    FcitxKey_asciicircum, 0x4E01, 0x319C,
    FcitxKey_asciicircum, 0x4E09, 0x3194,
    FcitxKey_asciicircum, 0x4E0A, 0x3196,
    FcitxKey_asciicircum, 0x4E0B, 0x3198,
    FcitxKey_asciicircum, 0x4E19, 0x319B,
    FcitxKey_asciicircum, 0x4E2D, 0x3197,
    FcitxKey_asciicircum, 0x4E59, 0x319A,
    FcitxKey_asciicircum, 0x4E8C, 0x3193,
    FcitxKey_asciicircum, 0x4EBA, 0x319F,
    FcitxKey_asciicircum, 0x56DB, 0x3195,
    FcitxKey_asciicircum, 0x5730, 0x319E,
    FcitxKey_asciicircum, 0x5929, 0x319D,
    FcitxKey_asciicircum, 0x7532, 0x3199,
    FcitxKey_asciicircum, FcitxKey_KP_Space, 0x00B2,
    FcitxKey_asciicircum, FcitxKey_KP_Add, 0x207A,
    FcitxKey_asciicircum, FcitxKey_KP_0, 0x2070,
    FcitxKey_asciicircum, FcitxKey_KP_1, 0x00B9,
    FcitxKey_asciicircum, FcitxKey_KP_2, 0x00B2,
    FcitxKey_asciicircum, FcitxKey_KP_3, 0x00B3,
    FcitxKey_asciicircum, FcitxKey_KP_4, 0x2074,
    FcitxKey_asciicircum, FcitxKey_KP_5, 0x2075,
    FcitxKey_asciicircum, FcitxKey_KP_6, 0x2076,
    FcitxKey_asciicircum, FcitxKey_KP_7, 0x2077,
    FcitxKey_asciicircum, FcitxKey_KP_8, 0x2078,
    FcitxKey_asciicircum, FcitxKey_KP_9, 0x2079,
    FcitxKey_asciicircum, FcitxKey_KP_Equal, 0x207C,
    FcitxKey_underscore, FcitxKey_parenleft, 0x208D,
    FcitxKey_underscore, FcitxKey_parenright, 0x208E,
    FcitxKey_underscore, FcitxKey_plus, 0x208A,
    FcitxKey_underscore, FcitxKey_0, 0x2080,
    FcitxKey_underscore, FcitxKey_1, 0x2081,
    FcitxKey_underscore, FcitxKey_2, 0x2082,
    FcitxKey_underscore, FcitxKey_3, 0x2083,
    FcitxKey_underscore, FcitxKey_4, 0x2084,
    FcitxKey_underscore, FcitxKey_5, 0x2085,
    FcitxKey_underscore, FcitxKey_6, 0x2086,
    FcitxKey_underscore, FcitxKey_7, 0x2087,
    FcitxKey_underscore, FcitxKey_8, 0x2088,
    FcitxKey_underscore, FcitxKey_9, 0x2089,
    FcitxKey_underscore, FcitxKey_equal, 0x208C,
    FcitxKey_underscore, FcitxKey_A, 0x00AA,
    FcitxKey_underscore, FcitxKey_E, 0x0112,
    FcitxKey_underscore, FcitxKey_G, 0x1E20,
    FcitxKey_underscore, FcitxKey_I, 0x012A,
    FcitxKey_underscore, FcitxKey_O, 0x00BA,
    FcitxKey_underscore, FcitxKey_U, 0x016A,
    FcitxKey_underscore, FcitxKey_Y, 0x0232,
    FcitxKey_underscore, FcitxKey_asciicircum, 0x00AF,
    FcitxKey_underscore, FcitxKey_underscore, 0x00AF,
    FcitxKey_underscore, FcitxKey_a, 0x00AA,
    FcitxKey_underscore, FcitxKey_e, 0x0113,
    FcitxKey_underscore, FcitxKey_g, 0x1E21,
    FcitxKey_underscore, FcitxKey_i, 0x012B,
    FcitxKey_underscore, FcitxKey_o, 0x00BA,
    FcitxKey_underscore, FcitxKey_u, 0x016B,
    FcitxKey_underscore, FcitxKey_y, 0x0233,
    FcitxKey_underscore, FcitxKey_Adiaeresis, 0x01DE,
    FcitxKey_underscore, FcitxKey_AE, 0x01E2,
    FcitxKey_underscore, FcitxKey_Otilde, 0x022C,
    FcitxKey_underscore, FcitxKey_Odiaeresis, 0x022A,
    FcitxKey_underscore, 0x00DC, 0x01D5,
    FcitxKey_underscore, FcitxKey_adiaeresis, 0x01DF,
    FcitxKey_underscore, FcitxKey_ae, 0x01E3,
    FcitxKey_underscore, FcitxKey_otilde, 0x022D,
    FcitxKey_underscore, FcitxKey_odiaeresis, 0x022B,
    FcitxKey_underscore, FcitxKey_udiaeresis, 0x01D6,
    FcitxKey_underscore, 0x01EA, 0x01EC,
    FcitxKey_underscore, 0x01EB, 0x01ED,
    FcitxKey_underscore, 0x0226, 0x01E0,
    FcitxKey_underscore, 0x0227, 0x01E1,
    FcitxKey_underscore, 0x022E, 0x0230,
    FcitxKey_underscore, 0x022F, 0x0231,
    FcitxKey_underscore, FcitxKey_Cyrillic_i, 0x04E3,
    FcitxKey_underscore, FcitxKey_Cyrillic_u, 0x04EF,
    FcitxKey_underscore, FcitxKey_Cyrillic_I, 0x04E2,
    FcitxKey_underscore, FcitxKey_Cyrillic_U, 0x04EE,
    FcitxKey_underscore, FcitxKey_Greek_ALPHA, 0x1FB9,
    FcitxKey_underscore, FcitxKey_Greek_IOTA, 0x1FD9,
    FcitxKey_underscore, FcitxKey_Greek_UPSILON, 0x1FE9,
    FcitxKey_underscore, FcitxKey_Greek_alpha, 0x1FB1,
    FcitxKey_underscore, FcitxKey_Greek_iota, 0x1FD1,
    FcitxKey_underscore, FcitxKey_Greek_upsilon, 0x1FE1,
    FcitxKey_underscore, 0x1E36, 0x1E38,
    FcitxKey_underscore, 0x1E37, 0x1E39,
    FcitxKey_underscore, 0x1E5A, 0x1E5C,
    FcitxKey_underscore, 0x1E5B, 0x1E5D,
    FcitxKey_underscore, 0x2212, 0x208B,
    FcitxKey_underscore, FcitxKey_KP_Space, 0x2082,
    FcitxKey_underscore, FcitxKey_KP_Add, 0x208A,
    FcitxKey_underscore, FcitxKey_KP_0, 0x2080,
    FcitxKey_underscore, FcitxKey_KP_1, 0x2081,
    FcitxKey_underscore, FcitxKey_KP_2, 0x2082,
    FcitxKey_underscore, FcitxKey_KP_3, 0x2083,
    FcitxKey_underscore, FcitxKey_KP_4, 0x2084,
    FcitxKey_underscore, FcitxKey_KP_5, 0x2085,
    FcitxKey_underscore, FcitxKey_KP_6, 0x2086,
    FcitxKey_underscore, FcitxKey_KP_7, 0x2087,
    FcitxKey_underscore, FcitxKey_KP_8, 0x2088,
    FcitxKey_underscore, FcitxKey_KP_9, 0x2089,
    FcitxKey_underscore, FcitxKey_KP_Equal, 0x208C,
    FcitxKey_grave, FcitxKey_space, 0x0060,
    FcitxKey_grave, FcitxKey_A, 0x00C0,
    FcitxKey_grave, FcitxKey_E, 0x00C8,
    FcitxKey_grave, FcitxKey_I, 0x00CC,
    FcitxKey_grave, FcitxKey_N, 0x01F8,
    FcitxKey_grave, FcitxKey_O, 0x00D2,
    FcitxKey_grave, FcitxKey_U, 0x00D9,
    FcitxKey_grave, FcitxKey_W, 0x1E80,
    FcitxKey_grave, FcitxKey_Y, 0x1EF2,
    FcitxKey_grave, FcitxKey_a, 0x00E0,
    FcitxKey_grave, FcitxKey_e, 0x00E8,
    FcitxKey_grave, FcitxKey_i, 0x00EC,
    FcitxKey_grave, FcitxKey_n, 0x01F9,
    FcitxKey_grave, FcitxKey_o, 0x00F2,
    FcitxKey_grave, FcitxKey_u, 0x00F9,
    FcitxKey_grave, FcitxKey_w, 0x1E81,
    FcitxKey_grave, FcitxKey_y, 0x1EF3,
    FcitxKey_grave, FcitxKey_Acircumflex, 0x1EA6,
    FcitxKey_grave, FcitxKey_Ecircumflex, 0x1EC0,
    FcitxKey_grave, FcitxKey_Ocircumflex, 0x1ED2,
    FcitxKey_grave, 0x00DC, 0x01DB,
    FcitxKey_grave, FcitxKey_acircumflex, 0x1EA7,
    FcitxKey_grave, FcitxKey_ecircumflex, 0x1EC1,
    FcitxKey_grave, FcitxKey_ocircumflex, 0x1ED3,
    FcitxKey_grave, FcitxKey_udiaeresis, 0x01DC,
    FcitxKey_grave, FcitxKey_Ohorn, 0x1EDC,
    FcitxKey_grave, FcitxKey_ohorn, 0x1EDD,
    FcitxKey_grave, FcitxKey_Uhorn, 0x1EEA,
    FcitxKey_grave, FcitxKey_uhorn, 0x1EEB,
    FcitxKey_grave, FcitxKey_Abreve, 0x1EB0,
    FcitxKey_grave, FcitxKey_abreve, 0x1EB1,
    FcitxKey_grave, FcitxKey_Emacron, 0x1E14,
    FcitxKey_grave, FcitxKey_emacron, 0x1E15,
    FcitxKey_grave, FcitxKey_Omacron, 0x1E50,
    FcitxKey_grave, FcitxKey_omacron, 0x1E51,
    FcitxKey_grave, FcitxKey_Cyrillic_ie, 0x0450,
    FcitxKey_grave, FcitxKey_Cyrillic_i, 0x045D,
    FcitxKey_grave, FcitxKey_Cyrillic_IE, 0x0400,
    FcitxKey_grave, FcitxKey_Cyrillic_I, 0x040D,
    FcitxKey_grave, FcitxKey_Greek_iotadieresis, 0x1FD2,
    FcitxKey_grave, FcitxKey_Greek_upsilondieresis, 0x1FE2,
    FcitxKey_grave, FcitxKey_Greek_ALPHA, 0x1FBA,
    FcitxKey_grave, FcitxKey_Greek_EPSILON, 0x1FC8,
    FcitxKey_grave, FcitxKey_Greek_ETA, 0x1FCA,
    FcitxKey_grave, FcitxKey_Greek_IOTA, 0x1FDA,
    FcitxKey_grave, FcitxKey_Greek_OMICRON, 0x1FF8,
    FcitxKey_grave, FcitxKey_Greek_UPSILON, 0x1FEA,
    FcitxKey_grave, FcitxKey_Greek_OMEGA, 0x1FFA,
    FcitxKey_grave, FcitxKey_Greek_alpha, 0x1F70,
    FcitxKey_grave, FcitxKey_Greek_epsilon, 0x1F72,
    FcitxKey_grave, FcitxKey_Greek_eta, 0x1F74,
    FcitxKey_grave, FcitxKey_Greek_iota, 0x1F76,
    FcitxKey_grave, FcitxKey_Greek_omicron, 0x1F78,
    FcitxKey_grave, FcitxKey_Greek_upsilon, 0x1F7A,
    FcitxKey_grave, FcitxKey_Greek_omega, 0x1F7C,
    FcitxKey_grave, 0x1F00, 0x1F02,
    FcitxKey_grave, 0x1F01, 0x1F03,
    FcitxKey_grave, 0x1F08, 0x1F0A,
    FcitxKey_grave, 0x1F09, 0x1F0B,
    FcitxKey_grave, 0x1F10, 0x1F12,
    FcitxKey_grave, 0x1F11, 0x1F13,
    FcitxKey_grave, 0x1F18, 0x1F1A,
    FcitxKey_grave, 0x1F19, 0x1F1B,
    FcitxKey_grave, 0x1F20, 0x1F22,
    FcitxKey_grave, 0x1F21, 0x1F23,
    FcitxKey_grave, 0x1F28, 0x1F2A,
    FcitxKey_grave, 0x1F29, 0x1F2B,
    FcitxKey_grave, 0x1F30, 0x1F32,
    FcitxKey_grave, 0x1F31, 0x1F33,
    FcitxKey_grave, 0x1F38, 0x1F3A,
    FcitxKey_grave, 0x1F39, 0x1F3B,
    FcitxKey_grave, 0x1F40, 0x1F42,
    FcitxKey_grave, 0x1F41, 0x1F43,
    FcitxKey_grave, 0x1F48, 0x1F4A,
    FcitxKey_grave, 0x1F49, 0x1F4B,
    FcitxKey_grave, 0x1F50, 0x1F52,
    FcitxKey_grave, 0x1F51, 0x1F53,
    FcitxKey_grave, 0x1F59, 0x1F5B,
    FcitxKey_grave, 0x1F60, 0x1F62,
    FcitxKey_grave, 0x1F61, 0x1F63,
    FcitxKey_grave, 0x1F68, 0x1F6A,
    FcitxKey_grave, 0x1F69, 0x1F6B,
    FcitxKey_a, FcitxKey_quotedbl, 0x00E4,
    FcitxKey_a, FcitxKey_apostrophe, 0x00E1,
    FcitxKey_a, FcitxKey_parenleft, 0x0103,
    FcitxKey_a, FcitxKey_asterisk, 0x00E5,
    FcitxKey_a, FcitxKey_comma, 0x0105,
    FcitxKey_a, FcitxKey_minus, 0x00E3,
    FcitxKey_a, FcitxKey_greater, 0x00E2,
    FcitxKey_a, FcitxKey_asciicircum, 0x00E2,
    FcitxKey_a, FcitxKey_underscore, 0x00AA,
    FcitxKey_a, FcitxKey_grave, 0x00E0,
    FcitxKey_a, FcitxKey_a, 0x00E5,
    FcitxKey_a, FcitxKey_e, 0x00E6,
    FcitxKey_a, FcitxKey_asciitilde, 0x00E3,
    FcitxKey_a, FcitxKey_diaeresis, 0x00E4,
    FcitxKey_a, FcitxKey_acute, 0x00E1,
    FcitxKey_b, FcitxKey_period, 0x1E03,
    FcitxKey_b, FcitxKey_A, 0x0102,
    FcitxKey_b, FcitxKey_E, 0x0114,
    FcitxKey_b, FcitxKey_G, 0x011E,
    FcitxKey_b, FcitxKey_I, 0x012C,
    FcitxKey_b, FcitxKey_O, 0x014E,
    FcitxKey_b, FcitxKey_U, 0x016C,
    FcitxKey_b, FcitxKey_a, 0x0103,
    FcitxKey_b, FcitxKey_e, 0x0115,
    FcitxKey_b, FcitxKey_g, 0x011F,
    FcitxKey_b, FcitxKey_i, 0x012D,
    FcitxKey_b, FcitxKey_o, 0x014F,
    FcitxKey_b, FcitxKey_u, 0x016D,
    FcitxKey_b, 0x0228, 0x1E1C,
    FcitxKey_b, 0x0229, 0x1E1D,
    FcitxKey_b, FcitxKey_Cyrillic_a, 0x04D1,
    FcitxKey_b, FcitxKey_Cyrillic_ie, 0x04D7,
    FcitxKey_b, FcitxKey_Cyrillic_i, 0x0439,
    FcitxKey_b, FcitxKey_Cyrillic_u, 0x045E,
    FcitxKey_b, FcitxKey_Cyrillic_zhe, 0x04C2,
    FcitxKey_b, FcitxKey_Cyrillic_A, 0x04D0,
    FcitxKey_b, FcitxKey_Cyrillic_IE, 0x04D6,
    FcitxKey_b, FcitxKey_Cyrillic_I, 0x0419,
    FcitxKey_b, FcitxKey_Cyrillic_U, 0x040E,
    FcitxKey_b, FcitxKey_Cyrillic_ZHE, 0x04C1,
    FcitxKey_b, FcitxKey_Greek_ALPHA, 0x1FB8,
    FcitxKey_b, FcitxKey_Greek_IOTA, 0x1FD8,
    FcitxKey_b, FcitxKey_Greek_UPSILON, 0x1FE8,
    FcitxKey_b, FcitxKey_Greek_alpha, 0x1FB0,
    FcitxKey_b, FcitxKey_Greek_iota, 0x1FD0,
    FcitxKey_b, FcitxKey_Greek_upsilon, 0x1FE0,
    FcitxKey_b, 0x1EA0, 0x1EB6,
    FcitxKey_b, 0x1EA1, 0x1EB7,
    FcitxKey_c, FcitxKey_apostrophe, 0x0107,
    FcitxKey_c, FcitxKey_comma, 0x00E7,
    FcitxKey_c, FcitxKey_period, 0x010B,
    FcitxKey_c, FcitxKey_slash, 0x00A2,
    FcitxKey_c, FcitxKey_0, 0x00A9,
    FcitxKey_c, FcitxKey_less, 0x010D,
    FcitxKey_c, FcitxKey_equal, 0x20AC,
    FcitxKey_c, FcitxKey_A, 0x01CD,
    FcitxKey_c, FcitxKey_C, 0x010C,
    FcitxKey_c, FcitxKey_D, 0x010E,
    FcitxKey_c, FcitxKey_E, 0x011A,
    FcitxKey_c, FcitxKey_G, 0x01E6,
    FcitxKey_c, FcitxKey_H, 0x021E,
    FcitxKey_c, FcitxKey_I, 0x01CF,
    FcitxKey_c, FcitxKey_K, 0x01E8,
    FcitxKey_c, FcitxKey_L, 0x013D,
    FcitxKey_c, FcitxKey_N, 0x0147,
    FcitxKey_c, FcitxKey_O, 0x00A9,
    FcitxKey_c, FcitxKey_R, 0x0158,
    FcitxKey_c, FcitxKey_S, 0x0160,
    FcitxKey_c, FcitxKey_T, 0x0164,
    FcitxKey_c, FcitxKey_U, 0x01D3,
    FcitxKey_c, FcitxKey_Z, 0x017D,
    FcitxKey_c, FcitxKey_a, 0x01CE,
    FcitxKey_c, FcitxKey_c, 0x010D,
    FcitxKey_c, FcitxKey_d, 0x010F,
    FcitxKey_c, FcitxKey_e, 0x011B,
    FcitxKey_c, FcitxKey_g, 0x01E7,
    FcitxKey_c, FcitxKey_h, 0x021F,
    FcitxKey_c, FcitxKey_i, 0x01D0,
    FcitxKey_c, FcitxKey_j, 0x01F0,
    FcitxKey_c, FcitxKey_k, 0x01E9,
    FcitxKey_c, FcitxKey_l, 0x013E,
    FcitxKey_c, FcitxKey_n, 0x0148,
    FcitxKey_c, FcitxKey_o, 0x00A9,
    FcitxKey_c, FcitxKey_r, 0x0159,
    FcitxKey_c, FcitxKey_s, 0x0161,
    FcitxKey_c, FcitxKey_t, 0x0165,
    FcitxKey_c, FcitxKey_u, 0x01D4,
    FcitxKey_c, FcitxKey_z, 0x017E,
    FcitxKey_c, FcitxKey_bar, 0x00A2,
    FcitxKey_c, 0x00DC, 0x01D9,
    FcitxKey_c, FcitxKey_udiaeresis, 0x01DA,
    FcitxKey_c, 0x01B7, 0x01EE,
    FcitxKey_c, 0x0292, 0x01EF,
    FcitxKey_d, FcitxKey_minus, 0x0111,
    FcitxKey_d, FcitxKey_period, 0x1E0B,
    FcitxKey_d, FcitxKey_less, 0x010F,
    FcitxKey_d, FcitxKey_h, 0x00F0,
    FcitxKey_e, FcitxKey_quotedbl, 0x00EB,
    FcitxKey_e, FcitxKey_apostrophe, 0x00E9,
    FcitxKey_e, FcitxKey_comma, 0x0119,
    FcitxKey_e, FcitxKey_minus, 0x0113,
    FcitxKey_e, FcitxKey_period, 0x0117,
    FcitxKey_e, FcitxKey_less, 0x011B,
    FcitxKey_e, FcitxKey_equal, 0x20AC,
    FcitxKey_e, FcitxKey_greater, 0x00EA,
    FcitxKey_e, FcitxKey_asciicircum, 0x00EA,
    FcitxKey_e, FcitxKey_underscore, 0x0113,
    FcitxKey_e, FcitxKey_grave, 0x00E8,
    FcitxKey_e, FcitxKey_e, 0x0259,
    FcitxKey_e, FcitxKey_diaeresis, 0x00EB,
    FcitxKey_e, FcitxKey_acute, 0x00E9,
    FcitxKey_f, FcitxKey_period, 0x1E1F,
    FcitxKey_f, FcitxKey_S, 0x017F,
    FcitxKey_f, FcitxKey_s, 0x017F,
    FcitxKey_g, FcitxKey_parenleft, 0x011F,
    FcitxKey_g, FcitxKey_comma, 0x0123,
    FcitxKey_g, FcitxKey_period, 0x0121,
    FcitxKey_g, FcitxKey_U, 0x011F,
    FcitxKey_g, FcitxKey_breve, 0x011F,
    FcitxKey_i, FcitxKey_quotedbl, 0x00EF,
    FcitxKey_i, FcitxKey_apostrophe, 0x00ED,
    FcitxKey_i, FcitxKey_comma, 0x012F,
    FcitxKey_i, FcitxKey_minus, 0x012B,
    FcitxKey_i, FcitxKey_period, 0x0131,
    FcitxKey_i, FcitxKey_greater, 0x00EE,
    FcitxKey_i, FcitxKey_asciicircum, 0x00EE,
    FcitxKey_i, FcitxKey_underscore, 0x012B,
    FcitxKey_i, FcitxKey_grave, 0x00EC,
    FcitxKey_i, FcitxKey_asciitilde, 0x0129,
    FcitxKey_i, FcitxKey_diaeresis, 0x00EF,
    FcitxKey_i, FcitxKey_acute, 0x00ED,
    FcitxKey_k, FcitxKey_comma, 0x0137,
    FcitxKey_k, FcitxKey_k, 0x0138,
    FcitxKey_l, FcitxKey_apostrophe, 0x013A,
    FcitxKey_l, FcitxKey_comma, 0x013C,
    FcitxKey_l, FcitxKey_minus, 0x00A3,
    FcitxKey_l, FcitxKey_slash, 0x0142,
    FcitxKey_l, FcitxKey_less, 0x013E,
    FcitxKey_l, FcitxKey_equal, 0x00A3,
    FcitxKey_l, FcitxKey_v, 0x007C,
    FcitxKey_m, FcitxKey_period, 0x1E41,
    FcitxKey_m, FcitxKey_slash, 0x20A5,
    FcitxKey_m, FcitxKey_u, 0x00B5,
    FcitxKey_n, FcitxKey_apostrophe, 0x0144,
    FcitxKey_n, FcitxKey_comma, 0x0146,
    FcitxKey_n, FcitxKey_minus, 0x00F1,
    FcitxKey_n, FcitxKey_less, 0x0148,
    FcitxKey_n, FcitxKey_g, 0x014B,
    FcitxKey_n, FcitxKey_asciitilde, 0x00F1,
    FcitxKey_o, FcitxKey_quotedbl, 0x00F6,
    FcitxKey_o, FcitxKey_apostrophe, 0x00F3,
    FcitxKey_o, FcitxKey_minus, 0x00F5,
    FcitxKey_o, FcitxKey_slash, 0x00F8,
    FcitxKey_o, FcitxKey_greater, 0x00F4,
    FcitxKey_o, FcitxKey_A, 0x00C5,
    FcitxKey_o, FcitxKey_C, 0x00A9,
    FcitxKey_o, FcitxKey_R, 0x00AE,
    FcitxKey_o, FcitxKey_U, 0x016E,
    FcitxKey_o, FcitxKey_X, 0x00A4,
    FcitxKey_o, FcitxKey_asciicircum, 0x00F4,
    FcitxKey_o, FcitxKey_underscore, 0x00BA,
    FcitxKey_o, FcitxKey_grave, 0x00F2,
    FcitxKey_o, FcitxKey_a, 0x00E5,
    FcitxKey_o, FcitxKey_c, 0x00A9,
    FcitxKey_o, FcitxKey_e, 0x0153,
    FcitxKey_o, FcitxKey_o, 0x00B0,
    FcitxKey_o, FcitxKey_r, 0x00AE,
    FcitxKey_o, FcitxKey_s, 0x00A7,
    FcitxKey_o, FcitxKey_u, 0x016F,
    FcitxKey_o, FcitxKey_w, 0x1E98,
    FcitxKey_o, FcitxKey_x, 0x00A4,
    FcitxKey_o, FcitxKey_y, 0x1E99,
    FcitxKey_o, FcitxKey_asciitilde, 0x00F5,
    FcitxKey_o, FcitxKey_diaeresis, 0x00F6,
    FcitxKey_o, FcitxKey_acute, 0x00F3,
    FcitxKey_p, FcitxKey_exclam, 0x00B6,
    FcitxKey_p, FcitxKey_period, 0x1E57,
    FcitxKey_r, FcitxKey_apostrophe, 0x0155,
    FcitxKey_r, FcitxKey_comma, 0x0157,
    FcitxKey_r, FcitxKey_less, 0x0159,
    FcitxKey_s, FcitxKey_exclam, 0x00A7,
    FcitxKey_s, FcitxKey_apostrophe, 0x015B,
    FcitxKey_s, FcitxKey_comma, 0x015F,
    FcitxKey_s, FcitxKey_period, 0x1E61,
    FcitxKey_s, FcitxKey_0, 0x00A7,
    FcitxKey_s, FcitxKey_1, 0x00B9,
    FcitxKey_s, FcitxKey_2, 0x00B2,
    FcitxKey_s, FcitxKey_3, 0x00B3,
    FcitxKey_s, FcitxKey_less, 0x0161,
    FcitxKey_s, FcitxKey_M, 0x2120,
    FcitxKey_s, FcitxKey_m, 0x2120,
    FcitxKey_s, FcitxKey_o, 0x00A7,
    FcitxKey_s, FcitxKey_s, 0x00DF,
    FcitxKey_s, FcitxKey_cedilla, 0x015F,
    FcitxKey_t, FcitxKey_minus, 0x0167,
    FcitxKey_t, FcitxKey_period, 0x1E6B,
    FcitxKey_t, FcitxKey_slash, 0x0167,
    FcitxKey_t, FcitxKey_less, 0x0165,
    FcitxKey_t, FcitxKey_M, 0x2122,
    FcitxKey_t, FcitxKey_h, 0x00FE,
    FcitxKey_t, FcitxKey_m, 0x2122,
    FcitxKey_u, FcitxKey_quotedbl, 0x00FC,
    FcitxKey_u, FcitxKey_apostrophe, 0x00FA,
    FcitxKey_u, FcitxKey_asterisk, 0x016F,
    FcitxKey_u, FcitxKey_comma, 0x0173,
    FcitxKey_u, FcitxKey_minus, 0x016B,
    FcitxKey_u, FcitxKey_slash, 0x00B5,
    FcitxKey_u, FcitxKey_greater, 0x00FB,
    FcitxKey_u, FcitxKey_asciicircum, 0x00FB,
    FcitxKey_u, FcitxKey_underscore, 0x016B,
    FcitxKey_u, FcitxKey_grave, 0x00F9,
    FcitxKey_u, FcitxKey_u, 0x016D,
    FcitxKey_u, FcitxKey_asciitilde, 0x0169,
    FcitxKey_u, FcitxKey_diaeresis, 0x00FC,
    FcitxKey_u, FcitxKey_acute, 0x00FA,
    FcitxKey_v, FcitxKey_Z, 0x017D,
    FcitxKey_v, FcitxKey_l, 0x007C,
    FcitxKey_v, FcitxKey_z, 0x017E,
    FcitxKey_w, FcitxKey_asciicircum, 0x0175,
    FcitxKey_x, FcitxKey_0, 0x00A4,
    FcitxKey_x, FcitxKey_O, 0x00A4,
    FcitxKey_x, FcitxKey_o, 0x00A4,
    FcitxKey_x, FcitxKey_x, 0x00D7,
    FcitxKey_y, FcitxKey_quotedbl, 0x00FF,
    FcitxKey_y, FcitxKey_apostrophe, 0x00FD,
    FcitxKey_y, FcitxKey_minus, 0x00A5,
    FcitxKey_y, FcitxKey_equal, 0x00A5,
    FcitxKey_y, FcitxKey_asciicircum, 0x0177,
    FcitxKey_y, FcitxKey_diaeresis, 0x00FF,
    FcitxKey_y, FcitxKey_acute, 0x00FD,
    FcitxKey_z, FcitxKey_apostrophe, 0x017A,
    FcitxKey_z, FcitxKey_period, 0x017C,
    FcitxKey_z, FcitxKey_less, 0x017E,
    FcitxKey_bar, FcitxKey_C, 0x00A2,
    FcitxKey_bar, FcitxKey_c, 0x00A2,
    FcitxKey_asciitilde, FcitxKey_space, 0x007E,
    FcitxKey_asciitilde, FcitxKey_A, 0x00C3,
    FcitxKey_asciitilde, FcitxKey_E, 0x1EBC,
    FcitxKey_asciitilde, FcitxKey_I, 0x0128,
    FcitxKey_asciitilde, FcitxKey_N, 0x00D1,
    FcitxKey_asciitilde, FcitxKey_O, 0x00D5,
    FcitxKey_asciitilde, FcitxKey_U, 0x0168,
    FcitxKey_asciitilde, FcitxKey_V, 0x1E7C,
    FcitxKey_asciitilde, FcitxKey_Y, 0x1EF8,
    FcitxKey_asciitilde, FcitxKey_a, 0x00E3,
    FcitxKey_asciitilde, FcitxKey_e, 0x1EBD,
    FcitxKey_asciitilde, FcitxKey_i, 0x0129,
    FcitxKey_asciitilde, FcitxKey_n, 0x00F1,
    FcitxKey_asciitilde, FcitxKey_o, 0x00F5,
    FcitxKey_asciitilde, FcitxKey_u, 0x0169,
    FcitxKey_asciitilde, FcitxKey_v, 0x1E7D,
    FcitxKey_asciitilde, FcitxKey_y, 0x1EF9,
    FcitxKey_asciitilde, FcitxKey_Acircumflex, 0x1EAA,
    FcitxKey_asciitilde, FcitxKey_Ecircumflex, 0x1EC4,
    FcitxKey_asciitilde, FcitxKey_Ocircumflex, 0x1ED6,
    FcitxKey_asciitilde, FcitxKey_acircumflex, 0x1EAB,
    FcitxKey_asciitilde, FcitxKey_ecircumflex, 0x1EC5,
    FcitxKey_asciitilde, FcitxKey_ocircumflex, 0x1ED7,
    FcitxKey_asciitilde, FcitxKey_Ohorn, 0x1EE0,
    FcitxKey_asciitilde, FcitxKey_ohorn, 0x1EE1,
    FcitxKey_asciitilde, FcitxKey_Uhorn, 0x1EEE,
    FcitxKey_asciitilde, FcitxKey_uhorn, 0x1EEF,
    FcitxKey_asciitilde, FcitxKey_Abreve, 0x1EB4,
    FcitxKey_asciitilde, FcitxKey_abreve, 0x1EB5,
    FcitxKey_asciitilde, FcitxKey_Greek_iotadieresis, 0x1FD7,
    FcitxKey_asciitilde, FcitxKey_Greek_upsilondieresis, 0x1FE7,
    FcitxKey_asciitilde, FcitxKey_Greek_alpha, 0x1FB6,
    FcitxKey_asciitilde, FcitxKey_Greek_eta, 0x1FC6,
    FcitxKey_asciitilde, FcitxKey_Greek_iota, 0x1FD6,
    FcitxKey_asciitilde, FcitxKey_Greek_upsilon, 0x1FE6,
    FcitxKey_asciitilde, FcitxKey_Greek_omega, 0x1FF6,
    FcitxKey_asciitilde, 0x1F00, 0x1F06,
    FcitxKey_asciitilde, 0x1F01, 0x1F07,
    FcitxKey_asciitilde, 0x1F08, 0x1F0E,
    FcitxKey_asciitilde, 0x1F09, 0x1F0F,
    FcitxKey_asciitilde, 0x1F20, 0x1F26,
    FcitxKey_asciitilde, 0x1F21, 0x1F27,
    FcitxKey_asciitilde, 0x1F28, 0x1F2E,
    FcitxKey_asciitilde, 0x1F29, 0x1F2F,
    FcitxKey_asciitilde, 0x1F30, 0x1F36,
    FcitxKey_asciitilde, 0x1F31, 0x1F37,
    FcitxKey_asciitilde, 0x1F38, 0x1F3E,
    FcitxKey_asciitilde, 0x1F39, 0x1F3F,
    FcitxKey_asciitilde, 0x1F50, 0x1F56,
    FcitxKey_asciitilde, 0x1F51, 0x1F57,
    FcitxKey_asciitilde, 0x1F59, 0x1F5F,
    FcitxKey_asciitilde, 0x1F60, 0x1F66,
    FcitxKey_asciitilde, 0x1F61, 0x1F67,
    FcitxKey_asciitilde, 0x1F68, 0x1F6E,
    FcitxKey_asciitilde, 0x1F69, 0x1F6F,
    FcitxKey_diaeresis, FcitxKey_apostrophe, 0x0385,
    FcitxKey_diaeresis, FcitxKey_A, 0x00C4,
    FcitxKey_diaeresis, FcitxKey_E, 0x00CB,
    FcitxKey_diaeresis, FcitxKey_I, 0x00CF,
    FcitxKey_diaeresis, FcitxKey_O, 0x00D6,
    FcitxKey_diaeresis, FcitxKey_U, 0x00DC,
    FcitxKey_diaeresis, FcitxKey_Y, 0x0178,
    FcitxKey_diaeresis, FcitxKey_grave, 0x1FED,
    FcitxKey_diaeresis, FcitxKey_a, 0x00E4,
    FcitxKey_diaeresis, FcitxKey_e, 0x00EB,
    FcitxKey_diaeresis, FcitxKey_i, 0x00EF,
    FcitxKey_diaeresis, FcitxKey_o, 0x00F6,
    FcitxKey_diaeresis, FcitxKey_u, 0x00FC,
    FcitxKey_diaeresis, FcitxKey_y, 0x00FF,
    FcitxKey_diaeresis, FcitxKey_asciitilde, 0x1FC1,
    FcitxKey_diaeresis, FcitxKey_acute, 0x0385,
    FcitxKey_diaeresis, FcitxKey_dead_grave, 0x1FED,
    FcitxKey_diaeresis, FcitxKey_dead_acute, 0x0385,
    FcitxKey_diaeresis, FcitxKey_dead_tilde, 0x1FC1,
    FcitxKey_macron, FcitxKey_A, 0x0100,
    FcitxKey_macron, FcitxKey_E, 0x0112,
    FcitxKey_macron, FcitxKey_G, 0x1E20,
    FcitxKey_macron, FcitxKey_I, 0x012A,
    FcitxKey_macron, FcitxKey_O, 0x014C,
    FcitxKey_macron, FcitxKey_U, 0x016A,
    FcitxKey_macron, FcitxKey_Y, 0x0232,
    FcitxKey_macron, FcitxKey_a, 0x0101,
    FcitxKey_macron, FcitxKey_e, 0x0113,
    FcitxKey_macron, FcitxKey_g, 0x1E21,
    FcitxKey_macron, FcitxKey_i, 0x012B,
    FcitxKey_macron, FcitxKey_o, 0x014D,
    FcitxKey_macron, FcitxKey_u, 0x016B,
    FcitxKey_macron, FcitxKey_y, 0x0233,
    FcitxKey_macron, FcitxKey_Adiaeresis, 0x01DE,
    FcitxKey_macron, FcitxKey_AE, 0x01E2,
    FcitxKey_macron, FcitxKey_Otilde, 0x022C,
    FcitxKey_macron, FcitxKey_Odiaeresis, 0x022A,
    FcitxKey_macron, 0x00DC, 0x01D5,
    FcitxKey_macron, FcitxKey_adiaeresis, 0x01DF,
    FcitxKey_macron, FcitxKey_ae, 0x01E3,
    FcitxKey_macron, FcitxKey_otilde, 0x022D,
    FcitxKey_macron, FcitxKey_odiaeresis, 0x022B,
    FcitxKey_macron, FcitxKey_udiaeresis, 0x01D6,
    FcitxKey_macron, 0x01EA, 0x01EC,
    FcitxKey_macron, 0x01EB, 0x01ED,
    FcitxKey_macron, 0x0226, 0x01E0,
    FcitxKey_macron, 0x0227, 0x01E1,
    FcitxKey_macron, 0x022E, 0x0230,
    FcitxKey_macron, 0x022F, 0x0231,
    FcitxKey_macron, FcitxKey_Cyrillic_i, 0x04E3,
    FcitxKey_macron, FcitxKey_Cyrillic_u, 0x04EF,
    FcitxKey_macron, FcitxKey_Cyrillic_I, 0x04E2,
    FcitxKey_macron, FcitxKey_Cyrillic_U, 0x04EE,
    FcitxKey_macron, FcitxKey_Greek_ALPHA, 0x1FB9,
    FcitxKey_macron, FcitxKey_Greek_IOTA, 0x1FD9,
    FcitxKey_macron, FcitxKey_Greek_UPSILON, 0x1FE9,
    FcitxKey_macron, FcitxKey_Greek_alpha, 0x1FB1,
    FcitxKey_macron, FcitxKey_Greek_iota, 0x1FD1,
    FcitxKey_macron, FcitxKey_Greek_upsilon, 0x1FE1,
    FcitxKey_macron, 0x1E36, 0x1E38,
    FcitxKey_macron, 0x1E37, 0x1E39,
    FcitxKey_macron, 0x1E5A, 0x1E5C,
    FcitxKey_macron, 0x1E5B, 0x1E5D,
    FcitxKey_acute, FcitxKey_A, 0x00C1,
    FcitxKey_acute, FcitxKey_C, 0x0106,
    FcitxKey_acute, FcitxKey_E, 0x00C9,
    FcitxKey_acute, FcitxKey_G, 0x01F4,
    FcitxKey_acute, FcitxKey_I, 0x00CD,
    FcitxKey_acute, FcitxKey_K, 0x1E30,
    FcitxKey_acute, FcitxKey_L, 0x0139,
    FcitxKey_acute, FcitxKey_M, 0x1E3E,
    FcitxKey_acute, FcitxKey_N, 0x0143,
    FcitxKey_acute, FcitxKey_O, 0x00D3,
    FcitxKey_acute, FcitxKey_P, 0x1E54,
    FcitxKey_acute, FcitxKey_R, 0x0154,
    FcitxKey_acute, FcitxKey_S, 0x015A,
    FcitxKey_acute, FcitxKey_U, 0x00DA,
    FcitxKey_acute, FcitxKey_W, 0x1E82,
    FcitxKey_acute, FcitxKey_Y, 0x00DD,
    FcitxKey_acute, FcitxKey_Z, 0x0179,
    FcitxKey_acute, FcitxKey_a, 0x00E1,
    FcitxKey_acute, FcitxKey_c, 0x0107,
    FcitxKey_acute, FcitxKey_e, 0x00E9,
    FcitxKey_acute, FcitxKey_g, 0x01F5,
    FcitxKey_acute, FcitxKey_i, 0x00ED,
    FcitxKey_acute, FcitxKey_k, 0x1E31,
    FcitxKey_acute, FcitxKey_l, 0x013A,
    FcitxKey_acute, FcitxKey_m, 0x1E3F,
    FcitxKey_acute, FcitxKey_n, 0x0144,
    FcitxKey_acute, FcitxKey_o, 0x00F3,
    FcitxKey_acute, FcitxKey_p, 0x1E55,
    FcitxKey_acute, FcitxKey_r, 0x0155,
    FcitxKey_acute, FcitxKey_s, 0x015B,
    FcitxKey_acute, FcitxKey_u, 0x00FA,
    FcitxKey_acute, FcitxKey_w, 0x1E83,
    FcitxKey_acute, FcitxKey_y, 0x00FD,
    FcitxKey_acute, FcitxKey_z, 0x017A,
    FcitxKey_acute, FcitxKey_Acircumflex, 0x1EA4,
    FcitxKey_acute, FcitxKey_Aring, 0x01FA,
    FcitxKey_acute, FcitxKey_AE, 0x01FC,
    FcitxKey_acute, FcitxKey_Ccedilla, 0x1E08,
    FcitxKey_acute, FcitxKey_Ecircumflex, 0x1EBE,
    FcitxKey_acute, FcitxKey_Idiaeresis, 0x1E2E,
    FcitxKey_acute, FcitxKey_Ocircumflex, 0x1ED0,
    FcitxKey_acute, FcitxKey_Otilde, 0x1E4C,
    FcitxKey_acute, FcitxKey_Ooblique, 0x01FE,
    FcitxKey_acute, 0x00DC, 0x01D7,
    FcitxKey_acute, FcitxKey_acircumflex, 0x1EA5,
    FcitxKey_acute, FcitxKey_aring, 0x01FB,
    FcitxKey_acute, FcitxKey_ae, 0x01FD,
    FcitxKey_acute, FcitxKey_ccedilla, 0x1E09,
    FcitxKey_acute, FcitxKey_ecircumflex, 0x1EBF,
    FcitxKey_acute, FcitxKey_idiaeresis, 0x1E2F,
    FcitxKey_acute, FcitxKey_ocircumflex, 0x1ED1,
    FcitxKey_acute, FcitxKey_otilde, 0x1E4D,
    FcitxKey_acute, FcitxKey_oslash, 0x01FF,
    FcitxKey_acute, FcitxKey_udiaeresis, 0x01D8,
    FcitxKey_acute, FcitxKey_Ohorn, 0x1EDA,
    FcitxKey_acute, FcitxKey_ohorn, 0x1EDB,
    FcitxKey_acute, FcitxKey_Uhorn, 0x1EE8,
    FcitxKey_acute, FcitxKey_uhorn, 0x1EE9,
    FcitxKey_acute, FcitxKey_Abreve, 0x1EAE,
    FcitxKey_acute, FcitxKey_abreve, 0x1EAF,
    FcitxKey_acute, FcitxKey_Emacron, 0x1E16,
    FcitxKey_acute, FcitxKey_emacron, 0x1E17,
    FcitxKey_acute, FcitxKey_Omacron, 0x1E52,
    FcitxKey_acute, FcitxKey_Utilde, 0x1E78,
    FcitxKey_acute, FcitxKey_omacron, 0x1E53,
    FcitxKey_acute, FcitxKey_utilde, 0x1E79,
    FcitxKey_acute, FcitxKey_Cyrillic_ghe, 0x0453,
    FcitxKey_acute, FcitxKey_Cyrillic_ka, 0x045C,
    FcitxKey_acute, FcitxKey_Cyrillic_GHE, 0x0403,
    FcitxKey_acute, FcitxKey_Cyrillic_KA, 0x040C,
    FcitxKey_acute, FcitxKey_Greek_iotadieresis, 0x0390,
    FcitxKey_acute, FcitxKey_Greek_upsilondieresis, 0x03B0,
    FcitxKey_acute, FcitxKey_Greek_ALPHA, 0x0386,
    FcitxKey_acute, FcitxKey_Greek_EPSILON, 0x0388,
    FcitxKey_acute, FcitxKey_Greek_ETA, 0x0389,
    FcitxKey_acute, FcitxKey_Greek_IOTA, 0x038A,
    FcitxKey_acute, FcitxKey_Greek_OMICRON, 0x038C,
    FcitxKey_acute, FcitxKey_Greek_UPSILON, 0x038E,
    FcitxKey_acute, FcitxKey_Greek_OMEGA, 0x038F,
    FcitxKey_acute, FcitxKey_Greek_alpha, 0x03AC,
    FcitxKey_acute, FcitxKey_Greek_epsilon, 0x03AD,
    FcitxKey_acute, FcitxKey_Greek_eta, 0x03AE,
    FcitxKey_acute, FcitxKey_Greek_iota, 0x03AF,
    FcitxKey_acute, FcitxKey_Greek_omicron, 0x03CC,
    FcitxKey_acute, FcitxKey_Greek_upsilon, 0x03CD,
    FcitxKey_acute, FcitxKey_Greek_omega, 0x03CE,
    FcitxKey_acute, 0x1F00, 0x1F04,
    FcitxKey_acute, 0x1F01, 0x1F05,
    FcitxKey_acute, 0x1F08, 0x1F0C,
    FcitxKey_acute, 0x1F09, 0x1F0D,
    FcitxKey_acute, 0x1F10, 0x1F14,
    FcitxKey_acute, 0x1F11, 0x1F15,
    FcitxKey_acute, 0x1F18, 0x1F1C,
    FcitxKey_acute, 0x1F19, 0x1F1D,
    FcitxKey_acute, 0x1F20, 0x1F24,
    FcitxKey_acute, 0x1F21, 0x1F25,
    FcitxKey_acute, 0x1F28, 0x1F2C,
    FcitxKey_acute, 0x1F29, 0x1F2D,
    FcitxKey_acute, 0x1F30, 0x1F34,
    FcitxKey_acute, 0x1F31, 0x1F35,
    FcitxKey_acute, 0x1F38, 0x1F3C,
    FcitxKey_acute, 0x1F39, 0x1F3D,
    FcitxKey_acute, 0x1F40, 0x1F44,
    FcitxKey_acute, 0x1F41, 0x1F45,
    FcitxKey_acute, 0x1F48, 0x1F4C,
    FcitxKey_acute, 0x1F49, 0x1F4D,
    FcitxKey_acute, 0x1F50, 0x1F54,
    FcitxKey_acute, 0x1F51, 0x1F55,
    FcitxKey_acute, 0x1F59, 0x1F5D,
    FcitxKey_acute, 0x1F60, 0x1F64,
    FcitxKey_acute, 0x1F61, 0x1F65,
    FcitxKey_acute, 0x1F68, 0x1F6C,
    FcitxKey_acute, 0x1F69, 0x1F6D,
    FcitxKey_cedilla, FcitxKey_C, 0x00C7,
    FcitxKey_cedilla, FcitxKey_D, 0x1E10,
    FcitxKey_cedilla, FcitxKey_E, 0x0228,
    FcitxKey_cedilla, FcitxKey_G, 0x0122,
    FcitxKey_cedilla, FcitxKey_H, 0x1E28,
    FcitxKey_cedilla, FcitxKey_K, 0x0136,
    FcitxKey_cedilla, FcitxKey_L, 0x013B,
    FcitxKey_cedilla, FcitxKey_N, 0x0145,
    FcitxKey_cedilla, FcitxKey_R, 0x0156,
    FcitxKey_cedilla, FcitxKey_S, 0x015E,
    FcitxKey_cedilla, FcitxKey_T, 0x0162,
    FcitxKey_cedilla, FcitxKey_c, 0x00E7,
    FcitxKey_cedilla, FcitxKey_d, 0x1E11,
    FcitxKey_cedilla, FcitxKey_e, 0x0229,
    FcitxKey_cedilla, FcitxKey_g, 0x0123,
    FcitxKey_cedilla, FcitxKey_h, 0x1E29,
    FcitxKey_cedilla, FcitxKey_k, 0x0137,
    FcitxKey_cedilla, FcitxKey_l, 0x013C,
    FcitxKey_cedilla, FcitxKey_n, 0x0146,
    FcitxKey_cedilla, FcitxKey_r, 0x0157,
    FcitxKey_cedilla, FcitxKey_s, 0x015F,
    FcitxKey_cedilla, FcitxKey_t, 0x0163,
    FcitxKey_breve, FcitxKey_G, 0x011E,
    FcitxKey_breve, FcitxKey_g, 0x011F,
    0x05B4, FcitxKey_hebrew_yod, 0xFB1D,
    0x05B7, 0x05F2, 0xFB1F,
    0x05B7, FcitxKey_hebrew_aleph, 0xFB2E,
    0x05B8, FcitxKey_hebrew_aleph, 0xFB2F,
    0x05B9, FcitxKey_hebrew_waw, 0xFB4B,
    0x05BC, FcitxKey_hebrew_aleph, 0xFB30,
    0x05BC, FcitxKey_hebrew_beth, 0xFB31,
    0x05BC, FcitxKey_hebrew_gimmel, 0xFB32,
    0x05BC, FcitxKey_hebrew_daleth, 0xFB33,
    0x05BC, FcitxKey_hebrew_he, 0xFB34,
    0x05BC, FcitxKey_hebrew_waw, 0xFB35,
    0x05BC, FcitxKey_hebrew_zayin, 0xFB36,
    0x05BC, FcitxKey_hebrew_teth, 0xFB38,
    0x05BC, FcitxKey_hebrew_yod, 0xFB39,
    0x05BC, FcitxKey_hebrew_finalkaph, 0xFB3A,
    0x05BC, FcitxKey_hebrew_kaph, 0xFB3B,
    0x05BC, FcitxKey_hebrew_lamed, 0xFB3C,
    0x05BC, FcitxKey_hebrew_mem, 0xFB3E,
    0x05BC, FcitxKey_hebrew_nun, 0xFB40,
    0x05BC, FcitxKey_hebrew_samekh, 0xFB41,
    0x05BC, FcitxKey_hebrew_finalpe, 0xFB43,
    0x05BC, FcitxKey_hebrew_pe, 0xFB44,
    0x05BC, FcitxKey_hebrew_zadi, 0xFB46,
    0x05BC, FcitxKey_hebrew_qoph, 0xFB47,
    0x05BC, FcitxKey_hebrew_resh, 0xFB48,
    0x05BC, FcitxKey_hebrew_shin, 0xFB49,
    0x05BC, FcitxKey_hebrew_taw, 0xFB4A,
    0x05BF, FcitxKey_hebrew_beth, 0xFB4C,
    0x05BF, FcitxKey_hebrew_kaph, 0xFB4D,
    0x05BF, FcitxKey_hebrew_pe, 0xFB4E,
    0x05C1, FcitxKey_hebrew_shin, 0xFB2A,
    0x05C1, 0xFB49, 0xFB2C,
    0x05C2, FcitxKey_hebrew_shin, 0xFB2B,
    0x05C2, 0xFB49, 0xFB2D,
    0x0653, FcitxKey_Arabic_alef, 0x0622,
    0x0654, FcitxKey_Arabic_alef, 0x0623,
    0x0654, FcitxKey_Arabic_waw, 0x0624,
    0x0654, FcitxKey_Arabic_yeh, 0x0626,
    0x0654, 0x06C1, 0x06C2,
    0x0654, 0x06D2, 0x06D3,
    0x0654, 0x06D5, 0x06C0,
    0x0655, FcitxKey_Arabic_alef, 0x0625,
    FcitxKey_Cyrillic_pe, FcitxKey_Cyrillic_a, 0x00A7,
    FcitxKey_Cyrillic_IE, FcitxKey_equal, 0x20AC,
    FcitxKey_Cyrillic_EN, FcitxKey_Cyrillic_o, 0x2116,
    FcitxKey_Cyrillic_EN, FcitxKey_Cyrillic_O, 0x2116,
    FcitxKey_Cyrillic_ES, FcitxKey_equal, 0x20AC,
    FcitxKey_Greek_ALPHA, FcitxKey_apostrophe, 0x0386,
    FcitxKey_Greek_EPSILON, FcitxKey_apostrophe, 0x0388,
    FcitxKey_Greek_ETA, FcitxKey_apostrophe, 0x0389,
    FcitxKey_Greek_IOTA, FcitxKey_quotedbl, 0x03AA,
    FcitxKey_Greek_IOTA, FcitxKey_apostrophe, 0x038A,
    FcitxKey_Greek_OMICRON, FcitxKey_apostrophe, 0x038C,
    FcitxKey_Greek_UPSILON, FcitxKey_quotedbl, 0x03AB,
    FcitxKey_Greek_UPSILON, FcitxKey_apostrophe, 0x038E,
    FcitxKey_Greek_OMEGA, FcitxKey_apostrophe, 0x038F,
    FcitxKey_Greek_alpha, FcitxKey_apostrophe, 0x03AC,
    FcitxKey_Greek_epsilon, FcitxKey_apostrophe, 0x03AD,
    FcitxKey_Greek_eta, FcitxKey_apostrophe, 0x03AE,
    FcitxKey_Greek_iota, FcitxKey_quotedbl, 0x03CA,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x03AF,
    FcitxKey_Greek_iota, FcitxKey_Greek_alphaaccent, 0x1FB4,
    FcitxKey_Greek_iota, FcitxKey_Greek_etaaccent, 0x1FC4,
    FcitxKey_Greek_iota, FcitxKey_Greek_omegaaccent, 0x1FF4,
    FcitxKey_Greek_iota, FcitxKey_Greek_ALPHA, 0x1FBC,
    FcitxKey_Greek_iota, FcitxKey_Greek_ETA, 0x1FCC,
    FcitxKey_Greek_iota, FcitxKey_Greek_OMEGA, 0x1FFC,
    FcitxKey_Greek_iota, FcitxKey_Greek_alpha, 0x1FB3,
    FcitxKey_Greek_iota, FcitxKey_Greek_eta, 0x1FC3,
    FcitxKey_Greek_iota, FcitxKey_Greek_omega, 0x1FF3,
    FcitxKey_Greek_iota, 0x1F00, 0x1F80,
    FcitxKey_Greek_iota, 0x1F01, 0x1F81,
    FcitxKey_Greek_iota, 0x1F02, 0x1F82,
    FcitxKey_Greek_iota, 0x1F03, 0x1F83,
    FcitxKey_Greek_iota, 0x1F04, 0x1F84,
    FcitxKey_Greek_iota, 0x1F05, 0x1F85,
    FcitxKey_Greek_iota, 0x1F06, 0x1F86,
    FcitxKey_Greek_iota, 0x1F07, 0x1F87,
    FcitxKey_Greek_iota, 0x1F08, 0x1F88,
    FcitxKey_Greek_iota, 0x1F09, 0x1F89,
    FcitxKey_Greek_iota, 0x1F0A, 0x1F8A,
    FcitxKey_Greek_iota, 0x1F0B, 0x1F8B,
    FcitxKey_Greek_iota, 0x1F0C, 0x1F8C,
    FcitxKey_Greek_iota, 0x1F0D, 0x1F8D,
    FcitxKey_Greek_iota, 0x1F0E, 0x1F8E,
    FcitxKey_Greek_iota, 0x1F0F, 0x1F8F,
    FcitxKey_Greek_iota, 0x1F20, 0x1F90,
    FcitxKey_Greek_iota, 0x1F21, 0x1F91,
    FcitxKey_Greek_iota, 0x1F22, 0x1F92,
    FcitxKey_Greek_iota, 0x1F23, 0x1F93,
    FcitxKey_Greek_iota, 0x1F24, 0x1F94,
    FcitxKey_Greek_iota, 0x1F25, 0x1F95,
    FcitxKey_Greek_iota, 0x1F26, 0x1F96,
    FcitxKey_Greek_iota, 0x1F27, 0x1F97,
    FcitxKey_Greek_iota, 0x1F28, 0x1F98,
    FcitxKey_Greek_iota, 0x1F29, 0x1F99,
    FcitxKey_Greek_iota, 0x1F2A, 0x1F9A,
    FcitxKey_Greek_iota, 0x1F2B, 0x1F9B,
    FcitxKey_Greek_iota, 0x1F2C, 0x1F9C,
    FcitxKey_Greek_iota, 0x1F2D, 0x1F9D,
    FcitxKey_Greek_iota, 0x1F2E, 0x1F9E,
    FcitxKey_Greek_iota, 0x1F2F, 0x1F9F,
    FcitxKey_Greek_iota, 0x1F60, 0x1FA0,
    FcitxKey_Greek_iota, 0x1F61, 0x1FA1,
    FcitxKey_Greek_iota, 0x1F62, 0x1FA2,
    FcitxKey_Greek_iota, 0x1F63, 0x1FA3,
    FcitxKey_Greek_iota, 0x1F64, 0x1FA4,
    FcitxKey_Greek_iota, 0x1F65, 0x1FA5,
    FcitxKey_Greek_iota, 0x1F66, 0x1FA6,
    FcitxKey_Greek_iota, 0x1F67, 0x1FA7,
    FcitxKey_Greek_iota, 0x1F68, 0x1FA8,
    FcitxKey_Greek_iota, 0x1F69, 0x1FA9,
    FcitxKey_Greek_iota, 0x1F6A, 0x1FAA,
    FcitxKey_Greek_iota, 0x1F6B, 0x1FAB,
    FcitxKey_Greek_iota, 0x1F6C, 0x1FAC,
    FcitxKey_Greek_iota, 0x1F6D, 0x1FAD,
    FcitxKey_Greek_iota, 0x1F6E, 0x1FAE,
    FcitxKey_Greek_iota, 0x1F6F, 0x1FAF,
    FcitxKey_Greek_iota, 0x1F70, 0x1FB2,
    FcitxKey_Greek_iota, 0x1F74, 0x1FC2,
    FcitxKey_Greek_iota, 0x1F7C, 0x1FF2,
    FcitxKey_Greek_iota, 0x1FB6, 0x1FB7,
    FcitxKey_Greek_iota, 0x1FC6, 0x1FC7,
    FcitxKey_Greek_iota, 0x1FF6, 0x1FF7,
    FcitxKey_Greek_omicron, FcitxKey_apostrophe, 0x03CC,
    FcitxKey_Greek_upsilon, FcitxKey_quotedbl, 0x03CB,
    FcitxKey_Greek_upsilon, FcitxKey_apostrophe, 0x03CD,
    FcitxKey_Greek_omega, FcitxKey_apostrophe, 0x03CE,
    FcitxKey_lessthanequal, 0x0338, 0x2270,
    FcitxKey_greaterthanequal, 0x0338, 0x2271,
    FcitxKey_approximate, 0x0338, 0x2247,
    FcitxKey_identical, 0x0338, 0x2262,
    FcitxKey_includedin, 0x0338, 0x2284,
    FcitxKey_includes, 0x0338, 0x2285,
    0x093C, 0x0915, 0x0958,
    0x093C, 0x0916, 0x0959,
    0x093C, 0x0917, 0x095A,
    0x093C, 0x091C, 0x095B,
    0x093C, 0x0921, 0x095C,
    0x093C, 0x0922, 0x095D,
    0x093C, 0x0928, 0x0929,
    0x093C, 0x092B, 0x095E,
    0x093C, 0x092F, 0x095F,
    0x093C, 0x0930, 0x0931,
    0x093C, 0x0933, 0x0934,
    0x09BC, 0x09A1, 0x09DC,
    0x09BC, 0x09A2, 0x09DD,
    0x09BC, 0x09AF, 0x09DF,
    0x09C7, 0x09BE, 0x09CB,
    0x09C7, 0x09D7, 0x09CC,
    0x0A3C, 0x0A16, 0x0A59,
    0x0A3C, 0x0A17, 0x0A5A,
    0x0A3C, 0x0A1C, 0x0A5B,
    0x0A3C, 0x0A2B, 0x0A5E,
    0x0A3C, 0x0A32, 0x0A33,
    0x0A3C, 0x0A38, 0x0A36,
    0x0B3C, 0x0B21, 0x0B5C,
    0x0B3C, 0x0B22, 0x0B5D,
    0x0B47, 0x0B3E, 0x0B4B,
    0x0B47, 0x0B56, 0x0B48,
    0x0B47, 0x0B57, 0x0B4C,
    FcitxKey_leftcaret, 0x0338, 0x226E,
    FcitxKey_rightcaret, 0x0338, 0x226F,
    FcitxKey_underbar, FcitxKey_parenleft, 0x208D,
    FcitxKey_underbar, FcitxKey_parenright, 0x208E,
    FcitxKey_underbar, FcitxKey_plus, 0x208A,
    FcitxKey_underbar, FcitxKey_0, 0x2080,
    FcitxKey_underbar, FcitxKey_1, 0x2081,
    FcitxKey_underbar, FcitxKey_2, 0x2082,
    FcitxKey_underbar, FcitxKey_3, 0x2083,
    FcitxKey_underbar, FcitxKey_4, 0x2084,
    FcitxKey_underbar, FcitxKey_5, 0x2085,
    FcitxKey_underbar, FcitxKey_6, 0x2086,
    FcitxKey_underbar, FcitxKey_7, 0x2087,
    FcitxKey_underbar, FcitxKey_8, 0x2088,
    FcitxKey_underbar, FcitxKey_9, 0x2089,
    FcitxKey_underbar, FcitxKey_equal, 0x208C,
    0x0BC6, 0x0BBE, 0x0BCA,
    0x0BC6, 0x0BD7, 0x0BCC,
    FcitxKey_underbar, 0x2212, 0x208B,
    FcitxKey_underbar, FcitxKey_KP_Space, 0x2082,
    FcitxKey_underbar, FcitxKey_KP_Add, 0x208A,
    FcitxKey_underbar, FcitxKey_KP_0, 0x2080,
    FcitxKey_underbar, FcitxKey_KP_1, 0x2081,
    FcitxKey_underbar, FcitxKey_KP_2, 0x2082,
    FcitxKey_underbar, FcitxKey_KP_3, 0x2083,
    FcitxKey_underbar, FcitxKey_KP_4, 0x2084,
    FcitxKey_underbar, FcitxKey_KP_5, 0x2085,
    FcitxKey_underbar, FcitxKey_KP_6, 0x2086,
    FcitxKey_underbar, FcitxKey_KP_7, 0x2087,
    FcitxKey_underbar, FcitxKey_KP_8, 0x2088,
    FcitxKey_underbar, FcitxKey_KP_9, 0x2089,
    FcitxKey_underbar, FcitxKey_KP_Equal, 0x208C,
    0x0BC7, 0x0BBE, 0x0BCB,
    0x0BD7, 0x0B92, 0x0B94,
    FcitxKey_rightshoe, 0x0338, 0x2285,
    FcitxKey_leftshoe, 0x0338, 0x2284,
    FcitxKey_righttack, 0x0338, 0x22AC,
    0x0C46, 0x0C56, 0x0C48,
    0x0CBF, 0x0CD5, 0x0CC0,
    0x0CC6, 0x0CC2, 0x0CCA,
    0x0CC6, 0x0CD5, 0x0CC7,
    0x0CC6, 0x0CD6, 0x0CC8,
    0x0CCA, 0x0CD5, 0x0CCB,
    0x0D46, 0x0D3E, 0x0D4A,
    0x0D46, 0x0D57, 0x0D4C,
    0x0D47, 0x0D3E, 0x0D4B,
    0x0DD9, 0x0DCA, 0x0DDA,
    0x0DD9, 0x0DCF, 0x0DDC,
    0x0DD9, 0x0DDF, 0x0DDE,
    0x0DDC, 0x0DCA, 0x0DDD,
    0x0F71, 0x0F72, 0x0F73,
    0x0F71, 0x0F74, 0x0F75,
    0x0F71, 0x0F80, 0x0F81,
    0x0F90, 0x0FB5, 0x0FB9,
    0x0F92, 0x0FB7, 0x0F93,
    0x0F9C, 0x0FB7, 0x0F9D,
    0x0FA1, 0x0FB7, 0x0FA2,
    0x0FA6, 0x0FB7, 0x0FA7,
    0x0FAB, 0x0FB7, 0x0FAC,
    0x0FB2, 0x0F80, 0x0F76,
    0x0FB3, 0x0F80, 0x0F78,
    0x0FB5, 0x0F40, 0x0F69,
    0x0FB7, 0x0F42, 0x0F43,
    0x0FB7, 0x0F4C, 0x0F4D,
    0x0FB7, 0x0F51, 0x0F52,
    0x0FB7, 0x0F56, 0x0F57,
    0x0FB7, 0x0F5B, 0x0F5C,
    0x102E, 0x1025, 0x1026,
    0x1100, 0x1100, 0x1101,
    0x1102, 0x1100, 0x1113,
    0x1102, 0x1102, 0x1114,
    0x1102, 0x1103, 0x1115,
    0x1102, 0x1107, 0x1116,
    0x1103, 0x1100, 0x1117,
    0x1103, 0x1103, 0x1104,
    0x1105, 0x1102, 0x1118,
    0x1105, 0x1105, 0x1119,
    0x1105, 0x110B, 0x111B,
    0x1105, 0x1112, 0x111A,
    0x1106, 0x1107, 0x111C,
    0x1106, 0x110B, 0x111D,
    0x1107, 0x1100, 0x111E,
    0x1107, 0x1102, 0x111F,
    0x1107, 0x1103, 0x1120,
    0x1107, 0x1107, 0x1108,
    0x1107, 0x1109, 0x1121,
    0x1107, 0x110A, 0x1125,
    0x1107, 0x110B, 0x112B,
    0x1107, 0x110C, 0x1127,
    0x1107, 0x110E, 0x1128,
    0x1107, 0x1110, 0x1129,
    0x1107, 0x1111, 0x112A,
    0x1107, 0x112B, 0x112C,
    0x1107, 0x112D, 0x1122,
    0x1107, 0x112F, 0x1123,
    0x1107, 0x1132, 0x1124,
    0x1107, 0x1136, 0x1126,
    0x1108, 0x110B, 0x112C,
    0x1109, 0x1100, 0x112D,
    0x1109, 0x1102, 0x112E,
    0x1109, 0x1103, 0x112F,
    0x1109, 0x1105, 0x1130,
    0x1109, 0x1106, 0x1131,
    0x1109, 0x1107, 0x1132,
    0x1109, 0x1109, 0x110A,
    0x1109, 0x110A, 0x1134,
    0x1109, 0x110B, 0x1135,
    0x1109, 0x110C, 0x1136,
    0x1109, 0x110E, 0x1137,
    0x1109, 0x110F, 0x1138,
    0x1109, 0x1110, 0x1139,
    0x1109, 0x1111, 0x113A,
    0x1109, 0x1112, 0x113B,
    0x1109, 0x111E, 0x1133,
    0x110A, 0x1109, 0x1134,
    0x110B, 0x1100, 0x1141,
    0x110B, 0x1103, 0x1142,
    0x110B, 0x1106, 0x1143,
    0x110B, 0x1107, 0x1144,
    0x110B, 0x1109, 0x1145,
    0x110B, 0x110B, 0x1147,
    0x110B, 0x110C, 0x1148,
    0x110B, 0x110E, 0x1149,
    0x110B, 0x1110, 0x114A,
    0x110B, 0x1111, 0x114B,
    0x110B, 0x1140, 0x1146,
    0x110C, 0x110B, 0x114D,
    0x110C, 0x110C, 0x110D,
    0x110E, 0x110F, 0x1152,
    0x110E, 0x1112, 0x1153,
    0x1111, 0x1107, 0x1156,
    0x1111, 0x110B, 0x1157,
    0x1112, 0x1112, 0x1158,
    0x1121, 0x1100, 0x1122,
    0x1121, 0x1103, 0x1123,
    0x1121, 0x1107, 0x1124,
    0x1121, 0x1109, 0x1125,
    0x1121, 0x110C, 0x1126,
    0x1132, 0x1100, 0x1133,
    0x113C, 0x113C, 0x113D,
    0x113E, 0x113E, 0x113F,
    0x114E, 0x114E, 0x114F,
    0x1150, 0x1150, 0x1151,
    0x1161, 0x1169, 0x1176,
    0x1161, 0x116E, 0x1177,
    0x1161, 0x1175, 0x1162,
    0x1163, 0x1169, 0x1178,
    0x1163, 0x116D, 0x1179,
    0x1163, 0x1175, 0x1164,
    0x1165, 0x1169, 0x117A,
    0x1165, 0x116E, 0x117B,
    0x1165, 0x1173, 0x117C,
    0x1165, 0x1175, 0x1166,
    0x1167, 0x1169, 0x117D,
    0x1167, 0x116E, 0x117E,
    0x1167, 0x1175, 0x1168,
    0x1169, 0x1161, 0x116A,
    0x1169, 0x1162, 0x116B,
    0x1169, 0x1165, 0x117F,
    0x1169, 0x1166, 0x1180,
    0x1169, 0x1168, 0x1181,
    0x1169, 0x1169, 0x1182,
    0x1169, 0x116E, 0x1183,
    0x1169, 0x1175, 0x116C,
    0x116A, 0x1175, 0x116B,
    0x116D, 0x1163, 0x1184,
    0x116D, 0x1164, 0x1185,
    0x116D, 0x1167, 0x1186,
    0x116D, 0x1169, 0x1187,
    0x116D, 0x1175, 0x1188,
    0x116E, 0x1161, 0x1189,
    0x116E, 0x1162, 0x118A,
    0x116E, 0x1165, 0x116F,
    0x116E, 0x1166, 0x1170,
    0x116E, 0x1168, 0x118C,
    0x116E, 0x116E, 0x118D,
    0x116E, 0x1175, 0x1171,
    0x116E, 0x117C, 0x118B,
    0x116F, 0x1173, 0x118B,
    0x116F, 0x1175, 0x1170,
    0x1172, 0x1161, 0x118E,
    0x1172, 0x1165, 0x118F,
    0x1172, 0x1166, 0x1190,
    0x1172, 0x1167, 0x1191,
    0x1172, 0x1168, 0x1192,
    0x1172, 0x116E, 0x1193,
    0x1172, 0x1175, 0x1194,
    0x1173, 0x116E, 0x1195,
    0x1173, 0x1173, 0x1196,
    0x1173, 0x1175, 0x1174,
    0x1174, 0x116E, 0x1197,
    0x1175, 0x1161, 0x1198,
    0x1175, 0x1163, 0x1199,
    0x1175, 0x1169, 0x119A,
    0x1175, 0x116E, 0x119B,
    0x1175, 0x1173, 0x119C,
    0x1175, 0x119E, 0x119D,
    0x119E, 0x1165, 0x119F,
    0x119E, 0x116E, 0x11A0,
    0x119E, 0x1175, 0x11A1,
    0x119E, 0x119E, 0x11A2,
    0x11A8, 0x11A8, 0x11A9,
    0x11A8, 0x11AF, 0x11C3,
    0x11A8, 0x11BA, 0x11AA,
    0x11A8, 0x11E7, 0x11C4,
    0x11AA, 0x11A8, 0x11C4,
    0x11AB, 0x11A8, 0x11C5,
    0x11AB, 0x11AE, 0x11C6,
    0x11AB, 0x11BA, 0x11C7,
    0x11AB, 0x11BD, 0x11AC,
    0x11AB, 0x11C0, 0x11C9,
    0x11AB, 0x11C2, 0x11AD,
    0x11AB, 0x11EB, 0x11C8,
    0x11AE, 0x11A8, 0x11CA,
    0x11AE, 0x11AF, 0x11CB,
    0x11AF, 0x11A8, 0x11B0,
    0x11AF, 0x11AA, 0x11CC,
    0x11AF, 0x11AB, 0x11CD,
    0x11AF, 0x11AE, 0x11CE,
    0x11AF, 0x11AF, 0x11D0,
    0x11AF, 0x11B7, 0x11B1,
    0x11AF, 0x11B8, 0x11B2,
    0x11AF, 0x11B9, 0x11D3,
    0x11AF, 0x11BA, 0x11B3,
    0x11AF, 0x11BB, 0x11D6,
    0x11AF, 0x11BF, 0x11D8,
    0x11AF, 0x11C0, 0x11B4,
    0x11AF, 0x11C1, 0x11B5,
    0x11AF, 0x11C2, 0x11B6,
    0x11AF, 0x11DA, 0x11D1,
    0x11AF, 0x11DD, 0x11D2,
    0x11AF, 0x11E5, 0x11D4,
    0x11AF, 0x11E6, 0x11D5,
    0x11AF, 0x11EB, 0x11D7,
    0x11AF, 0x11F9, 0x11D9,
    0x11B0, 0x11BA, 0x11CC,
    0x11B1, 0x11A8, 0x11D1,
    0x11B1, 0x11BA, 0x11D2,
    0x11B2, 0x11BA, 0x11D3,
    0x11B2, 0x11BC, 0x11D5,
    0x11B2, 0x11C2, 0x11D4,
    0x11B3, 0x11BA, 0x11D6,
    0x11B7, 0x11A8, 0x11DA,
    0x11B7, 0x11AF, 0x11DB,
    0x11B7, 0x11B8, 0x11DC,
    0x11B7, 0x11BA, 0x11DD,
    0x11B7, 0x11BB, 0x11DE,
    0x11B7, 0x11BC, 0x11E2,
    0x11B7, 0x11BE, 0x11E0,
    0x11B7, 0x11C2, 0x11E1,
    0x11B7, 0x11EB, 0x11DF,
    0x11B8, 0x11AF, 0x11E3,
    0x11B8, 0x11BA, 0x11B9,
    0x11B8, 0x11BC, 0x11E6,
    0x11B8, 0x11C1, 0x11E4,
    0x11B8, 0x11C2, 0x11E5,
    0x11BA, 0x11A8, 0x11E7,
    0x11BA, 0x11AE, 0x11E8,
    0x11BA, 0x11AF, 0x11E9,
    0x11BA, 0x11B8, 0x11EA,
    0x11BA, 0x11BA, 0x11BB,
    0x11BC, 0x11A8, 0x11EC,
    0x11BC, 0x11A9, 0x11ED,
    0x11BC, 0x11BC, 0x11EE,
    0x11BC, 0x11BF, 0x11EF,
    0x11C1, 0x11B8, 0x11F3,
    0x11C1, 0x11BC, 0x11F4,
    0x11C2, 0x11AB, 0x11F5,
    0x11C2, 0x11AF, 0x11F6,
    0x11C2, 0x11B7, 0x11F7,
    0x11C2, 0x11B8, 0x11F8,
    0x11CE, 0x11C2, 0x11CF,
    0x11DD, 0x11BA, 0x11DE,
    0x11EC, 0x11A8, 0x11ED,
    0x11F0, 0x11BA, 0x11F1,
    0x11F0, 0x11EB, 0x11F2,
    0x1FBF, FcitxKey_apostrophe, 0x1FCE,
    0x1FBF, FcitxKey_grave, 0x1FCD,
    0x1FBF, FcitxKey_asciitilde, 0x1FCF,
    0x1FBF, FcitxKey_acute, 0x1FCE,
    0x1FBF, FcitxKey_dead_grave, 0x1FCD,
    0x1FBF, FcitxKey_dead_acute, 0x1FCE,
    0x1FBF, FcitxKey_dead_tilde, 0x1FCF,
    0x1FFE, FcitxKey_apostrophe, 0x1FDE,
    0x1FFE, FcitxKey_grave, 0x1FDD,
    0x1FFE, FcitxKey_asciitilde, 0x1FDF,
    0x1FFE, FcitxKey_acute, 0x1FDE,
    0x1FFE, FcitxKey_dead_grave, 0x1FDD,
    0x1FFE, FcitxKey_dead_acute, 0x1FDE,
    0x1FFE, FcitxKey_dead_tilde, 0x1FDF,
    0x2203, 0x0338, 0x2204,
    0x2208, 0x0338, 0x2209,
    0x220B, 0x0338, 0x220C,
    0x2223, 0x0338, 0x2224,
    0x2225, 0x0338, 0x2226,
    0x223C, 0x0338, 0x2241,
    0x2243, 0x0338, 0x2244,
    0x2248, 0x0338, 0x2249,
    0x224D, 0x0338, 0x226D,
    0x2272, 0x0338, 0x2274,
    0x2273, 0x0338, 0x2275,
    0x2276, 0x0338, 0x2278,
    0x2277, 0x0338, 0x2279,
    0x227A, 0x0338, 0x2280,
    0x227B, 0x0338, 0x2281,
    0x227C, 0x0338, 0x22E0,
    0x227D, 0x0338, 0x22E1,
    0x2286, 0x0338, 0x2288,
    0x2287, 0x0338, 0x2289,
    0x2291, 0x0338, 0x22E2,
    0x2292, 0x0338, 0x22E3,
    0x22A8, 0x0338, 0x22AD,
    0x22A9, 0x0338, 0x22AE,
    0x22AB, 0x0338, 0x22AF,
    0x22B2, 0x0338, 0x22EA,
    0x22B3, 0x0338, 0x22EB,
    0x22B4, 0x0338, 0x22EC,
    0x22B5, 0x0338, 0x22ED,
    0x2ADD, 0x0338, 0x2ADC,
    FcitxKey_KP_Divide, FcitxKey_D, 0x0110,
    FcitxKey_KP_Divide, FcitxKey_G, 0x01E4,
    FcitxKey_KP_Divide, FcitxKey_H, 0x0126,
    FcitxKey_KP_Divide, FcitxKey_I, 0x0197,
    FcitxKey_KP_Divide, FcitxKey_L, 0x0141,
    FcitxKey_KP_Divide, FcitxKey_O, 0x00D8,
    FcitxKey_KP_Divide, FcitxKey_T, 0x0166,
    FcitxKey_KP_Divide, FcitxKey_Z, 0x01B5,
    FcitxKey_KP_Divide, FcitxKey_b, 0x0180,
    FcitxKey_KP_Divide, FcitxKey_d, 0x0111,
    FcitxKey_KP_Divide, FcitxKey_g, 0x01E5,
    FcitxKey_KP_Divide, FcitxKey_h, 0x0127,
    FcitxKey_KP_Divide, FcitxKey_i, 0x0268,
    FcitxKey_KP_Divide, FcitxKey_l, 0x0142,
    FcitxKey_KP_Divide, FcitxKey_o, 0x00F8,
    FcitxKey_KP_Divide, FcitxKey_t, 0x0167,
    FcitxKey_KP_Divide, FcitxKey_z, 0x01B6,
    FcitxKey_KP_Divide, 0x0294, 0x02A1,
    FcitxKey_KP_Divide, 0x04AE, 0x04B0,
    FcitxKey_KP_Divide, 0x04AF, 0x04B1,
    FcitxKey_KP_Divide, FcitxKey_Cyrillic_ghe, 0x0493,
    FcitxKey_KP_Divide, FcitxKey_Cyrillic_ka, 0x049F,
    FcitxKey_KP_Divide, FcitxKey_Cyrillic_GHE, 0x0492,
    FcitxKey_KP_Divide, FcitxKey_Cyrillic_KA, 0x049E,
    FcitxKey_KP_Divide, FcitxKey_leftarrow, 0x219A,
    FcitxKey_KP_Divide, FcitxKey_rightarrow, 0x219B,
    FcitxKey_KP_Divide, 0x2194, 0x21AE,
    FcitxKey_KP_Equal, 0x0338, 0x2260,
    FcitxKey_exclam, FcitxKey_plus, FcitxKey_O, 0x1EE2,
    FcitxKey_exclam, FcitxKey_plus, FcitxKey_U, 0x1EF0,
    FcitxKey_exclam, FcitxKey_plus, FcitxKey_o, 0x1EE3,
    FcitxKey_exclam, FcitxKey_plus, FcitxKey_u, 0x1EF1,
    FcitxKey_exclam, FcitxKey_dead_horn, FcitxKey_O, 0x1EE2,
    FcitxKey_exclam, FcitxKey_dead_horn, FcitxKey_U, 0x1EF0,
    FcitxKey_exclam, FcitxKey_dead_horn, FcitxKey_o, 0x1EE3,
    FcitxKey_exclam, FcitxKey_dead_horn, FcitxKey_u, 0x1EF1,
    FcitxKey_quotedbl, FcitxKey_apostrophe, FcitxKey_space, 0x0385,
    FcitxKey_quotedbl, FcitxKey_apostrophe, FcitxKey_Greek_iota, 0x0390,
    FcitxKey_quotedbl, FcitxKey_apostrophe, FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_quotedbl, FcitxKey_underscore, FcitxKey_U, 0x1E7A,
    FcitxKey_quotedbl, FcitxKey_underscore, FcitxKey_u, 0x1E7B,
    FcitxKey_quotedbl, FcitxKey_asciitilde, FcitxKey_O, 0x1E4E,
    FcitxKey_quotedbl, FcitxKey_asciitilde, FcitxKey_o, 0x1E4F,
    FcitxKey_quotedbl, FcitxKey_macron, FcitxKey_U, 0x1E7A,
    FcitxKey_quotedbl, FcitxKey_macron, FcitxKey_u, 0x1E7B,
    FcitxKey_quotedbl, FcitxKey_dead_tilde, FcitxKey_O, 0x1E4E,
    FcitxKey_quotedbl, FcitxKey_dead_tilde, FcitxKey_o, 0x1E4F,
    FcitxKey_quotedbl, FcitxKey_dead_macron, FcitxKey_U, 0x1E7A,
    FcitxKey_quotedbl, FcitxKey_dead_macron, FcitxKey_u, 0x1E7B,
    FcitxKey_apostrophe, FcitxKey_quotedbl, FcitxKey_space, 0x0385,
    FcitxKey_apostrophe, FcitxKey_quotedbl, FcitxKey_I, 0x1E2E,
    FcitxKey_apostrophe, FcitxKey_quotedbl, FcitxKey_U, 0x01D7,
    FcitxKey_apostrophe, FcitxKey_quotedbl, FcitxKey_i, 0x1E2F,
    FcitxKey_apostrophe, FcitxKey_quotedbl, FcitxKey_u, 0x01D8,
    FcitxKey_apostrophe, FcitxKey_quotedbl, FcitxKey_Greek_iota, 0x0390,
    FcitxKey_apostrophe, FcitxKey_quotedbl, FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F0D,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_EPSILON, 0x1F1D,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F2D,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_IOTA, 0x1F3D,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_OMICRON, 0x1F4D,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_UPSILON, 0x1F5D,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1F6D,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F05,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_epsilon, 0x1F15,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F25,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_iota, 0x1F35,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_omicron, 0x1F45,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_upsilon, 0x1F55,
    FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1F65,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F0C,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_EPSILON, 0x1F1C,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F2C,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_IOTA, 0x1F3C,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_OMICRON, 0x1F4C,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1F6C,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F04,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_epsilon, 0x1F14,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F24,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_iota, 0x1F34,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_omicron, 0x1F44,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_upsilon, 0x1F54,
    FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1F64,
    FcitxKey_apostrophe, FcitxKey_plus, FcitxKey_O, 0x1EDA,
    FcitxKey_apostrophe, FcitxKey_plus, FcitxKey_U, 0x1EE8,
    FcitxKey_apostrophe, FcitxKey_plus, FcitxKey_o, 0x1EDB,
    FcitxKey_apostrophe, FcitxKey_plus, FcitxKey_u, 0x1EE9,
    FcitxKey_apostrophe, FcitxKey_slash, FcitxKey_O, 0x01FE,
    FcitxKey_apostrophe, FcitxKey_slash, FcitxKey_o, 0x01FF,
    FcitxKey_apostrophe, FcitxKey_asciicircum, FcitxKey_A, 0x1EA4,
    FcitxKey_apostrophe, FcitxKey_asciicircum, FcitxKey_E, 0x1EBE,
    FcitxKey_apostrophe, FcitxKey_asciicircum, FcitxKey_O, 0x1ED0,
    FcitxKey_apostrophe, FcitxKey_asciicircum, FcitxKey_a, 0x1EA5,
    FcitxKey_apostrophe, FcitxKey_asciicircum, FcitxKey_e, 0x1EBF,
    FcitxKey_apostrophe, FcitxKey_asciicircum, FcitxKey_o, 0x1ED1,
    FcitxKey_apostrophe, FcitxKey_underscore, FcitxKey_E, 0x1E16,
    FcitxKey_apostrophe, FcitxKey_underscore, FcitxKey_O, 0x1E52,
    FcitxKey_apostrophe, FcitxKey_underscore, FcitxKey_e, 0x1E17,
    FcitxKey_apostrophe, FcitxKey_underscore, FcitxKey_o, 0x1E53,
    FcitxKey_apostrophe, FcitxKey_b, FcitxKey_A, 0x1EAE,
    FcitxKey_apostrophe, FcitxKey_b, FcitxKey_a, 0x1EAF,
    FcitxKey_apostrophe, FcitxKey_asciitilde, FcitxKey_O, 0x1E4C,
    FcitxKey_apostrophe, FcitxKey_asciitilde, FcitxKey_U, 0x1E78,
    FcitxKey_apostrophe, FcitxKey_asciitilde, FcitxKey_o, 0x1E4D,
    FcitxKey_apostrophe, FcitxKey_asciitilde, FcitxKey_u, 0x1E79,
    FcitxKey_apostrophe, FcitxKey_macron, FcitxKey_E, 0x1E16,
    FcitxKey_apostrophe, FcitxKey_macron, FcitxKey_O, 0x1E52,
    FcitxKey_apostrophe, FcitxKey_macron, FcitxKey_e, 0x1E17,
    FcitxKey_apostrophe, FcitxKey_macron, FcitxKey_o, 0x1E53,
    FcitxKey_apostrophe, FcitxKey_cedilla, FcitxKey_C, 0x1E08,
    FcitxKey_apostrophe, FcitxKey_cedilla, FcitxKey_c, 0x1E09,
    FcitxKey_apostrophe, FcitxKey_dead_circumflex, FcitxKey_A, 0x1EA4,
    FcitxKey_apostrophe, FcitxKey_dead_circumflex, FcitxKey_E, 0x1EBE,
    FcitxKey_apostrophe, FcitxKey_dead_circumflex, FcitxKey_O, 0x1ED0,
    FcitxKey_apostrophe, FcitxKey_dead_circumflex, FcitxKey_a, 0x1EA5,
    FcitxKey_apostrophe, FcitxKey_dead_circumflex, FcitxKey_e, 0x1EBF,
    FcitxKey_apostrophe, FcitxKey_dead_circumflex, FcitxKey_o, 0x1ED1,
    FcitxKey_apostrophe, FcitxKey_dead_tilde, FcitxKey_O, 0x1E4C,
    FcitxKey_apostrophe, FcitxKey_dead_tilde, FcitxKey_U, 0x1E78,
    FcitxKey_apostrophe, FcitxKey_dead_tilde, FcitxKey_o, 0x1E4D,
    FcitxKey_apostrophe, FcitxKey_dead_tilde, FcitxKey_u, 0x1E79,
    FcitxKey_apostrophe, FcitxKey_dead_macron, FcitxKey_E, 0x1E16,
    FcitxKey_apostrophe, FcitxKey_dead_macron, FcitxKey_O, 0x1E52,
    FcitxKey_apostrophe, FcitxKey_dead_macron, FcitxKey_e, 0x1E17,
    FcitxKey_apostrophe, FcitxKey_dead_macron, FcitxKey_o, 0x1E53,
    FcitxKey_apostrophe, FcitxKey_dead_breve, FcitxKey_A, 0x1EAE,
    FcitxKey_apostrophe, FcitxKey_dead_breve, FcitxKey_a, 0x1EAF,
    FcitxKey_apostrophe, FcitxKey_dead_diaeresis, FcitxKey_I, 0x1E2E,
    FcitxKey_apostrophe, FcitxKey_dead_diaeresis, FcitxKey_U, 0x01D7,
    FcitxKey_apostrophe, FcitxKey_dead_diaeresis, FcitxKey_i, 0x1E2F,
    FcitxKey_apostrophe, FcitxKey_dead_diaeresis, FcitxKey_u, 0x01D8,
    FcitxKey_apostrophe, FcitxKey_dead_diaeresis, FcitxKey_Greek_iota, 0x0390,
    FcitxKey_apostrophe, FcitxKey_dead_diaeresis, FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_apostrophe, FcitxKey_dead_abovering, FcitxKey_A, 0x01FA,
    FcitxKey_apostrophe, FcitxKey_dead_abovering, FcitxKey_a, 0x01FB,
    FcitxKey_apostrophe, FcitxKey_dead_cedilla, FcitxKey_C, 0x1E08,
    FcitxKey_apostrophe, FcitxKey_dead_cedilla, FcitxKey_c, 0x1E09,
    FcitxKey_apostrophe, FcitxKey_dead_horn, FcitxKey_O, 0x1EDA,
    FcitxKey_apostrophe, FcitxKey_dead_horn, FcitxKey_U, 0x1EE8,
    FcitxKey_apostrophe, FcitxKey_dead_horn, FcitxKey_o, 0x1EDB,
    FcitxKey_apostrophe, FcitxKey_dead_horn, FcitxKey_u, 0x1EE9,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F0C,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_EPSILON, 0x1F1C,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F2C,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_IOTA, 0x1F3C,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_OMICRON, 0x1F4C,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1F6C,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F04,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_epsilon, 0x1F14,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F24,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_iota, 0x1F34,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_omicron, 0x1F44,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_upsilon, 0x1F54,
    FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1F64,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F0D,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_EPSILON, 0x1F1D,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F2D,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_IOTA, 0x1F3D,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_OMICRON, 0x1F4D,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_UPSILON, 0x1F5D,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1F6D,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F05,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_epsilon, 0x1F15,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F25,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_iota, 0x1F35,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_omicron, 0x1F45,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_upsilon, 0x1F55,
    FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1F65,
    FcitxKey_apostrophe, FcitxKey_KP_Divide, FcitxKey_O, 0x01FE,
    FcitxKey_apostrophe, FcitxKey_KP_Divide, FcitxKey_o, 0x01FF,
    FcitxKey_parenleft, FcitxKey_0, FcitxKey_parenright, 0x24EA,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_parenright, 0x2460,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_parenright, 0x2461,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_parenright, 0x2462,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_parenright, 0x2463,
    FcitxKey_parenleft, FcitxKey_5, FcitxKey_parenright, 0x2464,
    FcitxKey_parenleft, FcitxKey_6, FcitxKey_parenright, 0x2465,
    FcitxKey_parenleft, FcitxKey_7, FcitxKey_parenright, 0x2466,
    FcitxKey_parenleft, FcitxKey_8, FcitxKey_parenright, 0x2467,
    FcitxKey_parenleft, FcitxKey_9, FcitxKey_parenright, 0x2468,
    FcitxKey_parenleft, FcitxKey_A, FcitxKey_parenright, 0x24B6,
    FcitxKey_parenleft, FcitxKey_B, FcitxKey_parenright, 0x24B7,
    FcitxKey_parenleft, FcitxKey_C, FcitxKey_parenright, 0x24B8,
    FcitxKey_parenleft, FcitxKey_D, FcitxKey_parenright, 0x24B9,
    FcitxKey_parenleft, FcitxKey_E, FcitxKey_parenright, 0x24BA,
    FcitxKey_parenleft, FcitxKey_F, FcitxKey_parenright, 0x24BB,
    FcitxKey_parenleft, FcitxKey_G, FcitxKey_parenright, 0x24BC,
    FcitxKey_parenleft, FcitxKey_H, FcitxKey_parenright, 0x24BD,
    FcitxKey_parenleft, FcitxKey_I, FcitxKey_parenright, 0x24BE,
    FcitxKey_parenleft, FcitxKey_J, FcitxKey_parenright, 0x24BF,
    FcitxKey_parenleft, FcitxKey_K, FcitxKey_parenright, 0x24C0,
    FcitxKey_parenleft, FcitxKey_L, FcitxKey_parenright, 0x24C1,
    FcitxKey_parenleft, FcitxKey_M, FcitxKey_parenright, 0x24C2,
    FcitxKey_parenleft, FcitxKey_N, FcitxKey_parenright, 0x24C3,
    FcitxKey_parenleft, FcitxKey_O, FcitxKey_parenright, 0x24C4,
    FcitxKey_parenleft, FcitxKey_P, FcitxKey_parenright, 0x24C5,
    FcitxKey_parenleft, FcitxKey_Q, FcitxKey_parenright, 0x24C6,
    FcitxKey_parenleft, FcitxKey_R, FcitxKey_parenright, 0x24C7,
    FcitxKey_parenleft, FcitxKey_S, FcitxKey_parenright, 0x24C8,
    FcitxKey_parenleft, FcitxKey_T, FcitxKey_parenright, 0x24C9,
    FcitxKey_parenleft, FcitxKey_U, FcitxKey_parenright, 0x24CA,
    FcitxKey_parenleft, FcitxKey_V, FcitxKey_parenright, 0x24CB,
    FcitxKey_parenleft, FcitxKey_W, FcitxKey_parenright, 0x24CC,
    FcitxKey_parenleft, FcitxKey_X, FcitxKey_parenright, 0x24CD,
    FcitxKey_parenleft, FcitxKey_Y, FcitxKey_parenright, 0x24CE,
    FcitxKey_parenleft, FcitxKey_Z, FcitxKey_parenright, 0x24CF,
    FcitxKey_parenleft, FcitxKey_a, FcitxKey_parenright, 0x24D0,
    FcitxKey_parenleft, FcitxKey_b, FcitxKey_parenright, 0x24D1,
    FcitxKey_parenleft, FcitxKey_c, FcitxKey_parenright, 0x24D2,
    FcitxKey_parenleft, FcitxKey_d, FcitxKey_parenright, 0x24D3,
    FcitxKey_parenleft, FcitxKey_e, FcitxKey_parenright, 0x24D4,
    FcitxKey_parenleft, FcitxKey_f, FcitxKey_parenright, 0x24D5,
    FcitxKey_parenleft, FcitxKey_g, FcitxKey_parenright, 0x24D6,
    FcitxKey_parenleft, FcitxKey_h, FcitxKey_parenright, 0x24D7,
    FcitxKey_parenleft, FcitxKey_i, FcitxKey_parenright, 0x24D8,
    FcitxKey_parenleft, FcitxKey_j, FcitxKey_parenright, 0x24D9,
    FcitxKey_parenleft, FcitxKey_k, FcitxKey_parenright, 0x24DA,
    FcitxKey_parenleft, FcitxKey_l, FcitxKey_parenright, 0x24DB,
    FcitxKey_parenleft, FcitxKey_m, FcitxKey_parenright, 0x24DC,
    FcitxKey_parenleft, FcitxKey_n, FcitxKey_parenright, 0x24DD,
    FcitxKey_parenleft, FcitxKey_o, FcitxKey_parenright, 0x24DE,
    FcitxKey_parenleft, FcitxKey_p, FcitxKey_parenright, 0x24DF,
    FcitxKey_parenleft, FcitxKey_q, FcitxKey_parenright, 0x24E0,
    FcitxKey_parenleft, FcitxKey_r, FcitxKey_parenright, 0x24E1,
    FcitxKey_parenleft, FcitxKey_s, FcitxKey_parenright, 0x24E2,
    FcitxKey_parenleft, FcitxKey_t, FcitxKey_parenright, 0x24E3,
    FcitxKey_parenleft, FcitxKey_u, FcitxKey_parenright, 0x24E4,
    FcitxKey_parenleft, FcitxKey_v, FcitxKey_parenright, 0x24E5,
    FcitxKey_parenleft, FcitxKey_w, FcitxKey_parenright, 0x24E6,
    FcitxKey_parenleft, FcitxKey_x, FcitxKey_parenright, 0x24E7,
    FcitxKey_parenleft, FcitxKey_y, FcitxKey_parenright, 0x24E8,
    FcitxKey_parenleft, FcitxKey_z, FcitxKey_parenright, 0x24E9,
    FcitxKey_parenleft, FcitxKey_kana_WO, FcitxKey_parenright, 0x32FE,
    FcitxKey_parenleft, FcitxKey_kana_A, FcitxKey_parenright, 0x32D0,
    FcitxKey_parenleft, FcitxKey_kana_I, FcitxKey_parenright, 0x32D1,
    FcitxKey_parenleft, FcitxKey_kana_U, FcitxKey_parenright, 0x32D2,
    FcitxKey_parenleft, FcitxKey_kana_E, FcitxKey_parenright, 0x32D3,
    FcitxKey_parenleft, FcitxKey_kana_O, FcitxKey_parenright, 0x32D4,
    FcitxKey_parenleft, FcitxKey_kana_KA, FcitxKey_parenright, 0x32D5,
    FcitxKey_parenleft, FcitxKey_kana_KI, FcitxKey_parenright, 0x32D6,
    FcitxKey_parenleft, FcitxKey_kana_KU, FcitxKey_parenright, 0x32D7,
    FcitxKey_parenleft, FcitxKey_kana_KE, FcitxKey_parenright, 0x32D8,
    FcitxKey_parenleft, FcitxKey_kana_KO, FcitxKey_parenright, 0x32D9,
    FcitxKey_parenleft, FcitxKey_kana_SA, FcitxKey_parenright, 0x32DA,
    FcitxKey_parenleft, FcitxKey_kana_SHI, FcitxKey_parenright, 0x32DB,
    FcitxKey_parenleft, FcitxKey_kana_SU, FcitxKey_parenright, 0x32DC,
    FcitxKey_parenleft, FcitxKey_kana_SE, FcitxKey_parenright, 0x32DD,
    FcitxKey_parenleft, FcitxKey_kana_SO, FcitxKey_parenright, 0x32DE,
    FcitxKey_parenleft, FcitxKey_kana_TA, FcitxKey_parenright, 0x32DF,
    FcitxKey_parenleft, FcitxKey_kana_CHI, FcitxKey_parenright, 0x32E0,
    FcitxKey_parenleft, FcitxKey_kana_TSU, FcitxKey_parenright, 0x32E1,
    FcitxKey_parenleft, FcitxKey_kana_TE, FcitxKey_parenright, 0x32E2,
    FcitxKey_parenleft, FcitxKey_kana_TO, FcitxKey_parenright, 0x32E3,
    FcitxKey_parenleft, FcitxKey_kana_NA, FcitxKey_parenright, 0x32E4,
    FcitxKey_parenleft, FcitxKey_kana_NI, FcitxKey_parenright, 0x32E5,
    FcitxKey_parenleft, FcitxKey_kana_NU, FcitxKey_parenright, 0x32E6,
    FcitxKey_parenleft, FcitxKey_kana_NE, FcitxKey_parenright, 0x32E7,
    FcitxKey_parenleft, FcitxKey_kana_NO, FcitxKey_parenright, 0x32E8,
    FcitxKey_parenleft, FcitxKey_kana_HA, FcitxKey_parenright, 0x32E9,
    FcitxKey_parenleft, FcitxKey_kana_HI, FcitxKey_parenright, 0x32EA,
    FcitxKey_parenleft, FcitxKey_kana_FU, FcitxKey_parenright, 0x32EB,
    FcitxKey_parenleft, FcitxKey_kana_HE, FcitxKey_parenright, 0x32EC,
    FcitxKey_parenleft, FcitxKey_kana_HO, FcitxKey_parenright, 0x32ED,
    FcitxKey_parenleft, FcitxKey_kana_MA, FcitxKey_parenright, 0x32EE,
    FcitxKey_parenleft, FcitxKey_kana_MI, FcitxKey_parenright, 0x32EF,
    FcitxKey_parenleft, FcitxKey_kana_MU, FcitxKey_parenright, 0x32F0,
    FcitxKey_parenleft, FcitxKey_kana_ME, FcitxKey_parenright, 0x32F1,
    FcitxKey_parenleft, FcitxKey_kana_MO, FcitxKey_parenright, 0x32F2,
    FcitxKey_parenleft, FcitxKey_kana_YA, FcitxKey_parenright, 0x32F3,
    FcitxKey_parenleft, FcitxKey_kana_YU, FcitxKey_parenright, 0x32F4,
    FcitxKey_parenleft, FcitxKey_kana_YO, FcitxKey_parenright, 0x32F5,
    FcitxKey_parenleft, FcitxKey_kana_RA, FcitxKey_parenright, 0x32F6,
    FcitxKey_parenleft, FcitxKey_kana_RI, FcitxKey_parenright, 0x32F7,
    FcitxKey_parenleft, FcitxKey_kana_RU, FcitxKey_parenright, 0x32F8,
    FcitxKey_parenleft, FcitxKey_kana_RE, FcitxKey_parenright, 0x32F9,
    FcitxKey_parenleft, FcitxKey_kana_RO, FcitxKey_parenright, 0x32FA,
    FcitxKey_parenleft, FcitxKey_kana_WA, FcitxKey_parenright, 0x32FB,
    FcitxKey_parenleft, 0x1100, FcitxKey_parenright, 0x3260,
    FcitxKey_parenleft, 0x1102, FcitxKey_parenright, 0x3261,
    FcitxKey_parenleft, 0x1103, FcitxKey_parenright, 0x3262,
    FcitxKey_parenleft, 0x1105, FcitxKey_parenright, 0x3263,
    FcitxKey_parenleft, 0x1106, FcitxKey_parenright, 0x3264,
    FcitxKey_parenleft, 0x1107, FcitxKey_parenright, 0x3265,
    FcitxKey_parenleft, 0x1109, FcitxKey_parenright, 0x3266,
    FcitxKey_parenleft, 0x110B, FcitxKey_parenright, 0x3267,
    FcitxKey_parenleft, 0x110C, FcitxKey_parenright, 0x3268,
    FcitxKey_parenleft, 0x110E, FcitxKey_parenright, 0x3269,
    FcitxKey_parenleft, 0x110F, FcitxKey_parenright, 0x326A,
    FcitxKey_parenleft, 0x1110, FcitxKey_parenright, 0x326B,
    FcitxKey_parenleft, 0x1111, FcitxKey_parenright, 0x326C,
    FcitxKey_parenleft, 0x1112, FcitxKey_parenright, 0x326D,
    FcitxKey_parenleft, 0x30F0, FcitxKey_parenright, 0x32FC,
    FcitxKey_parenleft, 0x30F1, FcitxKey_parenright, 0x32FD,
    FcitxKey_parenleft, 0x4E00, FcitxKey_parenright, 0x3280,
    FcitxKey_parenleft, 0x4E03, FcitxKey_parenright, 0x3286,
    FcitxKey_parenleft, 0x4E09, FcitxKey_parenright, 0x3282,
    FcitxKey_parenleft, 0x4E0A, FcitxKey_parenright, 0x32A4,
    FcitxKey_parenleft, 0x4E0B, FcitxKey_parenright, 0x32A6,
    FcitxKey_parenleft, 0x4E2D, FcitxKey_parenright, 0x32A5,
    FcitxKey_parenleft, 0x4E5D, FcitxKey_parenright, 0x3288,
    FcitxKey_parenleft, 0x4E8C, FcitxKey_parenright, 0x3281,
    FcitxKey_parenleft, 0x4E94, FcitxKey_parenright, 0x3284,
    FcitxKey_parenleft, 0x4F01, FcitxKey_parenright, 0x32AD,
    FcitxKey_parenleft, 0x4F11, FcitxKey_parenright, 0x32A1,
    FcitxKey_parenleft, 0x512A, FcitxKey_parenright, 0x329D,
    FcitxKey_parenleft, 0x516B, FcitxKey_parenright, 0x3287,
    FcitxKey_parenleft, 0x516D, FcitxKey_parenright, 0x3285,
    FcitxKey_parenleft, 0x5199, FcitxKey_parenright, 0x32A2,
    FcitxKey_parenleft, 0x52B4, FcitxKey_parenright, 0x3298,
    FcitxKey_parenleft, 0x533B, FcitxKey_parenright, 0x32A9,
    FcitxKey_parenleft, 0x5341, FcitxKey_parenright, 0x3289,
    FcitxKey_parenleft, 0x5354, FcitxKey_parenright, 0x32AF,
    FcitxKey_parenleft, 0x5370, FcitxKey_parenright, 0x329E,
    FcitxKey_parenleft, 0x53F3, FcitxKey_parenright, 0x32A8,
    FcitxKey_parenleft, 0x540D, FcitxKey_parenright, 0x3294,
    FcitxKey_parenleft, 0x56DB, FcitxKey_parenright, 0x3283,
    FcitxKey_parenleft, 0x571F, FcitxKey_parenright, 0x328F,
    FcitxKey_parenleft, 0x591C, FcitxKey_parenright, 0x32B0,
    FcitxKey_parenleft, 0x5973, FcitxKey_parenright, 0x329B,
    FcitxKey_parenleft, 0x5B66, FcitxKey_parenright, 0x32AB,
    FcitxKey_parenleft, 0x5B97, FcitxKey_parenright, 0x32AA,
    FcitxKey_parenleft, 0x5DE6, FcitxKey_parenright, 0x32A7,
    FcitxKey_parenleft, 0x65E5, FcitxKey_parenright, 0x3290,
    FcitxKey_parenleft, 0x6708, FcitxKey_parenright, 0x328A,
    FcitxKey_parenleft, 0x6709, FcitxKey_parenright, 0x3292,
    FcitxKey_parenleft, 0x6728, FcitxKey_parenright, 0x328D,
    FcitxKey_parenleft, 0x682A, FcitxKey_parenright, 0x3291,
    FcitxKey_parenleft, 0x6B63, FcitxKey_parenright, 0x32A3,
    FcitxKey_parenleft, 0x6C34, FcitxKey_parenright, 0x328C,
    FcitxKey_parenleft, 0x6CE8, FcitxKey_parenright, 0x329F,
    FcitxKey_parenleft, 0x706B, FcitxKey_parenright, 0x328B,
    FcitxKey_parenleft, 0x7279, FcitxKey_parenright, 0x3295,
    FcitxKey_parenleft, 0x7537, FcitxKey_parenright, 0x329A,
    FcitxKey_parenleft, 0x76E3, FcitxKey_parenright, 0x32AC,
    FcitxKey_parenleft, 0x793E, FcitxKey_parenright, 0x3293,
    FcitxKey_parenleft, 0x795D, FcitxKey_parenright, 0x3297,
    FcitxKey_parenleft, 0x79D8, FcitxKey_parenright, 0x3299,
    FcitxKey_parenleft, 0x8CA1, FcitxKey_parenright, 0x3296,
    FcitxKey_parenleft, 0x8CC7, FcitxKey_parenright, 0x32AE,
    FcitxKey_parenleft, 0x9069, FcitxKey_parenright, 0x329C,
    FcitxKey_parenleft, 0x91D1, FcitxKey_parenright, 0x328E,
    FcitxKey_parenleft, 0x9805, FcitxKey_parenright, 0x32A0,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_parenright, 0x2461,
    FcitxKey_parenleft, FcitxKey_KP_0, FcitxKey_parenright, 0x24EA,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_parenright, 0x2460,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_parenright, 0x2461,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_parenright, 0x2462,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_parenright, 0x2463,
    FcitxKey_parenleft, FcitxKey_KP_5, FcitxKey_parenright, 0x2464,
    FcitxKey_parenleft, FcitxKey_KP_6, FcitxKey_parenright, 0x2465,
    FcitxKey_parenleft, FcitxKey_KP_7, FcitxKey_parenright, 0x2466,
    FcitxKey_parenleft, FcitxKey_KP_8, FcitxKey_parenright, 0x2467,
    FcitxKey_parenleft, FcitxKey_KP_9, FcitxKey_parenright, 0x2468,
    FcitxKey_minus, FcitxKey_minus, FcitxKey_space, 0x00AD,
    FcitxKey_minus, FcitxKey_minus, FcitxKey_minus, 0x2014,
    FcitxKey_minus, FcitxKey_minus, FcitxKey_period, 0x2013,
    FcitxKey_period, FcitxKey_exclam, FcitxKey_S, 0x1E68,
    FcitxKey_period, FcitxKey_exclam, FcitxKey_s, 0x1E69,
    FcitxKey_period, FcitxKey_apostrophe, FcitxKey_S, 0x1E64,
    FcitxKey_period, FcitxKey_apostrophe, FcitxKey_s, 0x1E65,
    FcitxKey_period, FcitxKey_acute, FcitxKey_S, 0x1E64,
    FcitxKey_period, FcitxKey_acute, FcitxKey_s, 0x1E65,
    FcitxKey_period, FcitxKey_dead_acute, FcitxKey_S, 0x1E64,
    FcitxKey_period, FcitxKey_dead_acute, FcitxKey_s, 0x1E65,
    FcitxKey_period, FcitxKey_dead_caron, FcitxKey_S, 0x1E66,
    FcitxKey_period, FcitxKey_dead_caron, FcitxKey_s, 0x1E67,
    FcitxKey_period, FcitxKey_dead_belowdot, FcitxKey_S, 0x1E68,
    FcitxKey_period, FcitxKey_dead_belowdot, FcitxKey_s, 0x1E69,
    FcitxKey_question, FcitxKey_plus, FcitxKey_O, 0x1EDE,
    FcitxKey_question, FcitxKey_plus, FcitxKey_U, 0x1EEC,
    FcitxKey_question, FcitxKey_plus, FcitxKey_o, 0x1EDF,
    FcitxKey_question, FcitxKey_plus, FcitxKey_u, 0x1EED,
    FcitxKey_question, FcitxKey_asciicircum, FcitxKey_A, 0x1EA8,
    FcitxKey_question, FcitxKey_asciicircum, FcitxKey_E, 0x1EC2,
    FcitxKey_question, FcitxKey_asciicircum, FcitxKey_O, 0x1ED4,
    FcitxKey_question, FcitxKey_asciicircum, FcitxKey_a, 0x1EA9,
    FcitxKey_question, FcitxKey_asciicircum, FcitxKey_e, 0x1EC3,
    FcitxKey_question, FcitxKey_asciicircum, FcitxKey_o, 0x1ED5,
    FcitxKey_question, FcitxKey_b, FcitxKey_A, 0x1EB2,
    FcitxKey_question, FcitxKey_b, FcitxKey_a, 0x1EB3,
    FcitxKey_question, FcitxKey_dead_circumflex, FcitxKey_A, 0x1EA8,
    FcitxKey_question, FcitxKey_dead_circumflex, FcitxKey_E, 0x1EC2,
    FcitxKey_question, FcitxKey_dead_circumflex, FcitxKey_O, 0x1ED4,
    FcitxKey_question, FcitxKey_dead_circumflex, FcitxKey_a, 0x1EA9,
    FcitxKey_question, FcitxKey_dead_circumflex, FcitxKey_e, 0x1EC3,
    FcitxKey_question, FcitxKey_dead_circumflex, FcitxKey_o, 0x1ED5,
    FcitxKey_question, FcitxKey_dead_breve, FcitxKey_A, 0x1EB2,
    FcitxKey_question, FcitxKey_dead_breve, FcitxKey_a, 0x1EB3,
    FcitxKey_question, FcitxKey_dead_horn, FcitxKey_O, 0x1EDE,
    FcitxKey_question, FcitxKey_dead_horn, FcitxKey_U, 0x1EEC,
    FcitxKey_question, FcitxKey_dead_horn, FcitxKey_o, 0x1EDF,
    FcitxKey_question, FcitxKey_dead_horn, FcitxKey_u, 0x1EED,
    FcitxKey_U, FcitxKey_exclam, FcitxKey_A, 0x1EB6,
    FcitxKey_U, FcitxKey_exclam, FcitxKey_a, 0x1EB7,
    FcitxKey_U, FcitxKey_comma, FcitxKey_E, 0x1E1C,
    FcitxKey_U, FcitxKey_comma, FcitxKey_e, 0x1E1D,
    FcitxKey_U, FcitxKey_cedilla, FcitxKey_E, 0x1E1C,
    FcitxKey_U, FcitxKey_cedilla, FcitxKey_e, 0x1E1D,
    FcitxKey_U, FcitxKey_dead_cedilla, FcitxKey_E, 0x1E1C,
    FcitxKey_U, FcitxKey_dead_cedilla, FcitxKey_e, 0x1E1D,
    FcitxKey_U, FcitxKey_dead_belowdot, FcitxKey_A, 0x1EB6,
    FcitxKey_U, FcitxKey_dead_belowdot, FcitxKey_a, 0x1EB7,
    FcitxKey_asciicircum, FcitxKey_exclam, FcitxKey_A, 0x1EAC,
    FcitxKey_asciicircum, FcitxKey_exclam, FcitxKey_E, 0x1EC6,
    FcitxKey_asciicircum, FcitxKey_exclam, FcitxKey_O, 0x1ED8,
    FcitxKey_asciicircum, FcitxKey_exclam, FcitxKey_a, 0x1EAD,
    FcitxKey_asciicircum, FcitxKey_exclam, FcitxKey_e, 0x1EC7,
    FcitxKey_asciicircum, FcitxKey_exclam, FcitxKey_o, 0x1ED9,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_a, 0x00AA,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_h, 0x02B0,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_i, 0x2071,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_j, 0x02B2,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_l, 0x02E1,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_n, 0x207F,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_o, 0x00BA,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_r, 0x02B3,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_s, 0x02E2,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_w, 0x02B7,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_x, 0x02E3,
    FcitxKey_asciicircum, FcitxKey_underscore, FcitxKey_y, 0x02B8,
    FcitxKey_asciicircum, FcitxKey_underscore, 0x0263, 0x02E0,
    FcitxKey_asciicircum, FcitxKey_underscore, 0x0266, 0x02B1,
    FcitxKey_asciicircum, FcitxKey_underscore, 0x0279, 0x02B4,
    FcitxKey_asciicircum, FcitxKey_underscore, 0x027B, 0x02B5,
    FcitxKey_asciicircum, FcitxKey_underscore, 0x0281, 0x02B6,
    FcitxKey_asciicircum, FcitxKey_underscore, 0x0295, 0x02E4,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_a, 0x00AA,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_h, 0x02B0,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_i, 0x2071,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_j, 0x02B2,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_l, 0x02E1,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_n, 0x207F,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_o, 0x00BA,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_r, 0x02B3,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_s, 0x02E2,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_w, 0x02B7,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_x, 0x02E3,
    FcitxKey_asciicircum, FcitxKey_underbar, FcitxKey_y, 0x02B8,
    FcitxKey_asciicircum, FcitxKey_underbar, 0x0263, 0x02E0,
    FcitxKey_asciicircum, FcitxKey_underbar, 0x0266, 0x02B1,
    FcitxKey_asciicircum, FcitxKey_underbar, 0x0279, 0x02B4,
    FcitxKey_asciicircum, FcitxKey_underbar, 0x027B, 0x02B5,
    FcitxKey_asciicircum, FcitxKey_underbar, 0x0281, 0x02B6,
    FcitxKey_asciicircum, FcitxKey_underbar, 0x0295, 0x02E4,
    FcitxKey_asciicircum, FcitxKey_dead_belowdot, FcitxKey_A, 0x1EAC,
    FcitxKey_asciicircum, FcitxKey_dead_belowdot, FcitxKey_E, 0x1EC6,
    FcitxKey_asciicircum, FcitxKey_dead_belowdot, FcitxKey_O, 0x1ED8,
    FcitxKey_asciicircum, FcitxKey_dead_belowdot, FcitxKey_a, 0x1EAD,
    FcitxKey_asciicircum, FcitxKey_dead_belowdot, FcitxKey_e, 0x1EC7,
    FcitxKey_asciicircum, FcitxKey_dead_belowdot, FcitxKey_o, 0x1ED9,
    FcitxKey_underscore, FcitxKey_exclam, FcitxKey_L, 0x1E38,
    FcitxKey_underscore, FcitxKey_exclam, FcitxKey_R, 0x1E5C,
    FcitxKey_underscore, FcitxKey_exclam, FcitxKey_l, 0x1E39,
    FcitxKey_underscore, FcitxKey_exclam, FcitxKey_r, 0x1E5D,
    FcitxKey_underscore, FcitxKey_quotedbl, FcitxKey_A, 0x01DE,
    FcitxKey_underscore, FcitxKey_quotedbl, FcitxKey_O, 0x022A,
    FcitxKey_underscore, FcitxKey_quotedbl, FcitxKey_U, 0x01D5,
    FcitxKey_underscore, FcitxKey_quotedbl, FcitxKey_a, 0x01DF,
    FcitxKey_underscore, FcitxKey_quotedbl, FcitxKey_o, 0x022B,
    FcitxKey_underscore, FcitxKey_quotedbl, FcitxKey_u, 0x01D6,
    FcitxKey_underscore, FcitxKey_period, FcitxKey_A, 0x01E0,
    FcitxKey_underscore, FcitxKey_period, FcitxKey_O, 0x0230,
    FcitxKey_underscore, FcitxKey_period, FcitxKey_a, 0x01E1,
    FcitxKey_underscore, FcitxKey_period, FcitxKey_o, 0x0231,
    FcitxKey_underscore, FcitxKey_semicolon, FcitxKey_O, 0x01EC,
    FcitxKey_underscore, FcitxKey_semicolon, FcitxKey_o, 0x01ED,
    FcitxKey_underscore, FcitxKey_asciitilde, FcitxKey_O, 0x022C,
    FcitxKey_underscore, FcitxKey_asciitilde, FcitxKey_o, 0x022D,
    FcitxKey_underscore, FcitxKey_dead_tilde, FcitxKey_O, 0x022C,
    FcitxKey_underscore, FcitxKey_dead_tilde, FcitxKey_o, 0x022D,
    FcitxKey_underscore, FcitxKey_dead_abovedot, FcitxKey_A, 0x01E0,
    FcitxKey_underscore, FcitxKey_dead_abovedot, FcitxKey_O, 0x0230,
    FcitxKey_underscore, FcitxKey_dead_abovedot, FcitxKey_a, 0x01E1,
    FcitxKey_underscore, FcitxKey_dead_abovedot, FcitxKey_o, 0x0231,
    FcitxKey_underscore, FcitxKey_dead_diaeresis, FcitxKey_A, 0x01DE,
    FcitxKey_underscore, FcitxKey_dead_diaeresis, FcitxKey_O, 0x022A,
    FcitxKey_underscore, FcitxKey_dead_diaeresis, FcitxKey_U, 0x01D5,
    FcitxKey_underscore, FcitxKey_dead_diaeresis, FcitxKey_a, 0x01DF,
    FcitxKey_underscore, FcitxKey_dead_diaeresis, FcitxKey_o, 0x022B,
    FcitxKey_underscore, FcitxKey_dead_diaeresis, FcitxKey_u, 0x01D6,
    FcitxKey_underscore, FcitxKey_dead_ogonek, FcitxKey_O, 0x01EC,
    FcitxKey_underscore, FcitxKey_dead_ogonek, FcitxKey_o, 0x01ED,
    FcitxKey_underscore, FcitxKey_dead_belowdot, FcitxKey_L, 0x1E38,
    FcitxKey_underscore, FcitxKey_dead_belowdot, FcitxKey_R, 0x1E5C,
    FcitxKey_underscore, FcitxKey_dead_belowdot, FcitxKey_l, 0x1E39,
    FcitxKey_underscore, FcitxKey_dead_belowdot, FcitxKey_r, 0x1E5D,
    FcitxKey_grave, FcitxKey_quotedbl, FcitxKey_U, 0x01DB,
    FcitxKey_grave, FcitxKey_quotedbl, FcitxKey_u, 0x01DC,
    FcitxKey_grave, FcitxKey_quotedbl, FcitxKey_Greek_iota, 0x1FD2,
    FcitxKey_grave, FcitxKey_quotedbl, FcitxKey_Greek_upsilon, 0x1FE2,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F0B,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_EPSILON, 0x1F1B,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F2B,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_IOTA, 0x1F3B,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_OMICRON, 0x1F4B,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_UPSILON, 0x1F5B,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1F6B,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F03,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_epsilon, 0x1F13,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F23,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_iota, 0x1F33,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_omicron, 0x1F43,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_upsilon, 0x1F53,
    FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1F63,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F0A,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_EPSILON, 0x1F1A,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F2A,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_IOTA, 0x1F3A,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_OMICRON, 0x1F4A,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1F6A,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F02,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_epsilon, 0x1F12,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F22,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_iota, 0x1F32,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_omicron, 0x1F42,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_upsilon, 0x1F52,
    FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1F62,
    FcitxKey_grave, FcitxKey_plus, FcitxKey_O, 0x1EDC,
    FcitxKey_grave, FcitxKey_plus, FcitxKey_U, 0x1EEA,
    FcitxKey_grave, FcitxKey_plus, FcitxKey_o, 0x1EDD,
    FcitxKey_grave, FcitxKey_plus, FcitxKey_u, 0x1EEB,
    FcitxKey_grave, FcitxKey_asciicircum, FcitxKey_A, 0x1EA6,
    FcitxKey_grave, FcitxKey_asciicircum, FcitxKey_E, 0x1EC0,
    FcitxKey_grave, FcitxKey_asciicircum, FcitxKey_O, 0x1ED2,
    FcitxKey_grave, FcitxKey_asciicircum, FcitxKey_a, 0x1EA7,
    FcitxKey_grave, FcitxKey_asciicircum, FcitxKey_e, 0x1EC1,
    FcitxKey_grave, FcitxKey_asciicircum, FcitxKey_o, 0x1ED3,
    FcitxKey_grave, FcitxKey_underscore, FcitxKey_E, 0x1E14,
    FcitxKey_grave, FcitxKey_underscore, FcitxKey_O, 0x1E50,
    FcitxKey_grave, FcitxKey_underscore, FcitxKey_e, 0x1E15,
    FcitxKey_grave, FcitxKey_underscore, FcitxKey_o, 0x1E51,
    FcitxKey_grave, FcitxKey_b, FcitxKey_A, 0x1EB0,
    FcitxKey_grave, FcitxKey_b, FcitxKey_a, 0x1EB1,
    FcitxKey_grave, FcitxKey_macron, FcitxKey_E, 0x1E14,
    FcitxKey_grave, FcitxKey_macron, FcitxKey_O, 0x1E50,
    FcitxKey_grave, FcitxKey_macron, FcitxKey_e, 0x1E15,
    FcitxKey_grave, FcitxKey_macron, FcitxKey_o, 0x1E51,
    FcitxKey_grave, FcitxKey_dead_circumflex, FcitxKey_A, 0x1EA6,
    FcitxKey_grave, FcitxKey_dead_circumflex, FcitxKey_E, 0x1EC0,
    FcitxKey_grave, FcitxKey_dead_circumflex, FcitxKey_O, 0x1ED2,
    FcitxKey_grave, FcitxKey_dead_circumflex, FcitxKey_a, 0x1EA7,
    FcitxKey_grave, FcitxKey_dead_circumflex, FcitxKey_e, 0x1EC1,
    FcitxKey_grave, FcitxKey_dead_circumflex, FcitxKey_o, 0x1ED3,
    FcitxKey_grave, FcitxKey_dead_macron, FcitxKey_E, 0x1E14,
    FcitxKey_grave, FcitxKey_dead_macron, FcitxKey_O, 0x1E50,
    FcitxKey_grave, FcitxKey_dead_macron, FcitxKey_e, 0x1E15,
    FcitxKey_grave, FcitxKey_dead_macron, FcitxKey_o, 0x1E51,
    FcitxKey_grave, FcitxKey_dead_breve, FcitxKey_A, 0x1EB0,
    FcitxKey_grave, FcitxKey_dead_breve, FcitxKey_a, 0x1EB1,
    FcitxKey_grave, FcitxKey_dead_diaeresis, FcitxKey_U, 0x01DB,
    FcitxKey_grave, FcitxKey_dead_diaeresis, FcitxKey_u, 0x01DC,
    FcitxKey_grave, FcitxKey_dead_diaeresis, FcitxKey_Greek_iota, 0x1FD2,
    FcitxKey_grave, FcitxKey_dead_diaeresis, FcitxKey_Greek_upsilon, 0x1FE2,
    FcitxKey_grave, FcitxKey_dead_horn, FcitxKey_O, 0x1EDC,
    FcitxKey_grave, FcitxKey_dead_horn, FcitxKey_U, 0x1EEA,
    FcitxKey_grave, FcitxKey_dead_horn, FcitxKey_o, 0x1EDD,
    FcitxKey_grave, FcitxKey_dead_horn, FcitxKey_u, 0x1EEB,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F0A,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_EPSILON, 0x1F1A,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F2A,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_IOTA, 0x1F3A,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_OMICRON, 0x1F4A,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1F6A,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F02,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_epsilon, 0x1F12,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F22,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_iota, 0x1F32,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_omicron, 0x1F42,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_upsilon, 0x1F52,
    FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1F62,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F0B,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_EPSILON, 0x1F1B,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F2B,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_IOTA, 0x1F3B,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_OMICRON, 0x1F4B,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_UPSILON, 0x1F5B,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1F6B,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F03,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_epsilon, 0x1F13,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F23,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_iota, 0x1F33,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_omicron, 0x1F43,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_upsilon, 0x1F53,
    FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1F63,
    FcitxKey_b, FcitxKey_exclam, FcitxKey_A, 0x1EB6,
    FcitxKey_b, FcitxKey_exclam, FcitxKey_a, 0x1EB7,
    FcitxKey_b, FcitxKey_comma, FcitxKey_E, 0x1E1C,
    FcitxKey_b, FcitxKey_comma, FcitxKey_e, 0x1E1D,
    FcitxKey_b, FcitxKey_cedilla, FcitxKey_E, 0x1E1C,
    FcitxKey_b, FcitxKey_cedilla, FcitxKey_e, 0x1E1D,
    FcitxKey_b, FcitxKey_dead_cedilla, FcitxKey_E, 0x1E1C,
    FcitxKey_b, FcitxKey_dead_cedilla, FcitxKey_e, 0x1E1D,
    FcitxKey_b, FcitxKey_dead_belowdot, FcitxKey_A, 0x1EB6,
    FcitxKey_b, FcitxKey_dead_belowdot, FcitxKey_a, 0x1EB7,
    FcitxKey_c, FcitxKey_quotedbl, FcitxKey_U, 0x01D9,
    FcitxKey_c, FcitxKey_quotedbl, FcitxKey_u, 0x01DA,
    FcitxKey_c, FcitxKey_dead_diaeresis, FcitxKey_U, 0x01D9,
    FcitxKey_c, FcitxKey_dead_diaeresis, FcitxKey_u, 0x01DA,
    FcitxKey_o, FcitxKey_apostrophe, FcitxKey_A, 0x01FA,
    FcitxKey_o, FcitxKey_apostrophe, FcitxKey_a, 0x01FB,
    FcitxKey_asciitilde, FcitxKey_quotedbl, FcitxKey_Greek_iota, 0x1FD7,
    FcitxKey_asciitilde, FcitxKey_quotedbl, FcitxKey_Greek_upsilon, 0x1FE7,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F0F,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F2F,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_IOTA, 0x1F3F,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_UPSILON, 0x1F5F,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1F6F,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F07,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F27,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_iota, 0x1F37,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_upsilon, 0x1F57,
    FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1F67,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F0E,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F2E,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_IOTA, 0x1F3E,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1F6E,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F06,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F26,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_iota, 0x1F36,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_upsilon, 0x1F56,
    FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1F66,
    FcitxKey_asciitilde, FcitxKey_plus, FcitxKey_O, 0x1EE0,
    FcitxKey_asciitilde, FcitxKey_plus, FcitxKey_U, 0x1EEE,
    FcitxKey_asciitilde, FcitxKey_plus, FcitxKey_o, 0x1EE1,
    FcitxKey_asciitilde, FcitxKey_plus, FcitxKey_u, 0x1EEF,
    FcitxKey_asciitilde, FcitxKey_asciicircum, FcitxKey_A, 0x1EAA,
    FcitxKey_asciitilde, FcitxKey_asciicircum, FcitxKey_E, 0x1EC4,
    FcitxKey_asciitilde, FcitxKey_asciicircum, FcitxKey_O, 0x1ED6,
    FcitxKey_asciitilde, FcitxKey_asciicircum, FcitxKey_a, 0x1EAB,
    FcitxKey_asciitilde, FcitxKey_asciicircum, FcitxKey_e, 0x1EC5,
    FcitxKey_asciitilde, FcitxKey_asciicircum, FcitxKey_o, 0x1ED7,
    FcitxKey_asciitilde, FcitxKey_b, FcitxKey_A, 0x1EB4,
    FcitxKey_asciitilde, FcitxKey_b, FcitxKey_a, 0x1EB5,
    FcitxKey_asciitilde, FcitxKey_dead_circumflex, FcitxKey_A, 0x1EAA,
    FcitxKey_asciitilde, FcitxKey_dead_circumflex, FcitxKey_E, 0x1EC4,
    FcitxKey_asciitilde, FcitxKey_dead_circumflex, FcitxKey_O, 0x1ED6,
    FcitxKey_asciitilde, FcitxKey_dead_circumflex, FcitxKey_a, 0x1EAB,
    FcitxKey_asciitilde, FcitxKey_dead_circumflex, FcitxKey_e, 0x1EC5,
    FcitxKey_asciitilde, FcitxKey_dead_circumflex, FcitxKey_o, 0x1ED7,
    FcitxKey_asciitilde, FcitxKey_dead_breve, FcitxKey_A, 0x1EB4,
    FcitxKey_asciitilde, FcitxKey_dead_breve, FcitxKey_a, 0x1EB5,
    FcitxKey_asciitilde, FcitxKey_dead_diaeresis, FcitxKey_Greek_iota, 0x1FD7,
    FcitxKey_asciitilde, FcitxKey_dead_diaeresis, FcitxKey_Greek_upsilon, 0x1FE7,
    FcitxKey_asciitilde, FcitxKey_dead_horn, FcitxKey_O, 0x1EE0,
    FcitxKey_asciitilde, FcitxKey_dead_horn, FcitxKey_U, 0x1EEE,
    FcitxKey_asciitilde, FcitxKey_dead_horn, FcitxKey_o, 0x1EE1,
    FcitxKey_asciitilde, FcitxKey_dead_horn, FcitxKey_u, 0x1EEF,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F0E,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F2E,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_IOTA, 0x1F3E,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1F6E,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F06,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F26,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_iota, 0x1F36,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_upsilon, 0x1F56,
    FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1F66,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F0F,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F2F,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_IOTA, 0x1F3F,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_UPSILON, 0x1F5F,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1F6F,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F07,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F27,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_iota, 0x1F37,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_upsilon, 0x1F57,
    FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1F67,
    FcitxKey_macron, FcitxKey_exclam, FcitxKey_L, 0x1E38,
    FcitxKey_macron, FcitxKey_exclam, FcitxKey_R, 0x1E5C,
    FcitxKey_macron, FcitxKey_exclam, FcitxKey_l, 0x1E39,
    FcitxKey_macron, FcitxKey_exclam, FcitxKey_r, 0x1E5D,
    FcitxKey_macron, FcitxKey_quotedbl, FcitxKey_A, 0x01DE,
    FcitxKey_macron, FcitxKey_quotedbl, FcitxKey_O, 0x022A,
    FcitxKey_macron, FcitxKey_quotedbl, FcitxKey_U, 0x01D5,
    FcitxKey_macron, FcitxKey_quotedbl, FcitxKey_a, 0x01DF,
    FcitxKey_macron, FcitxKey_quotedbl, FcitxKey_o, 0x022B,
    FcitxKey_macron, FcitxKey_quotedbl, FcitxKey_u, 0x01D6,
    FcitxKey_macron, FcitxKey_period, FcitxKey_A, 0x01E0,
    FcitxKey_macron, FcitxKey_period, FcitxKey_O, 0x0230,
    FcitxKey_macron, FcitxKey_period, FcitxKey_a, 0x01E1,
    FcitxKey_macron, FcitxKey_period, FcitxKey_o, 0x0231,
    FcitxKey_macron, FcitxKey_semicolon, FcitxKey_O, 0x01EC,
    FcitxKey_macron, FcitxKey_semicolon, FcitxKey_o, 0x01ED,
    FcitxKey_macron, FcitxKey_asciitilde, FcitxKey_O, 0x022C,
    FcitxKey_macron, FcitxKey_asciitilde, FcitxKey_o, 0x022D,
    FcitxKey_macron, FcitxKey_dead_tilde, FcitxKey_O, 0x022C,
    FcitxKey_macron, FcitxKey_dead_tilde, FcitxKey_o, 0x022D,
    FcitxKey_macron, FcitxKey_dead_abovedot, FcitxKey_A, 0x01E0,
    FcitxKey_macron, FcitxKey_dead_abovedot, FcitxKey_O, 0x0230,
    FcitxKey_macron, FcitxKey_dead_abovedot, FcitxKey_a, 0x01E1,
    FcitxKey_macron, FcitxKey_dead_abovedot, FcitxKey_o, 0x0231,
    FcitxKey_macron, FcitxKey_dead_diaeresis, FcitxKey_A, 0x01DE,
    FcitxKey_macron, FcitxKey_dead_diaeresis, FcitxKey_O, 0x022A,
    FcitxKey_macron, FcitxKey_dead_diaeresis, FcitxKey_U, 0x01D5,
    FcitxKey_macron, FcitxKey_dead_diaeresis, FcitxKey_a, 0x01DF,
    FcitxKey_macron, FcitxKey_dead_diaeresis, FcitxKey_o, 0x022B,
    FcitxKey_macron, FcitxKey_dead_diaeresis, FcitxKey_u, 0x01D6,
    FcitxKey_macron, FcitxKey_dead_ogonek, FcitxKey_O, 0x01EC,
    FcitxKey_macron, FcitxKey_dead_ogonek, FcitxKey_o, 0x01ED,
    FcitxKey_macron, FcitxKey_dead_belowdot, FcitxKey_L, 0x1E38,
    FcitxKey_macron, FcitxKey_dead_belowdot, FcitxKey_R, 0x1E5C,
    FcitxKey_macron, FcitxKey_dead_belowdot, FcitxKey_l, 0x1E39,
    FcitxKey_macron, FcitxKey_dead_belowdot, FcitxKey_r, 0x1E5D,
    FcitxKey_acute, FcitxKey_quotedbl, FcitxKey_I, 0x1E2E,
    FcitxKey_acute, FcitxKey_quotedbl, FcitxKey_U, 0x01D7,
    FcitxKey_acute, FcitxKey_quotedbl, FcitxKey_i, 0x1E2F,
    FcitxKey_acute, FcitxKey_quotedbl, FcitxKey_u, 0x01D8,
    FcitxKey_acute, FcitxKey_quotedbl, FcitxKey_Greek_iota, 0x0390,
    FcitxKey_acute, FcitxKey_quotedbl, FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F0D,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_EPSILON, 0x1F1D,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F2D,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_IOTA, 0x1F3D,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_OMICRON, 0x1F4D,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_UPSILON, 0x1F5D,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1F6D,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F05,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_epsilon, 0x1F15,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F25,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_iota, 0x1F35,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_omicron, 0x1F45,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_upsilon, 0x1F55,
    FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1F65,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F0C,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_EPSILON, 0x1F1C,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F2C,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_IOTA, 0x1F3C,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_OMICRON, 0x1F4C,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1F6C,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F04,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_epsilon, 0x1F14,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F24,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_iota, 0x1F34,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_omicron, 0x1F44,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_upsilon, 0x1F54,
    FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1F64,
    FcitxKey_acute, FcitxKey_plus, FcitxKey_O, 0x1EDA,
    FcitxKey_acute, FcitxKey_plus, FcitxKey_U, 0x1EE8,
    FcitxKey_acute, FcitxKey_plus, FcitxKey_o, 0x1EDB,
    FcitxKey_acute, FcitxKey_plus, FcitxKey_u, 0x1EE9,
    FcitxKey_acute, FcitxKey_comma, FcitxKey_C, 0x1E08,
    FcitxKey_acute, FcitxKey_comma, FcitxKey_c, 0x1E09,
    FcitxKey_acute, FcitxKey_slash, FcitxKey_O, 0x01FE,
    FcitxKey_acute, FcitxKey_slash, FcitxKey_o, 0x01FF,
    FcitxKey_acute, FcitxKey_asciicircum, FcitxKey_A, 0x1EA4,
    FcitxKey_acute, FcitxKey_asciicircum, FcitxKey_E, 0x1EBE,
    FcitxKey_acute, FcitxKey_asciicircum, FcitxKey_O, 0x1ED0,
    FcitxKey_acute, FcitxKey_asciicircum, FcitxKey_a, 0x1EA5,
    FcitxKey_acute, FcitxKey_asciicircum, FcitxKey_e, 0x1EBF,
    FcitxKey_acute, FcitxKey_asciicircum, FcitxKey_o, 0x1ED1,
    FcitxKey_acute, FcitxKey_underscore, FcitxKey_E, 0x1E16,
    FcitxKey_acute, FcitxKey_underscore, FcitxKey_O, 0x1E52,
    FcitxKey_acute, FcitxKey_underscore, FcitxKey_e, 0x1E17,
    FcitxKey_acute, FcitxKey_underscore, FcitxKey_o, 0x1E53,
    FcitxKey_acute, FcitxKey_b, FcitxKey_A, 0x1EAE,
    FcitxKey_acute, FcitxKey_b, FcitxKey_a, 0x1EAF,
    FcitxKey_acute, FcitxKey_asciitilde, FcitxKey_O, 0x1E4C,
    FcitxKey_acute, FcitxKey_asciitilde, FcitxKey_U, 0x1E78,
    FcitxKey_acute, FcitxKey_asciitilde, FcitxKey_o, 0x1E4D,
    FcitxKey_acute, FcitxKey_asciitilde, FcitxKey_u, 0x1E79,
    FcitxKey_acute, FcitxKey_macron, FcitxKey_E, 0x1E16,
    FcitxKey_acute, FcitxKey_macron, FcitxKey_O, 0x1E52,
    FcitxKey_acute, FcitxKey_macron, FcitxKey_e, 0x1E17,
    FcitxKey_acute, FcitxKey_macron, FcitxKey_o, 0x1E53,
    FcitxKey_acute, FcitxKey_cedilla, FcitxKey_C, 0x1E08,
    FcitxKey_acute, FcitxKey_cedilla, FcitxKey_c, 0x1E09,
    FcitxKey_acute, FcitxKey_dead_circumflex, FcitxKey_A, 0x1EA4,
    FcitxKey_acute, FcitxKey_dead_circumflex, FcitxKey_E, 0x1EBE,
    FcitxKey_acute, FcitxKey_dead_circumflex, FcitxKey_O, 0x1ED0,
    FcitxKey_acute, FcitxKey_dead_circumflex, FcitxKey_a, 0x1EA5,
    FcitxKey_acute, FcitxKey_dead_circumflex, FcitxKey_e, 0x1EBF,
    FcitxKey_acute, FcitxKey_dead_circumflex, FcitxKey_o, 0x1ED1,
    FcitxKey_acute, FcitxKey_dead_tilde, FcitxKey_O, 0x1E4C,
    FcitxKey_acute, FcitxKey_dead_tilde, FcitxKey_U, 0x1E78,
    FcitxKey_acute, FcitxKey_dead_tilde, FcitxKey_o, 0x1E4D,
    FcitxKey_acute, FcitxKey_dead_tilde, FcitxKey_u, 0x1E79,
    FcitxKey_acute, FcitxKey_dead_macron, FcitxKey_E, 0x1E16,
    FcitxKey_acute, FcitxKey_dead_macron, FcitxKey_O, 0x1E52,
    FcitxKey_acute, FcitxKey_dead_macron, FcitxKey_e, 0x1E17,
    FcitxKey_acute, FcitxKey_dead_macron, FcitxKey_o, 0x1E53,
    FcitxKey_acute, FcitxKey_dead_breve, FcitxKey_A, 0x1EAE,
    FcitxKey_acute, FcitxKey_dead_breve, FcitxKey_a, 0x1EAF,
    FcitxKey_acute, FcitxKey_dead_diaeresis, FcitxKey_I, 0x1E2E,
    FcitxKey_acute, FcitxKey_dead_diaeresis, FcitxKey_U, 0x01D7,
    FcitxKey_acute, FcitxKey_dead_diaeresis, FcitxKey_i, 0x1E2F,
    FcitxKey_acute, FcitxKey_dead_diaeresis, FcitxKey_u, 0x01D8,
    FcitxKey_acute, FcitxKey_dead_diaeresis, FcitxKey_Greek_iota, 0x0390,
    FcitxKey_acute, FcitxKey_dead_diaeresis, FcitxKey_Greek_upsilon, 0x03B0,
    FcitxKey_acute, FcitxKey_dead_abovering, FcitxKey_A, 0x01FA,
    FcitxKey_acute, FcitxKey_dead_abovering, FcitxKey_a, 0x01FB,
    FcitxKey_acute, FcitxKey_dead_cedilla, FcitxKey_C, 0x1E08,
    FcitxKey_acute, FcitxKey_dead_cedilla, FcitxKey_c, 0x1E09,
    FcitxKey_acute, FcitxKey_dead_horn, FcitxKey_O, 0x1EDA,
    FcitxKey_acute, FcitxKey_dead_horn, FcitxKey_U, 0x1EE8,
    FcitxKey_acute, FcitxKey_dead_horn, FcitxKey_o, 0x1EDB,
    FcitxKey_acute, FcitxKey_dead_horn, FcitxKey_u, 0x1EE9,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F0C,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_EPSILON, 0x1F1C,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F2C,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_IOTA, 0x1F3C,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_OMICRON, 0x1F4C,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1F6C,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F04,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_epsilon, 0x1F14,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F24,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_iota, 0x1F34,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_omicron, 0x1F44,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_upsilon, 0x1F54,
    FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1F64,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F0D,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_EPSILON, 0x1F1D,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F2D,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_IOTA, 0x1F3D,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_OMICRON, 0x1F4D,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_UPSILON, 0x1F5D,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1F6D,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F05,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_epsilon, 0x1F15,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F25,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_iota, 0x1F35,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_omicron, 0x1F45,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_upsilon, 0x1F55,
    FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1F65,
    FcitxKey_acute, FcitxKey_KP_Divide, FcitxKey_O, 0x01FE,
    FcitxKey_acute, FcitxKey_KP_Divide, FcitxKey_o, 0x01FF,
    0x05C1, 0x05BC, FcitxKey_hebrew_shin, 0xFB2C,
    0x05C2, 0x05BC, FcitxKey_hebrew_shin, 0xFB2D,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_Greek_alpha, 0x1FB4,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_Greek_eta, 0x1FC4,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_Greek_omega, 0x1FF4,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F00, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F01, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F08, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F09, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F20, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F21, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F28, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F29, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F60, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F61, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F68, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, 0x1F69, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F89,
    FcitxKey_Greek_iota, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F99,
    FcitxKey_Greek_iota, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FA9,
    FcitxKey_Greek_iota, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F81,
    FcitxKey_Greek_iota, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F91,
    FcitxKey_Greek_iota, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA1,
    FcitxKey_Greek_iota, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F88,
    FcitxKey_Greek_iota, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F98,
    FcitxKey_Greek_iota, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FA8,
    FcitxKey_Greek_iota, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F80,
    FcitxKey_Greek_iota, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F90,
    FcitxKey_Greek_iota, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA0,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_Greek_alpha, 0x1FB2,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_Greek_eta, 0x1FC2,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_Greek_omega, 0x1FF2,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F00, 0x1F82,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F01, 0x1F83,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F08, 0x1F8A,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F09, 0x1F8B,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F20, 0x1F92,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F21, 0x1F93,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F28, 0x1F9A,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F29, 0x1F9B,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F60, 0x1FA2,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F61, 0x1FA3,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F68, 0x1FAA,
    FcitxKey_Greek_iota, FcitxKey_grave, 0x1F69, 0x1FAB,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_Greek_alpha, 0x1FB7,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_Greek_eta, 0x1FC7,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_Greek_omega, 0x1FF7,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F00, 0x1F86,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F01, 0x1F87,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F08, 0x1F8E,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F09, 0x1F8F,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F20, 0x1F96,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F21, 0x1F97,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F28, 0x1F9E,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F29, 0x1F9F,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F60, 0x1FA6,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F61, 0x1FA7,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F68, 0x1FAE,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, 0x1F69, 0x1FAF,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_Greek_alpha, 0x1FB4,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_Greek_eta, 0x1FC4,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_Greek_omega, 0x1FF4,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F00, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F01, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F08, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F09, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F20, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F21, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F28, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F29, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F60, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F61, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F68, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_acute, 0x1F69, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_Greek_alpha, 0x1FB2,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_Greek_eta, 0x1FC2,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_Greek_omega, 0x1FF2,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F00, 0x1F82,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F01, 0x1F83,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F08, 0x1F8A,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F09, 0x1F8B,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F20, 0x1F92,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F21, 0x1F93,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F28, 0x1F9A,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F29, 0x1F9B,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F60, 0x1FA2,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F61, 0x1FA3,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F68, 0x1FAA,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, 0x1F69, 0x1FAB,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_Greek_alpha, 0x1FB4,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_Greek_eta, 0x1FC4,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_Greek_omega, 0x1FF4,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F00, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F01, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F08, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F09, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F20, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F21, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F28, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F29, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F60, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F61, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F68, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, 0x1F69, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_Greek_alpha, 0x1FB7,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_Greek_eta, 0x1FC7,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_Greek_omega, 0x1FF7,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F00, 0x1F86,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F01, 0x1F87,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F08, 0x1F8E,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F09, 0x1F8F,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F20, 0x1F96,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F21, 0x1F97,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F28, 0x1F9E,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F29, 0x1F9F,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F60, 0x1FA6,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F61, 0x1FA7,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F68, 0x1FAE,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, 0x1F69, 0x1FAF,
    FcitxKey_Greek_iota, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F88,
    FcitxKey_Greek_iota, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F98,
    FcitxKey_Greek_iota, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FA8,
    FcitxKey_Greek_iota, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F80,
    FcitxKey_Greek_iota, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F90,
    FcitxKey_Greek_iota, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA0,
    FcitxKey_Greek_iota, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F89,
    FcitxKey_Greek_iota, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F99,
    FcitxKey_Greek_iota, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FA9,
    FcitxKey_Greek_iota, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F81,
    FcitxKey_Greek_iota, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F91,
    FcitxKey_Greek_iota, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA1,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_0, FcitxKey_parenright, 0x2469,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_1, FcitxKey_parenright, 0x246A,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_2, FcitxKey_parenright, 0x246B,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_3, FcitxKey_parenright, 0x246C,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_4, FcitxKey_parenright, 0x246D,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_5, FcitxKey_parenright, 0x246E,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_6, FcitxKey_parenright, 0x246F,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_7, FcitxKey_parenright, 0x2470,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_8, FcitxKey_parenright, 0x2471,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_9, FcitxKey_parenright, 0x2472,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_Space, FcitxKey_parenright, 0x246B,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_0, FcitxKey_parenright, 0x2469,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_1, FcitxKey_parenright, 0x246A,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_2, FcitxKey_parenright, 0x246B,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_3, FcitxKey_parenright, 0x246C,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_4, FcitxKey_parenright, 0x246D,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_5, FcitxKey_parenright, 0x246E,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_6, FcitxKey_parenright, 0x246F,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_7, FcitxKey_parenright, 0x2470,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_8, FcitxKey_parenright, 0x2471,
    FcitxKey_parenleft, FcitxKey_1, FcitxKey_KP_9, FcitxKey_parenright, 0x2472,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_0, FcitxKey_parenright, 0x2473,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_1, FcitxKey_parenright, 0x3251,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_2, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_3, FcitxKey_parenright, 0x3253,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_4, FcitxKey_parenright, 0x3254,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_5, FcitxKey_parenright, 0x3255,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_6, FcitxKey_parenright, 0x3256,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_7, FcitxKey_parenright, 0x3257,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_8, FcitxKey_parenright, 0x3258,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_9, FcitxKey_parenright, 0x3259,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_Space, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_0, FcitxKey_parenright, 0x2473,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_1, FcitxKey_parenright, 0x3251,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_2, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_3, FcitxKey_parenright, 0x3253,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_4, FcitxKey_parenright, 0x3254,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_5, FcitxKey_parenright, 0x3255,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_6, FcitxKey_parenright, 0x3256,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_7, FcitxKey_parenright, 0x3257,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_8, FcitxKey_parenright, 0x3258,
    FcitxKey_parenleft, FcitxKey_2, FcitxKey_KP_9, FcitxKey_parenright, 0x3259,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_0, FcitxKey_parenright, 0x325A,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_1, FcitxKey_parenright, 0x325B,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_2, FcitxKey_parenright, 0x325C,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_3, FcitxKey_parenright, 0x325D,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_4, FcitxKey_parenright, 0x325E,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_5, FcitxKey_parenright, 0x325F,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_6, FcitxKey_parenright, 0x32B1,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_7, FcitxKey_parenright, 0x32B2,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_8, FcitxKey_parenright, 0x32B3,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_9, FcitxKey_parenright, 0x32B4,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_Space, FcitxKey_parenright, 0x325C,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_0, FcitxKey_parenright, 0x325A,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_1, FcitxKey_parenright, 0x325B,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_2, FcitxKey_parenright, 0x325C,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_3, FcitxKey_parenright, 0x325D,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_4, FcitxKey_parenright, 0x325E,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_5, FcitxKey_parenright, 0x325F,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_6, FcitxKey_parenright, 0x32B1,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_7, FcitxKey_parenright, 0x32B2,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_8, FcitxKey_parenright, 0x32B3,
    FcitxKey_parenleft, FcitxKey_3, FcitxKey_KP_9, FcitxKey_parenright, 0x32B4,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_0, FcitxKey_parenright, 0x32B5,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_1, FcitxKey_parenright, 0x32B6,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_2, FcitxKey_parenright, 0x32B7,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_3, FcitxKey_parenright, 0x32B8,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_4, FcitxKey_parenright, 0x32B9,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_5, FcitxKey_parenright, 0x32BA,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_6, FcitxKey_parenright, 0x32BB,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_7, FcitxKey_parenright, 0x32BC,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_8, FcitxKey_parenright, 0x32BD,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_9, FcitxKey_parenright, 0x32BE,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_Space, FcitxKey_parenright, 0x32B7,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_0, FcitxKey_parenright, 0x32B5,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_1, FcitxKey_parenright, 0x32B6,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_2, FcitxKey_parenright, 0x32B7,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_3, FcitxKey_parenright, 0x32B8,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_4, FcitxKey_parenright, 0x32B9,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_5, FcitxKey_parenright, 0x32BA,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_6, FcitxKey_parenright, 0x32BB,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_7, FcitxKey_parenright, 0x32BC,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_8, FcitxKey_parenright, 0x32BD,
    FcitxKey_parenleft, FcitxKey_4, FcitxKey_KP_9, FcitxKey_parenright, 0x32BE,
    FcitxKey_parenleft, FcitxKey_5, FcitxKey_KP_0, FcitxKey_parenright, 0x32BF,
    FcitxKey_parenleft, 0x1100, 0x1161, FcitxKey_parenright, 0x326E,
    FcitxKey_parenleft, 0x1102, 0x1161, FcitxKey_parenright, 0x326F,
    FcitxKey_parenleft, 0x1103, 0x1161, FcitxKey_parenright, 0x3270,
    FcitxKey_parenleft, 0x1105, 0x1161, FcitxKey_parenright, 0x3271,
    FcitxKey_parenleft, 0x1106, 0x1161, FcitxKey_parenright, 0x3272,
    FcitxKey_parenleft, 0x1107, 0x1161, FcitxKey_parenright, 0x3273,
    FcitxKey_parenleft, 0x1109, 0x1161, FcitxKey_parenright, 0x3274,
    FcitxKey_parenleft, 0x110B, 0x1161, FcitxKey_parenright, 0x3275,
    FcitxKey_parenleft, 0x110C, 0x1161, FcitxKey_parenright, 0x3276,
    FcitxKey_parenleft, 0x110E, 0x1161, FcitxKey_parenright, 0x3277,
    FcitxKey_parenleft, 0x110F, 0x1161, FcitxKey_parenright, 0x3278,
    FcitxKey_parenleft, 0x1110, 0x1161, FcitxKey_parenright, 0x3279,
    FcitxKey_parenleft, 0x1111, 0x1161, FcitxKey_parenright, 0x327A,
    FcitxKey_parenleft, 0x1112, 0x1161, FcitxKey_parenright, 0x327B,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_0, FcitxKey_parenright, 0x2473,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_1, FcitxKey_parenright, 0x3251,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_2, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_3, FcitxKey_parenright, 0x3253,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_4, FcitxKey_parenright, 0x3254,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_5, FcitxKey_parenright, 0x3255,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_6, FcitxKey_parenright, 0x3256,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_7, FcitxKey_parenright, 0x3257,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_8, FcitxKey_parenright, 0x3258,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_9, FcitxKey_parenright, 0x3259,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_Space, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_0, FcitxKey_parenright, 0x2473,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_1, FcitxKey_parenright, 0x3251,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_2, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_3, FcitxKey_parenright, 0x3253,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_4, FcitxKey_parenright, 0x3254,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_5, FcitxKey_parenright, 0x3255,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_6, FcitxKey_parenright, 0x3256,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_7, FcitxKey_parenright, 0x3257,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_8, FcitxKey_parenright, 0x3258,
    FcitxKey_parenleft, FcitxKey_KP_Space, FcitxKey_KP_9, FcitxKey_parenright, 0x3259,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_0, FcitxKey_parenright, 0x2469,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_1, FcitxKey_parenright, 0x246A,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_2, FcitxKey_parenright, 0x246B,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_3, FcitxKey_parenright, 0x246C,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_4, FcitxKey_parenright, 0x246D,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_5, FcitxKey_parenright, 0x246E,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_6, FcitxKey_parenright, 0x246F,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_7, FcitxKey_parenright, 0x2470,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_8, FcitxKey_parenright, 0x2471,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_9, FcitxKey_parenright, 0x2472,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_Space, FcitxKey_parenright, 0x246B,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_0, FcitxKey_parenright, 0x2469,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_1, FcitxKey_parenright, 0x246A,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_2, FcitxKey_parenright, 0x246B,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_3, FcitxKey_parenright, 0x246C,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_4, FcitxKey_parenright, 0x246D,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_5, FcitxKey_parenright, 0x246E,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_6, FcitxKey_parenright, 0x246F,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_7, FcitxKey_parenright, 0x2470,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_8, FcitxKey_parenright, 0x2471,
    FcitxKey_parenleft, FcitxKey_KP_1, FcitxKey_KP_9, FcitxKey_parenright, 0x2472,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_0, FcitxKey_parenright, 0x2473,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_1, FcitxKey_parenright, 0x3251,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_2, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_3, FcitxKey_parenright, 0x3253,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_4, FcitxKey_parenright, 0x3254,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_5, FcitxKey_parenright, 0x3255,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_6, FcitxKey_parenright, 0x3256,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_7, FcitxKey_parenright, 0x3257,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_8, FcitxKey_parenright, 0x3258,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_9, FcitxKey_parenright, 0x3259,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_Space, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_0, FcitxKey_parenright, 0x2473,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_1, FcitxKey_parenright, 0x3251,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_2, FcitxKey_parenright, 0x3252,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_3, FcitxKey_parenright, 0x3253,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_4, FcitxKey_parenright, 0x3254,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_5, FcitxKey_parenright, 0x3255,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_6, FcitxKey_parenright, 0x3256,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_7, FcitxKey_parenright, 0x3257,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_8, FcitxKey_parenright, 0x3258,
    FcitxKey_parenleft, FcitxKey_KP_2, FcitxKey_KP_9, FcitxKey_parenright, 0x3259,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_0, FcitxKey_parenright, 0x325A,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_1, FcitxKey_parenright, 0x325B,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_2, FcitxKey_parenright, 0x325C,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_3, FcitxKey_parenright, 0x325D,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_4, FcitxKey_parenright, 0x325E,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_5, FcitxKey_parenright, 0x325F,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_6, FcitxKey_parenright, 0x32B1,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_7, FcitxKey_parenright, 0x32B2,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_8, FcitxKey_parenright, 0x32B3,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_9, FcitxKey_parenright, 0x32B4,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_Space, FcitxKey_parenright, 0x325C,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_0, FcitxKey_parenright, 0x325A,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_1, FcitxKey_parenright, 0x325B,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_2, FcitxKey_parenright, 0x325C,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_3, FcitxKey_parenright, 0x325D,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_4, FcitxKey_parenright, 0x325E,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_5, FcitxKey_parenright, 0x325F,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_6, FcitxKey_parenright, 0x32B1,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_7, FcitxKey_parenright, 0x32B2,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_8, FcitxKey_parenright, 0x32B3,
    FcitxKey_parenleft, FcitxKey_KP_3, FcitxKey_KP_9, FcitxKey_parenright, 0x32B4,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_0, FcitxKey_parenright, 0x32B5,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_1, FcitxKey_parenright, 0x32B6,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_2, FcitxKey_parenright, 0x32B7,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_3, FcitxKey_parenright, 0x32B8,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_4, FcitxKey_parenright, 0x32B9,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_5, FcitxKey_parenright, 0x32BA,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_6, FcitxKey_parenright, 0x32BB,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_7, FcitxKey_parenright, 0x32BC,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_8, FcitxKey_parenright, 0x32BD,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_9, FcitxKey_parenright, 0x32BE,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_Space, FcitxKey_parenright, 0x32B7,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_0, FcitxKey_parenright, 0x32B5,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_1, FcitxKey_parenright, 0x32B6,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_2, FcitxKey_parenright, 0x32B7,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_3, FcitxKey_parenright, 0x32B8,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_4, FcitxKey_parenright, 0x32B9,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_5, FcitxKey_parenright, 0x32BA,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_6, FcitxKey_parenright, 0x32BB,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_7, FcitxKey_parenright, 0x32BC,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_8, FcitxKey_parenright, 0x32BD,
    FcitxKey_parenleft, FcitxKey_KP_4, FcitxKey_KP_9, FcitxKey_parenright, 0x32BE,
    FcitxKey_parenleft, FcitxKey_KP_5, FcitxKey_KP_0, FcitxKey_parenright, 0x32BF,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_apostrophe, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8B,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9B,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAB,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F83,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F93,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA3,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8A,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9A,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAA,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F82,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F92,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA2,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8A,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9A,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAA,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F82,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F92,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA2,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8B,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9B,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAB,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F83,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F93,
    FcitxKey_Greek_iota, FcitxKey_grave, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA3,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8F,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9F,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAF,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F87,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F97,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA7,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8E,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9E,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAE,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F86,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F96,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA6,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8E,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9E,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAE,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F86,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F96,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA6,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8F,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9F,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAF,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F87,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F97,
    FcitxKey_Greek_iota, FcitxKey_asciitilde, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA7,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_acute, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8B,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9B,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAB,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F83,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F93,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA3,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8A,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9A,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAA,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F82,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F92,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA2,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8A,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9A,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAA,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F82,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F92,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA2,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8B,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9B,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAB,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F83,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F93,
    FcitxKey_Greek_iota, FcitxKey_dead_grave, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA3,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8C,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9C,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAC,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F84,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F94,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA4,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8D,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9D,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAD,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F85,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F95,
    FcitxKey_Greek_iota, FcitxKey_dead_acute, FcitxKey_dead_dasia, FcitxKey_Greek_omega, 0x1FA5,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenleft, FcitxKey_Greek_ALPHA, 0x1F8F,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenleft, FcitxKey_Greek_ETA, 0x1F9F,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenleft, FcitxKey_Greek_OMEGA, 0x1FAF,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenleft, FcitxKey_Greek_alpha, 0x1F87,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenleft, FcitxKey_Greek_eta, 0x1F97,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenleft, FcitxKey_Greek_omega, 0x1FA7,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenright, FcitxKey_Greek_ALPHA, 0x1F8E,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenright, FcitxKey_Greek_ETA, 0x1F9E,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenright, FcitxKey_Greek_OMEGA, 0x1FAE,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenright, FcitxKey_Greek_alpha, 0x1F86,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenright, FcitxKey_Greek_eta, 0x1F96,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_parenright, FcitxKey_Greek_omega, 0x1FA6,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_ALPHA, 0x1F8E,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_ETA, 0x1F9E,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_OMEGA, 0x1FAE,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_alpha, 0x1F86,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_eta, 0x1F96,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_psili, FcitxKey_Greek_omega, 0x1FA6,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_ALPHA, 0x1F8F,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_ETA, 0x1F9F,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_OMEGA, 0x1FAF,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_alpha, 0x1F87,
    FcitxKey_Greek_iota, FcitxKey_dead_tilde, FcitxKey_dead_dasia, FcitxKey_Greek_eta, 0x1F97,
};

#endif


// kate: indent-mode cstyle; space-indent on; indent-width 0;
