/*
 * $Id: media_gen_dvd_gui.c,v 1.2 2011-01-27 10:40:38 sand Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "media_gen_dvd_gui.h"

#ifdef HAVE_GTK
#include "media_gen_dvd_gui_gtk.h"
#endif

void *
media_gen_dvd_gui_create(
	unsigned int page,
	const char *name,
	const char *media,
	const char *size,
	const char *iso,
	const char *cue,
	struct sig_manage *port_manage,
	struct sig_magneto_optical *port_connect
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return media_gen_dvd_gui_gtk_create(page, name,
				media, size, iso, cue,
				port_manage, port_connect);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
media_gen_dvd_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		media_gen_dvd_gui_gtk_destroy(_cpssp);
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
