/* $Id: glue-gui-gtk-led.c,v 1.2 2009-01-27 17:06:40 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "glue-log.h"
#include "umutil.h"

#include "glue-gui-gtk-led.h"

typedef struct {
	GtkVBoxClass parent_class;
} GuiGtkLedClass;

static GdkPixbuf *icon_power_led = 0;
static GdkPixbuf *icon_power_led_off = 0;

static void
gui_gtk_led_class_init(GuiGtkLedClass *klass)
{
	const char *path;

	path = buildpath(PNGDIR, "power_led_off.png");
	icon_power_led_off = gdk_pixbuf_new_from_file(path, NULL);
	if (icon_power_led_off == NULL) {
		faum_log(FAUM_LOG_ERROR, "gtk-GUI", "",
				"couldn't load image: %s\n", path);
	}

	path = buildpath(PNGDIR, "power_led.png");
	icon_power_led = gdk_pixbuf_new_from_file(path, NULL);
	if (icon_power_led == NULL) {
		faum_log(FAUM_LOG_ERROR, "gtk-GUI", "",
				"couldn't load image: %s\n", path);
	}
}

static void
gui_gtk_led_init(GuiGtkLed *ttt)
{
}

GType
gui_gtk_led_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkLedClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_led_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkLed),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_led_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_VBOX,
				"Led", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKLED_TYPE	gui_gtk_led_get_type()

GtkWidget *
gui_gtk_led_new(const char *desc)
{
	GuiGtkLed *widget;

	widget = GUI_GTK_LED(g_object_new(GUIGTKLED_TYPE, NULL));

	assert(icon_power_led_off);
	
	widget->led = gtk_image_new();
	gtk_image_set_from_pixbuf(GTK_IMAGE(widget->led),
			icon_power_led_off);
	gtk_widget_show(widget->led);
	gtk_box_pack_start(GTK_BOX(widget), widget->led,
			FALSE, FALSE, 5);

	widget->desc = gtk_label_new(desc);
	gtk_widget_show(widget->desc);
	gtk_box_pack_start(GTK_BOX(widget), widget->desc,
			FALSE, FALSE, 1);

	return GTK_WIDGET(widget);
}

void
gui_gtk_led_set(GuiGtkLed *widget, unsigned int on)
{
	assert(icon_power_led);
	assert(icon_power_led_off);

	gtk_image_set_from_pixbuf(GTK_IMAGE(widget->led),
			on ? icon_power_led : icon_power_led_off);
}
