/* $Id: arch_tap.c,v 1.3 2009-09-01 06:10:31 sand Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE

/* Hack to get ntohl etc working */
#define _LINUX_BYTEORDER_GENERIC_H	1

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#ifdef HAVE_LINUX_IF_TUN_H
#include <linux/if_tun.h>
#endif
#ifdef HAVE_NET_IF_TUN_H
#include <net/if_tun.h>
#endif
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <assert.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "glue-io.h"
#include "glue-main.h"

#endif /* INCLUDE */

#ifdef STATE

struct {
	char name[13];
	int fd;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static int
NAME_(send)(
	struct cpssp * cpssp,
	const unsigned char *buf,
	unsigned int bufsize
)
{
	int ret;

	ret = write(cpssp->NAME.fd, buf, bufsize);

	return ret;
}

static void
NAME_(interrupt)(int fd, void *_cpssp)
{
	struct cpssp * cpssp = (struct cpssp *) _cpssp;
	unsigned char buf[2048];
	int len;

	for (;;) {
		do {
			len = read(cpssp->NAME.fd, buf, sizeof(buf));
		} while (len < 0 && errno == EINTR);
		if (len < 0 && errno == EAGAIN) {
			break;
		}
		assert(0 < len);

		bridge_real_to_virt(cpssp, buf, len);
	}
}

#ifdef HAVE_LINUX_IF_TUN_H
static int
NAME_(open)(struct cpssp * cpssp)
{
	int ret;
	struct ifreq ifr;

	/* open tap device */

	cpssp->NAME.fd = open("/dev/tun", O_RDWR);
	if( cpssp->NAME.fd<0 && errno==ENOENT )
		cpssp->NAME.fd = open("/dev/net/tun", O_RDWR);
	if (cpssp->NAME.fd < 0) {
		fprintf(stderr, "can't open /dev/tun or /dev/net/tun: %s\n",
				strerror(errno));
		exit(1);
	}

	memset((void *) &ifr, 0, sizeof(ifr));
	ifr.ifr_flags = IFF_TAP | IFF_NO_PI;
	strcpy(ifr.ifr_name, cpssp->NAME.name);
	ret = ioctl(cpssp->NAME.fd, TUNSETIFF, (void *) &ifr);
	if (ret < 0) {
		fprintf(stderr, "can't TUNSETIFF to tap: %s\n",
				strerror(errno));
		exit(1);
	}

	io_register(cpssp->NAME.fd, cpssp, NAME_(interrupt));

	fprintf(stderr, "%s: connected to interface %s\n",
			__FUNCTION__,
			ifr.ifr_name);
	return 0;
}
#endif

#ifdef HAVE_NET_IF_TUN_H
static int
NAME_(open)(struct cpssp * cpssp)
{
	char tunname[256];

	tunname[sizeof(tunname)-1] = '\0';
	snprintf(tunname, sizeof(tunname)-1, "/dev/%s", cpssp->NAME.name);
	cpssp->NAME.fd = open(tunname, O_RDWR);
	if (cpssp->NAME.fd < 0) {
		fprintf(stderr, "%s: %s\n", tunname, strerror(errno));
		exit(1);
	}

	io_register(cpssp->NAME.fd, cpssp, NAME_(interrupt));

	return 0;
}
#endif

static int
NAME_(close)(struct cpssp * cpssp)
{
	int ret;

	if (cpssp->NAME.fd < 0) {
		return 0;
	}

	io_unregister(cpssp->NAME.fd);

	ret = close(cpssp->NAME.fd);

	return ret;
}

static void
NAME_(create)(struct cpssp * cpssp, const char *name)
{
	assert(strlen(name) <= 12);

	strncpy(cpssp->NAME.name, name, 12);
	cpssp->NAME.name[12] = '\0';

	NAME_(open)(cpssp);
}

static void
NAME_(destroy)(struct cpssp * cpssp)
{
	NAME_(close)(cpssp);
}

#endif /* BEHAVIOR */
